/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.center.config.RCConfigField;
import cn.rongcloud.rtc.center.config.RCServerConfig;

public class RCAudioStreamConfigImpl
implements RCRTCAudioStreamConfig {
    private RCConfigField<Boolean> isAGCLimiter;
    private RCConfigField<Float> AGCTargetdbov;
    private RCConfigField<Boolean> isHighPassFilters;
    private RCConfigField<Float> preAmplifierLevel;
    private RCConfigField<Boolean> isPreAmplifier;
    private RCConfigField<Boolean> isAGCControl;
    private RCConfigField<Boolean> isEchoFilter;
    private RCConfigField<RCRTCParamsType.AECMode> echoCancel;
    private RCConfigField<RCRTCParamsType.NSLevel> noiseSuppressionLevel;
    private RCConfigField<RCRTCParamsType.NSMode> noiseSuppression;
    private RCConfigField<Integer> agcCompression;
    private RCConfigField<RCRTCParamsType.AudioScenario> audioEFCTMode;
    private RCConfigField<Integer> audioBitrate = RCConfigField.create(32);

    public RCAudioStreamConfigImpl() {
        this.agcCompression = RCConfigField.create(9);
        this.AGCTargetdbov = RCConfigField.create(Float.valueOf(-3.0f));
        this.isHighPassFilters = RCConfigField.create(true);
        this.noiseSuppression = RCConfigField.create(RCRTCParamsType.NSMode.NS_MODE0);
        this.noiseSuppressionLevel = RCConfigField.create(RCRTCParamsType.NSLevel.NS_MODERATE);
        this.echoCancel = RCConfigField.create(RCRTCParamsType.AECMode.AEC_MODE2);
        this.isEchoFilter = RCConfigField.create(false);
        this.isPreAmplifier = RCConfigField.create(false);
        this.preAmplifierLevel = RCConfigField.create(Float.valueOf(1.0f));
        this.isAGCControl = RCConfigField.create(true);
        this.audioEFCTMode = RCConfigField.create(RCRTCParamsType.AudioScenario.DEFAULT);
        this.isAGCLimiter = RCConfigField.create(true);
    }

    public boolean isAGCLimiter() {
        return this.isAGCLimiter.getValue();
    }

    public float getAGCTargetdbov() {
        return this.AGCTargetdbov.getValue().floatValue();
    }

    public boolean isHighPassFilters() {
        return this.isHighPassFilters.getValue();
    }

    public float getPreAmplifierLevel() {
        return this.preAmplifierLevel.getValue().floatValue();
    }

    public RCRTCParamsType.AudioScenario getAudioEFCTMode() {
        return this.audioEFCTMode.getValue();
    }

    public int getAudioBitrate() {
        return this.audioBitrate.getValue();
    }

    public boolean isPreAmplifier() {
        return this.isPreAmplifier.getValue();
    }

    public boolean isAGCControl() {
        return this.isAGCControl.getValue();
    }

    public boolean isEchoFilter() {
        return this.isEchoFilter.getValue();
    }

    public RCRTCParamsType.AECMode getEchoCancel() {
        return this.echoCancel.getValue();
    }

    public RCRTCParamsType.NSLevel getNoiseSuppressionLevel() {
        return this.noiseSuppressionLevel.getValue();
    }

    public RCRTCParamsType.NSMode getNoiseSuppression() {
        return this.noiseSuppression.getValue();
    }

    public Integer getAgcCompression() {
        return this.agcCompression.getValue();
    }

    public String formatLogString() {
        return "{isAGCLimiter=" + this.isAGCLimiter.getValue() + ", AGCTargetdbov=" + this.AGCTargetdbov.getValue() + ", isHighPassFilters=" + this.isHighPassFilters.getValue() + ", preAmplifierLevel=" + this.preAmplifierLevel.getValue() + ", isPreAmplifier=" + this.isPreAmplifier.getValue() + ", isAGCControl=" + this.isAGCControl.getValue() + ", isEchoFilter=" + this.isEchoFilter.getValue() + ", echoCancel=" + this.echoCancel.getValue().getValue() + ", noiseSuppressionLevel=" + this.noiseSuppressionLevel.getValue().getValue() + ", noiseSuppression=" + this.noiseSuppression.getValue().getValue() + ", agcCompression=" + this.agcCompression.getValue() + ", audioEFCTMode=" + this.audioEFCTMode.getValue().getValue() + ", audioBitrate=" + this.audioBitrate.getValue() + '}';
    }

    public String toString() {
        return "RCAudioStreamConfigImpl{isAGCLimiter=" + this.isAGCLimiter.getValue() + ", AGCTargetdbov=" + this.AGCTargetdbov.getValue() + ", isHighPassFilters=" + this.isHighPassFilters.getValue() + ", preAmplifierLevel=" + this.preAmplifierLevel.getValue() + ", isPreAmplifier=" + this.isPreAmplifier.getValue() + ", isAGCControl=" + this.isAGCControl.getValue() + ", isEchoFilter=" + this.isEchoFilter.getValue() + ", echoCancel=" + (Object)((Object)this.echoCancel.getValue()) + ", noiseSuppressionLevel=" + (Object)((Object)this.noiseSuppressionLevel.getValue()) + ", noiseSuppression=" + (Object)((Object)this.noiseSuppression.getValue()) + ", agcCompression=" + this.agcCompression.getValue() + ", audioEFCTMode=" + (Object)((Object)this.audioEFCTMode.getValue()) + ", audioBitrate=" + this.audioBitrate.getValue() + '}';
    }

    public void updateServerConfig() {
        this.audioBitrate.setServerValue(RCServerConfig.getAudioBitRate());
        this.agcCompression.setServerValue(RCServerConfig.getAGCCompression());
        this.AGCTargetdbov.setServerValue(Float.valueOf(RCServerConfig.getAGCTargetdbov()));
        this.isHighPassFilters.setServerValue(RCServerConfig.isHighPass());
        this.noiseSuppression.setServerValue(RCServerConfig.getNoiseSuppression());
        this.noiseSuppressionLevel.setServerValue(RCServerConfig.getNoiseSuppressionLevel());
        this.echoCancel.setServerValue(RCServerConfig.getEchoCancel());
        this.isEchoFilter.setServerValue(RCServerConfig.isEchoCancelFilterEnable());
        this.isPreAmplifier.setServerValue(RCServerConfig.isPreAmplifier());
        this.preAmplifierLevel.setServerValue(Float.valueOf(RCServerConfig.getPreAmplifierLevel()));
        this.isAGCControl.setServerValue(RCServerConfig.isAGCControl());
    }

    public static class RCBuilderImpl
    extends RCRTCAudioStreamConfig.Builder {
        private RCAudioStreamConfigImpl config = new RCAudioStreamConfigImpl();

        @Override
        public RCRTCAudioStreamConfig buildMusicMode() {
            this.initMusicMode();
            return this.config;
        }

        private void initMusicMode() {
            if (!this.config.audioBitrate.hasSet()) {
                this.config.audioBitrate.setLocalValue(256);
            }
            if (!this.config.agcCompression.hasSet()) {
                this.config.agcCompression.setLocalValue(9);
            }
            if (!this.config.AGCTargetdbov.hasSet()) {
                this.config.AGCTargetdbov.setLocalValue(Float.valueOf(-3.0f));
            }
            if (!this.config.isHighPassFilters.hasSet()) {
                this.config.isHighPassFilters.setLocalValue(true);
            }
            if (!this.config.noiseSuppression.hasSet()) {
                this.config.noiseSuppression.setLocalValue(RCRTCParamsType.NSMode.NS_MODE0);
            }
            if (!this.config.noiseSuppressionLevel.hasSet()) {
                this.config.noiseSuppressionLevel.setLocalValue(RCRTCParamsType.NSLevel.NS_LOW);
            }
            if (!this.config.echoCancel.hasSet()) {
                this.config.echoCancel.setLocalValue(RCRTCParamsType.AECMode.AEC_MODE0);
            }
            if (!this.config.isEchoFilter.hasSet()) {
                this.config.isEchoFilter.setLocalValue(false);
            }
            if (!this.config.isPreAmplifier.hasSet()) {
                this.config.isPreAmplifier.setLocalValue(true);
            }
            if (!this.config.preAmplifierLevel.hasSet()) {
                this.config.preAmplifierLevel.setLocalValue(Float.valueOf(1.0f));
            }
            if (!this.config.isAGCControl.hasSet()) {
                this.config.isAGCControl.setLocalValue(false);
            }
            if (!this.config.audioEFCTMode.hasSet()) {
                this.config.audioEFCTMode.setLocalValue(RCRTCParamsType.AudioScenario.MUSIC);
            }
            if (!this.config.isAGCLimiter.hasSet()) {
                this.config.isAGCLimiter.setLocalValue(true);
            }
        }

        private void initDefaultMode() {
            if (!this.config.audioBitrate.hasSet()) {
                this.config.audioBitrate.setLocalValue(32);
            }
            if (!this.config.agcCompression.hasSet()) {
                this.config.agcCompression.setLocalValue(9);
            }
            if (!this.config.AGCTargetdbov.hasSet()) {
                this.config.AGCTargetdbov.setLocalValue(Float.valueOf(-3.0f));
            }
            if (!this.config.isHighPassFilters.hasSet()) {
                this.config.isHighPassFilters.setLocalValue(true);
            }
            if (!this.config.noiseSuppression.hasSet()) {
                this.config.noiseSuppression.setLocalValue(RCRTCParamsType.NSMode.NS_MODE0);
            }
            if (!this.config.noiseSuppressionLevel.hasSet()) {
                this.config.noiseSuppressionLevel.setLocalValue(RCRTCParamsType.NSLevel.NS_MODERATE);
            }
            if (!this.config.echoCancel.hasSet()) {
                this.config.echoCancel.setLocalValue(RCRTCParamsType.AECMode.AEC_MODE2);
            }
            if (!this.config.isEchoFilter.hasSet()) {
                this.config.isEchoFilter.setLocalValue(false);
            }
            if (!this.config.isPreAmplifier.hasSet()) {
                this.config.isPreAmplifier.setLocalValue(false);
            }
            if (!this.config.preAmplifierLevel.hasSet()) {
                this.config.preAmplifierLevel.setLocalValue(Float.valueOf(1.0f));
            }
            if (!this.config.isAGCControl.hasSet()) {
                this.config.isAGCControl.setLocalValue(true);
            }
            if (!this.config.audioEFCTMode.hasSet()) {
                this.config.audioEFCTMode.setLocalValue(RCRTCParamsType.AudioScenario.DEFAULT);
            }
            if (!this.config.isAGCLimiter.hasSet()) {
                this.config.isAGCLimiter.setLocalValue(true);
            }
        }

        @Override
        public RCRTCAudioStreamConfig buildDefaultMode() {
            this.initDefaultMode();
            return this.config;
        }

        @Override
        public RCRTCAudioStreamConfig build() {
            return this.config;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder enableAGCLimiter(boolean enableAGCLimiter) {
            this.config.isAGCLimiter.setLocalValue(enableAGCLimiter);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setAGCTargetdbov(int AGCTargetdbov) {
            this.config.AGCTargetdbov.setLocalValue(Float.valueOf(AGCTargetdbov));
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setPreAmplifierLevel(float preAmplifierLevel) {
            this.config.preAmplifierLevel.setLocalValue(Float.valueOf(preAmplifierLevel));
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setAGCCompression(int agcCompression) {
            this.config.agcCompression.setLocalValue(agcCompression);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder enableHighPassFilter(boolean enableHighPassFilter) {
            this.config.isHighPassFilters.setLocalValue(enableHighPassFilter);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder enablePreAmplifier(boolean enablePreAmplifier) {
            this.config.isPreAmplifier.setLocalValue(enablePreAmplifier);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAGCLimiter(boolean AGCLimiter) {
            this.config.isAGCLimiter.setLocalValue(AGCLimiter);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAGCTargetdbov(float AGCTargetdbov) {
            this.config.AGCTargetdbov.setLocalValue(Float.valueOf(AGCTargetdbov));
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setHighPassFilters(boolean highPassFilters) {
            this.config.isHighPassFilters.setLocalValue(highPassFilters);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setPreAmplifier(boolean preAmplifier) {
            this.config.isPreAmplifier.setLocalValue(preAmplifier);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAGCControl(boolean AGCControl) {
            this.config.isAGCControl.setLocalValue(AGCControl);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setEchoFilter(boolean echoFilter) {
            this.config.isEchoFilter.setLocalValue(echoFilter);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAgcCompression(int agcCompression) {
            this.config.agcCompression.setLocalValue(agcCompression);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAudioEFCTMode(RCRTCParamsType.AudioScenario audioEFCTMode) {
            this.config.audioEFCTMode.setLocalValue(audioEFCTMode);
            return this;
        }

        public RCRTCAudioStreamConfig.Builder setAudioBitrate(int audioBitrate) {
            this.config.audioBitrate.setLocalValue(audioBitrate);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder enableAGCControl(boolean AGCControl) {
            this.config.isAGCControl.setLocalValue(AGCControl);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder enableEchoFilter(boolean echoFilter) {
            this.config.isEchoFilter.setLocalValue(echoFilter);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setEchoCancel(RCRTCParamsType.AECMode echoCancel) {
            this.config.echoCancel.setLocalValue(echoCancel);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setNoiseSuppressionLevel(RCRTCParamsType.NSLevel noiseSuppressionLevel) {
            this.config.noiseSuppressionLevel.setLocalValue(noiseSuppressionLevel);
            return this;
        }

        @Override
        public RCRTCAudioStreamConfig.Builder setNoiseSuppression(RCRTCParamsType.NSMode noiseSuppression) {
            this.config.noiseSuppression.setLocalValue(noiseSuppression);
            return this;
        }
    }
}

