/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.config;

import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;

public class RCVideoConfigImpl
implements RCRTCVideoStreamConfig {
    private int maxRate = -1;
    private int minRate = -1;
    private RCRTCParamsType.RCRTCVideoFps videoFps = RCRTCParamsType.RCRTCVideoFps.Fps_15;
    private RCRTCParamsType.RCRTCVideoResolution videoResolution = RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_480_640;

    @Override
    public int getMaxRate() {
        return this.maxRate;
    }

    @Override
    public int getMinRate() {
        return this.minRate;
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.videoFps;
    }

    @Override
    public RCRTCParamsType.RCRTCVideoResolution getVideoResolution() {
        return this.videoResolution;
    }

    private void setMaxRate(int maxRate) {
        this.maxRate = maxRate;
    }

    private void setMinRate(int minRate) {
        this.minRate = minRate;
    }

    private void setVideoFps(RCRTCParamsType.RCRTCVideoFps videoFps) {
        this.videoFps = videoFps;
    }

    private void setVideoResolution(RCRTCParamsType.RCRTCVideoResolution videoResolution) {
        this.videoResolution = videoResolution;
    }

    public String formatLogString() {
        return "{maxRate=" + this.maxRate + ", minRate=" + this.minRate + ", videoFps=" + this.videoFps.getFps() + ", videoResolution=" + this.videoResolution.getLabel() + '}';
    }

    public static class Builder
    extends RCRTCVideoStreamConfig.Builder {
        private int maxRate = -1;
        private int minRate = -1;
        private RCRTCParamsType.RCRTCVideoFps videoFps;
        private RCRTCParamsType.RCRTCVideoResolution videoResolution;

        @Override
        public RCRTCVideoStreamConfig build() {
            RCVideoConfigImpl config = new RCVideoConfigImpl();
            if (this.maxRate != -1) {
                config.setMaxRate(this.maxRate);
            }
            if (this.minRate != -1) {
                config.setMinRate(this.minRate);
            }
            if (this.videoFps != null) {
                config.setVideoFps(this.videoFps);
            }
            if (this.videoResolution != null) {
                config.setVideoResolution(this.videoResolution);
                if (this.maxRate == -1) {
                    config.setMaxRate(this.videoResolution.getMaxBitRate());
                }
                if (this.minRate == -1) {
                    config.setMinRate(this.videoResolution.getMinBitRate());
                }
            }
            return config;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setMaxRate(int maxRate) {
            this.maxRate = maxRate;
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setMinRate(int minRate) {
            this.minRate = minRate;
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setVideoFps(RCRTCParamsType.RCRTCVideoFps videoFps) {
            this.videoFps = videoFps;
            return this;
        }

        @Override
        public RCRTCVideoStreamConfig.Builder setVideoResolution(RCRTCParamsType.RCRTCVideoResolution videoResolution) {
            this.videoResolution = videoResolution;
            return this;
        }
    }
}

