/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.config;

import android.util.Log;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.utils.RongRTCSessionManager;
import org.json.JSONException;
import org.json.JSONObject;

public class RCServerConfig {
    private static final String TAG = "RCServerConfig";
    static final String KEY_CENTER_CONFIG_MINRATE = "minRate";
    static final String KEY_CENTER_CONFIG_MAXRATE = "maxRate";
    static final String KEY_CENTER_CONFIG_VIDEO_WIDTH = "videoWidth";
    static final String KEY_CENTER_CONFIG_VIDEO_HEIGHT = "videoHeight";
    static final String KEY_CENTER_CONFIG_VIDEO_FPS = "videoFps";
    static final String KEY_CENTER_CONFIG_SAMPLE_RATE = "audioSampleRate";
    static final String KEY_CENTER_CONFIG_AUDIO_BIT_RATE = "audioBitRate";
    static final String KEY_CENTER_CONFIG_AGC_CONTROL = "agcControl";
    static final String KEY_CENTER_CONFIG_AGC_TDBOV = "agcTargetDBOV";
    static final String KEY_CENTER_CONFIG_HIGH_PASS = "highPass";
    static final String KEY_CENTER_CONFIG_AGC_COMPRESSION = "agcCompression";
    static final String KEY_CENTER_CONFIG_PRE_AMPLIFIER = "preAmplifier";
    static final String KEY_CENTER_CONFIG_PRE_AMPLIFIER_LEVEL = "preAmplifierLevel";
    static final String KEY_CENTER_CONFIG_ECHOCANCEL = "echoCancel";
    static final String KEY_CENTER_CONFIG_ECHO_CANCEL_FILTER_ENABLE = "echoCancelFilterEnable";
    static final String KEY_CENTER_CONFIG_NOISE_SUPPRESSION = "noiseSuppression";
    static final String KEY_CENTER_CONFIG_NOISE_SUPPRESSION_LEVEL = "noiseSuppressionLevel";
    static final String KEY_CENTER_CONFIG_STEREO_ENABLE = "stereoEnable";
    static final String KEY_CENTER_CONFIG_TEXTURE_ENABLE = "textureEnable";
    static final String KEY_CENTER_CONFIG_HIGHT_PROFILE = "highProfile";
    static final String KEY_CENTER_CONFIG_HW_ENCODE = "hwEncode";
    static final String KEY_CENTER_CONFIG_HW_DECODE = "hwDecode";
    static final String KEY_CENTER_CONFIG_ENCODER_COLOR = "encodeColor";
    static final String KEY_CENTER_CONFIG_DECODE_COLOR = "decodeColor";
    static final String KEY_CENTER_CONFIG_HW_ENCODER_FRAME_RATE = "hwEncoderFrameRate";
    static final String KEY_CENTER_CONFIG_HW_ENCODER_KEY_FRAME_INTERVAL = "hwEncoderKeyFrameInterval";
    static final String KEY_CENTER_CONFIG_ENCODE_BITRATE_MODE = "encodeBitRateMode";
    static final String KEY_CENTER_CONFIG_USE_AUDIO_RECORDER = "useAudioRecorder";
    static final String KEY_CENTER_CONFIG_AUDIO_SOURCE = "audioSource";

    public static int getAudioSampleRate() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_SAMPLE_RATE, 48000);
    }

    public static boolean isAGCControl() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_AGC_CONTROL, true);
    }

    public static int getAGCTargetdbov() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_AGC_TDBOV, -3);
    }

    public static boolean isHighPass() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_HIGH_PASS, true);
    }

    public static int getAGCCompression() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_AGC_TDBOV, 9);
    }

    public static boolean isPreAmplifier() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_PRE_AMPLIFIER, true);
    }

    public static float getPreAmplifierLevel() {
        return RongRTCSessionManager.getInstance().getFloat(KEY_CENTER_CONFIG_PRE_AMPLIFIER_LEVEL, 1.0f);
    }

    public static RCRTCParamsType.NSMode getNoiseSuppression() {
        return RCRTCParamsType.NSMode.valueOf(RongRTCSessionManager.getInstance().getString(KEY_CENTER_CONFIG_NOISE_SUPPRESSION, RCRTCParamsType.NSMode.NS_MODE0.name()));
    }

    public static RCRTCParamsType.NSLevel getNoiseSuppressionLevel() {
        return RCRTCParamsType.NSLevel.valueOf(RongRTCSessionManager.getInstance().getString(KEY_CENTER_CONFIG_NOISE_SUPPRESSION_LEVEL, RCRTCParamsType.NSLevel.NS_MODERATE.name()));
    }

    public static RCRTCParamsType.AECMode getEchoCancel() {
        return RCRTCParamsType.AECMode.valueOf(RongRTCSessionManager.getInstance().getString(KEY_CENTER_CONFIG_ECHOCANCEL, RCRTCParamsType.AECMode.AEC_MODE2.name()));
    }

    public static boolean isEchoCancelFilterEnable() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_ECHO_CANCEL_FILTER_ENABLE, false);
    }

    public static boolean isStereo() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_STEREO_ENABLE, false);
    }

    public static int getAudioBitRate() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_AUDIO_BIT_RATE, 32);
    }

    public static boolean isHighProfile() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_HIGHT_PROFILE, false);
    }

    public static boolean isHardWareEncode() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_HW_ENCODE, true);
    }

    public static boolean isHardWareDecode() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_HW_ENCODE, true);
    }

    public static int getEncodeColor() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_ENCODER_COLOR, 0);
    }

    public static int getDecodeColor() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_DECODE_COLOR, 0);
    }

    public static RCRTCParamsType.VideoBitrateMode getEnCodeBitRateMode() {
        return RCRTCParamsType.VideoBitrateMode.valueOf(RongRTCSessionManager.getInstance().getString(KEY_CENTER_CONFIG_ENCODE_BITRATE_MODE, RCRTCParamsType.VideoBitrateMode.CBR.name()));
    }

    public static boolean isUseAudioRecoder() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_USE_AUDIO_RECORDER, true);
    }

    public static int getAudioSource() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_AUDIO_SOURCE, 7);
    }

    public static boolean isTextureEnable() {
        return RongRTCSessionManager.getInstance().getBool(KEY_CENTER_CONFIG_TEXTURE_ENABLE, true);
    }

    public static int getHardWareEncoderFrameRate() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_HW_ENCODER_FRAME_RATE, 30);
    }

    public static int getHardWareEncoderKeyFrameInterval() {
        return RongRTCSessionManager.getInstance().getInt(KEY_CENTER_CONFIG_HW_ENCODER_KEY_FRAME_INTERVAL, 100);
    }

    public static void saveConfig(RongRTCSessionManager sm, String config) {
        try {
            JSONObject jsonObject = new JSONObject(config);
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_MINRATE)) {
                int minRate = jsonObject.getInt(KEY_CENTER_CONFIG_MINRATE);
                sm.putInt(KEY_CENTER_CONFIG_MINRATE, minRate);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_MAXRATE)) {
                int maxRate = jsonObject.getInt(KEY_CENTER_CONFIG_MAXRATE);
                sm.putInt(KEY_CENTER_CONFIG_MAXRATE, maxRate);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_VIDEO_WIDTH)) {
                int width = jsonObject.getInt(KEY_CENTER_CONFIG_VIDEO_WIDTH);
                sm.putInt(KEY_CENTER_CONFIG_VIDEO_WIDTH, width);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_VIDEO_HEIGHT)) {
                int height = jsonObject.getInt(KEY_CENTER_CONFIG_VIDEO_HEIGHT);
                sm.putInt(KEY_CENTER_CONFIG_VIDEO_HEIGHT, height);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_VIDEO_FPS)) {
                int fps = jsonObject.getInt(KEY_CENTER_CONFIG_VIDEO_FPS);
                sm.putInt(KEY_CENTER_CONFIG_VIDEO_FPS, fps);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_SAMPLE_RATE)) {
                int audioSampleRate = jsonObject.getInt(KEY_CENTER_CONFIG_SAMPLE_RATE);
                sm.putInt(KEY_CENTER_CONFIG_SAMPLE_RATE, audioSampleRate);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_AUDIO_BIT_RATE)) {
                int audioBitrate = jsonObject.getInt(KEY_CENTER_CONFIG_AUDIO_BIT_RATE);
                sm.putInt(KEY_CENTER_CONFIG_AUDIO_BIT_RATE, audioBitrate);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_AGC_CONTROL)) {
                boolean agcControl = jsonObject.getBoolean(KEY_CENTER_CONFIG_AGC_CONTROL);
                sm.putBool(KEY_CENTER_CONFIG_AGC_CONTROL, agcControl);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_AGC_TDBOV)) {
                int agcTargetDBOV = jsonObject.getInt(KEY_CENTER_CONFIG_AGC_TDBOV);
                sm.putInt(KEY_CENTER_CONFIG_AGC_TDBOV, agcTargetDBOV);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_AGC_COMPRESSION)) {
                int agcCompress = jsonObject.getInt(KEY_CENTER_CONFIG_AGC_COMPRESSION);
                sm.putInt(KEY_CENTER_CONFIG_AGC_COMPRESSION, agcCompress);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_PRE_AMPLIFIER)) {
                boolean preAmplifier = jsonObject.getBoolean(KEY_CENTER_CONFIG_PRE_AMPLIFIER);
                sm.putBool(KEY_CENTER_CONFIG_PRE_AMPLIFIER, preAmplifier);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_PRE_AMPLIFIER_LEVEL)) {
                float amplifierLevel = (float)jsonObject.getDouble(KEY_CENTER_CONFIG_PRE_AMPLIFIER_LEVEL);
                sm.putFloat(KEY_CENTER_CONFIG_PRE_AMPLIFIER_LEVEL, amplifierLevel);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_ECHOCANCEL)) {
                RCRTCParamsType.AECMode rtcaecMode = RCRTCParamsType.AECMode.parseValue(jsonObject.getInt(KEY_CENTER_CONFIG_ECHOCANCEL));
                sm.putString(KEY_CENTER_CONFIG_ECHOCANCEL, rtcaecMode.name());
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HIGH_PASS)) {
                boolean highPass = jsonObject.getBoolean(KEY_CENTER_CONFIG_HIGH_PASS);
                sm.putBool(KEY_CENTER_CONFIG_HIGH_PASS, highPass);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_ECHO_CANCEL_FILTER_ENABLE)) {
                boolean echoFilter = jsonObject.getBoolean(KEY_CENTER_CONFIG_ECHO_CANCEL_FILTER_ENABLE);
                sm.putBool(KEY_CENTER_CONFIG_ECHO_CANCEL_FILTER_ENABLE, echoFilter);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_NOISE_SUPPRESSION)) {
                RCRTCParamsType.NSMode rongRTCNSMode = RCRTCParamsType.NSMode.parseValue(jsonObject.getInt(KEY_CENTER_CONFIG_NOISE_SUPPRESSION));
                sm.putString(KEY_CENTER_CONFIG_NOISE_SUPPRESSION, rongRTCNSMode.name());
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_NOISE_SUPPRESSION_LEVEL)) {
                RCRTCParamsType.NSLevel rtcnslevel = RCRTCParamsType.NSLevel.parseValue(jsonObject.getInt(KEY_CENTER_CONFIG_NOISE_SUPPRESSION_LEVEL));
                sm.putString(KEY_CENTER_CONFIG_NOISE_SUPPRESSION_LEVEL, rtcnslevel.name());
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_STEREO_ENABLE)) {
                boolean isStereo = jsonObject.getBoolean(KEY_CENTER_CONFIG_STEREO_ENABLE);
                sm.putBool(KEY_CENTER_CONFIG_STEREO_ENABLE, isStereo);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_TEXTURE_ENABLE)) {
                boolean textureEnable = jsonObject.getBoolean(KEY_CENTER_CONFIG_TEXTURE_ENABLE);
                sm.putBool(KEY_CENTER_CONFIG_TEXTURE_ENABLE, textureEnable);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HIGHT_PROFILE)) {
                boolean highProfile = jsonObject.getBoolean(KEY_CENTER_CONFIG_HIGHT_PROFILE);
                sm.putBool(KEY_CENTER_CONFIG_HIGHT_PROFILE, highProfile);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HW_ENCODE)) {
                boolean hwEncoder = jsonObject.getBoolean(KEY_CENTER_CONFIG_HW_ENCODE);
                sm.putBool(KEY_CENTER_CONFIG_HW_ENCODE, hwEncoder);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HW_DECODE)) {
                boolean hwDecoder = jsonObject.getBoolean(KEY_CENTER_CONFIG_HW_DECODE);
                sm.putBool(KEY_CENTER_CONFIG_HW_DECODE, hwDecoder);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_ENCODER_COLOR)) {
                int encoderColor = jsonObject.getInt(KEY_CENTER_CONFIG_ENCODER_COLOR);
                sm.putInt(KEY_CENTER_CONFIG_ENCODER_COLOR, encoderColor);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_DECODE_COLOR)) {
                int decoderColor = jsonObject.getInt(KEY_CENTER_CONFIG_DECODE_COLOR);
                sm.putInt(KEY_CENTER_CONFIG_DECODE_COLOR, decoderColor);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HW_ENCODER_FRAME_RATE)) {
                int hwEncoderFrameRate = jsonObject.getInt(KEY_CENTER_CONFIG_HW_ENCODER_FRAME_RATE);
                sm.putInt(KEY_CENTER_CONFIG_HW_ENCODER_FRAME_RATE, hwEncoderFrameRate);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_HW_ENCODER_KEY_FRAME_INTERVAL)) {
                int keyFrameInterval = jsonObject.getInt(KEY_CENTER_CONFIG_HW_ENCODER_KEY_FRAME_INTERVAL);
                sm.putInt(KEY_CENTER_CONFIG_HW_ENCODER_KEY_FRAME_INTERVAL, keyFrameInterval);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_ENCODE_BITRATE_MODE)) {
                RCRTCParamsType.VideoBitrateMode encoderBitrateMode = RCRTCParamsType.VideoBitrateMode.valueOf(jsonObject.getInt(KEY_CENTER_CONFIG_ENCODE_BITRATE_MODE));
                sm.putString(KEY_CENTER_CONFIG_ENCODE_BITRATE_MODE, encoderBitrateMode.name());
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_USE_AUDIO_RECORDER)) {
                boolean isAudioRecoder = jsonObject.getBoolean(KEY_CENTER_CONFIG_USE_AUDIO_RECORDER);
                sm.putBool(KEY_CENTER_CONFIG_USE_AUDIO_RECORDER, isAudioRecoder);
            }
            if (!jsonObject.isNull(KEY_CENTER_CONFIG_AUDIO_SOURCE)) {
                int audioSource = jsonObject.getInt(KEY_CENTER_CONFIG_AUDIO_SOURCE);
                sm.putInt(KEY_CENTER_CONFIG_AUDIO_SOURCE, audioSource);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("valueFromJson: " + e.toString()));
        }
    }
}

