/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.config;

import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.center.config.RCConfigField;
import cn.rongcloud.rtc.center.config.RCServerConfig;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.Map;

public class RCRTCConfigImpl
implements RCRTCConfig {
    private static String TAG = "RCRTCConfig";
    private boolean autoReconnectAble = true;
    private RCConfigField<Boolean> microphoneEnable = RCConfigField.create(true);
    private RCConfigField<Integer> audioBitrate = RCConfigField.create(32);
    private RCConfigField<Integer> audioSampleRate = RCConfigField.create(48000);
    private RCConfigField<Integer> audioSource;
    private RCConfigField<Boolean> stereo;
    private RCConfigField<Boolean> encoderHighProfile;
    private RCConfigField<Integer> encoderColor;
    private RCConfigField<Boolean> hardWareEncoder;
    private RCConfigField<Boolean> hardWareDecoder;
    private RCConfigField<Integer> encoderFrameRate;
    private RCConfigField<Boolean> encoderTexture;
    private RCConfigField<RCRTCParamsType.VideoBitrateMode> encoderBitMode;
    private RCConfigField<Integer> decoderColor = RCConfigField.create(0);
    private Map<String, String> customizedCameraParameter = null;
    private RCConfigField<Boolean> audioEncryption;
    private RCConfigField<Boolean> videoEncryption;
    private RCConfigField<Integer> statusReportInterval;
    private RCConfigField<Boolean> enableSRTP;
    private RCConfigField<Boolean> lowLatencyRecordingEnabled;

    RCRTCConfigImpl() {
        this.encoderBitMode = RCConfigField.create(RCRTCParamsType.VideoBitrateMode.CBR);
        this.encoderColor = RCConfigField.create(0);
        this.encoderFrameRate = RCConfigField.create(30);
        this.encoderHighProfile = RCConfigField.create(false);
        this.encoderTexture = RCConfigField.create(true);
        this.stereo = RCConfigField.create(false);
        this.hardWareDecoder = RCConfigField.create(true);
        this.hardWareEncoder = RCConfigField.create(true);
        this.audioSource = RCConfigField.create(7);
        this.audioEncryption = RCConfigField.create(false);
        this.videoEncryption = RCConfigField.create(false);
        this.statusReportInterval = RCConfigField.create(0);
        this.enableSRTP = RCConfigField.create(false);
        this.lowLatencyRecordingEnabled = RCConfigField.create(false);
    }

    public int getAudioSource() {
        return this.audioSource.getValue();
    }

    public boolean isMicrophoneEnable() {
        return this.microphoneEnable.getValue();
    }

    public int getAudioBitrate() {
        return this.audioBitrate.getValue();
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate.getValue();
    }

    public boolean isStereo() {
        return this.stereo.getValue();
    }

    public boolean isEncoderHighProfile() {
        return this.encoderHighProfile.getValue();
    }

    public boolean isHardWareDecoder() {
        return this.hardWareDecoder.getValue();
    }

    public int getEncoderColor() {
        return this.encoderColor.getValue();
    }

    public int getEncoderFrameRate() {
        return this.encoderFrameRate.getValue();
    }

    public boolean isEncoderTexture() {
        return this.encoderTexture.getValue();
    }

    public RCRTCParamsType.VideoBitrateMode getEncoderBitMode() {
        return this.encoderBitMode.getValue();
    }

    public int getDecoderColor() {
        return this.decoderColor.getValue();
    }

    public boolean isHardWareEncoder() {
        return this.hardWareEncoder.getValue();
    }

    public boolean isAutoReconnect() {
        return this.autoReconnectAble;
    }

    public boolean isAudioEncryptionEnable() {
        return this.audioEncryption.getValue();
    }

    public boolean isVideoEncryptionEnable() {
        return this.videoEncryption.getValue();
    }

    public Map<String, String> getCustomizedCameraParameter() {
        return this.customizedCameraParameter;
    }

    public Integer getStatusReportInterval() {
        return this.statusReportInterval.getValue();
    }

    public boolean isSRTPEnable() {
        return this.enableSRTP.getValue();
    }

    public void updateServerConfig() {
        this.microphoneEnable.setServerValue(RCServerConfig.isUseAudioRecoder());
        this.audioBitrate.setServerValue(RCServerConfig.getAudioBitRate());
        this.audioSampleRate.setServerValue(RCServerConfig.getAudioSampleRate());
        this.stereo.setServerValue(RCServerConfig.isStereo());
        this.encoderHighProfile.setServerValue(RCServerConfig.isHighProfile());
        this.hardWareEncoder.setServerValue(RCServerConfig.isHardWareEncode());
        this.encoderColor.setServerValue(RCServerConfig.getEncodeColor());
        this.encoderFrameRate.setServerValue(RCServerConfig.getHardWareEncoderFrameRate());
        this.encoderTexture.setServerValue(RCServerConfig.isTextureEnable());
        this.encoderBitMode.setServerValue(RCServerConfig.getEnCodeBitRateMode());
        this.hardWareDecoder.setServerValue(RCServerConfig.isHardWareDecode());
        this.decoderColor.setServerValue(RCServerConfig.getDecodeColor());
    }

    public boolean isLowLatencyRecordingEnabled() {
        return this.lowLatencyRecordingEnabled.getValue();
    }

    public Object formatLogString() {
        return "{autoReconnectAble=" + this.autoReconnectAble + ", microphoneEnable=" + this.microphoneEnable.getValue() + ", audioBitrate=" + this.audioBitrate.getValue() + ", audioSampleRate=" + this.audioSampleRate.getValue() + ", audioSource=" + this.audioSource.getValue() + ", stereo=" + this.stereo.getValue() + ", encoderHighProfile=" + this.encoderHighProfile.getValue() + ", encoderColor=" + this.encoderColor.getValue() + ", hardWareEncoder=" + this.hardWareEncoder.getValue() + ", hardWareDecoder=" + this.hardWareDecoder.getValue() + ", encoderFrameRate=" + this.encoderFrameRate.getValue() + ", encoderTexture=" + this.encoderTexture.getValue() + ", encoderBitMode=" + this.encoderBitMode.getValue().getValue() + ", decoderColor=" + this.decoderColor.getValue() + ", audioEncryption=" + this.audioEncryption.getValue() + ", videoEncryption=" + this.videoEncryption.getValue() + ", statusReportInterval=" + this.statusReportInterval.getValue() + ", lowLatencyRecordingEnabled=" + this.lowLatencyRecordingEnabled.getValue() + '}';
    }

    public static class BuilderImpl
    extends RCRTCConfig.Builder {
        private RCRTCConfigImpl rcConfig = new RCRTCConfigImpl();

        @Override
        public RCRTCConfig build() {
            return this.rcConfig;
        }

        @Override
        public RCRTCConfig.Builder enableMicrophone(boolean enabled) {
            this.rcConfig.microphoneEnable.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setAudioBitrate(int audioBitrate) {
            this.rcConfig.audioBitrate.setLocalValue(audioBitrate);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setAudioSampleRate(int audioSampleRate) {
            this.rcConfig.audioSampleRate.setLocalValue(audioSampleRate);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableStereo(boolean enabled) {
            this.rcConfig.stereo.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setAudioSource(int audioSource) {
            this.rcConfig.audioSource.setLocalValue(audioSource);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableHardwareEncoderHighProfile(boolean enabled) {
            this.rcConfig.encoderHighProfile.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableHardwareDecoder(boolean enabled) {
            this.rcConfig.hardWareDecoder.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setHardwareEncoderColor(int hardWareEncoderColor) {
            this.rcConfig.encoderColor.setLocalValue(hardWareEncoderColor);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setHardwareEncoderFrameRate(int hardWareEncoderFrameRate) {
            this.rcConfig.encoderFrameRate.setLocalValue(hardWareEncoderFrameRate);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableEncoderTexture(boolean enabled) {
            this.rcConfig.encoderTexture.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setHardwareEncoderBitrateMode(RCRTCParamsType.VideoBitrateMode hardwareEncoderBitrateMode) {
            this.rcConfig.encoderBitMode.setLocalValue(hardwareEncoderBitrateMode);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableHardwareEncoder(boolean enabled) {
            this.rcConfig.hardWareEncoder.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setHardwareDecoderColor(int hardwareDecoderColor) {
            this.rcConfig.decoderColor.setLocalValue(hardwareDecoderColor);
            return this;
        }

        @Override
        public RCRTCConfig.Builder setCustomizedCameraParameter(Map<String, String> parameter) {
            this.rcConfig.customizedCameraParameter = parameter;
            return this;
        }

        @Override
        public RCRTCConfig.Builder setStatusReportInterval(int interval) {
            if (interval >= 100) {
                this.rcConfig.statusReportInterval.setLocalValue(interval);
            } else {
                FinLog.e(TAG, "status report interval must be greater than 100. ");
            }
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableAutoReconnect(boolean enable) {
            this.rcConfig.autoReconnectAble = enable;
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableAudioEncryption(boolean enabled) {
            this.rcConfig.audioEncryption.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableVideoEncryption(boolean enabled) {
            this.rcConfig.videoEncryption.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableSRTP(boolean enabled) {
            this.rcConfig.enableSRTP.setLocalValue(enabled);
            return this;
        }

        @Override
        public RCRTCConfig.Builder enableLowLatencyRecording(boolean enable) {
            this.rcConfig.lowLatencyRecordingEnabled.setLocalValue(enable);
            return this;
        }
    }
}

