/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCOtherRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import io.rong.imlib.model.Message;
import java.util.List;

public class RCRoomListenerWrapper
extends IRCRTCOtherRoomEventsListener {
    private IRCRTCOtherRoomEventsListener mEventsListener;
    private Handler mCallBackHandler;

    public RCRoomListenerWrapper(Handler callBackHandler) {
        this.mCallBackHandler = callBackHandler;
    }

    public void setEventsListener(IRCRTCOtherRoomEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    public void release() {
        this.mCallBackHandler = null;
        this.mEventsListener = null;
    }

    private void postCallback(Runnable runnable) {
        Handler callBackHandler = this.mCallBackHandler;
        if (callBackHandler == null || this.mEventsListener == null) {
            return;
        }
        callBackHandler.post(runnable);
    }

    @Override
    public void onRemoteUserPublishResource(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onRemoteUserPublishResource(room, remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteAudio(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onRemoteUserMuteAudio(room, remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteVideo(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onRemoteUserMuteVideo(room, remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserUnpublishResource(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onRemoteUserUnpublishResource(room, remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onUserJoined(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onUserJoined(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserLeft(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onUserLeft(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserOffline(final RCRTCOtherRoom room, final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onUserOffline(room, remoteUser);
                }
            }
        });
    }

    @Override
    public void onLeaveRoom(final RCRTCOtherRoom room, final int reasonCode) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onLeaveRoom(room, reasonCode);
                }
            }
        });
    }

    @Override
    public void onVideoTrackAdd(final RCRTCOtherRoom room, final String userId, final String tag) {
        super.onVideoTrackAdd(room, userId, tag);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onVideoTrackAdd(room, userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteVideoFrame(final RCRTCOtherRoom room, final String userId, final String tag) {
        super.onFirstRemoteVideoFrame(room, userId, tag);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onFirstRemoteVideoFrame(room, userId, tag);
                }
            }
        });
    }

    @Override
    public void onReceiveMessage(final RCRTCOtherRoom room, final Message message) {
        super.onReceiveMessage(room, message);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onReceiveMessage(room, message);
                }
            }
        });
    }

    @Override
    public void onKickedByServer(final RCRTCOtherRoom room) {
        super.onKickedByServer(room);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomListenerWrapper.this.mEventsListener != null) {
                    RCRoomListenerWrapper.this.mEventsListener.onKickedByServer(room);
                }
            }
        });
    }
}

