/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCLocalUser;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomEventListenerWrapper;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.RTCPingManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.UUID22;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RCRoomImpl
implements RCRTCRoom {
    public static final String RONG_RTC_UUID = "RongRTC_uuid";
    private Map<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
    private RCLocalUserImpl mLocalUser;
    private RCRTCRoomType roomType;
    private String sessionId;
    private String clientSessionId;
    private RCRoomEventListenerWrapper eventsListener;
    private static final String TAG = "RCRoomImpl";
    private String roomId;
    private String rtcToken;
    private RTCPingManager mPingManager;
    private Map<String, String> mOtherRoomIdsMap;

    public RCRoomImpl(String roomId, RCRTCRoomType roomType, RCLocalUserImpl localUser, Map<String, RCRTCRemoteUser> remoteUsers, String sessionId, String rtcToken, RTCPingManager rtcPingManager, Handler callbackHandler, ArrayList<String> otherRoomIds) {
        if (remoteUsers != null) {
            this.remoteUsers.putAll(remoteUsers);
        }
        this.roomId = roomId;
        this.mLocalUser = localUser;
        this.sessionId = sessionId;
        this.roomType = roomType;
        this.clientSessionId = UUID22.getUUID22();
        this.rtcToken = rtcToken;
        this.mPingManager = rtcPingManager;
        this.eventsListener = new RCRoomEventListenerWrapper(callbackHandler);
        this.mOtherRoomIdsMap = new ConcurrentHashMap<String, String>();
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (String id : otherRoomIds) {
                this.mOtherRoomIdsMap.put(id, id);
            }
        }
    }

    @Override
    public void setRemoteAudioDataListener(IRCRTCAudioDataListener listener) {
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).setRemoteAudioPCMBufferListener(listener);
    }

    @Override
    public List<String> getOtherRoomIds() {
        ArrayList<String> list = new ArrayList<String>(this.mOtherRoomIdsMap.keySet().size());
        if (this.mOtherRoomIdsMap.size() > 0) {
            list.addAll(this.mOtherRoomIdsMap.keySet());
        }
        FinLog.d(TAG, "getOtherRoomIds : " + list.size());
        return list;
    }

    public void addRemoteUser(RCRTCRemoteUser remoteUser) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.remoteUsers.put(remoteUser.getUserId(), remoteUser);
    }

    public RCRTCRemoteUser removeRemoteUser(String userId) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        RCRemoteUserImpl user = (RCRemoteUserImpl)this.remoteUsers.remove(userId);
        if (user != null) {
            user.release();
        }
        return user;
    }

    @Override
    public RCRTCLocalUser getLocalUser() {
        return this.mLocalUser;
    }

    public String getRtcToken() {
        return this.rtcToken;
    }

    @Override
    public String getRoomId() {
        return this.roomId;
    }

    @Override
    public List<RCRTCRemoteUser> getRemoteUsers() {
        ArrayList<RCRTCRemoteUser> rcRemoteUsers = new ArrayList<RCRTCRemoteUser>(this.remoteUsers.values().size());
        rcRemoteUsers.addAll(this.remoteUsers.values());
        return rcRemoteUsers;
    }

    @Override
    public RCRTCRemoteUser getRemoteUser(String userId) {
        return this.remoteUsers.get(userId);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void muteAllRemoteAudio(boolean mute) {
        ReportUtil.appStatus(ReportUtil.TAG.MUTEALLREMOTEAUDIO, "mute", mute);
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).muteAllRemoteAudio(mute);
    }

    @Override
    public void setRoomAttributeValue(String value, String key, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.roomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void setRoomAttribute(String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.roomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void deleteRoomAttributes(List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().deleteAttributes(this.roomId, RCAttributeType.ROOM, attributeKeys, message, callback);
    }

    @Override
    public void getRoomAttributes(List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        RTCEngineImpl.getInstance().getAttributes(this.roomId, RCAttributeType.ROOM, attributeKeys, callback);
    }

    @Override
    public void registerRoomListener(IRCRTCRoomEventsListener eventsListener) {
        if (eventsListener != null) {
            this.eventsListener.setEventsListener(eventsListener);
        }
    }

    @Override
    public void unregisterRoomListener() {
        if (this.eventsListener != null) {
            this.eventsListener.setEventsListener(null);
        }
    }

    @Override
    public void sendMessage(MessageContent messageContent, IRongCallback.ISendMessageCallback callback) {
        RTCEngineImpl.getInstance().sendIMSignal(messageContent, callback);
    }

    public RCRTCRoomType getRoomType() {
        return this.roomType;
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public void release() {
        for (RCRTCRemoteUser remoteUser : this.remoteUsers.values()) {
            ((RCRemoteUserImpl)remoteUser).release();
        }
        ((RCMicOutputStreamImpl)this.mLocalUser.getDefaultAudioStream()).setRemoteAudioPCMBufferListener(null);
        this.remoteUsers.clear();
        this.mLocalUser = null;
        if (this.mPingManager != null) {
            this.mPingManager.stopPing();
        }
        this.mPingManager = null;
        if (this.eventsListener != null) {
            this.eventsListener.release();
        }
        this.eventsListener = null;
        if (this.mOtherRoomIdsMap != null) {
            this.mOtherRoomIdsMap.clear();
        }
    }

    public RTCPingManager getPingManager() {
        return this.mPingManager;
    }

    public IRCRTCRoomEventsListener getEventsListener() {
        return this.eventsListener;
    }

    public void addOtherRoomId(String otherRoomId) {
        if (TextUtils.isEmpty((CharSequence)otherRoomId)) {
            FinLog.e(TAG, "addOtherRoomId.error .otherRoomId is empty.");
            return;
        }
        this.mOtherRoomIdsMap.put(otherRoomId, otherRoomId);
    }

    public void removeOtherRoomId(String otherRoomId) {
        if (this.mOtherRoomIdsMap != null && this.mOtherRoomIdsMap.size() > 0 && !TextUtils.isEmpty((CharSequence)otherRoomId)) {
            FinLog.d(TAG, "removeOtherRoomId. otherRoomId : " + otherRoomId);
            this.mOtherRoomIdsMap.remove(otherRoomId);
        } else {
            FinLog.e(TAG, "removeOtherRoomId.error . empty");
        }
    }
}

