/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import io.rong.imlib.model.Message;
import java.util.List;

public class RCRoomEventListenerWrapper
extends IRCRTCRoomEventsListener {
    private IRCRTCRoomEventsListener mEventsListener;
    private Handler mCallBackHandler;

    public RCRoomEventListenerWrapper(Handler callBackHandler) {
        this.mCallBackHandler = callBackHandler;
    }

    public void setEventsListener(IRCRTCRoomEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    public void release() {
        this.mCallBackHandler = null;
        this.mEventsListener = null;
    }

    private void postCallback(Runnable runnable) {
        Handler callBackHandler = this.mCallBackHandler;
        if (callBackHandler == null || this.mEventsListener == null) {
            return;
        }
        callBackHandler.post(runnable);
    }

    @Override
    public void onRemoteUserPublishResource(final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onRemoteUserPublishResource(remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteAudio(final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onRemoteUserMuteAudio(remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteVideo(final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onRemoteUserMuteVideo(remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserUnpublishResource(final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onRemoteUserUnpublishResource(remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onUserJoined(final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onUserJoined(remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserLeft(final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onUserLeft(remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserOffline(final RCRTCRemoteUser remoteUser) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onUserOffline(remoteUser);
                }
            }
        });
    }

    @Override
    public void onLeaveRoom(final int reasonCode) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onLeaveRoom(reasonCode);
                }
            }
        });
    }

    @Override
    public void onVideoTrackAdd(final String userId, final String tag) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onVideoTrackAdd(userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteVideoFrame(final String userId, final String tag) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onFirstRemoteVideoFrame(userId, tag);
                }
            }
        });
    }

    @Override
    public void onReceiveMessage(final Message message) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onReceiveMessage(message);
                }
            }
        });
    }

    @Override
    public void onKickedByServer() {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onKickedByServer();
                }
            }
        });
    }

    @Override
    public void onRequestJoinOtherRoom(final String inviterRoomId, final String inviterUserId, final String extra) {
        super.onRequestJoinOtherRoom(inviterRoomId, inviterUserId, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onRequestJoinOtherRoom(inviterRoomId, inviterUserId, extra);
                }
            }
        });
    }

    @Override
    public void onResponseJoinOtherRoom(final String inviterRoomId, final String inviterUserId, final String inviteeRoomId, final String inviteeUserId, final boolean agree, final String extra) {
        super.onResponseJoinOtherRoom(inviterRoomId, inviterUserId, inviteeRoomId, inviteeUserId, agree, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onResponseJoinOtherRoom(inviterRoomId, inviterUserId, inviteeRoomId, inviteeUserId, agree, extra);
                }
            }
        });
    }

    @Override
    public void onCancelRequestOtherRoom(final String inviterRoomId, final String inviterUserId, final String extra) {
        super.onCancelRequestOtherRoom(inviterRoomId, inviterUserId, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onCancelRequestOtherRoom(inviterRoomId, inviterUserId, extra);
                }
            }
        });
    }

    @Override
    public void onFinishOtherRoom(final String roomId, final String userId) {
        super.onFinishOtherRoom(roomId, userId);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onFinishOtherRoom(roomId, userId);
                }
            }
        });
    }

    @Override
    public void onOtherRoomConnectionError(final String otherRoomId) {
        super.onOtherRoomConnectionError(otherRoomId);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onOtherRoomConnectionError(otherRoomId);
                }
            }
        });
    }
}

