/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.center.RCUserImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCAudioInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RCRemoteUserImpl
extends RCUserImpl
implements RCRTCRemoteUser {
    private static final String TAG = "RCRemoteUserImpl";
    private List<RCRTCInputStream> streams = new ArrayList<RCRTCInputStream>();

    public RCRemoteUserImpl(String userId, String extra) {
        super(userId, extra);
    }

    public boolean addStream(RCRTCInputStream inputStream) {
        if (TextUtils.isEmpty((CharSequence)inputStream.getTag())) {
            RTCEngineImpl.getInstance().version2UserIDs.put(this.getUserId(), "");
            FinLog.d(TAG, "2.0 version's user :: " + this.getUserId());
        }
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.streams.add(inputStream);
        return true;
    }

    public void removeStream(String streamId, RCRTCMediaType mediaType) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        Iterator<RCRTCInputStream> iterator = this.streams.iterator();
        while (iterator.hasNext()) {
            RCInputStreamImpl stream = (RCInputStreamImpl)iterator.next();
            if (!TextUtils.equals((CharSequence)streamId, (CharSequence)stream.getStreamId()) || mediaType != stream.getMediaType()) continue;
            stream.release();
            iterator.remove();
            break;
        }
    }

    public void clearStream() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        for (RCRTCInputStream stream : this.streams) {
            ((RCInputStreamImpl)stream).release();
        }
        this.streams.clear();
    }

    @Override
    public boolean containsStream(RCRTCInputStream inputStream) {
        return this.getStreams().contains(inputStream);
    }

    @Override
    public void switchToNormalStream(IRCRTCResultCallback callBack) {
        this.switchStream(false, callBack);
    }

    @Override
    public void switchToTinyStream(IRCRTCResultCallback callBack) {
        this.switchStream(true, callBack);
    }

    private void switchStream(boolean tiny, IRCRTCResultCallback callBack) {
        RCRTCInputStream stream = this.getStream("RongCloudRTC", RCRTCMediaType.VIDEO);
        RTCEngineImpl.getInstance().switchStream(tiny, stream, callBack);
    }

    @Override
    public List<RCRTCInputStream> getStreams() {
        return new ArrayList<RCRTCInputStream>(this.streams);
    }

    @Override
    public RCRTCInputStream getStream(String tag, RCRTCMediaType type) {
        List<RCRTCInputStream> streams = this.getStreams();
        for (RCRTCInputStream stream : streams) {
            if (!TextUtils.equals((CharSequence)stream.getTag(), (CharSequence)tag) || ((RCInputStreamImpl)stream).getMediaType() != type) continue;
            return stream;
        }
        return null;
    }

    public void release() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.clearStream();
    }

    public static RCRemoteUserImpl parseRemoteUsers(String userId, String json) {
        RCRemoteUserImpl remoteUser = new RCRemoteUserImpl(userId, null);
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = (JSONObject)array.get(i);
                    String streamId = object.getString("msid");
                    int type = object.getInt("mediaType");
                    String uri = object.getString("uri");
                    String tag = "";
                    if (object.has("tag")) {
                        tag = object.getString("tag");
                    }
                    RCRTCResourceState state = RCRTCResourceState.valueOf(object.getInt("state"));
                    RCRTCMediaType mediaType = RCRTCMediaType.getMediaType(type);
                    if (mediaType == RCRTCMediaType.APPLICATION) continue;
                    RCInputStreamImpl avInputStream = mediaType == RCRTCMediaType.VIDEO ? new RCVideoInputStreamImpl(userId, tag, streamId, uri) : new RCRTCAudioInputStreamImpl(userId, tag, streamId, uri);
                    avInputStream.setResourceState(state);
                    remoteUser.addStream(avInputStream);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return remoteUser;
    }
}

