/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

public enum RTCErrorCode {
    UnknownError("unknown error, please check the error code", -1),
    RongRTCCodeNoMatchedRoom("no matched room", 40003),
    ServiceNotOpened("not open voip service", 40010),
    ServerUserBlocked("user is blocked", 40021),
    RongRTCCodeTokenInvalid("Token invalid", 41001),
    RongRTCCodeTokenExpired("token expired", 42002),
    RongRTCCodeTokenNotInRoom("token not in the room", 42003),
    RongRTCCodeSignalServerNotConnect("init error, IM server not connected", 50000),
    RongRTCCodeParameterError("parameter error", 50001),
    RongRTCCodeJoinRepeatedRoom("join same rooms", 50002),
    RongRTCCodeNotInRoom("user not in room", 50003),
    RongRTCCodeVoIPNotAvailable("please check whether is VoIP service available", 50004),
    RongRTCCodeRTCTokenIsNull("rtc token is null", 50006),
    ILLEGALSTATE("IllegalState", 50007),
    RongRTCCodeHttpTimeoutError("http request timeout ", 50010),
    RongRTCCodeHttpResponseError("http response error", 50011),
    RongRTCCodeNetworkUnavailable("net work unavailable", 50012),
    RongRTCCodePublishDuplicateResources("publish duplicate resource", 50020),
    RongRTCCodeSessionNegotiateOfferError("set local sdp error", 50021),
    RongRTCCodeSessionNegotiateSetRemoteError("set remote sdp error", 50022),
    RongRTCCodePublishStreamsHasReachedMaxCount("publish stream reached max count", 50023),
    RongRTCCodeUnpublishNotExistStream("unpublish not exist stream", 50024),
    RongRTCCodeSubscribeNotExistResources("subscribe not exist resource", 50030),
    RongRTCCodeSubscribeDuplicateResources("subscribe duplicate resource", 50031),
    RongRTCCodeUnsubscribeNotExistResources("unsubscribe not exist resource", 50032),
    RongRTCCodeRTCConnectionIsNull("RTC connection is null", 50065),
    PublishMediaStreamIsNull("PublishMediaStreamIsNull", 50066),
    JsonParseError("parse json data error", 50069),
    LiveInfoIsNull("Live Info is Null", 50070),
    ConnectionAddStreamFailed("PeerConnection AddStream Failed", 50071),
    RongRTCCodeIMError("IM error", 50072),
    RongRTCTokenError("rtc token error", 50073),
    NOT_JOINED_MAIN_ROOM("Not joined the main room", 50074),
    OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM("Other room numbers cannot be the main room", 50075),
    CANCELLED_INVITATION_DOES_NOT_EXIST("The cancelled invitation does not exist", 50076),
    RESPONDING_INVITATION_DOES_NOT_EXIST("The responding invitation does not exist", 50077),
    RongRTCCodeCDNCountReachToLimit("RongRTCCodeCDNCountReachToLimit", 50080),
    RECONNECT_ERROR("reconnect error", 50100),
    HARDWARE_VIDEO_ENCODER_INIT_ERROR("video hardware encoder init error", 51000),
    HARDWARE_VIDEO_ENCODER_ERROR("video hardware encoder error", 51001),
    HARDWARE_VIDEO_DECODER_INIT_ERROR("video hardware decoder init error", 51002),
    HARDWARE_VIDEO_DECODER_ERROR("video hardware decoder error", 51003),
    CAMERA_ID_NOT_AVAILABLE("cameraId not available", 51004),
    NO_CAMERA_DEVICE("no camera device", 51005),
    OPEN_CAMERA_FAILED("open camera failed", 51006),
    RTC_INIT_TIMEOUT("rtc init timeout", 51007),
    CREATE_ANSWER_FAILURE("create Answer Failed", 51100),
    CAMERA_IS_RELEASED("camera is released", 51200),
    CANCEL_OPERATOR("cancel operator", 51201);

    private String reason;
    private int value;

    private RTCErrorCode(String reason, int value) {
        this.reason = reason;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getReason() {
        return this.reason;
    }

    public static RTCErrorCode valueOf(int value) {
        for (RTCErrorCode errorCode : RTCErrorCode.values()) {
            if (errorCode.value != value) continue;
            return errorCode;
        }
        UnknownError.setValue(value);
        return UnknownError;
    }

    public String toString() {
        return "RTCErrorCode{code: " + this.value + ", reason: '" + this.reason + "'}";
    }
}

