/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

import android.graphics.Matrix;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.YuvHelper;
import cn.rongcloud.rtc.utils.FinLog;
import java.nio.ByteBuffer;

public class RCRTCRemoteVideoFrame {
    private static final String TAG = "RCRTCRemoteVideoFrame";
    private final VideoFrame mVideoFrame;
    private final RTCBuffer mBuffer;

    public RCRTCRemoteVideoFrame(VideoFrame videoFrame) {
        this.mVideoFrame = videoFrame;
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        if (buffer == null) {
            this.mBuffer = null;
            FinLog.e(TAG, "VideoFrame Buffer Is Null");
            return;
        }
        this.mBuffer = buffer instanceof VideoFrame.TextureBuffer ? new RTCOESTextureBuffer((VideoFrame.TextureBuffer)buffer) : new RTCI420Buffer((VideoFrame.I420Buffer)buffer);
    }

    public RTCBuffer getBuffer() {
        return this.mBuffer;
    }

    public int getRotation() {
        return this.mVideoFrame.getRotation();
    }

    public long getTimestampNs() {
        return this.mVideoFrame.getTimestampNs();
    }

    public int getRotatedWidth() {
        return this.mVideoFrame.getRotatedWidth();
    }

    public int getRotatedHeight() {
        return this.mVideoFrame.getRotatedHeight();
    }

    public static interface RTCBuffer {
        public int getWidth();

        public int getHeight();
    }

    public class RTCI420Buffer
    implements RTCBuffer {
        private final VideoFrame.I420Buffer mI420Buffer;

        RTCI420Buffer(VideoFrame.I420Buffer i420Buffer) {
            this.mI420Buffer = i420Buffer;
        }

        public ByteBuffer getDataY() {
            return this.mI420Buffer.getDataY();
        }

        public ByteBuffer getDataU() {
            return this.mI420Buffer.getDataU();
        }

        public ByteBuffer getDataV() {
            return this.mI420Buffer.getDataV();
        }

        public int getStrideY() {
            return this.mI420Buffer.getStrideY();
        }

        public int getStrideU() {
            return this.mI420Buffer.getStrideU();
        }

        public int getStrideV() {
            return this.mI420Buffer.getStrideV();
        }

        @Override
        public int getWidth() {
            return this.mI420Buffer.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mI420Buffer.getHeight();
        }

        public void copy(ByteBuffer dst) {
            YuvHelper.I420Copy(this.getDataY(), this.getStrideY(), this.getDataU(), this.getStrideU(), this.getDataV(), this.getStrideV(), dst, this.getWidth(), this.getHeight());
        }

        public void toNV12(ByteBuffer dst) {
            YuvHelper.I420ToNV12(this.getDataY(), this.getStrideY(), this.getDataU(), this.getStrideU(), this.getDataV(), this.getStrideV(), dst, this.getWidth(), this.getHeight());
        }
    }

    public class RTCOESTextureBuffer
    implements RTCBuffer {
        private final VideoFrame.TextureBuffer mTextureBuffer;

        RTCOESTextureBuffer(VideoFrame.TextureBuffer textureBuffer) {
            this.mTextureBuffer = textureBuffer;
        }

        public int getTextureId() {
            return this.mTextureBuffer.getTextureId();
        }

        public Matrix getTransformMatrix() {
            return this.mTextureBuffer.getTransformMatrix();
        }

        public float[] getOriginalMatrix() {
            return this.mTextureBuffer.getOriginalMatrix();
        }

        @Override
        public int getWidth() {
            return this.mTextureBuffer.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mTextureBuffer.getHeight();
        }
    }
}

