/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import org.json.JSONException;
import org.json.JSONObject;

public class RCRTCMediaResourceInfo
implements Parcelable {
    private String tag = RCRTCMediaResourceInfo.class.getSimpleName();
    private String streamId;
    private int type;
    private String uri;
    private String features;
    private RCRTCResourceState state = RCRTCResourceState.NORMAL;
    public static final Parcelable.Creator<RCRTCMediaResourceInfo> CREATOR = new Parcelable.Creator<RCRTCMediaResourceInfo>(){

        public RCRTCMediaResourceInfo createFromParcel(Parcel in) {
            return new RCRTCMediaResourceInfo(in);
        }

        public RCRTCMediaResourceInfo[] newArray(int size) {
            return new RCRTCMediaResourceInfo[size];
        }
    };

    public RCRTCMediaResourceInfo(String tag, String streamId, int type, String uri, String features) {
        this.tag = tag;
        this.streamId = streamId;
        this.type = type;
        this.uri = uri;
        this.features = features;
    }

    public RCRTCMediaResourceInfo(RCOutputStreamImpl outputStream) {
    }

    protected RCRTCMediaResourceInfo(Parcel in) {
        this.tag = in.readString();
        this.streamId = in.readString();
        this.type = in.readInt();
        this.uri = in.readString();
        this.features = in.readString();
        this.state = RCRTCResourceState.valueOf(in.readInt());
    }

    public RCRTCMediaResourceInfo(JSONObject jsonObject) {
        try {
            this.valueFromJson(jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public RCRTCMediaResourceInfo() {
    }

    public RCRTCMediaResourceInfo(String jsonStr) {
        if (jsonStr == null) {
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonStr);
            this.valueFromJson(jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void valueFromJson(JSONObject jsonObject) throws JSONException {
        this.tag = jsonObject.has("tag") ? jsonObject.getString("tag") : "";
        if (jsonObject.has("msid")) {
            this.streamId = jsonObject.getString("msid");
        }
        try {
            if (this.streamId != null) {
                int i = this.streamId.lastIndexOf(95);
                this.tag = i != -1 ? this.streamId.substring(i + 1) : RCRTCMediaResourceInfo.class.getSimpleName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsonObject.has("mediaType")) {
            this.type = jsonObject.getInt("mediaType");
        }
        if (jsonObject.has("uri")) {
            this.uri = jsonObject.getString("uri");
        }
        if (jsonObject.has("features")) {
            this.features = jsonObject.getString("features");
        }
        if (jsonObject.has("state")) {
            this.state = RCRTCResourceState.valueOf(jsonObject.getInt("state"));
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.tag);
        dest.writeString(this.streamId);
        dest.writeInt(this.type);
        dest.writeString(this.uri);
        dest.writeString(this.features);
        dest.writeInt(this.state.getValue());
    }

    public JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.putOpt("tag", (Object)this.tag);
            jsonObject.putOpt("msid", (Object)this.streamId);
            jsonObject.putOpt("mediaType", (Object)this.type);
            jsonObject.putOpt("uri", (Object)this.uri);
            jsonObject.putOpt("features", (Object)this.features);
            jsonObject.putOpt("state", (Object)this.state.getValue());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public RCRTCMediaType getType() {
        return RCRTCMediaType.getMediaType(this.type);
    }

    public void setType(RCRTCMediaType mediaType) {
        this.type = mediaType.getValue();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isSupportTiny() {
        return this.features != null && this.features.contains("simulcast");
    }

    public RCRTCResourceState getResourceState() {
        return this.state;
    }

    public void setResourceState(RCRTCResourceState resourceState) {
        this.state = resourceState;
    }

    public String toString() {
        return "MediaResourceInfo{tag='" + this.tag + '\'' + ", streamId='" + this.streamId + '\'' + ", type=" + this.type + ", uri='" + this.uri + '\'' + ", features='" + this.features + '\'' + ", resourceState=" + (Object)((Object)this.state) + '}';
    }
}

