/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.rongcloud.rtc.core.CreateEglCallback;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglRenderer;
import cn.rongcloud.rtc.core.GlRectDrawer;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class RCRTCVideoView
extends SurfaceView
implements SurfaceHolder.Callback,
VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final EglRenderer eglRenderer;
    private final double threshold = 8.0;
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock = new Object();
    private boolean isFirstFrameRendered;
    public int rotatedFrameWidth;
    public int rotatedFrameHeight;
    private int frameRotation;
    private boolean enableFixedSize = true;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean needCallback = true;
    private String userId;
    private volatile AtomicBoolean allowRenderer = new AtomicBoolean(true);
    private OnSizeChangedListener onSizeChangedListener;
    private boolean isLocal = false;

    public RCRTCVideoView(Context context) {
        super(context);
        ReportUtil.appStatus(ReportUtil.TAG.INITVIDEOVIEW, "identity", this.hashCode());
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public RCRTCVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        ReportUtil.appStatus(ReportUtil.TAG.INITVIDEOVIEW, "identity", this.hashCode());
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, String userId) {
        this.userId = userId;
        this.init(sharedContext, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        this.init(sharedContext, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        Object object = this.layoutLock;
        synchronized (object) {
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        this.eglRenderer.setCreateEglCallback(new CreateEglCallback(){

            @Override
            public void onFailed(Exception e) {
                if (RCRTCVideoView.this.rendererEvents != null) {
                    RCRTCVideoView.this.rendererEvents.onCreateEglFailed(e);
                }
            }
        });
        try {
            this.eglRenderer.init(sharedContext, configAttributes, drawer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawer) {
        this.eglRenderer.addFrameListener(listener, scale, drawer);
    }

    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        this.eglRenderer.addFrameListener(listener, scale);
    }

    public void removeFrameListener(EglRenderer.FrameListener listener) {
        this.eglRenderer.removeFrameListener(listener);
    }

    public void setEnableHardwareScalar(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
    }

    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingTypeMatchOrientation, scalingTypeMismatchOrientation);
    }

    public RendererCommon.ScalingType getScalingType() {
        return this.videoLayoutMeasure.getActualScalingType();
    }

    public void setFpsReduction(float fps) {
        this.eglRenderer.setFpsReduction(fps);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    public void setAllowRenderer(boolean isAllow) {
        this.allowRenderer.set(isAllow);
    }

    public void clearScreen() {
        this.eglRenderer.clearImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        Point size;
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        }
        this.setMeasuredDimension(size.x, size.y);
        if (this.rotatedFrameHeight != 0 && this.rotatedFrameWidth != 0 && this.needCallback && this.onSizeChangedListener != null) {
            this.onSizeChangedListener.onChanged(new Size(this.rotatedFrameWidth, this.rotatedFrameHeight));
            this.needCallback = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
                int drawnFrameHeight;
                int drawnFrameWidth;
                float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
                float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
                if (frameAspectRatio > layoutAspectRatio) {
                    drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                    drawnFrameHeight = this.rotatedFrameHeight;
                } else {
                    drawnFrameWidth = this.rotatedFrameWidth;
                    drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
                }
                int width = Math.min(this.getWidth(), drawnFrameWidth);
                int height = Math.min(this.getHeight(), drawnFrameHeight);
                FinLog.e(TAG, "updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
                if (width != this.surfaceWidth || height != this.surfaceHeight) {
                    this.surfaceWidth = width;
                    this.surfaceHeight = height;
                    this.getHolder().setFixedSize(width, height);
                }
            } else {
                this.surfaceHeight = 0;
                this.surfaceWidth = 0;
                this.getHolder().setSizeFromLayout();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder holder2) {
        ReportUtil.appStatus(ReportUtil.TAG.CREATEVIDEOVIEW, "identity", this.hashCode());
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(holder2.getSurface());
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder holder2) {
        ReportUtil.appStatus(ReportUtil.TAG.DESTROYVIDEOVIEW, "identity", this.hashCode());
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
    }

    public void surfaceChanged(SurfaceHolder holder2, int format, int width, int height) {
        Log.d((String)TAG, (String)("surfaceChanged: format: " + format + " size: " + width + "x" + height));
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.updateFrameDimensionsAndReportEvents(frame);
        this.eglRenderer.onFrame(frame);
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        final int rotatedWidth = rotation != 0 && rotation != 180 ? videoHeight : videoWidth;
        final int rotatedHeight = rotation != 0 && rotation != 180 ? videoWidth : videoHeight;
        this.postOrRun(new Runnable(){

            @Override
            public void run() {
                RCRTCVideoView.this.rotatedFrameWidth = rotatedWidth;
                RCRTCVideoView.this.rotatedFrameHeight = rotatedHeight;
                RCRTCVideoView.this.updateSurfaceSize();
                RCRTCVideoView.this.requestLayout();
            }
        });
    }

    @Override
    public void onCreateEglFailed(Exception e) {
        if (this.rendererEvents != null) {
            this.rendererEvents.onCreateEglFailed(e);
        }
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId()) + ": ";
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(final VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                FinLog.d(TAG, "Reporting first rendered frame for user:: " + this.userId);
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth == frame.getRotatedWidth()) {
                if (this.rotatedFrameHeight == frame.getRotatedHeight()) return;
            }
            Log.d((String)TAG, (String)("Reporting frame resolution changed to " + frame.getBuffer().getWidth() + "x" + frame.getBuffer().getHeight() + " with rotation " + frame.getRotation()));
            if (this.rendererEvents != null) {
                this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
            }
            if (this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.onSizeChangedListener != null) {
                try {
                    double oldRatio = RongRTCUtils.div(this.rotatedFrameWidth, this.rotatedFrameHeight);
                    double newRatio = RongRTCUtils.div(frame.getRotatedWidth(), frame.getRotatedHeight());
                    if (oldRatio != newRatio) {
                        double tempRation = RongRTCUtils.formatDouble4(oldRatio > newRatio ? oldRatio - newRatio : newRatio - oldRatio);
                        double thresholdNewHeight = RongRTCUtils.div(8.0, frame.getRotatedHeight());
                        double thresholdNewWidth = RongRTCUtils.div(8.0, frame.getRotatedWidth());
                        double b = Math.max(thresholdNewWidth, thresholdNewHeight);
                        if (!(tempRation > b)) {
                            // empty if block
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.rotatedFrameWidth = frame.getRotatedWidth();
            this.rotatedFrameHeight = frame.getRotatedHeight();
            this.frameRotation = frame.getRotation();
            this.post(new Runnable(){

                @Override
                public void run() {
                    RCRTCVideoView.this.updateSurfaceSize();
                    RCRTCVideoView.this.requestLayout();
                    if (RCRTCVideoView.this.onSizeChangedListener == null) {
                        return;
                    }
                    RCRTCVideoView.this.onSizeChangedListener.onChanged(new Size(frame.getRotatedWidth(), frame.getRotatedHeight()));
                }
            });
            return;
        }
    }

    public Size getSize() {
        return new Size(this.rotatedFrameWidth, this.rotatedFrameHeight);
    }

    public void setOnSizeChangedListener(OnSizeChangedListener onSizeChangedListener) {
        this.onSizeChangedListener = onSizeChangedListener;
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + string);
    }

    public static interface OnSizeChangedListener {
        public void onChanged(Size var1);
    }

    public class Size {
        public int with;
        public int height;

        public Size(int with, int height) {
            this.with = with;
            this.height = height;
        }

        public int getHW() {
            return this.with == 0 ? 0 : this.height / this.with;
        }
    }
}

