/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.graphics.SurfaceTexture;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglRenderer;
import cn.rongcloud.rtc.core.GlRectDrawer;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.VideoFrame;
import java.util.concurrent.CountDownLatch;

public class RCRTCTextureView
extends EglRenderer {
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock = new Object();
    private boolean isInitialized;
    private boolean isRenderingPaused;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private SurfaceTexture texture;
    private boolean isLocal = false;

    public RCRTCTextureView(String name) {
        super(name);
    }

    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        this.init(sharedContext, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        Object object = this.layoutLock;
        synchronized (object) {
            this.isFirstFrameRendered = false;
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = -1;
        }
        super.init(sharedContext, configAttributes, drawer);
    }

    @Override
    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        this.init(sharedContext, null, configAttributes, drawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFpsReduction(float fps) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = fps == 0.0f;
        }
        super.setFpsReduction(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.updateFrameDimensionsAndReportEvents(frame);
        super.onFrame(frame);
    }

    public void surfaceCreated(SurfaceTexture texture) {
        ThreadUtils.checkIsOnMainThread();
        this.texture = texture;
        this.createEglSurface(texture);
    }

    public void surfaceDestroyed() {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
                this.rotatedFrameWidth = frame.getRotatedWidth();
                this.rotatedFrameHeight = frame.getRotatedHeight();
                this.texture.setDefaultBufferSize(this.rotatedFrameWidth, this.rotatedFrameHeight);
                this.frameRotation = frame.getRotation();
            }
        }
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }
}

