/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.report;

import android.os.Handler;
import android.os.HandlerThread;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.report.ReportUserInfo;
import cn.rongcloud.rtc.api.report.StatusReportParser;
import cn.rongcloud.rtc.core.StatsObserver;
import cn.rongcloud.rtc.core.StatsReport;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import java.util.HashMap;

public class RTCStatusReportManager
implements StatsObserver {
    private static final String TAG = RTCStatusReportManager.class.getSimpleName();
    private HashMap<String, ReportUserInfo> mUserIdTrackIdMap = new HashMap();
    private StatusReportParser mStatusParser;
    private RTCConnectionHolder mConnection;
    private Object mMapLook = new Object();
    private Handler mHandler;
    public IRCRTCStatusReportListener mListener = null;
    private long mIntervalTime;

    public RTCStatusReportManager(RTCConnectionHolder connection, long interval) {
        this.mConnection = connection;
        this.mStatusParser = new StatusReportParser();
        this.mIntervalTime = interval < 100L ? 1000L : interval;
        this.start();
    }

    private void start() {
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Handler handler;
                RTCConnectionHolder connection = RTCStatusReportManager.this.mConnection;
                if (connection != null && RTCStatusReportManager.this.mListener != null) {
                    connection.getStatus(RTCStatusReportManager.this);
                }
                if ((handler = RTCStatusReportManager.this.mHandler) != null) {
                    handler.postDelayed((Runnable)this, RTCStatusReportManager.this.mIntervalTime);
                }
            }
        }, this.mIntervalTime);
    }

    public void stop() {
        if (this.mHandler != null) {
            this.mHandler.getLooper().quit();
        }
        this.mHandler = null;
        this.mConnection = null;
        this.mStatusParser = null;
        this.mListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReport(String userId, String streamId, String trackId) {
        Object object = this.mMapLook;
        synchronized (object) {
            if (!this.mUserIdTrackIdMap.containsKey(trackId)) {
                this.mUserIdTrackIdMap.put(trackId, new ReportUserInfo(userId, streamId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReport(String trackId) {
        Object object = this.mMapLook;
        synchronized (object) {
            this.mUserIdTrackIdMap.remove(trackId);
        }
    }

    public void setRTCStatusReportListener(IRCRTCStatusReportListener eventsListener) {
        this.mListener = eventsListener;
    }

    @Override
    public void onComplete(final StatsReport[] reports) {
        Handler handler = this.mHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StatusReportParser statusParser = RTCStatusReportManager.this.mStatusParser;
                if (statusParser != null) {
                    Object object = RTCStatusReportManager.this.mMapLook;
                    synchronized (object) {
                        statusParser.parseAndCallback(reports, RTCStatusReportManager.this.mUserIdTrackIdMap, RTCStatusReportManager.this.mListener);
                    }
                }
            }
        });
    }
}

