/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import com.google.gson.annotations.SerializedName;
import java.util.List;

public class RCRTCMixConfig
implements Parcelable {
    private int version = 1;
    private Integer mode;
    @SerializedName(value="host_user_id")
    private String hostUserId;
    private String host_stream_id;
    @SerializedName(value="output")
    private MediaConfig mediaConfig;
    @SerializedName(value="input")
    private CustomLayoutList customLayouts;
    public static final Parcelable.Creator<RCRTCMixConfig> CREATOR = new Parcelable.Creator<RCRTCMixConfig>(){

        public RCRTCMixConfig createFromParcel(Parcel source) {
            return new RCRTCMixConfig(source);
        }

        public RCRTCMixConfig[] newArray(int size) {
            return new RCRTCMixConfig[size];
        }
    };

    public RCRTCMixConfig(List<MediaConfig.CDNPushUrl> urls) {
        this.mediaConfig = new MediaConfig();
        this.mediaConfig.setCdn(urls);
    }

    public RCRTCMixConfig() {
        this.mode = MixLayoutMode.SUSPENSION.getValue();
    }

    public int getVersion() {
        return this.version;
    }

    public MixLayoutMode getLayoutMode() {
        return MixLayoutMode.valueOf(this.mode);
    }

    public void setLayoutMode(MixLayoutMode mode) {
        this.mode = mode.getValue();
    }

    public String getHostUserId() {
        return this.hostUserId;
    }

    public String getHostStreamId() {
        return this.host_stream_id;
    }

    public void setHostVideoStream(RCRTCStream stream) {
        this.hostUserId = ((RCStreamImpl)stream).getUserId();
        this.host_stream_id = stream.getStreamId();
    }

    public MediaConfig getMediaConfig() {
        return this.mediaConfig;
    }

    public void setMediaConfig(MediaConfig mediaConfig) {
        this.mediaConfig = mediaConfig;
    }

    public List<CustomLayoutList.CustomLayout> getCustomLayouts() {
        if (this.customLayouts != null) {
            return this.customLayouts.getCustomLayouts();
        }
        return null;
    }

    public void setCustomLayouts(List<CustomLayoutList.CustomLayout> customLayouts) {
        this.customLayouts = new CustomLayoutList(customLayouts);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.version);
        dest.writeInt(this.mode.intValue());
        dest.writeString(this.hostUserId);
        dest.writeParcelable((Parcelable)this.mediaConfig, flags);
        dest.writeParcelable((Parcelable)this.customLayouts, flags);
    }

    protected RCRTCMixConfig(Parcel in) {
        this.version = in.readInt();
        this.mode = in.readInt();
        this.hostUserId = in.readString();
        this.mediaConfig = (MediaConfig)in.readParcelable(MediaConfig.class.getClassLoader());
        this.customLayouts = (CustomLayoutList)in.readParcelable(CustomLayoutList.class.getClassLoader());
    }

    public static enum VideoRenderMode {
        CROP(1),
        WHOLE(2);

        private int value;

        private VideoRenderMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static VideoRenderMode valueOf(@IntRange(from=1L, to=2L) int value) {
            VideoRenderMode[] values;
            for (VideoRenderMode mode : values = VideoRenderMode.values()) {
                if (value != mode.value) continue;
                return mode;
            }
            return WHOLE;
        }
    }

    public static enum MixLayoutMode {
        CUSTOM(1),
        SUSPENSION(2),
        ADAPTIVE(3);

        private int value;

        private MixLayoutMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MixLayoutMode valueOf(@IntRange(from=1L, to=3L) int value) {
            MixLayoutMode[] values;
            for (MixLayoutMode mixLayoutMode : values = MixLayoutMode.values()) {
                if (value != mixLayoutMode.value) continue;
                return mixLayoutMode;
            }
            return SUSPENSION;
        }
    }

    public static class CustomLayoutList
    implements Parcelable {
        @SerializedName(value="video")
        private List<CustomLayout> customLayouts;
        public static final Parcelable.Creator<CustomLayoutList> CREATOR = new Parcelable.Creator<CustomLayoutList>(){

            public CustomLayoutList createFromParcel(Parcel source) {
                return new CustomLayoutList(source);
            }

            public CustomLayoutList[] newArray(int size) {
                return new CustomLayoutList[size];
            }
        };

        public CustomLayoutList(List<CustomLayout> customLayouts) {
            this.customLayouts = customLayouts;
        }

        public List<CustomLayout> getCustomLayouts() {
            return this.customLayouts;
        }

        public void setCustomLayouts(List<CustomLayout> customLayouts) {
            this.customLayouts = customLayouts;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.customLayouts);
        }

        public CustomLayoutList() {
        }

        protected CustomLayoutList(Parcel in) {
            this.customLayouts = in.createTypedArrayList(CustomLayout.CREATOR);
        }

        public static class CustomLayout
        implements Parcelable {
            @SerializedName(value="user_id")
            private String userId;
            private String stream_id;
            private int x;
            private int y;
            private int width;
            private int height;
            public static final Parcelable.Creator<CustomLayout> CREATOR = new Parcelable.Creator<CustomLayout>(){

                public CustomLayout createFromParcel(Parcel source) {
                    return new CustomLayout(source);
                }

                public CustomLayout[] newArray(int size) {
                    return new CustomLayout[size];
                }
            };

            public String getUserId() {
                return this.userId;
            }

            public String getStreamId() {
                return this.stream_id;
            }

            public void setVideoStream(RCRTCStream stream) {
                this.userId = ((RCStreamImpl)stream).getUserId();
                this.stream_id = stream.getStreamId();
            }

            public int getX() {
                return this.x;
            }

            public void setX(int x) {
                this.x = x;
            }

            public int getY() {
                return this.y;
            }

            public void setY(int y) {
                this.y = y;
            }

            public int getWidth() {
                return this.width;
            }

            public void setWidth(int width) {
                this.width = width;
            }

            public int getHeight() {
                return this.height;
            }

            public void setHeight(int height) {
                this.height = height;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.userId);
                dest.writeInt(this.x);
                dest.writeInt(this.y);
                dest.writeInt(this.width);
                dest.writeInt(this.height);
            }

            public CustomLayout() {
            }

            protected CustomLayout(Parcel in) {
                this.userId = in.readString();
                this.x = in.readInt();
                this.y = in.readInt();
                this.width = in.readInt();
                this.height = in.readInt();
            }
        }
    }

    public static class MediaConfig
    implements Parcelable {
        @SerializedName(value="video")
        private VideoConfig videoConfig;
        @SerializedName(value="audio")
        private AudioConfig audioConfig = null;
        private List<CDNPushUrl> cdn = null;
        public static final Parcelable.Creator<MediaConfig> CREATOR = new Parcelable.Creator<MediaConfig>(){

            public MediaConfig createFromParcel(Parcel source) {
                return new MediaConfig(source);
            }

            public MediaConfig[] newArray(int size) {
                return new MediaConfig[size];
            }
        };

        public VideoConfig getVideoConfig() {
            return this.videoConfig;
        }

        public void setVideoConfig(VideoConfig videoConfig) {
            this.videoConfig = videoConfig;
        }

        public AudioConfig getAudioConfig() {
            return this.audioConfig;
        }

        public void setAudioConfig(AudioConfig audioConfig) {
            this.audioConfig = audioConfig;
        }

        protected void setCdn(List<CDNPushUrl> cdnList) {
            this.cdn = cdnList;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.videoConfig, flags);
            dest.writeParcelable((Parcelable)this.audioConfig, flags);
        }

        public MediaConfig() {
        }

        protected MediaConfig(Parcel in) {
            this.videoConfig = (VideoConfig)in.readParcelable(VideoConfig.class.getClassLoader());
            this.audioConfig = (AudioConfig)in.readParcelable(AudioConfig.class.getClassLoader());
        }

        public static class AudioConfig
        implements Parcelable {
            private int bitrate;
            public static final Parcelable.Creator<AudioConfig> CREATOR = new Parcelable.Creator<AudioConfig>(){

                public AudioConfig createFromParcel(Parcel source) {
                    return new AudioConfig(source);
                }

                public AudioConfig[] newArray(int size) {
                    return new AudioConfig[size];
                }
            };

            public AudioConfig() {
            }

            public AudioConfig(int bitrate) {
                this.bitrate = bitrate;
            }

            public int getBitrate() {
                return this.bitrate;
            }

            public void setBitrate(int bitrate) {
                this.bitrate = bitrate;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.bitrate);
            }

            protected AudioConfig(Parcel in) {
                this.bitrate = in.readInt();
            }
        }

        public static class VideoConfig
        implements Parcelable {
            @SerializedName(value="normal")
            private VideoLayout videoLayout;
            @SerializedName(value="tiny")
            private VideoLayout tinyVideoLayout;
            @SerializedName(value="exparams")
            private VideoExtend extend;
            private String backgroundColor;
            public static final Parcelable.Creator<VideoConfig> CREATOR = new Parcelable.Creator<VideoConfig>(){

                public VideoConfig createFromParcel(Parcel source) {
                    return new VideoConfig(source);
                }

                public VideoConfig[] newArray(int size) {
                    return new VideoConfig[size];
                }
            };

            public VideoConfig() {
            }

            public VideoLayout getVideoLayout() {
                return this.videoLayout;
            }

            public void setVideoLayout(VideoLayout videoLayout) {
                this.videoLayout = videoLayout;
            }

            public VideoLayout getTinyVideoLayout() {
                return this.tinyVideoLayout;
            }

            public void setTinyVideoLayout(VideoLayout tinyVideoLayout) {
                this.tinyVideoLayout = tinyVideoLayout;
            }

            public VideoExtend getExtend() {
                return this.extend;
            }

            public void setExtend(VideoExtend extend) {
                this.extend = extend;
            }

            public boolean setBackgroundColor(int backgroundColor) {
                if (backgroundColor < 0 || backgroundColor > 0xFFFFFF) {
                    return false;
                }
                this.backgroundColor = String.format("0x%06x", backgroundColor);
                return true;
            }

            public boolean setBackgroundColor(int red, int green, int blue) {
                if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
                    return false;
                }
                this.backgroundColor = String.format("0x%02x%02x%02x", red, green, blue);
                return true;
            }

            public String getBackgroundColor() {
                return this.backgroundColor;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeParcelable((Parcelable)this.videoLayout, flags);
                dest.writeParcelable((Parcelable)this.tinyVideoLayout, flags);
                dest.writeParcelable((Parcelable)this.extend, flags);
            }

            protected VideoConfig(Parcel in) {
                this.videoLayout = (VideoLayout)in.readParcelable(VideoLayout.class.getClassLoader());
                this.tinyVideoLayout = (VideoLayout)in.readParcelable(VideoLayout.class.getClassLoader());
                this.extend = (VideoExtend)in.readParcelable(VideoExtend.class.getClassLoader());
            }

            public static class VideoExtend
            implements Parcelable {
                private int renderMode = VideoRenderMode.access$000(VideoRenderMode.WHOLE);
                public static final Parcelable.Creator<VideoExtend> CREATOR = new Parcelable.Creator<VideoExtend>(){

                    public VideoExtend createFromParcel(Parcel source) {
                        return new VideoExtend(source);
                    }

                    public VideoExtend[] newArray(int size) {
                        return new VideoExtend[size];
                    }
                };

                public VideoExtend(VideoRenderMode renderMode) {
                    this.renderMode = renderMode.value;
                }

                public VideoRenderMode getRenderMode() {
                    return VideoRenderMode.valueOf(this.renderMode);
                }

                public void setRenderMode(VideoRenderMode renderMode) {
                    this.renderMode = renderMode.value;
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeInt(this.renderMode);
                }

                protected VideoExtend(Parcel in) {
                    this.renderMode = in.readInt();
                }
            }

            public static class VideoLayout
            implements Parcelable {
                private int width;
                private int height;
                private int fps;
                private int bitrate;
                public static final Parcelable.Creator<VideoLayout> CREATOR = new Parcelable.Creator<VideoLayout>(){

                    public VideoLayout createFromParcel(Parcel source) {
                        return new VideoLayout(source);
                    }

                    public VideoLayout[] newArray(int size) {
                        return new VideoLayout[size];
                    }
                };

                public int getWidth() {
                    return this.width;
                }

                public void setWidth(int width) {
                    this.width = width;
                }

                public int getHeight() {
                    return this.height;
                }

                public void setHeight(int height) {
                    this.height = height;
                }

                public int getFps() {
                    return this.fps;
                }

                public void setFps(int fps) {
                    this.fps = fps;
                }

                public int getBitrate() {
                    return this.bitrate;
                }

                public void setBitrate(int bitrate) {
                    this.bitrate = bitrate;
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeInt(this.width);
                    dest.writeInt(this.height);
                    dest.writeInt(this.fps);
                    dest.writeInt(this.bitrate);
                }

                public VideoLayout() {
                }

                protected VideoLayout(Parcel in) {
                    this.width = in.readInt();
                    this.height = in.readInt();
                    this.fps = in.readInt();
                    this.bitrate = in.readInt();
                }
            }
        }

        public static class CDNPushUrl
        implements Parcelable {
            public String pushurl;
            public static final Parcelable.Creator<CDNPushUrl> CREATOR = new Parcelable.Creator<CDNPushUrl>(){

                public CDNPushUrl createFromParcel(Parcel in) {
                    return new CDNPushUrl(in);
                }

                public CDNPushUrl[] newArray(int size) {
                    return new CDNPushUrl[size];
                }
            };

            public CDNPushUrl(String pushurl) {
                this.pushurl = pushurl;
            }

            protected CDNPushUrl(Parcel in) {
                this.pushurl = in.readString();
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.pushurl);
            }

            public int describeContents() {
                return 0;
            }
        }
    }
}

