/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc;

import android.content.Context;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCMicOutputStream;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.proxy.message.CancelInviteMessage;
import cn.rongcloud.rtc.proxy.message.EndInviteMessage;
import cn.rongcloud.rtc.proxy.message.InviteAnswerMessage;
import cn.rongcloud.rtc.proxy.message.InviteMessage;
import cn.rongcloud.rtc.proxy.message.InviteTimeoutMessage;
import cn.rongcloud.rtc.proxy.message.KickMessage;
import cn.rongcloud.rtc.proxy.message.ModifyResourceMessage;
import cn.rongcloud.rtc.proxy.message.PublishResourceMessage;
import cn.rongcloud.rtc.proxy.message.RoomUserStateMessage;
import cn.rongcloud.rtc.proxy.message.TotalContentResources;
import cn.rongcloud.rtc.proxy.message.UnPublishResourceMessage;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RongRTCSessionManager;
import io.rong.imlib.IMLibExtensionModule;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.HardwareResource;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.List;

public class RongRTCExtensionModule
implements IMLibExtensionModule {
    private static final String TAG = "RongRTCExtensionModule";

    public void onCreate(Context context, String appKey) {
        FinLog.d(TAG, "onCreate: ");
        RongRTCSessionManager.getInstance().init(context);
        RTCEngineImpl.getInstance().setAppKey(appKey);
    }

    public void onLogin(String userId, String token) {
        FinLog.d(TAG, "onLogin: ");
        RTCEngineImpl.getInstance().onIMLogin(userId, token);
    }

    public boolean onReceiveMessage(Message message, int left, boolean offline, int cmdLeft) {
        return false;
    }

    public List<Class<? extends MessageContent>> getMessageContentList() {
        ArrayList<Class<? extends MessageContent>> messageContentClazzList = new ArrayList<Class<? extends MessageContent>>();
        messageContentClazzList.add(PublishResourceMessage.class);
        messageContentClazzList.add(UnPublishResourceMessage.class);
        messageContentClazzList.add(ModifyResourceMessage.class);
        messageContentClazzList.add(RoomUserStateMessage.class);
        messageContentClazzList.add(KickMessage.class);
        messageContentClazzList.add(TotalContentResources.class);
        messageContentClazzList.add(InviteMessage.class);
        messageContentClazzList.add(InviteTimeoutMessage.class);
        messageContentClazzList.add(CancelInviteMessage.class);
        messageContentClazzList.add(InviteAnswerMessage.class);
        messageContentClazzList.add(EndInviteMessage.class);
        return messageContentClazzList;
    }

    public List<Class<? extends MessageContent>> getCmdMessageContentList() {
        return null;
    }

    public void onConnectStatusChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus connectionStatus) {
        FinLog.v(TAG, "onChanged() connectionStatus = " + connectionStatus);
        RTCEngineImpl.getInstance().onIMConnectChanged(connectionStatus);
    }

    public void onLogout() {
    }

    public void onDestroy() {
    }

    public boolean onRequestHardwareResource(HardwareResource.ResourceType resourceType) {
        RCRTCCameraOutputStream defaultVideoStream;
        if (resourceType == HardwareResource.ResourceType.AUDIO) {
            RCRTCMicOutputStream defaultAudioStream = RTCEngineImpl.getInstance().getDefaultAudioStream();
            if (defaultAudioStream != null) {
                return ((RCMicOutputStreamImpl)defaultAudioStream).isRecording();
            }
        } else if (resourceType == HardwareResource.ResourceType.VIDEO && (defaultVideoStream = RTCEngineImpl.getInstance().getDefaultVideoStream()) != null) {
            return ((RCCameraOutputStreamImpl)defaultVideoStream).isCapturing();
        }
        return false;
    }
}

