/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.tools;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TextTextureGenerator {
    public static final int CHAR_MAX = 256;
    public static final int MIN_DIFF_SIZE = 4;
    private int textFontsize = -1;
    private int textFontsizeTrue = -1;
    static final int AN_LABEL_MAXCHARINLINE = 7;
    static final int AN_LABEL_MULITYLINE_SPAN = 2;
    private static final int ALIGNCENTER = 51;
    private static final int ALIGNLEFT = 49;
    private static final int ALIGNRIGHT = 50;
    private float baseLine = 0.0f;
    private float startX = 0.0f;
    private Paint textPaint = null;

    public static int getNearstSize2N(int n2) {
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3;
    }

    public TextTextureGenerator() {
        this.createTextParam();
    }

    private void createTextParam() {
        float f2;
        this.textFontsizeTrue = this.textFontsize - 2;
        this.textPaint = TextTextureGenerator.newPaint(null, this.textFontsizeTrue, 49);
        this.startX = f2 = (float)(this.textFontsize - this.textFontsizeTrue) / 2.0f;
        float f3 = 7.3242188f;
        float f4 = -27.832031f;
        try {
            Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
            f3 = fontMetrics.descent;
            f4 = fontMetrics.ascent;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.baseLine = ((float)this.textFontsizeTrue - (f3 + f4)) / 2.0f + f2 + 0.5f;
    }

    public byte[] getTextPixelBuffer(int n2, int n3) {
        if (this.textFontsize != n3) {
            this.textFontsize = n3;
            this.createTextParam();
        }
        try {
            char[] cArray = new char[]{(char)n2};
            float f2 = this.baseLine;
            Bitmap bitmap = Bitmap.createBitmap((int)this.textFontsize, (int)this.textFontsize, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(bitmap);
            byte[] byArray = new byte[this.textFontsize * this.textFontsize];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            float f3 = this.textPaint.measureText(String.valueOf((char)n2));
            if (cArray[0] > '\u0000' && cArray[0] < '\u0100') {
                f2 -= 1.5f;
            }
            Paint.Align align = this.textPaint.getTextAlign();
            float f4 = f3 - (float)this.textFontsizeTrue;
            if (align != Paint.Align.CENTER && f4 >= 4.0f) {
                this.textPaint.setTextAlign(Paint.Align.CENTER);
                this.textPaint.setTextSize((float)this.textFontsizeTrue - f4);
                canvas.drawText(cArray, 0, 1, ((float)this.textFontsizeTrue - f4) / 2.0f, f2, this.textPaint);
                this.textPaint.setTextAlign(align);
            } else {
                canvas.drawText(cArray, 0, 1, this.startX, f2, this.textPaint);
            }
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            bitmap.recycle();
            bitmap = null;
            byteBuffer = null;
            return byArray;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte[] getCharsWidths(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n2];
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[0] = this.textPaint.measureText((char)nArray[i2] + "");
            byArray[i2] = (byte)(fArray[0] + (float)(this.textFontsize - this.textFontsizeTrue));
        }
        return byArray;
    }

    private static Paint newPaint(String string, int n2, int n3) {
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(-1);
        textPaint.setTextSize((float)n2);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTypeface(Typeface.DEFAULT);
        switch (n3) {
            case 51: {
                textPaint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 49: {
                textPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 50: {
                textPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                textPaint.setTextAlign(Paint.Align.LEFT);
            }
        }
        return textPaint;
    }

    public static float getFontlength(Paint paint, String string) {
        return paint.measureText(string);
    }

    public static float getFontHeight(Paint paint) {
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        return fontMetrics.descent - fontMetrics.ascent;
    }
}

