/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.message;

import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.maploader.Pools;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.message.AbstractGestureMapMessage;

public class ScaleGestureMapMessage
extends AbstractGestureMapMessage {
    public float scaleDelta = 0.0f;
    public int pivotX = 0;
    public int pivotY = 0;
    private static final Pools.SynchronizedPool<ScaleGestureMapMessage> M_POOL = new Pools.SynchronizedPool(256);

    public static ScaleGestureMapMessage obtain(int n2, float f2, int n3, int n4) {
        ScaleGestureMapMessage scaleGestureMapMessage = M_POOL.acquire();
        if (scaleGestureMapMessage == null) {
            scaleGestureMapMessage = new ScaleGestureMapMessage(n2, f2, n3, n4);
        } else {
            scaleGestureMapMessage.reset();
            scaleGestureMapMessage.setParams(n2, f2, n3, n4);
        }
        return scaleGestureMapMessage;
    }

    public void recycle() {
        M_POOL.release(this);
    }

    public static void destory() {
        M_POOL.destory();
    }

    private void setParams(int n2, float f2, int n3, int n4) {
        this.setState(n2);
        this.scaleDelta = f2;
        this.pivotX = n3;
        this.pivotY = n4;
    }

    public ScaleGestureMapMessage(int n2, float f2, int n3, int n4) {
        super(n2);
        this.setParams(n2, f2, n3, n4);
    }

    public int getType() {
        return 1;
    }

    public void runCameraUpdate(GLMapState gLMapState) {
        if (this.isUseAnchor) {
            this.setMapZoomer(gLMapState);
            return;
        }
        int n2 = this.pivotX;
        int n3 = this.pivotY;
        if (this.isGestureScaleByMapCenter) {
            n2 = this.width >> 1;
            n3 = this.height >> 1;
        }
        IPoint iPoint = null;
        IPoint iPoint2 = null;
        if (n2 > 0 || n3 > 0) {
            iPoint = IPoint.obtain();
            iPoint2 = IPoint.obtain();
            this.win2geo(gLMapState, n2, n3, iPoint);
            gLMapState.setMapGeoCenter(iPoint.x, iPoint.y);
        }
        this.setMapZoomer(gLMapState);
        if (n2 > 0 || n3 > 0) {
            this.win2geo(gLMapState, n2, n3, iPoint2);
            if (iPoint != null) {
                gLMapState.setMapGeoCenter(2 * iPoint.x - iPoint2.x, 2 * iPoint.y - iPoint2.y);
            }
            gLMapState.recalculate();
        }
        if (iPoint != null) {
            iPoint.recycle();
        }
        if (iPoint2 != null) {
            iPoint2.recycle();
        }
    }

    private void setMapZoomer(GLMapState gLMapState) {
        float f2 = this.scaleDelta;
        float f3 = gLMapState.getMapZoomer() + f2;
        gLMapState.setMapZoomer(f3);
        gLMapState.recalculate();
    }
}

