/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.message;

import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.maploader.Pools;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.message.AbstractGestureMapMessage;

public class RotateGestureMapMessage
extends AbstractGestureMapMessage {
    public int pivotX = 0;
    public int pivotY = 0;
    public float angleDelta = 0.0f;
    private static final Pools.SynchronizedPool<RotateGestureMapMessage> M_POOL = new Pools.SynchronizedPool(256);

    public static RotateGestureMapMessage obtain(int n2, float f2, int n3, int n4) {
        RotateGestureMapMessage rotateGestureMapMessage = M_POOL.acquire();
        if (rotateGestureMapMessage == null) {
            rotateGestureMapMessage = new RotateGestureMapMessage(n2, f2, n3, n4);
        } else {
            rotateGestureMapMessage.reset();
            rotateGestureMapMessage.setParams(n2, f2, n3, n4);
        }
        return rotateGestureMapMessage;
    }

    public void recycle() {
        M_POOL.release(this);
    }

    public static void destory() {
        M_POOL.destory();
    }

    private void setParams(int n2, float f2, int n3, int n4) {
        this.setState(n2);
        this.angleDelta = f2;
        this.pivotX = n3;
        this.pivotY = n4;
    }

    public RotateGestureMapMessage(int n2, float f2, int n3, int n4) {
        super(n2);
        this.setParams(n2, f2, n3, n4);
        this.angleDelta = f2;
        this.pivotX = n3;
        this.pivotY = n4;
    }

    public int getType() {
        return 2;
    }

    public void runCameraUpdate(GLMapState gLMapState) {
        float f2 = this.angleDelta;
        float f3 = gLMapState.getMapAngle() + f2;
        if (this.isGestureScaleByMapCenter) {
            gLMapState.setMapAngle(f3);
            gLMapState.recalculate();
            return;
        }
        int n2 = this.pivotX;
        int n3 = this.pivotY;
        if (this.isUseAnchor) {
            n2 = this.anchorX;
            n3 = this.anchorY;
        }
        IPoint iPoint = null;
        IPoint iPoint2 = null;
        if (n2 > 0 || n3 > 0) {
            iPoint = IPoint.obtain();
            iPoint2 = IPoint.obtain();
            this.win2geo(gLMapState, n2, n3, iPoint);
            gLMapState.setMapGeoCenter(iPoint.x, iPoint.y);
        }
        gLMapState.setMapAngle(f3);
        gLMapState.recalculate();
        if (n2 > 0 || n3 > 0) {
            this.win2geo(gLMapState, n2, n3, iPoint2);
            if (iPoint != null) {
                gLMapState.setMapGeoCenter(2 * iPoint.x - iPoint2.x, 2 * iPoint.y - iPoint2.y);
            }
            gLMapState.recalculate();
        }
        if (iPoint != null) {
            iPoint.recycle();
        }
        if (iPoint2 != null) {
            iPoint2.recycle();
        }
    }
}

