/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.maploader;

import android.content.Context;
import com.amap.api.mapcore.util.eq;
import com.amap.api.mapcore.util.fr;
import com.amap.api.mapcore.util.hd;
import com.amap.api.mapcore.util.hg;
import com.amap.api.mapcore.util.hi;
import com.amap.api.mapcore.util.ho;
import com.amap.api.mapcore.util.ic;
import com.amap.api.mapcore.util.iu;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.ae.gmap.GLMapEngine;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AMapLoader
implements iu.a {
    ADataRequestParam mDataRequestParam;
    GLMapEngine mGLMapEngine;
    private int mEngineID = 0;
    private static final int GET_METHOD = 0;
    private volatile boolean isCanceled = false;
    private static String mDiu;
    private boolean mRequestCancel = false;
    public boolean isFinish = false;
    private iu downloadManager;

    public void onDownload(byte[] byArray, long l2) {
        if (byArray != null && this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.receiveNetData(this.mEngineID, this.mDataRequestParam.handler, byArray, byArray.length);
        }
    }

    public void onStop() {
        if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.netError(this.mEngineID, this.mDataRequestParam.handler, -1);
        }
    }

    public void onFinish() {
        if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.finishDownLoad(this.mEngineID, this.mDataRequestParam.handler);
        }
    }

    public void onException(Throwable throwable) {
        if (this.mGLMapEngine != null && this.mDataRequestParam != null) {
            this.mGLMapEngine.netError(this.mEngineID, this.mDataRequestParam.handler, -1);
        }
        ic.c(throwable, "AMapLoader", "download onException");
    }

    public AMapLoader(int n2, GLMapEngine gLMapEngine, ADataRequestParam aDataRequestParam) {
        this.mDataRequestParam = aDataRequestParam;
        this.mEngineID = n2;
        this.mGLMapEngine = gLMapEngine;
        this.mRequestCancel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest() {
        if (this.mRequestCancel) {
            return;
        }
        String string = this.mDataRequestParam.requestBaseUrl;
        String string2 = this.mDataRequestParam.requestUrl;
        boolean bl2 = true;
        if (!string.endsWith("?")) {
            string = string + "?";
        }
        if (bl2) {
            string2 = string2.replaceAll(";", this.getEncodeRequestParams(";").toString());
        }
        boolean bl3 = false;
        if (string != null && string.contains("http://m5.amap.com/")) {
            bl3 = true;
        }
        string2 = this.getRequestParams(string2, bl3, this.mDataRequestParam.nRequestType);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mDataRequestParam.nRequestType == 0) {
            stringBuffer.append(string2);
            stringBuffer.append("&csid=" + UUID.randomUUID().toString());
        } else {
            stringBuffer.append("csid=" + UUID.randomUUID().toString());
        }
        try {
            string = string + this.generateQueryString(this.mGLMapEngine.getContext(), stringBuffer.toString());
            AMapGridDownloadRequest aMapGridDownloadRequest = new AMapGridDownloadRequest(this.mGLMapEngine.getContext(), string, this.mGLMapEngine.getUserAgent());
            aMapGridDownloadRequest.setConnectionTimeout(1800000);
            aMapGridDownloadRequest.setSoTimeout(1800000);
            if (this.mDataRequestParam.nRequestType != 0) {
                byte[] byArray = string2.getBytes("UTF-8");
                aMapGridDownloadRequest.setPostEntityBytes(byArray);
            }
            this.downloadManager = new iu(aMapGridDownloadRequest, 0L, -1L, MapsInitializer.getProtocol() == 2);
            this.downloadManager.a(this);
        }
        catch (Throwable throwable) {
            this.onException(throwable);
        }
        finally {
            this.doCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        this.mRequestCancel = true;
        if (null != this.downloadManager && !this.isCanceled) {
            iu iu2 = this.downloadManager;
            synchronized (iu2) {
                try {
                    this.isCanceled = true;
                    this.downloadManager.a();
                    this.mGLMapEngine.setMapLoaderToTask(this.mEngineID, this.mDataRequestParam.handler, null);
                }
                catch (Throwable throwable) {
                    ic.c(throwable, "AMapLoader", "doCancel");
                }
            }
        }
    }

    private String getEncodeRequestParams(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public String getDeviceId(Context context) {
        if (null != context) {
            return hi.u(context);
        }
        return null;
    }

    protected String getRequestParams(String string, boolean bl2, int n2) {
        if (null == mDiu) {
            mDiu = this.getDeviceId(this.mGLMapEngine.getContext());
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl2) {
            stringBuffer.append("&channel=amap7&div=GNaviMap");
            stringBuffer.append("&diu=").append(mDiu);
        } else {
            stringBuffer.append("&channel=amapapi");
            stringBuffer.append("&div=GNaviMap");
            stringBuffer.append("&diu=").append(mDiu);
        }
        return stringBuffer.toString();
    }

    private String generateQueryString(Context context, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = hd.f(this.mGLMapEngine.getContext());
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuffer.append("&key=").append(string2);
        String string3 = this.sortReEncoderParams(stringBuffer.toString());
        String string4 = hg.a();
        stringBuffer.append("&ts=" + string4);
        stringBuffer.append("&scode=" + hg.a(context, string4, string3));
        stringBuffer.append("&dip=").append("16300");
        return stringBuffer.toString();
    }

    private String sortReEncoderParams(String string) {
        Object[] objectArray = string.split("&");
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : objectArray) {
            String string2 = this.strReEncoder((String)object);
            stringBuffer.append(string2);
            stringBuffer.append("&");
        }
        Object object = stringBuffer.toString();
        if (((String)object).length() > 1) {
            object = (String)((String)object).subSequence(0, ((String)object).length() - 1);
            return object;
        }
        return string;
    }

    private String strReEncoder(String string) {
        if (string == null) {
            return string;
        }
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ic.c(unsupportedEncodingException, "AbstractProtocalHandler", "strReEncoder");
        }
        catch (Exception exception) {
            ic.c(exception, "AbstractProtocalHandler", "strReEncoderException");
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AMapGridDownloadRequest
    extends eq {
        private final Context mContext;
        private String sUrl;
        private byte[] postEntityBytes;
        private String userAgent;

        public AMapGridDownloadRequest(Context context, String string, String string2) {
            this.mContext = context;
            this.sUrl = string;
            this.userAgent = string2;
        }

        @Override
        public Map<String, String> getRequestHead() {
            ho ho2 = fr.e();
            String string = null;
            if (ho2 != null) {
                string = ho2.b();
            }
            String string2 = hd.f(this.mContext);
            try {
                string2 = URLEncoder.encode(string2, "UTF-8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(16);
            hashtable.put("User-Agent", this.userAgent);
            hashtable.put("platinfo", String.format(Locale.US, "platform=Android&sdkversion=%s&product=%s", string, "3dmap"));
            hashtable.put("x-INFO", hg.a(this.mContext));
            hashtable.put("key", string2);
            hashtable.put("logversion", "2.1");
            return hashtable;
        }

        @Override
        public Map<String, String> getParams() {
            return null;
        }

        @Override
        public String getURL() {
            return this.sUrl;
        }

        public void setPostEntityBytes(byte[] byArray) {
            this.postEntityBytes = byArray;
        }

        @Override
        public byte[] getEntityBytes() {
            return this.postEntityBytes;
        }
    }

    public static class ADataRequestParam {
        public String requestUrl;
        public long handler;
        public int nRequestType;
        public byte[] enCodeString;
        public int nCompress;
        public String requestBaseUrl;
    }
}

