/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Rect;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;

public class Rectangle {
    public float left;
    public float right;
    public float bottom;
    public float top;
    public Rect rect = new Rect();
    private int beyond180Mode = 0;
    public IPoint[] clipRect = null;
    public FPoint[] clipMapRect = null;

    public int getBeyond180Mode() {
        return this.beyond180Mode;
    }

    public Rectangle() {
    }

    public Rectangle(Rect rect, int n2, int n3) {
        this.rect = rect;
        if (rect != null) {
            this.updateRect(rect, n2, n3);
            this.updateClipRect();
            this.updateClipMapRect(rect.centerX(), rect.centerY());
        }
    }

    public void updateRect(Rect rect, int n2, int n3) {
        if (rect != null) {
            this.rect = rect;
            this.rect.inset(-rect.width() / 8, -rect.height() / 8);
            float f2 = 100000.0f;
            this.beyond180Mode = (float)this.rect.left / f2 * ((float)this.rect.right / f2) < 0.0f ? -1 : (this.rect.right > 0x10000000 ? 1 : 0);
            this.updateClipRect();
            this.updateClipMapRect(n2, n3);
        }
    }

    private void updateClipRect() {
        if (this.clipRect == null) {
            this.clipRect = new IPoint[4];
            this.clipRect[0] = IPoint.obtain(0, 0);
            this.clipRect[1] = IPoint.obtain(0, 0);
            this.clipRect[2] = IPoint.obtain(0, 0);
            this.clipRect[3] = IPoint.obtain(0, 0);
        }
        if (this.rect != null) {
            this.clipRect[0].x = this.rect.left;
            this.clipRect[0].y = this.rect.top;
            this.clipRect[1].x = this.rect.right;
            this.clipRect[1].y = this.rect.top;
            this.clipRect[2].x = this.rect.right;
            this.clipRect[2].y = this.rect.bottom;
            this.clipRect[3].x = this.rect.left;
            this.clipRect[3].y = this.rect.bottom;
        }
    }

    private void updateClipMapRect(int n2, int n3) {
        if (this.clipMapRect == null) {
            this.clipMapRect = new FPoint[4];
            this.clipMapRect[0] = FPoint.obtain(0.0f, 0.0f);
            this.clipMapRect[1] = FPoint.obtain(0.0f, 0.0f);
            this.clipMapRect[2] = FPoint.obtain(0.0f, 0.0f);
            this.clipMapRect[3] = FPoint.obtain(0.0f, 0.0f);
        }
        if (this.rect != null) {
            this.clipMapRect[0].x = this.rect.left - n2;
            this.clipMapRect[0].y = this.rect.top - n3;
            this.clipMapRect[1].x = this.rect.right - n2;
            this.clipMapRect[1].y = this.rect.top - n3;
            this.clipMapRect[2].x = this.rect.right - n2;
            this.clipMapRect[2].y = this.rect.bottom - n3;
            this.clipMapRect[3].x = this.rect.left - n2;
            this.clipMapRect[3].y = this.rect.bottom - n3;
        }
    }

    public Rect getRect() {
        return this.rect;
    }

    public IPoint[] getClipRect() {
        return this.clipRect;
    }

    public FPoint[] getClipMapRect() {
        return this.clipMapRect;
    }

    public boolean contains(int n2, int n3) {
        if (this.rect != null) {
            boolean bl2 = this.rect.contains(n2, n3);
            if (bl2) {
                return true;
            }
            if (this.beyond180Mode != 0) {
                bl2 = this.rect.contains(n2 - 0x10000000, n3);
                if (bl2) {
                    return true;
                }
                bl2 = this.rect.contains(n2 + 0x10000000, n3);
                if (bl2) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean contains(IPoint iPoint) {
        if (iPoint == null) {
            return false;
        }
        return this.contains(iPoint.x, iPoint.y);
    }

    public boolean contains(Rect rect) {
        if (rect == null) {
            return false;
        }
        return this.rect.contains(rect);
    }

    public boolean isOverlap(Rect rect) {
        if (this.rect == null || rect == null) {
            return false;
        }
        return this.rect.left + this.rect.width() > rect.left && rect.left + rect.width() > this.rect.left && this.rect.top + this.rect.height() > rect.top && rect.top + rect.height() > this.rect.top;
    }

    public boolean isOverlap(int n2, int n3, int n4, int n5) {
        if (this.rect == null) {
            return false;
        }
        return this.rect.left + this.rect.width() > n2 && n2 + n4 > this.rect.left && this.rect.top + this.rect.height() > n3 && n3 + n5 > this.rect.top;
    }

    public Rectangle(float f2, float f3, float f4, float f5) {
        if (f2 >= f3 || f5 <= f4) {
            return;
        }
        this.left = f2;
        this.right = f3;
        this.top = f5;
        this.bottom = f4;
    }
}

