/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import com.amap.api.mapcore.util.ic;
import com.amap.api.maps.MapsInitializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String TAG = "FileUtil";

    public static void copy(Context context, String string, File file) throws Exception {
        file.delete();
        InputStream inputStream = context.getAssets().open(string);
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        inputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static boolean deleteFile(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isFile()) {
                    if (fileArray[i2].delete()) continue;
                    return false;
                }
                if (!FileUtil.deleteFile(fileArray[i2])) {
                    return false;
                }
                fileArray[i2].delete();
            }
        }
        file.delete();
        return true;
    }

    public static String getMapBaseStorage(Context context) {
        File file;
        if (context == null) {
            return null;
        }
        int n2 = Build.VERSION.SDK_INT;
        String string = "map_base_path";
        int n3 = 18;
        if (n2 > n3) {
            string = "map_base_path_v44";
        }
        String string2 = "";
        SharedPreferences sharedPreferences = context.getSharedPreferences("base_path", 0);
        string2 = MapsInitializer.sdcardDir != null && MapsInitializer.sdcardDir.trim().length() > 0 ? MapsInitializer.sdcardDir + File.separatorChar : sharedPreferences.getString(string, "");
        int n4 = 2;
        if (string2 != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                if (FileUtil.checkCanWrite(file)) {
                    return string2;
                }
                string2 = context.getCacheDir().toString() + "/amap/";
                if (string2 != null && string2.length() > n4) {
                    file = new File(string2);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    if (file.isDirectory()) {
                        return string2;
                    }
                }
            }
        }
        if ((string2 = FileUtil.getExternalStroragePath(context) + "/amap/") != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory() && file.canWrite()) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(string, string2);
                editor.commit();
                FileUtil.createNoMediaFileIfNotExist(string2);
                return string2;
            }
        }
        if ((string2 = context.getCacheDir().toString() + "/amap/") != null && string2.length() > n4) {
            file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                return string2;
            }
        }
        return string2;
    }

    public static boolean checkCanWrite(File file) {
        if (file == null) {
            return false;
        }
        if (!file.canWrite()) {
            return false;
        }
        File file2 = new File(file, "amap.tmp");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        if (file2 == null || !file2.exists()) {
            return false;
        }
        try {
            file2.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getExternalStroragePath(Context context) {
        int n2 = Build.VERSION.SDK_INT;
        int n3 = 12;
        if (n2 >= n3) {
            try {
                int n4;
                StorageManager storageManager = (StorageManager)context.getSystemService("storage");
                Method method = StorageManager.class.getMethod("getVolumeList", new Class[0]);
                Method method2 = StorageManager.class.getMethod("getVolumeState", String.class);
                Object[] objectArray = (Object[])method.invoke((Object)storageManager, new Object[0]);
                String string = null;
                String string2 = null;
                Boolean bl2 = false;
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = null;
                for (Object object : objectArray) {
                    Method method3 = object.getClass().getMethod("getPath", new Class[0]);
                    Method method4 = object.getClass().getMethod("isRemovable", new Class[0]);
                    string2 = (String)method3.invoke(object, new Object[0]);
                    string = (String)method2.invoke((Object)storageManager, method3.invoke(object, new Object[0]));
                    bl2 = (Boolean)method4.invoke(object, new Object[0]);
                    if (!TextUtils.isEmpty((CharSequence)string2) && string2.toLowerCase().contains("private")) continue;
                    if (bl2.booleanValue()) {
                        string3 = string2;
                        string5 = string;
                        if (null == string3 || null == string5 || !string5.equals("mounted")) continue;
                        if (n2 <= 18) {
                            string7 = string3;
                            break;
                        }
                        try {
                            File[] fileArray = context.getExternalFilesDirs(null);
                            if (fileArray == null) break;
                            if (fileArray.length > 1) {
                                string7 = fileArray[1].getAbsolutePath();
                                break;
                            }
                            string7 = string2;
                        }
                        catch (Exception exception) {
                            string7 = string3;
                        }
                        break;
                    }
                    string4 = string2;
                    string6 = string;
                }
                if (n2 <= (n4 = 18)) {
                    if (null == string7 && null != string4 && null != string6 && string6.equals("mounted")) {
                        string7 = string4;
                    }
                    return string7;
                }
                if (null != string4 && null != string6 && string6.equals("mounted")) {
                    string7 = string4;
                }
                return string7;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        File file = null;
        boolean bl3 = Environment.getExternalStorageState().equals("mounted");
        if (bl3) {
            file = Environment.getExternalStorageDirectory();
            return file.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDatasToFile(String string, byte[] byArray) {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            try {
                block11: {
                    block10: {
                        if (byArray == null) break block10;
                        if (byArray.length != 0) break block11;
                    }
                    Object var7_4 = null;
                    writeLock.unlock();
                    return;
                }
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_6 = null;
                writeLock.unlock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            writeLock.unlock();
            throw throwable;
        }
        Object var7_5 = null;
        writeLock.unlock();
    }

    public static byte[] readFileContents(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            fileInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            ic.c(throwable, TAG, "readFileContents");
            return null;
        }
    }

    public static void createNoMediaFileIfNotExist(String string) {
    }

    public static void saveFile(String string, String string2, boolean bl2) {
        try {
            Object object;
            String string3 = Environment.getExternalStorageDirectory().getAbsolutePath();
            File file = new File(string3 + "/" + string2);
            if (!file.exists()) {
                object = new File(file.getParent());
                ((File)object).mkdirs();
                file.createNewFile();
            }
            object = new FileOutputStream(file, bl2);
            ((FileOutputStream)object).write(string.getBytes("utf-8"));
            ((FileOutputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static byte[] readFileContentsFromAssets(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = null;
        try {
            String string2 = string;
            inputStream = assetManager.open(string2);
            int n2 = inputStream.available();
            if (n2 == 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; i2 += inputStream.read(byArray, i2, n2 - i2)) {
            }
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FileUtil.indexOfLastSeparator(string);
        return string.substring(n2 + 1);
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }
}

