/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.autonavi.amap.mapcore.FPoint;

public class FPointBounds {
    private final int mVersionCode;
    public final FPoint southwest;
    public final FPoint northeast;

    FPointBounds(int n2, FPoint fPoint, FPoint fPoint2) {
        this.mVersionCode = n2;
        this.southwest = fPoint;
        this.northeast = fPoint2;
    }

    public FPointBounds(FPoint fPoint, FPoint fPoint2) {
        this(1, fPoint, fPoint2);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(FPoint fPoint) {
        FPoint fPoint2 = fPoint;
        return this.containsy(fPoint2.y) && this.containsx(fPoint2.x);
    }

    public boolean contains(FPointBounds fPointBounds) {
        boolean bl2 = false;
        if (fPointBounds == null) {
            return bl2;
        }
        if (this.contains(fPointBounds.southwest) && this.contains(fPointBounds.northeast)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean intersects(FPointBounds fPointBounds) {
        if (fPointBounds == null) {
            return false;
        }
        return this.intersect(fPointBounds) || fPointBounds.intersect(this);
    }

    private boolean intersect(FPointBounds fPointBounds) {
        if (fPointBounds == null || fPointBounds.northeast == null || fPointBounds.southwest == null || this.northeast == null || this.southwest == null) {
            return false;
        }
        double d2 = fPointBounds.northeast.x + fPointBounds.southwest.x - this.northeast.x - this.southwest.x;
        double d3 = this.northeast.x - this.southwest.x + fPointBounds.northeast.x - this.southwest.x;
        double d4 = fPointBounds.northeast.y + fPointBounds.southwest.y - this.northeast.y - this.southwest.y;
        double d5 = this.northeast.y - this.southwest.y + fPointBounds.northeast.y - fPointBounds.southwest.y;
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    private boolean containsy(double d2) {
        return (double)this.southwest.y <= d2 && d2 <= (double)this.northeast.y;
    }

    private boolean containsx(double d2) {
        if (this.southwest.x <= this.northeast.x) {
            return (double)this.southwest.x <= d2 && d2 <= (double)this.northeast.x;
        }
        return (double)this.southwest.x <= d2 || d2 <= (double)this.northeast.x;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FPointBounds)) {
            return false;
        }
        FPointBounds fPointBounds = (FPointBounds)object;
        return this.southwest.equals((Object)fPointBounds.southwest) && this.northeast.equals((Object)fPointBounds.northeast);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("southwest = (");
        stringBuilder.append(this.southwest.x);
        stringBuilder.append(",");
        stringBuilder.append(this.southwest.y);
        stringBuilder.append(") northeast = (");
        stringBuilder.append(this.northeast.x);
        stringBuilder.append(",");
        stringBuilder.append(this.northeast.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private float mSouth = Float.POSITIVE_INFINITY;
        private float mNorth = Float.NEGATIVE_INFINITY;
        private float mWest = Float.POSITIVE_INFINITY;
        private float mEast = Float.NEGATIVE_INFINITY;

        public Builder include(FPoint fPoint) {
            this.mSouth = Math.min(this.mSouth, fPoint.y);
            this.mNorth = Math.max(this.mNorth, fPoint.y);
            this.mWest = Math.min(this.mWest, fPoint.x);
            this.mEast = Math.max(this.mEast, fPoint.x);
            return this;
        }

        private boolean containsx(double d2) {
            if (this.mWest <= this.mEast) {
                return (double)this.mWest <= d2 && d2 <= (double)this.mEast;
            }
            return (double)this.mWest <= d2 || d2 <= (double)this.mEast;
        }

        public FPointBounds build() {
            return new FPointBounds(FPoint.obtain(this.mWest, this.mSouth), FPoint.obtain(this.mEast, this.mNorth));
        }
    }
}

