/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Point;
import com.amap.api.mapcore.util.fr;
import com.amap.api.maps.AMap;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.amap.mapcore.MapConfig;

public abstract class AbstractCameraUpdateMessage {
    public Type nowType = Type.none;
    public float xPixel;
    public float yPixel;
    public float amount;
    public CameraPosition cameraPosition;
    public LatLngBounds bounds;
    public Point focus = null;
    public float zoom = Float.NaN;
    public float tilt = Float.NaN;
    public float bearing = Float.NaN;
    public Point geoPoint;
    public boolean isUseAnchor = false;
    public int anchorX;
    public int anchorY;
    public boolean isChangeFinished;
    public MapConfig mapConfig;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    public int paddingBottom;
    public AMap.CancelableCallback mCallback;
    public long mDuration = 250L;
    public int width;
    public int height;

    public abstract void runCameraUpdate(GLMapState var1);

    protected void normalChange(GLMapState gLMapState) {
        this.zoom = Float.isNaN(this.zoom) ? gLMapState.getMapZoomer() : this.zoom;
        this.bearing = Float.isNaN(this.bearing) ? gLMapState.getMapAngle() : this.bearing;
        this.tilt = Float.isNaN(this.tilt) ? gLMapState.getCameraDegree() : this.tilt;
        this.zoom = fr.a(this.mapConfig, this.zoom);
        this.tilt = fr.a(this.tilt, this.zoom);
        this.bearing = (float)(((double)this.bearing % 360.0 + 360.0) % 360.0);
        if (this.focus != null && this.geoPoint == null) {
            this.geoPoint = this.getAnchorGeoPoint(gLMapState, this.focus.x, this.focus.y);
        }
        if (!Float.isNaN(this.zoom)) {
            gLMapState.setMapZoomer(this.zoom);
        }
        if (!Float.isNaN(this.bearing)) {
            gLMapState.setMapAngle(this.bearing);
        }
        if (!Float.isNaN(this.tilt)) {
            gLMapState.setCameraDegree(this.tilt);
        }
        if (this.focus != null) {
            this.changeCenterByAnchor(gLMapState, this.geoPoint, this.focus.x, this.focus.y);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = this.geoPoint != null && (this.geoPoint.x != 0 || this.geoPoint.y != 0);
            if (bl2) {
                gLMapState.setMapGeoCenter(this.geoPoint.x, this.geoPoint.y);
            }
        }
    }

    protected void changeCenterByAnchor(GLMapState gLMapState, Point point) {
        this.changeCenterByAnchor(gLMapState, point, this.anchorX, this.anchorY);
    }

    protected void changeCenterByAnchor(GLMapState gLMapState, Point point, int n2, int n3) {
        gLMapState.recalculate();
        Point point2 = this.getAnchorGeoPoint(gLMapState, n2, n3);
        Point point3 = gLMapState.getMapGeoCenter();
        gLMapState.setMapGeoCenter(point3.x + point.x - point2.x, point3.y + point.y - point2.y);
    }

    protected Point getAnchorGeoPoint(GLMapState gLMapState, int n2, int n3) {
        Point point = new Point();
        gLMapState.screenToP20Point(n2, n3, point);
        return point;
    }

    public abstract void mergeCameraUpdateDelegate(AbstractCameraUpdateMessage var1);

    public void generateMapAnimation(GLMapEngine gLMapEngine) {
        GLMapState gLMapState = gLMapEngine.getNewMapState(1);
        this.runCameraUpdate(gLMapState);
        Point point = gLMapState.getMapGeoCenter();
        gLMapEngine.addGroupAnimation(1, (int)this.mDuration, gLMapState.getMapZoomer(), (int)gLMapState.getMapAngle(), (int)gLMapState.getCameraDegree(), point.x, point.y, this.mCallback);
        gLMapState.recycle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        none,
        zoomIn,
        changeCenter,
        changeTilt,
        changeBearing,
        changeBearingGeoCenter,
        changeGeoCenterZoom,
        zoomOut,
        zoomTo,
        zoomBy,
        scrollBy,
        newCameraPosition,
        newLatLngBounds,
        newLatLngBoundsWithSize,
        changeGeoCenterZoomTiltBearing;

    }
}

