/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gloverlay;

import android.util.SparseArray;
import com.amap.api.mapcore.util.ad;
import com.autonavi.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.ae.gmap.gloverlay.GLOverlay;
import com.autonavi.ae.gmap.gloverlay.GLOverlayTexture;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLOverlayBundle<E extends BaseMapOverlay<?, ?>> {
    private final List<E> mOverlayList = new ArrayList();
    ad mGLMapView = null;
    private long mNativeInstance = 0L;
    private SparseArray<GLOverlayTexture> mTextureCaches = new SparseArray();
    private int mEngineID;

    public static void intClr2PVRClr(float[] fArray, int n2) {
        fArray[2] = (float)(n2 & 0xFF) / 255.0f;
        fArray[1] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        fArray[0] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        fArray[3] = (float)(n2 >> 24 & 0xFF) / 255.0f;
    }

    public GLOverlayBundle(int n2, ad ad2) {
        this.mEngineID = n2;
        this.mGLMapView = ad2;
        this.mNativeInstance = ad2.a().getGlOverlayMgrPtr(this.mEngineID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOverlayCount() {
        List<E> list = this.mOverlayList;
        synchronized (list) {
            return this.mOverlayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cotainsOverlay(E e2) {
        if (e2 == null) {
            return false;
        }
        List<E> list = this.mOverlayList;
        synchronized (list) {
            return this.mOverlayList.contains(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getOverlay(int n2) {
        List<E> list = this.mOverlayList;
        synchronized (list) {
            if (n2 < 0 || n2 > this.mOverlayList.size() - 1) {
                return null;
            }
            return (E)((BaseMapOverlay)this.mOverlayList.get(n2));
        }
    }

    private int getOverlyExType(E e2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOverlay(E e2) {
        if (e2 == null) {
            return;
        }
        GLOverlayBundle.nativeAddGLOverlay(this.mNativeInstance, ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getNativeInstatnce(), ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getCode());
        ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).mIsInBundle = true;
        List<E> list = this.mOverlayList;
        synchronized (list) {
            this.mOverlayList.add(e2);
        }
    }

    public void sortOverlay() {
        GLOverlayBundle.nativeSortAllGLOverlay(this.mNativeInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOverlay(E e2) {
        if (e2 == null) {
            return;
        }
        GLOverlayBundle.nativeRemoveGLOverlay(this.mNativeInstance, ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getNativeInstatnce());
        ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).mIsInBundle = false;
        List<E> list = this.mOverlayList;
        synchronized (list) {
            this.mOverlayList.remove(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean bl2) {
        GLOverlayBundle.nativeClearAllGLOverlay(this.mNativeInstance, bl2);
        List<E> list = this.mOverlayList;
        synchronized (list) {
            for (int i2 = 0; i2 < this.mOverlayList.size(); ++i2) {
                BaseMapOverlay baseMapOverlay = (BaseMapOverlay)this.mOverlayList.get(i2);
                if (baseMapOverlay == null) continue;
                ((GLOverlay)baseMapOverlay.getGLOverlay()).mIsInBundle = false;
                ((GLOverlay)baseMapOverlay.getGLOverlay()).releaseInstance();
            }
            this.mOverlayList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFocus() {
        if (this.mOverlayList != null) {
            List<E> list = this.mOverlayList;
            synchronized (list) {
                for (int i2 = 0; i2 < this.mOverlayList.size(); ++i2) {
                    BaseMapOverlay baseMapOverlay = (BaseMapOverlay)this.mOverlayList.get(i2);
                    if (baseMapOverlay == null) continue;
                    baseMapOverlay.clearFocus();
                }
            }
        }
    }

    public boolean onSingleTap(int n2, int n3, int n4, int n5) {
        boolean bl2 = false;
        int n6 = 1;
        int n7 = n5 & n6;
        if (n7 == n6) {
            bl2 = this.onSingleTapPoints(n2, n3, n4);
        }
        if (bl2) {
            return true;
        }
        int n8 = 2;
        n7 = n5 & n8;
        if (n7 == n8) {
            bl2 = this.onSingleTapLines(n2, n3, n4);
        }
        return bl2;
    }

    boolean onSingleTapPoints(int n2, int n3, int n4) {
        return false;
    }

    boolean onSingleTapLines(int n2, int n3, int n4) {
        return false;
    }

    public long checkSingleTapOnLine(int n2, int n3) {
        long[] lArray = new long[3];
        if (GLOverlayBundle.nativeOnSingleTapLineOverlay(this.mNativeInstance, n2, n3, lArray)) {
            return lArray[0];
        }
        return -1L;
    }

    public long checkSingleTapOnPoint(int n2, int n3) {
        long[] lArray = new long[3];
        if (GLOverlayBundle.nativeOnSingleTapPointOverlay(this.mNativeInstance, n2, n3, lArray)) {
            return lArray[0];
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLOverlayTexture getOverlayTextureItem(int n2) {
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            return (GLOverlayTexture)this.mTextureCaches.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOverlayTextureItem(int n2, int n3, int n4, int n5) {
        GLOverlayTexture gLOverlayTexture = new GLOverlayTexture(n2, n3, n4, n5);
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.put(n2, (Object)gLOverlayTexture);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOverlayTextureItem(int n2, int n3, float f2, float f3, int n4, int n5) {
        GLOverlayTexture gLOverlayTexture = new GLOverlayTexture(n2, n3, f2, f3, n4, n5);
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.put(n2, (Object)gLOverlayTexture);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOverlayTexture() {
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.clear();
        }
    }

    public void reculateRouteBoard(ad ad2) {
    }

    private static native void nativeAddGLOverlay(long var0, long var2, long var4);

    private static native void nativeAddGLOverlayEx(long var0, long var2, long var4, int var6);

    private static native void nativeSortAllGLOverlay(long var0);

    private static native void nativeRemoveGLOverlay(long var0, long var2);

    private static native void nativeRemoveGLOverlayEx(long var0, long var2, int var4);

    private static native void nativeClearAllGLOverlay(long var0, boolean var2);

    private static native boolean nativeOnSingleTapPointOverlay(long var0, int var2, int var3, long[] var4);

    private static native boolean nativeOnSingleTapLineOverlay(long var0, int var2, int var3, long[] var4);

    public static class GLAmapFocusHits {
        public long mOverlayHashCode = 0L;
        public long mHitedIndex = 0L;
        public long mHitedTimes = 1000L;
    }
}

