/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.TileOverlayOptionsCreator;
import com.amap.api.maps.model.TileProvider;

public final class TileOverlayOptions
implements Parcelable {
    public static final TileOverlayOptionsCreator CREATOR = new TileOverlayOptionsCreator();
    private final int mVersionCode;
    private TileProvider mTileProvider;
    private boolean mVisible = true;
    private float mZIndex;
    private int memCacheSize = 0x500000;
    private long diskCacheSize = 0x1400000L;
    private String diskCacheDir = null;
    private boolean memoryCacheEnabled = true;
    private boolean diskCacheEnabled = true;

    public TileOverlayOptions() {
        this.mVersionCode = 1;
    }

    TileOverlayOptions(int n2, IBinder iBinder, boolean bl2, float f2) {
        this.mVersionCode = n2;
        this.mVisible = bl2;
        this.mZIndex = f2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.mVersionCode);
        parcel.writeValue((Object)this.mTileProvider);
        parcel.writeByte((byte)(this.mVisible ? 1 : 0));
        parcel.writeFloat(this.mZIndex);
        parcel.writeInt(this.memCacheSize);
        parcel.writeLong(this.diskCacheSize);
        parcel.writeString(this.diskCacheDir);
        parcel.writeByte((byte)(this.memoryCacheEnabled ? 1 : 0));
        parcel.writeByte((byte)(this.diskCacheEnabled ? 1 : 0));
    }

    public TileOverlayOptions tileProvider(TileProvider tileProvider) {
        this.mTileProvider = tileProvider;
        return this;
    }

    public TileOverlayOptions zIndex(float f2) {
        this.mZIndex = f2;
        return this;
    }

    public TileOverlayOptions visible(boolean bl2) {
        this.mVisible = bl2;
        return this;
    }

    public TileOverlayOptions memCacheSize(int n2) {
        this.memCacheSize = n2;
        return this;
    }

    public TileOverlayOptions diskCacheSize(int n2) {
        this.diskCacheSize = n2 * 1024;
        return this;
    }

    public TileOverlayOptions diskCacheDir(String string) {
        this.diskCacheDir = string;
        return this;
    }

    public TileOverlayOptions memoryCacheEnabled(boolean bl2) {
        this.memoryCacheEnabled = bl2;
        return this;
    }

    public TileOverlayOptions diskCacheEnabled(boolean bl2) {
        this.diskCacheEnabled = bl2;
        return this;
    }

    public TileProvider getTileProvider() {
        return this.mTileProvider;
    }

    public float getZIndex() {
        return this.mZIndex;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public int getMemCacheSize() {
        return this.memCacheSize;
    }

    public long getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public String getDiskCacheDir() {
        return this.diskCacheDir;
    }

    public boolean getMemoryCacheEnabled() {
        return this.memoryCacheEnabled;
    }

    public boolean getDiskCacheEnabled() {
        return this.diskCacheEnabled;
    }
}

