/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolylineOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolylineOptions
extends BaseOptions
implements Parcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    public static final int DOTTEDLINE_TYPE_SQUARE = 0;
    public static final int DOTTEDLINE_TYPE_CIRCLE = 1;
    private final List<LatLng> points;
    private float width = 10.0f;
    private int color = -16777216;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    String a;
    private BitmapDescriptor customTexture;
    private List<BitmapDescriptor> customTextureList;
    private List<Integer> colorValues;
    private List<Integer> customIndexs;
    private boolean isUseTexture = true;
    private boolean isGeodesic = false;
    private boolean isDottedLine = false;
    private boolean isGradient = false;
    private float transparency = 1.0f;
    private boolean isAboveMaskLayer = false;
    private int dottedLineType = 0;
    private LineCapType lineCapType = LineCapType.LineCapRound;
    private LineJoinType lineJoinType = LineJoinType.LineJoinBevel;
    private int nLineCapType = 3;
    private int nLineJoinType = 0;
    private float shownRatio = -1.0f;
    private float shownRangeBegin = -1.0f;
    private float shownRangeEnd = -1.0f;
    private final String type = "PolylineOptions";
    private int[] jniColorValues;
    private int[] jniCustomIndexes;
    private List<String> bitmapSymbolList;
    private String bitmapSymbol;
    private boolean isPointsUpdated = false;
    private boolean isCustomTextureListUpdated = false;
    private boolean isColorValuesUpdated = false;
    private boolean isCustomIndexesUpdated = false;
    private double[] pointList;

    public PolylineOptions() {
        this.points = new ArrayList<LatLng>();
    }

    public PolylineOptions setUseTexture(boolean bl2) {
        this.isUseTexture = bl2;
        return this;
    }

    public PolylineOptions setCustomTexture(BitmapDescriptor bitmapDescriptor) {
        this.customTexture = bitmapDescriptor;
        if (bitmapDescriptor != null) {
            this.bitmapSymbol = bitmapDescriptor.getId();
        }
        return this;
    }

    public BitmapDescriptor getCustomTexture() {
        return this.customTexture;
    }

    public PolylineOptions setCustomTextureList(List<BitmapDescriptor> list) {
        this.customTextureList = list;
        try {
            if (list != null) {
                this.bitmapSymbolList = new ArrayList<String>();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    this.bitmapSymbolList.add(list.get(i2).getId());
                }
                this.isCustomTextureListUpdated = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public List<BitmapDescriptor> getCustomTextureList() {
        return this.customTextureList;
    }

    public PolylineOptions setCustomTextureIndex(List<Integer> list) {
        try {
            this.customIndexs = list;
            this.jniCustomIndexes = new int[list.size()];
            for (int i2 = 0; i2 < this.jniCustomIndexes.length; ++i2) {
                this.jniCustomIndexes[i2] = list.get(i2);
            }
            this.isCustomIndexesUpdated = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public List<Integer> getCustomTextureIndex() {
        return this.customIndexs;
    }

    public PolylineOptions colorValues(List<Integer> list) {
        try {
            this.colorValues = list;
            this.jniColorValues = new int[list.size()];
            for (int i2 = 0; i2 < this.jniColorValues.length; ++i2) {
                this.jniColorValues[i2] = list.get(i2);
            }
            this.isColorValuesUpdated = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public List<Integer> getColorValues() {
        return this.colorValues;
    }

    public PolylineOptions useGradient(boolean bl2) {
        this.isGradient = bl2;
        return this;
    }

    public boolean isUseGradient() {
        return this.isGradient;
    }

    public boolean isUseTexture() {
        return this.isUseTexture;
    }

    public boolean isGeodesic() {
        return this.isGeodesic;
    }

    public PolylineOptions add(LatLng latLng) {
        if (latLng != null) {
            try {
                this.points.add(latLng);
                this.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions add(LatLng ... latLngArray) {
        if (latLngArray != null) {
            try {
                this.points.addAll(Arrays.asList(latLngArray));
                this.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> iterable) {
        if (iterable != null) {
            try {
                for (LatLng latLng : iterable) {
                    this.points.add(latLng);
                }
                this.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this;
    }

    public PolylineOptions width(float f2) {
        this.width = f2;
        return this;
    }

    public PolylineOptions color(int n2) {
        this.color = n2;
        return this;
    }

    public PolylineOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public PolylineOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public PolylineOptions geodesic(boolean bl2) {
        this.isGeodesic = bl2;
        return this;
    }

    public PolylineOptions setDottedLine(boolean bl2) {
        this.isDottedLine = bl2;
        return this;
    }

    public boolean isDottedLine() {
        return this.isDottedLine;
    }

    public PolylineOptions setDottedLineType(int n2) {
        this.dottedLineType = n2 == 0 ? 0 : 1;
        return this;
    }

    public PolylineOptions lineCapType(LineCapType lineCapType) {
        if (lineCapType != null) {
            this.lineCapType = lineCapType;
            this.nLineCapType = lineCapType.getTypeValue();
        }
        return this;
    }

    public PolylineOptions lineJoinType(LineJoinType lineJoinType) {
        if (lineJoinType != null) {
            this.lineJoinType = lineJoinType;
            this.nLineJoinType = lineJoinType.getTypeValue();
        }
        return this;
    }

    public LineCapType getLineCapType() {
        return this.lineCapType;
    }

    public LineJoinType getLineJoinType() {
        return this.lineJoinType;
    }

    public int getDottedLineType() {
        return this.dottedLineType;
    }

    public List<LatLng> getPoints() {
        return this.points;
    }

    public float getWidth() {
        return this.width;
    }

    public int getColor() {
        return this.color;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeTypedList(this.points);
        parcel.writeFloat(this.width);
        parcel.writeInt(this.color);
        parcel.writeInt(this.dottedLineType);
        parcel.writeFloat(this.zIndex);
        parcel.writeFloat(this.transparency);
        parcel.writeString(this.a);
        parcel.writeInt(this.lineCapType.getTypeValue());
        parcel.writeInt(this.lineJoinType.getTypeValue());
        parcel.writeBooleanArray(new boolean[]{this.isVisible, this.isDottedLine, this.isGeodesic, this.isGradient, this.isAboveMaskLayer});
        if (this.customTexture != null) {
            parcel.writeParcelable((Parcelable)this.customTexture, n2);
        }
        if (this.customTextureList != null) {
            parcel.writeList(this.customTextureList);
        }
        if (this.customIndexs != null) {
            parcel.writeList(this.customIndexs);
        }
        if (this.colorValues != null) {
            parcel.writeList(this.colorValues);
        }
        parcel.writeFloat(this.shownRatio);
    }

    public PolylineOptions transparency(float f2) {
        this.transparency = f2;
        return this;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public PolylineOptions aboveMaskLayer(boolean bl2) {
        this.isAboveMaskLayer = bl2;
        return this;
    }

    public boolean isAboveMaskLayer() {
        return this.isAboveMaskLayer;
    }

    public void setPoints(List<LatLng> list) {
        if (list != null && this.points != list) {
            try {
                this.points.clear();
                this.points.addAll(list);
                this.isPointsUpdated = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public float getShownRatio() {
        return this.shownRatio;
    }

    public PolylineOptions setShownRatio(float f2) {
        this.shownRatio = f2;
        return this;
    }

    public PolylineOptions setShownRange(float f2, float f3) {
        this.shownRangeBegin = f2;
        this.shownRangeEnd = f3;
        return this;
    }

    public float getShownRangeBegin() {
        return this.shownRangeBegin;
    }

    public float getShownRangeEnd() {
        return this.shownRangeEnd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineJoinType {
        LineJoinBevel(0),
        LineJoinMiter(1),
        LineJoinRound(2);

        private int type;

        private LineJoinType(int n3) {
            this.type = n3;
        }

        public int getTypeValue() {
            return this.type;
        }

        public static LineJoinType valueOf(int n2) {
            LineJoinType[] lineJoinTypeArray = LineJoinType.values();
            n2 = Math.max(0, Math.min(n2, lineJoinTypeArray.length));
            return lineJoinTypeArray[n2];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineCapType {
        LineCapButt(0),
        LineCapSquare(1),
        LineCapArrow(2),
        LineCapRound(3);

        private int type;

        private LineCapType(int n3) {
            this.type = n3;
        }

        public static LineCapType valueOf(int n2) {
            LineCapType[] lineCapTypeArray = LineCapType.values();
            n2 = Math.max(0, Math.min(n2, lineCapTypeArray.length));
            return lineCapTypeArray[n2];
        }

        public int getTypeValue() {
            return this.type;
        }
    }
}

