/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.mapcore.util.ic;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolylineOptions;
import com.autonavi.amap.mapcore.interfaces.IPolyline;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline
extends BaseOverlay {
    private IPolyline polylineDelegate;
    private PolylineOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public Polyline(IGlOverlayLayer iGlOverlayLayer, PolylineOptions polylineOptions) {
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polylineOptions;
    }

    public Polyline(IGlOverlayLayer iGlOverlayLayer, PolylineOptions polylineOptions, String string) {
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polylineOptions;
        this.overlayName = string;
    }

    public Polyline(IPolyline iPolyline) {
        this.polylineDelegate = iPolyline;
    }

    public void remove() {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.remove();
            } else {
                BitmapDescriptor bitmapDescriptor;
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
                if ((bitmapDescriptor = this.options.getCustomTexture()) != null) {
                    bitmapDescriptor.recycle();
                }
                if (this.options.getCustomTextureList() != null) {
                    for (BitmapDescriptor bitmapDescriptor2 : this.options.getCustomTextureList()) {
                        bitmapDescriptor2.recycle();
                    }
                    this.options.getCustomTextureList().clear();
                }
                this.options = null;
                this.overlayName = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getId() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<LatLng> list) {
        block7: {
            try {
                if (this.polylineDelegate != null) {
                    this.polylineDelegate.setPoints(list);
                    break block7;
                }
                Polyline polyline = this;
                synchronized (polyline) {
                    if (this.options != null) {
                        this.options.setPoints(list);
                        this.a();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public List<LatLng> getPoints() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getPoints();
            }
            return this.options != null ? this.options.getPoints() : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setGeodesic(boolean bl2) {
        try {
            if (this.polylineDelegate != null) {
                if (this.polylineDelegate.isGeodesic() != bl2) {
                    List<LatLng> list = this.getPoints();
                    this.polylineDelegate.setGeodesic(bl2);
                    this.setPoints(list);
                }
            } else if (this.options != null) {
                this.options.geodesic(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isGeodesic() {
        if (this.polylineDelegate.isGeodesic()) {
            return true;
        }
        return this.options != null ? this.options.isGeodesic() : false;
    }

    public void setDottedLine(boolean bl2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setDottedLine(bl2);
        } else if (this.options != null) {
            this.options.setDottedLine(bl2);
            this.a();
        }
    }

    public boolean isDottedLine() {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.isDottedLine();
        }
        return this.options != null ? this.options.isDottedLine() : false;
    }

    public void setWidth(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setWidth(f2);
            } else if (this.options != null) {
                this.options.width(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getWidth() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getWidth();
            }
            return this.options != null ? this.options.getWidth() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setColor(int n2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setColor(n2);
            } else if (this.options != null) {
                this.options.color(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getColor() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getColor();
            }
            return this.options != null ? this.options.getColor() : 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setZIndex(f2);
            } else if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getZIndex() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getZIndex();
            }
            return this.options != null ? this.options.getZIndex() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setVisible(bl2);
            } else if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isVisible() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.isVisible();
            }
            return this.options != null ? this.options.isVisible() : false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Polyline)) {
            return false;
        }
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.equalsRemote(((Polyline)object).polylineDelegate);
            }
            return super.equals(object) || ((Polyline)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.hashCodeRemote();
            }
            return super.hashCode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public LatLng getNearestLatLng(LatLng latLng) {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.getNearestLatLng(latLng);
        }
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (iGlOverlayLayer != null) {
            return iGlOverlayLayer.getNearestLatLng(this.options, latLng);
        }
        return null;
    }

    public void setTransparency(float f2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setTransparency(f2);
        } else if (this.options != null) {
            this.options.transparency(f2);
            this.a();
        }
    }

    public void setAboveMaskLayer(boolean bl2) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setAboveMaskLayer(bl2);
        } else if (this.options != null) {
            this.options.aboveMaskLayer(bl2);
            this.a();
        }
    }

    public void setCustomTexture(BitmapDescriptor bitmapDescriptor) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setCustomTexture(bitmapDescriptor);
        } else if (this.options != null) {
            this.options.setCustomTexture(bitmapDescriptor);
            this.a();
        }
    }

    public void setOptions(PolylineOptions polylineOptions) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setOptions(polylineOptions);
        } else {
            this.options = polylineOptions;
            this.a();
        }
    }

    public PolylineOptions getOptions() {
        if (this.polylineDelegate != null) {
            return this.polylineDelegate.getOptions();
        }
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustemTextureIndex(List<Integer> list) {
        if (this.polylineDelegate != null) {
            this.polylineDelegate.setCustemTextureIndex(list);
        } else {
            Polyline polyline = this;
            synchronized (polyline) {
                if (this.options != null) {
                    this.options.setCustomTextureIndex(list);
                    this.a();
                }
            }
        }
    }

    public void setShownRatio(float f2) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setShownRatio(f2);
            } else if (this.options != null) {
                this.options.setShownRatio(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setShownRange(float f2, float f3) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setShowRange(f2, f3);
            } else if (this.options != null) {
                this.options.setShownRange(f2, f3);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getShownRatio() {
        try {
            if (this.polylineDelegate != null) {
                return this.polylineDelegate.getShownRatio();
            }
            return this.options != null ? this.options.getShownRatio() : -1.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        try {
            Polyline polyline = this;
            synchronized (polyline) {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                    this.setOptionPointList(this.options);
                    if (iGlOverlayLayer != null) {
                        iGlOverlayLayer.updateOption(this.overlayName, this.options);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setCustomTextureList(List<BitmapDescriptor> list) {
        try {
            if (this.polylineDelegate != null) {
                this.polylineDelegate.setCustomTextureList(list);
            } else {
                this.options.setCustomTextureList(list);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void setOptionPointList(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("isPointsUpdated");
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            boolean bl2 = field.getBoolean(object);
            if (bl2) {
                PolylineOptions polylineOptions = (PolylineOptions)object;
                List<LatLng> list = polylineOptions.getPoints();
                double[] dArray = new double[list.size() * 2];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    dArray[i2 * 2] = list.get((int)i2).latitude;
                    dArray[i2 * 2 + 1] = list.get((int)i2).longitude;
                }
                Field field2 = clazz.getDeclaredField("pointList");
                if (field2 == null) {
                    return;
                }
                field2.setAccessible(true);
                field2.set(object, dArray);
            }
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Polyline", "setOptionPointList");
        }
    }
}

