/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
extends BaseOptions
implements Parcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final List<LatLng> points = new ArrayList<LatLng>();
    private float strokeWidth = 10.0f;
    private int strokeColor = -16777216;
    private int fillColor = -16777216;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private List<BaseHoleOptions> holeOptions = new ArrayList<BaseHoleOptions>();
    String a;
    private final String type = "PolygonOptions";
    private boolean isPointsUpdated = false;
    private boolean isHoleOptionsUpdated = false;
    private double[] pointList;

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeTypedList(this.points);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeList(this.holeOptions);
    }

    public PolygonOptions add(LatLng latLng) {
        try {
            this.points.add(latLng);
            this.isPointsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        try {
            this.points.addAll(Arrays.asList(latLngArray));
            this.isPointsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        try {
            for (LatLng latLng : iterable) {
                this.points.add(latLng);
            }
            this.isPointsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public void setPoints(List<LatLng> list) {
        try {
            this.points.clear();
            this.points.addAll(list);
            this.isPointsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setHoleOptions(List<BaseHoleOptions> list) {
        try {
            this.holeOptions.clear();
            this.holeOptions.addAll(list);
            this.isHoleOptionsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public PolygonOptions addHoles(BaseHoleOptions ... baseHoleOptionsArray) {
        try {
            this.holeOptions.addAll(Arrays.asList(baseHoleOptionsArray));
            this.isHoleOptionsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions addHoles(Iterable<BaseHoleOptions> iterable) {
        try {
            for (BaseHoleOptions baseHoleOptions : iterable) {
                this.holeOptions.add(baseHoleOptions);
            }
            this.isHoleOptionsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public PolygonOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public PolygonOptions strokeColor(int n2) {
        this.strokeColor = n2;
        return this;
    }

    public PolygonOptions fillColor(int n2) {
        this.fillColor = n2;
        return this;
    }

    public PolygonOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public PolygonOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.points;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public List<BaseHoleOptions> getHoleOptions() {
        return this.holeOptions;
    }
}

