/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.mapcore.util.ic;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.PolygonOptions;
import com.autonavi.amap.mapcore.interfaces.IPolygon;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Polygon
extends BaseOverlay {
    private IPolygon polygonDelegate;
    private PolygonOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;

    public Polygon(IPolygon iPolygon) {
        this.polygonDelegate = iPolygon;
    }

    public Polygon(IGlOverlayLayer iGlOverlayLayer, PolygonOptions polygonOptions) {
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = polygonOptions;
    }

    public void remove() {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.remove();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getId() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setPoints(List<LatLng> list) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setPoints(list);
            } else {
                this.options.setPoints(list);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public List<LatLng> getPoints() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getPoints();
            }
            return this.options != null ? this.options.getPoints() : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setHoleOptions(List<BaseHoleOptions> list) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setHoleOptions(list);
            } else {
                if (list == null) {
                    list = new ArrayList<BaseHoleOptions>();
                }
                this.options.setHoleOptions(list);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public List<BaseHoleOptions> getHoleOptions() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getHoleOptions();
            }
            return this.options != null ? this.options.getHoleOptions() : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setStrokeWidth(float f2) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setStrokeWidth(f2);
            } else {
                this.options.strokeWidth(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getStrokeWidth() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getStrokeWidth();
            }
            return this.options != null ? this.options.getStrokeWidth() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setStrokeColor(int n2) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setStrokeColor(n2);
            } else if (this.options != null) {
                this.options.strokeColor(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getStrokeColor() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getStrokeColor();
            }
            return this.options != null ? this.options.getStrokeColor() : 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setFillColor(int n2) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setFillColor(n2);
            } else if (this.options != null) {
                this.options.fillColor(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getFillColor() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getFillColor();
            }
            return this.options != null ? this.options.getFillColor() : 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setZIndex(f2);
            } else if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getZIndex() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.getZIndex();
            }
            return this.options != null ? this.options.getZIndex() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.polygonDelegate != null) {
                this.polygonDelegate.setVisible(bl2);
            } else if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isVisible() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.isVisible();
            }
            return this.options != null ? this.options.isVisible() : false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean contains(LatLng latLng) {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.contains(latLng);
            }
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (iGlOverlayLayer != null) {
                return iGlOverlayLayer.IsPolygonContainsPoint(this.options, latLng);
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Polygon)) {
            return false;
        }
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.equalsRemote(((Polygon)object).polygonDelegate);
            }
            return super.equals(object) || ((Polygon)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        try {
            if (this.polygonDelegate != null) {
                return this.polygonDelegate.hashCodeRemote();
            }
            return super.hashCode();
        }
        catch (Throwable throwable) {
            return super.hashCode();
        }
    }

    private void a() {
        try {
            IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
            if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
                this.setOptionPointList(this.options);
                iGlOverlayLayer.processPolygonHoleOption(this.options);
                iGlOverlayLayer.updateOption(this.overlayName, this.options);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setOptionPointList(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("isPointsUpdated");
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            boolean bl2 = field.getBoolean(object);
            if (bl2) {
                PolygonOptions polygonOptions = (PolygonOptions)object;
                List<LatLng> list = polygonOptions.getPoints();
                double[] dArray = new double[list.size() * 2];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    dArray[i2 * 2] = list.get((int)i2).latitude;
                    dArray[i2 * 2 + 1] = list.get((int)i2).longitude;
                }
                Field field2 = clazz.getDeclaredField("pointList");
                if (field2 == null) {
                    return;
                }
                field2.setAccessible(true);
                field2.set(object, dArray);
            }
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Polygon", "setOptionPointList");
        }
    }
}

