/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.MarkerOptionsCreator;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarkerOptions
implements Parcelable {
    public static final MarkerOptionsCreator CREATOR = new MarkerOptionsCreator();
    private LatLng latLng;
    private String title;
    private String snippet;
    private float anchorU = 0.5f;
    private float anchorV = 1.0f;
    private float zIndex = 0.0f;
    private boolean isDraggable = false;
    private boolean isVisible = true;
    String a;
    private boolean perspective = false;
    private int offsetX = 0;
    private int offsetY = 0;
    private ArrayList<BitmapDescriptor> bitmapDescriptors = new ArrayList();
    private int period = 20;
    private boolean isGps = false;
    private boolean isFlat = false;
    private boolean isRotatingMode = false;
    private float angleOffset = 0.0f;
    float b = 1.0f;
    boolean c = false;
    boolean d = true;
    int e = 5;
    float f;
    private boolean isBelowMaskLayer;

    public MarkerOptions icons(ArrayList<BitmapDescriptor> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            this.bitmapDescriptors = arrayList;
            this.isRotatingMode = false;
        }
        return this;
    }

    public MarkerOptions rotatingIcons(ArrayList<BitmapDescriptor> arrayList, float f2) {
        if (arrayList != null && arrayList.size() > 0) {
            this.bitmapDescriptors = arrayList;
            this.angleOffset = f2 != 0.0f ? f2 : 360.0f / (float)arrayList.size();
            this.isRotatingMode = true;
        }
        return this;
    }

    protected MarkerOptions angleOffset(float f2) {
        this.angleOffset = f2;
        return this;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    protected MarkerOptions setRotatingMode(boolean bl2) {
        this.isRotatingMode = bl2;
        return this;
    }

    public boolean isRotatingMode() {
        return this.isRotatingMode;
    }

    public ArrayList<BitmapDescriptor> getIcons() {
        return this.bitmapDescriptors;
    }

    public MarkerOptions period(int n2) {
        this.period = n2 <= 1 ? 1 : n2;
        return this;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public MarkerOptions perspective(boolean bl2) {
        this.perspective = bl2;
        return this;
    }

    public MarkerOptions position(LatLng latLng) {
        this.latLng = latLng;
        return this;
    }

    public MarkerOptions setFlat(boolean bl2) {
        this.isFlat = bl2;
        return this;
    }

    private void a() {
        if (this.bitmapDescriptors == null) {
            try {
                this.bitmapDescriptors = new ArrayList();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public MarkerOptions icon(BitmapDescriptor bitmapDescriptor) {
        try {
            this.a();
            this.bitmapDescriptors.clear();
            this.bitmapDescriptors.add(bitmapDescriptor);
            this.isRotatingMode = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public MarkerOptions anchor(float f2, float f3) {
        this.anchorU = f2;
        this.anchorV = f3;
        return this;
    }

    public MarkerOptions setInfoWindowOffset(int n2, int n3) {
        this.offsetX = n2;
        this.offsetY = n3;
        return this;
    }

    public MarkerOptions title(String string) {
        this.title = string;
        return this;
    }

    public MarkerOptions snippet(String string) {
        this.snippet = string;
        return this;
    }

    public MarkerOptions draggable(boolean bl2) {
        this.isDraggable = bl2;
        return this;
    }

    public MarkerOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public MarkerOptions setGps(boolean bl2) {
        this.isGps = bl2;
        return this;
    }

    public LatLng getPosition() {
        return this.latLng;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public BitmapDescriptor getIcon() {
        if (this.bitmapDescriptors != null && this.bitmapDescriptors.size() != 0) {
            return this.bitmapDescriptors.get(0);
        }
        return null;
    }

    public float getAnchorU() {
        return this.anchorU;
    }

    public int getInfoWindowOffsetX() {
        return this.offsetX;
    }

    public int getInfoWindowOffsetY() {
        return this.offsetY;
    }

    public float getAnchorV() {
        return this.anchorV;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isGps() {
        return this.isGps;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public MarkerOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public MarkerOptions alpha(float f2) {
        this.b = f2;
        return this;
    }

    public float getAlpha() {
        return this.b;
    }

    public MarkerOptions autoOverturnInfoWindow(boolean bl2) {
        this.c = bl2;
        return this;
    }

    public boolean isInfoWindowAutoOverturn() {
        return this.c;
    }

    public MarkerOptions displayLevel(int n2) {
        this.e = n2;
        return this;
    }

    public int getDisplayLevel() {
        return this.e;
    }

    public MarkerOptions rotateAngle(float f2) {
        this.f = f2;
        return this;
    }

    public float getRotateAngle() {
        return this.f;
    }

    public MarkerOptions infoWindowEnable(boolean bl2) {
        this.d = bl2;
        return this;
    }

    public boolean isInfoWindowEnable() {
        return this.d;
    }

    public MarkerOptions belowMaskLayer(boolean bl2) {
        this.isBelowMaskLayer = bl2;
        return this;
    }

    public boolean isBelowMaskLayer() {
        return this.isBelowMaskLayer;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.latLng, n2);
        parcel.writeString(this.title);
        parcel.writeString(this.snippet);
        parcel.writeFloat(this.anchorU);
        parcel.writeFloat(this.anchorV);
        parcel.writeInt(this.offsetX);
        parcel.writeInt(this.offsetY);
        parcel.writeBooleanArray(new boolean[]{this.isVisible, this.isDraggable, this.isGps, this.isFlat, this.c, this.d, this.isBelowMaskLayer, this.isRotatingMode});
        parcel.writeString(this.a);
        parcel.writeInt(this.period);
        parcel.writeList(this.bitmapDescriptors);
        parcel.writeFloat(this.zIndex);
        parcel.writeFloat(this.b);
        parcel.writeInt(this.e);
        parcel.writeFloat(this.f);
        parcel.writeFloat(this.angleOffset);
        if (this.bitmapDescriptors != null && this.bitmapDescriptors.size() != 0) {
            parcel.writeParcelable((Parcelable)this.bitmapDescriptors.get(0), n2);
        }
    }
}

