/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.text.TextUtils;
import com.amap.api.maps.interfaces.IGlOverlayLayer;
import com.amap.api.maps.model.BaseOverlay;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.GroundOverlayOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.interfaces.IGroundOverlay;
import java.lang.ref.WeakReference;

public final class GroundOverlay
extends BaseOverlay {
    private IGroundOverlay iGroundOverlayDelegate;
    private String overlayName;
    private GroundOverlayOptions options;
    private WeakReference<IGlOverlayLayer> glOverlayLayerRef;
    private LatLng point;
    private float width;
    private float high;

    public GroundOverlay(IGroundOverlay iGroundOverlay) {
        this.iGroundOverlayDelegate = iGroundOverlay;
    }

    public GroundOverlay(IGlOverlayLayer iGlOverlayLayer, GroundOverlayOptions groundOverlayOptions) {
        this.glOverlayLayerRef = new WeakReference<IGlOverlayLayer>(iGlOverlayLayer);
        this.options = groundOverlayOptions;
        this.overlayName = "";
    }

    public void remove() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.remove();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
                if (this.options != null && this.options.getImage() != null) {
                    this.options.getImage().recycle();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getId() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getId();
            }
            return this.overlayName;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setPosition(LatLng latLng) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setPosition(latLng);
            } else if (this.options != null && latLng != null) {
                float f2;
                float f3 = this.width > 0.0f ? this.width : this.options.getWidth();
                float f4 = f2 = this.high > 0.0f ? this.high : this.options.getHeight();
                if (f3 == 0.0f) {
                    this.point = latLng;
                } else if (f2 == 0.0f) {
                    this.options.position(latLng, f3);
                    this.a();
                } else if (f2 > 0.0f) {
                    this.options.position(latLng, f3, f2);
                    this.a();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public LatLng getPosition() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getPosition();
            }
            return this.options != null ? this.options.getLocation() : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setDimensions(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setDimensions(f2);
            } else if (this.options != null) {
                LatLng latLng;
                LatLng latLng2 = latLng = this.point != null ? this.point : this.options.getLocation();
                if (latLng == null) {
                    this.width = f2;
                } else {
                    this.options.position(latLng, f2);
                    this.a();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setImage(BitmapDescriptor bitmapDescriptor) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setImage(bitmapDescriptor);
            } else if (this.options != null) {
                this.options.image(bitmapDescriptor);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setDimensions(float f2, float f3) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setDimensions(f2, f3);
            } else if (this.options != null) {
                LatLng latLng;
                LatLng latLng2 = latLng = this.point != null ? this.point : this.options.getLocation();
                if (latLng == null) {
                    this.width = f2;
                    this.high = f3;
                } else {
                    this.options.position(this.options.getLocation(), f2, f3);
                    this.a();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getWidth() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getWidth();
            }
            return this.options != null ? this.options.getWidth() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public float getHeight() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getHeight();
            }
            return this.options != null ? this.options.getHeight() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setPositionFromBounds(LatLngBounds latLngBounds) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setPositionFromBounds(latLngBounds);
            } else if (this.options != null && latLngBounds != null) {
                this.options.positionFromBounds(latLngBounds);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public LatLngBounds getBounds() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getBounds();
            }
            return this.options != null ? this.options.getBounds() : null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setBearing(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setBearing(f2);
            } else if (this.options != null) {
                this.options.bearing(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getBearing() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getBearing();
            }
            return this.options != null ? this.options.getBearing() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setZIndex(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setZIndex(f2);
            } else if (this.options != null) {
                this.options.zIndex(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getZIndex() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getZIndex();
            }
            return this.options != null ? this.options.getZIndex() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setVisible(bl2);
            } else if (this.options != null) {
                this.options.visible(bl2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isVisible() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.isVisible();
            }
            return this.options != null ? this.options.isVisible() : false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void setTransparency(float f2) {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.setTransparency(f2);
            } else if (this.options != null) {
                this.options.transparency(f2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getTransparency() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.getTransparency();
            }
            return this.options != null ? this.options.getTransparency() : 0.0f;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0.0f;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GroundOverlay)) {
            return false;
        }
        try {
            if (this.iGroundOverlayDelegate != null) {
                return this.iGroundOverlayDelegate.equalsRemote(((GroundOverlay)object).iGroundOverlayDelegate);
            }
            return super.equals(object) || ((GroundOverlay)object).getId() == this.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void destroy() {
        try {
            if (this.iGroundOverlayDelegate != null) {
                this.iGroundOverlayDelegate.destroy();
            } else {
                IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
                if (iGlOverlayLayer != null) {
                    iGlOverlayLayer.removeOverlay(this.overlayName);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int hashCode() {
        if (this.iGroundOverlayDelegate != null) {
            return this.iGroundOverlayDelegate.hashCode();
        }
        return super.hashCode();
    }

    private void a() {
        IGlOverlayLayer iGlOverlayLayer = (IGlOverlayLayer)this.glOverlayLayerRef.get();
        if (!TextUtils.isEmpty((CharSequence)this.overlayName) && iGlOverlayLayer != null) {
            iGlOverlayLayer.updateOption(this.overlayName, this.options);
        }
    }
}

