/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.CircleOptionsCreator;
import com.amap.api.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CircleOptions
extends BaseOptions
implements Parcelable {
    public static final CircleOptionsCreator CREATOR = new CircleOptionsCreator();
    String a;
    private LatLng point = null;
    private double radius = 0.0;
    private float strokeWidth = 10.0f;
    private int strokeColor = -16777216;
    private int fillColor = 0;
    private float zIndex = 0.0f;
    private boolean isVisible = true;
    private List<BaseHoleOptions> holeOptions = new ArrayList<BaseHoleOptions>();
    private final String type = "CircleOptions";
    private boolean isCenterUpdated = false;
    private boolean isRadiusUpdated = false;
    private boolean isHoleOptionsUpdated = false;
    private int dottedLineType = -1;

    public void writeToParcel(Parcel parcel, int n2) {
        Bundle bundle = new Bundle();
        if (this.point != null) {
            bundle.putDouble("lat", this.point.latitude);
            bundle.putDouble("lng", this.point.longitude);
        }
        parcel.writeBundle(bundle);
        parcel.writeDouble(this.radius);
        parcel.writeFloat(this.strokeWidth);
        parcel.writeInt(this.strokeColor);
        parcel.writeInt(this.fillColor);
        parcel.writeFloat(this.zIndex);
        parcel.writeByte((byte)(this.isVisible ? 1 : 0));
        parcel.writeString(this.a);
        parcel.writeList(this.holeOptions);
        parcel.writeInt(this.dottedLineType);
    }

    public int describeContents() {
        return 0;
    }

    public CircleOptions center(LatLng latLng) {
        this.point = latLng;
        this.isCenterUpdated = true;
        return this;
    }

    public CircleOptions radius(double d2) {
        this.radius = d2;
        this.isRadiusUpdated = true;
        return this;
    }

    public CircleOptions strokeWidth(float f2) {
        this.strokeWidth = f2;
        return this;
    }

    public CircleOptions strokeColor(int n2) {
        this.strokeColor = n2;
        return this;
    }

    public CircleOptions fillColor(int n2) {
        this.fillColor = n2;
        return this;
    }

    public CircleOptions zIndex(float f2) {
        this.zIndex = f2;
        return this;
    }

    public CircleOptions visible(boolean bl2) {
        this.isVisible = bl2;
        return this;
    }

    public LatLng getCenter() {
        return this.point;
    }

    public double getRadius() {
        return this.radius;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public CircleOptions addHoles(BaseHoleOptions ... baseHoleOptionsArray) {
        try {
            this.holeOptions.addAll(Arrays.asList(baseHoleOptionsArray));
            this.isHoleOptionsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public CircleOptions addHoles(Iterable<BaseHoleOptions> iterable) {
        try {
            for (BaseHoleOptions baseHoleOptions : iterable) {
                this.holeOptions.add(baseHoleOptions);
            }
            this.isHoleOptionsUpdated = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this;
    }

    public List<BaseHoleOptions> getHoleOptions() {
        return this.holeOptions;
    }

    public CircleOptions setStrokeDottedLineType(int n2) {
        this.dottedLineType = n2;
        return this;
    }

    public int getStrokeDottedLineType() {
        return this.dottedLineType;
    }
}

