/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.graphics.Point;
import com.amap.api.maps.model.BaseOptions;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingOverlayOptions
extends BaseOptions {
    private int buildingHeight = -1;
    private int buildingHeightScale = 1;
    private int buildingTopColor = -7829368;
    private int buildingSideColor = -7829368;
    private boolean isVisible = true;
    private float zindex;
    private List<LatLng> buildingLatlngs = new ArrayList<LatLng>();
    private int[] buildingLatlngsPoints;

    public float getZIndex() {
        return this.zindex;
    }

    public void setZIndex(float f2) {
        this.zindex = f2;
    }

    public void setVisible(boolean bl2) {
        this.isVisible = bl2;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public BuildingOverlayOptions setBuildingHeightScale(int n2) {
        this.buildingHeightScale = n2;
        return this;
    }

    public int getBuildingHeightScale() {
        return this.buildingHeightScale;
    }

    public BuildingOverlayOptions setBuildingTopColor(int n2) {
        this.buildingTopColor = n2;
        return this;
    }

    public BuildingOverlayOptions setBuildingSideColor(int n2) {
        this.buildingSideColor = n2;
        return this;
    }

    public int getBuildingSideColor() {
        return this.buildingSideColor;
    }

    public int getBuildingTopColor() {
        return this.buildingTopColor;
    }

    public BuildingOverlayOptions setBuildingHeight(int n2) {
        this.buildingHeight = n2;
        return this;
    }

    public int getBuildingHeight() {
        return this.buildingHeight;
    }

    public List<LatLng> getBuildingLatlngs() {
        return this.buildingLatlngs;
    }

    public int[] getPoints() {
        if (this.buildingLatlngs != null && this.buildingLatlngs.size() > 0) {
            int[] nArray = new int[this.buildingLatlngs.size() * 2];
            int n2 = 0;
            for (int i2 = 0; i2 < this.buildingLatlngs.size(); ++i2) {
                LatLng latLng = this.buildingLatlngs.get(i2);
                Point point = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
                nArray[n2++] = point.x;
                nArray[n2++] = point.y;
            }
            return nArray;
        }
        return new int[0];
    }

    public BuildingOverlayOptions setBuildingLatlngs(List<LatLng> list) {
        this.buildingLatlngs = list;
        if (list != null && list.size() > 0) {
            this.buildingLatlngsPoints = new int[list.size() * 2];
            int n2 = 0;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                LatLng latLng = list.get(i2);
                Point point = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
                this.buildingLatlngsPoints[n2++] = point.x;
                this.buildingLatlngsPoints[n2++] = point.y;
            }
        }
        return this;
    }
}

