/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.amap.api.mapcore.util.ai;
import com.amap.api.mapcore.util.fa;
import com.amap.api.mapcore.util.fr;
import com.amap.api.maps.model.BitmapDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;

public final class BitmapDescriptorFactory {
    private static final String ICON_ID_PREFIX = "com.amap.api.icon_";
    private static int nextId = 0;
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;

    public static BitmapDescriptor fromResource(int n2) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                InputStream inputStream = context.getResources().openRawResource(n2);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor fromView(View view) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                FrameLayout frameLayout = new FrameLayout(context);
                frameLayout.addView(view);
                frameLayout.setDrawingCacheEnabled(true);
                Bitmap bitmap = fr.a((View)frameLayout);
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor fromPath(String string) {
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)string);
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor fromAsset(String string) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                return BitmapDescriptorFactory.fromBitmap(fr.a(context, string));
            }
            InputStream inputStream = BitmapDescriptorFactory.class.getResourceAsStream("/assets/" + string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor fromFile(String string) {
        try {
            Context context = BitmapDescriptorFactory.getContext();
            if (context != null) {
                FileInputStream fileInputStream = context.openFileInput(string);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
                fileInputStream.close();
                BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                bitmap.recycle();
                return bitmapDescriptor;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker() {
        try {
            return BitmapDescriptorFactory.fromAsset(fa.a.b.name() + ".png");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor defaultMarker(float f2) {
        try {
            f2 = (int)(f2 + 15.0f) / 30 * 30;
            int n2 = 330;
            if (f2 > (float)n2) {
                f2 = n2;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            String string = "";
            if (f2 == 0.0f) {
                string = "RED";
            } else if (f2 == 30.0f) {
                string = "ORANGE";
            } else if (f2 == 60.0f) {
                string = "YELLOW";
            } else if (f2 == 120.0f) {
                string = "GREEN";
            } else if (f2 == 180.0f) {
                string = "CYAN";
            } else if (f2 == 210.0f) {
                string = "AZURE";
            } else if (f2 == 240.0f) {
                string = "BLUE";
            } else if (f2 == 270.0f) {
                string = "VIOLET";
            } else if (f2 == 300.0f) {
                string = "MAGENTA";
            } else if (f2 == 330.0f) {
                string = "ROSE";
            }
            return BitmapDescriptorFactory.fromAsset(string + ".png");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = null;
        try {
            if (nextId == Integer.MAX_VALUE) {
                nextId = 0;
            }
            String string = ICON_ID_PREFIX + ++nextId;
            bitmapDescriptor = new BitmapDescriptor(bitmap, string);
            return bitmapDescriptor;
        }
        catch (Throwable throwable) {
            return bitmapDescriptor;
        }
    }

    public static Context getContext() {
        Context context = ai.a;
        try {
            if (context == null) {
                Class<?> clazz = Class.forName("com.amap.api.wrapper.MapFragmentDelegateWrapper");
                Object obj = clazz.getConstructor(Integer.TYPE).newInstance(0);
                Object object = clazz.getDeclaredMethod("getContext", new Class[0]).invoke(obj, new Object[0]);
                context = (Context)object;
            }
        }
        catch (Throwable throwable) {
            context = null;
            Log.d((String)"mapcore", (String)("BitmapDescriptor catch e:" + throwable.toString()));
        }
        return context;
    }
}

