/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps;

import android.graphics.Point;
import android.util.Log;
import com.amap.api.mapcore.util.aw;
import com.amap.api.maps.CameraUpdate;
import com.amap.api.maps.model.CameraPosition;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;

public final class CameraUpdateFactory {
    public static CameraUpdate zoomIn() {
        return new CameraUpdate(aw.a());
    }

    public static CameraUpdate zoomOut() {
        return new CameraUpdate(aw.b());
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        return new CameraUpdate(aw.a(f2, f3));
    }

    public static CameraUpdate zoomTo(float f2) {
        return new CameraUpdate(aw.a(f2));
    }

    public static CameraUpdate zoomBy(float f2) {
        return new CameraUpdate(aw.b(f2));
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        return new CameraUpdate(aw.a(f2, point));
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        if (cameraPosition == null) {
            Log.w((String)"CameraUpdateFactory", (String)"cameraPosition is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(cameraPosition));
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w((String)"CameraUpdateFactory", (String)"latLng is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(latLng));
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        if (latLng == null) {
            Log.w((String)"CameraUpdateFactory", (String)"target is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(latLng, f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        if (latLngBounds == null) {
            Log.w((String)"CameraUpdateFactory", (String)"bounds is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(latLngBounds, n2));
    }

    public static CameraUpdate changeLatLng(LatLng latLng) {
        if (latLng == null) {
            Log.w((String)"CameraUpdateFactory", (String)"target is null");
            return new CameraUpdate(aw.c());
        }
        Point point = VirtualEarthProjection.latLongToPixels(latLng.latitude, latLng.longitude, 20);
        return new CameraUpdate(aw.a(point));
    }

    public static CameraUpdate changeBearing(float f2) {
        return new CameraUpdate(aw.d(f2 % 360.0f));
    }

    public static CameraUpdate changeBearingGeoCenter(float f2, IPoint iPoint) {
        if (iPoint == null) {
            Log.w((String)"CameraUpdateFactory", (String)"geoPoint is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.b(f2 % 360.0f, new Point(iPoint.x, iPoint.y)));
    }

    public static CameraUpdate changeTilt(float f2) {
        return new CameraUpdate(aw.c(f2));
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        if (latLngBounds == null) {
            Log.w((String)"CameraUpdateFactory", (String)"bounds is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(latLngBounds, n2, n3, n4));
    }

    public static CameraUpdate newLatLngBoundsRect(LatLngBounds latLngBounds, int n2, int n3, int n4, int n5) {
        if (latLngBounds == null) {
            Log.w((String)"CameraUpdateFactory", (String)"bounds is null");
            return new CameraUpdate(aw.c());
        }
        return new CameraUpdate(aw.a(latLngBounds, n2, n3, n4, n5));
    }
}

