/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.mapcore.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.amap.api.mapcore.util.ad;
import com.amap.api.mapcore.util.fl;
import com.amap.api.mapcore.util.fm;
import com.amap.api.mapcore.util.ho;
import com.amap.api.mapcore.util.ic;
import com.amap.api.mapcore.util.w;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.CircleHoleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.PolygonHoleOptions;
import com.amap.api.maps.utils.SpatialRelationUtil;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.amap.mapcore.AbstractCameraUpdateMessage;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.FPoint3;
import com.autonavi.amap.mapcore.FileUtil;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.MapConfig;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fr {
    private static FPoint[] a = new FPoint[]{FPoint.obtain(), FPoint.obtain(), FPoint.obtain(), FPoint.obtain()};
    private static List<Float> b = new ArrayList<Float>(4);
    private static List<Float> c = new ArrayList<Float>(4);

    public static Bitmap a(Context context, String string) {
        try {
            AssetManager assetManager = fl.a(context);
            InputStream inputStream = assetManager.open(string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            return bitmap;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "fromAsset");
            return null;
        }
    }

    public static void a(Drawable drawable) {
        if (drawable != null) {
            drawable.setCallback(null);
            drawable = null;
        }
    }

    public static String a(String string, Object object) {
        return string + "=" + String.valueOf(object);
    }

    public static float a(float f2, float f3) {
        float f4 = f2;
        if (f2 > 40.0f) {
            int n2 = 0;
            n2 = f3 <= 15.0f ? 40 : (f3 <= 16.0f ? 56 : (f3 <= 17.0f ? 66 : (f3 <= 18.0f ? 74 : (f3 <= 18.0f ? 78 : 80))));
            f4 = f4 > (float)n2 ? (float)n2 : f4;
        }
        return f4;
    }

    public static float a(MapConfig mapConfig, float f2) {
        if (mapConfig != null) {
            if (f2 > mapConfig.maxZoomLevel) {
                f2 = mapConfig.maxZoomLevel;
            } else if (f2 < mapConfig.minZoomLevel) {
                f2 = mapConfig.minZoomLevel;
            }
        } else if (f2 > 20.0f) {
            f2 = 20.0f;
        } else if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        return f2;
    }

    public static FloatBuffer a(float[] fArray) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put(fArray);
            floatBuffer.position(0);
            return floatBuffer;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "makeFloatBuffer1");
            throwable.printStackTrace();
            return null;
        }
    }

    public static FloatBuffer a(float[] fArray, FloatBuffer floatBuffer) {
        try {
            floatBuffer.clear();
            floatBuffer.put(fArray);
            floatBuffer.position(0);
            return floatBuffer;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "makeFloatBuffer2");
            throwable.printStackTrace();
            return null;
        }
    }

    public static int a(int n2, int n3) {
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return fr.a(0, bitmap, true);
    }

    public static int a(Bitmap bitmap) {
        return fr.a(bitmap, false);
    }

    public static int a(Bitmap bitmap, boolean bl2) {
        return fr.a(0, bitmap, bl2);
    }

    public static int a(int n2, Bitmap bitmap, boolean bl2) {
        n2 = fr.b(n2, bitmap, bl2);
        if (bitmap != null) {
            bitmap.recycle();
        }
        return n2;
    }

    public static int b(int n2, Bitmap bitmap, boolean bl2) {
        if (bitmap == null || bitmap.isRecycled()) {
            return 0;
        }
        if (n2 == 0) {
            int[] nArray = new int[]{0};
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            n2 = nArray[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        if (bl2) {
            GLES20.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        } else {
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        return n2;
    }

    public static int a(int n2, Bitmap bitmap, int n3, int n4) {
        if (bitmap == null || bitmap.isRecycled()) {
            return 0;
        }
        if (n2 == 0) {
            int[] nArray = new int[]{0};
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            n2 = nArray[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLUtils.texSubImage2D((int)3553, (int)0, (int)n3, (int)n4, (Bitmap)bitmap);
        return n2;
    }

    public static String a(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string : stringArray) {
            stringBuilder.append(string);
            if (n2 != stringArray.length - 1) {
                stringBuilder.append(",");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int a(Object[] objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static Bitmap a(Bitmap bitmap, float f2) {
        if (bitmap == null) {
            return null;
        }
        int n2 = (int)((float)bitmap.getWidth() * f2);
        int n3 = (int)((float)bitmap.getHeight() * f2);
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)true);
        return bitmap2;
    }

    public static String a(Context context) {
        String string;
        File file;
        File file2 = new File(FileUtil.getMapBaseStorage(context), "data_v6");
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(string = file2.toString() + File.separator)).exists()) {
            file.mkdir();
        }
        return file2.toString() + File.separator;
    }

    public static String b(Context context) {
        return FileUtil.getMapBaseStorage(context) + File.separator + "data" + File.separator;
    }

    public static String c(Context context) {
        String string = fr.a(context);
        if (string == null) {
            return null;
        }
        File file = new File(string, "VMAP2");
        if (!file.exists()) {
            file.mkdir();
        }
        return file.toString() + File.separator;
    }

    public static String a(int n2) {
        String string = n2 < 1000 ? n2 + "m" : n2 / 1000 + "km";
        return string;
    }

    public static boolean d(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo.State state = networkInfo.getState();
        return state != null && state != NetworkInfo.State.DISCONNECTED && state != NetworkInfo.State.DISCONNECTING;
    }

    public static boolean a() {
        return Build.VERSION.SDK_INT >= 8;
    }

    public static boolean b() {
        return Build.VERSION.SDK_INT >= 9;
    }

    public static boolean c() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static boolean d() {
        return Build.VERSION.SDK_INT >= 12;
    }

    public static void b(int n2) {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{n2}, (int)0);
    }

    public static String a(InputStream inputStream) {
        String string = null;
        try {
            string = new String(fr.b(inputStream), "utf-8");
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "decodeAssetResData");
            throwable.printStackTrace();
        }
        return string;
    }

    public static byte[] b(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray, 0, 2048)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byArray = null;
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String a(File file) {
        StringBuffer stringBuffer;
        block31: {
            Object v0;
            stringBuffer = new StringBuffer();
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            Object var6_7 = null;
            try {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    v0 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_19;
                v0 = var9_19 = null;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            break block31;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object v1;
                    ic.c(fileNotFoundException, "Util", "readFile fileNotFound");
                    fileNotFoundException.printStackTrace();
                    Object var6_8 = null;
                    try {
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            v1 = null;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_20;
                        v1 = var9_20 = null;
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    break block31;
                }
                catch (IOException iOException) {
                    Object v2;
                    ic.c(iOException, "Util", "readFile io");
                    iOException.printStackTrace();
                    Object var6_9 = null;
                    try {
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            v2 = null;
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_21;
                        v2 = var9_21 = null;
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException3) {
                            iOException3.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var6_10 = null;
                try {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        v3 = null;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        v3 = null;
                    }
                }
                catch (Throwable throwable2) {
                    Object var9_22;
                    v3 = var9_22 = null;
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return stringBuffer.toString();
    }

    public static boolean a(LatLng latLng, List<LatLng> list) {
        boolean bl2 = false;
        int n2 = 0;
        double d2 = 180.0;
        double d3 = latLng.longitude;
        double d4 = latLng.latitude;
        double d5 = latLng.latitude;
        if (list.size() < 3) {
            return false;
        }
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            list.add(list.get(0));
        }
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            double d6 = list.get((int)i2).longitude;
            double d7 = list.get((int)i2).latitude;
            double d8 = list.get((int)(i2 + 1)).longitude;
            double d9 = list.get((int)(i2 + 1)).latitude;
            if (fr.b(d3, d4, d6, d7, d8, d9)) {
                return true;
            }
            if (Math.abs(d9 - d7) < 1.0E-9) continue;
            if (fr.b(d6, d7, d3, d4, d2, d5)) {
                if (!(d7 > d9)) continue;
                ++n2;
                continue;
            }
            if (fr.b(d8, d9, d3, d4, d2, d5)) {
                if (!(d9 > d7)) continue;
                ++n2;
                continue;
            }
            if (!fr.a(d6, d7, d8, d9, d3, d4, d2, d5)) continue;
            ++n2;
        }
        if (n2 % 2 != 0) {
            bl2 = true;
        }
        return bl2;
    }

    public static double a(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (d4 - d2) * (d7 - d3) - (d6 - d2) * (d5 - d3);
    }

    public static boolean b(double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl2 = false;
        if (Math.abs(fr.a(d2, d3, d4, d5, d6, d7)) < 1.0E-9 && (d2 - d4) * (d2 - d6) <= 0.0 && (d3 - d5) * (d3 - d7) <= 0.0) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        boolean bl2 = false;
        double d10 = (d4 - d2) * (d9 - d7) - (d5 - d3) * (d8 - d6);
        if (d10 != 0.0) {
            double d11 = ((d3 - d7) * (d8 - d6) - (d2 - d6) * (d9 - d7)) / d10;
            double d12 = ((d3 - d7) * (d4 - d2) - (d2 - d6) * (d5 - d3)) / d10;
            if (d11 >= 0.0 && d11 <= 1.0 && d12 >= 0.0 && d12 <= 1.0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean a(BaseHoleOptions baseHoleOptions, LatLng latLng) {
        if (baseHoleOptions instanceof CircleHoleOptions) {
            CircleHoleOptions circleHoleOptions = (CircleHoleOptions)baseHoleOptions;
            LatLng latLng2 = circleHoleOptions.getCenter();
            double d2 = circleHoleOptions.getRadius();
            if (latLng2 == null) {
                return false;
            }
            return (double)AMapUtils.calculateLineDistance(latLng2, latLng) <= d2;
        }
        PolygonHoleOptions polygonHoleOptions = (PolygonHoleOptions)baseHoleOptions;
        List<LatLng> list = polygonHoleOptions.getPoints();
        if (list == null || list.size() == 0) {
            return false;
        }
        return fr.a(latLng, list);
    }

    public static List<FPoint> a(FPoint[] fPointArray, List<FPoint> list, boolean bl2) {
        ArrayList<FPoint> arrayList = new ArrayList<FPoint>();
        ArrayList<FPoint> arrayList2 = new ArrayList<FPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                FPoint fPoint = (FPoint)((Object)arrayList2.get(n3 % n4));
                FPoint fPoint2 = (FPoint)((Object)arrayList2.get((n3 + 1) % n4));
                if (n3 == 0 && fr.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    arrayList.add(fPoint);
                }
                if (fr.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    if (fr.a(fPoint2, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                        arrayList.add(fPoint2);
                        continue;
                    }
                    arrayList.add(fr.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint, fPoint2));
                    continue;
                }
                if (!fr.a(fPoint2, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
                arrayList.add(fr.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint, fPoint2));
                arrayList.add(fPoint2);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((FPoint)((Object)arrayList.get(n3)));
            }
        }
        return arrayList2;
    }

    public static List<FPoint> b(FPoint[] fPointArray, List<FPoint> list, boolean bl2) {
        ArrayList<FPoint3> arrayList = new ArrayList<FPoint3>();
        ArrayList<FPoint> arrayList2 = new ArrayList<FPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                FPoint3 fPoint3 = (FPoint3)((Object)arrayList2.get(n3 % n4));
                FPoint3 fPoint32 = (FPoint3)((Object)arrayList2.get((n3 + 1) % n4));
                if (n3 == 0 && fr.a(fPoint3, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    arrayList.add(fPoint3);
                }
                if (fr.a(fPoint3, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    if (fr.a(fPoint32, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                        arrayList.add(fPoint32);
                        continue;
                    }
                    arrayList.add(fr.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint3, fPoint32, fPoint32.colorIndex));
                    continue;
                }
                if (!fr.a(fPoint32, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
                arrayList.add(fr.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint3, fPoint32, fPoint3.colorIndex));
                arrayList.add(fPoint32);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((FPoint)((Object)arrayList.get(n3)));
            }
        }
        return arrayList2;
    }

    public static FPoint[] a(ad ad2, boolean bl2) {
        float f2 = ad2.getSkyHeight();
        int n2 = 0;
        int n3 = 0;
        if (bl2) {
            n2 = 100;
            n3 = 10;
        }
        FPoint fPoint = FPoint.obtain();
        ad2.a(-n2, (int)(f2 - (float)n3), (PointF)fPoint);
        a[0].set(fPoint.x, fPoint.y);
        FPoint fPoint2 = FPoint.obtain();
        ad2.a(ad2.getMapWidth() + n2, (int)(f2 - (float)n3), (PointF)fPoint2);
        a[1].set(fPoint2.x, fPoint2.y);
        FPoint fPoint3 = FPoint.obtain();
        ad2.a(ad2.getMapWidth() + n2, ad2.getMapHeight() + n2, (PointF)fPoint3);
        a[2].set(fPoint3.x, fPoint3.y);
        FPoint fPoint4 = FPoint.obtain();
        ad2.a(-n2, ad2.getMapHeight() + n2, (PointF)fPoint4);
        a[3].set(fPoint4.x, fPoint4.y);
        fPoint.recycle();
        fPoint2.recycle();
        fPoint3.recycle();
        fPoint4.recycle();
        return a;
    }

    private static FPoint3 a(FPoint fPoint, FPoint fPoint2, FPoint3 fPoint3, FPoint3 fPoint32, int n2) {
        FPoint3 fPoint33 = new FPoint3(0.0f, 0.0f, n2);
        double d2 = (fPoint2.y - fPoint.y) * (fPoint.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint.y - fPoint3.y);
        double d3 = (fPoint2.y - fPoint.y) * (fPoint32.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint32.y - fPoint3.y);
        fPoint33.x = (float)((double)fPoint3.x + (double)(fPoint32.x - fPoint3.x) * d2 / d3);
        fPoint33.y = (float)((double)fPoint3.y + (double)(fPoint32.y - fPoint3.y) * d2 / d3);
        return fPoint33;
    }

    private static FPoint a(FPoint fPoint, FPoint fPoint2, FPoint fPoint3, FPoint fPoint4) {
        FPoint fPoint5 = FPoint.obtain(0.0f, 0.0f);
        double d2 = (fPoint2.y - fPoint.y) * (fPoint.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint.y - fPoint3.y);
        double d3 = (fPoint2.y - fPoint.y) * (fPoint4.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint4.y - fPoint3.y);
        fPoint5.x = (float)((double)fPoint3.x + (double)(fPoint4.x - fPoint3.x) * d2 / d3);
        fPoint5.y = (float)((double)fPoint3.y + (double)(fPoint4.y - fPoint3.y) * d2 / d3);
        return fPoint5;
    }

    public static boolean a(FPoint fPoint, FPoint[] fPointArray) {
        if (fPointArray == null) {
            return false;
        }
        for (int n2 = 0; n2 < fPointArray.length; n2 = (int)((byte)(n2 + 1))) {
            if (fr.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
            return false;
        }
        return true;
    }

    private static boolean a(FPoint fPoint, FPoint fPoint2, FPoint fPoint3) {
        double d2 = (fPoint3.x - fPoint2.x) * (fPoint.y - fPoint2.y) - (fPoint.x - fPoint2.x) * (fPoint3.y - fPoint2.y);
        return d2 >= 0.0;
    }

    public static List<IPoint> a(IPoint[] iPointArray, List<IPoint> list, boolean bl2) {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                IPoint iPoint = (IPoint)arrayList2.get(n3 % n4);
                IPoint iPoint2 = (IPoint)arrayList2.get((n3 + 1) % n4);
                if (n3 == 0 && fr.a(iPoint, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                    arrayList.add(iPoint);
                }
                if (fr.a(iPoint, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                    if (fr.a(iPoint2, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                        arrayList.add(iPoint2);
                        continue;
                    }
                    arrayList.add(fr.a(iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length], iPoint, iPoint2));
                    continue;
                }
                if (!fr.a(iPoint2, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) continue;
                arrayList.add(fr.a(iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length], iPoint, iPoint2));
                arrayList.add(iPoint2);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((IPoint)arrayList.get(n3));
            }
        }
        return arrayList2;
    }

    private static IPoint a(IPoint iPoint, IPoint iPoint2, IPoint iPoint3, IPoint iPoint4) {
        IPoint iPoint5 = IPoint.obtain(0, 0);
        double d2 = (double)(iPoint2.y - iPoint.y) * (double)(iPoint.x - iPoint3.x) - (double)(iPoint2.x - iPoint.x) * (double)(iPoint.y - iPoint3.y);
        double d3 = (double)(iPoint2.y - iPoint.y) * (double)(iPoint4.x - iPoint3.x) - (double)(iPoint2.x - iPoint.x) * (double)(iPoint4.y - iPoint3.y);
        iPoint5.x = (int)((double)iPoint3.x + (double)(iPoint4.x - iPoint3.x) * d2 / d3);
        iPoint5.y = (int)((double)iPoint3.y + (double)(iPoint4.y - iPoint3.y) * d2 / d3);
        return iPoint5;
    }

    public static boolean a(List<IPoint> list, int n2, int n3) {
        if (n3 < 3) {
            return false;
        }
        double d2 = 1000000.0;
        double d3 = 0.0;
        int n4 = n3 - 1;
        int n5 = 0;
        while (n5 < n3) {
            IPoint iPoint = list.get(n4);
            IPoint iPoint2 = list.get(n5);
            d3 += (double)iPoint.x / d2 * ((double)iPoint2.y / d2) - (double)iPoint2.x / d2 * ((double)iPoint.y / d2);
            n4 = n5++;
        }
        return d3 < 0.0;
    }

    private static boolean a(IPoint iPoint, IPoint iPoint2, IPoint iPoint3) {
        return fr.a(iPoint.x, iPoint.y, iPoint2, iPoint3);
    }

    private static boolean a(int n2, int n3, IPoint iPoint, IPoint iPoint2) {
        double d2 = iPoint2.x - iPoint.x;
        double d3 = n3 - iPoint.y;
        double d4 = n2 - iPoint.x;
        double d5 = iPoint2.y - iPoint.y;
        return d2 * d3 - d4 * d5 >= 0.0;
    }

    public static Bitmap a(int n2, int n3, int n4, int n5) {
        Bitmap bitmap = null;
        try {
            int[] nArray = new int[n4 * n5];
            int[] nArray2 = new int[n4 * n5];
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            GLES20.glReadPixels((int)n2, (int)n3, (int)n4, (int)n5, (int)6408, (int)5121, (Buffer)intBuffer);
            for (int i2 = 0; i2 < n5; ++i2) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n6;
                    int n7 = nArray[i2 * n4 + i3];
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 << 16 & 0xFF0000;
                    nArray2[(n5 - i2 - 1) * n4 + i3] = n6 = n7 & 0xFF00FF00 | n9 | n8;
                }
            }
            bitmap = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(nArray2, 0, n4, 0, 0, n4, n5);
            return bitmap;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "AMapDelegateImpGLSurfaceView", "SavePixels");
            throwable.printStackTrace();
            return null;
        }
    }

    public static ho e() {
        try {
            if (w.e == null) {
                return new ho.a("3dmap", "6.9.3", w.c).a(new String[]{"com.amap.api.maps", "com.amap.api.mapcore", "com.autonavi.amap.mapcore", "com.amap.api.3dmap.admic", "com.amap.api.trace", "com.amap.api.trace.core"}).a("6.9.3").a();
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return w.e;
    }

    private static void b(View view) {
        if (view instanceof ViewGroup) {
            for (int i2 = 0; i2 < ((ViewGroup)view).getChildCount(); ++i2) {
                fr.b(((ViewGroup)view).getChildAt(i2));
            }
        } else if (view instanceof TextView) {
            ((TextView)view).setHorizontallyScrolling(false);
        }
    }

    public static Bitmap a(View view) {
        try {
            fr.b(view);
            view.destroyDrawingCache();
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            Bitmap bitmap = view.getDrawingCache();
            if (bitmap != null) {
                return bitmap.copy(Bitmap.Config.ARGB_8888, false);
            }
            return null;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Utils", "getBitmapFromView");
            throwable.printStackTrace();
            return null;
        }
    }

    public static DPoint a(LatLng latLng) {
        double d2 = latLng.longitude / 360.0 + 0.5;
        double d3 = Math.sin(Math.toRadians(latLng.latitude));
        double d4 = 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) / (Math.PI * -2) + 0.5;
        return DPoint.obtain(d2 * 1.0, d4 * 1.0);
    }

    public static boolean a(Rect rect, int n2, int n3) {
        return rect.contains(n2, n3);
    }

    public static Pair<Float, IPoint> a(AbstractCameraUpdateMessage abstractCameraUpdateMessage, GLMapState gLMapState, MapConfig mapConfig) {
        LatLngBounds latLngBounds = abstractCameraUpdateMessage.bounds;
        int n2 = abstractCameraUpdateMessage.width;
        int n3 = abstractCameraUpdateMessage.height;
        int n4 = Math.max(abstractCameraUpdateMessage.paddingLeft, 1);
        int n5 = Math.max(abstractCameraUpdateMessage.paddingRight, 1);
        int n6 = Math.max(abstractCameraUpdateMessage.paddingTop, 1);
        int n7 = Math.max(abstractCameraUpdateMessage.paddingBottom, 1);
        return fr.a(mapConfig, n4, n5, n6, n7, latLngBounds, n2, n3);
    }

    public static Pair<Float, IPoint> a(MapConfig mapConfig, int n2, int n3, int n4, int n5, LatLngBounds latLngBounds, int n6, int n7) {
        int n8;
        int n9;
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null) {
            return null;
        }
        if (mapConfig == null) {
            return null;
        }
        Point point = VirtualEarthProjection.latLongToPixels(latLngBounds.northeast.latitude, latLngBounds.northeast.longitude, 20);
        Point point2 = VirtualEarthProjection.latLongToPixels(latLngBounds.southwest.latitude, latLngBounds.southwest.longitude, 20);
        int n10 = point.x - point2.x;
        int n11 = point2.y - point.y;
        int n12 = n6 - (n2 + n3);
        int n13 = n7 - (n4 + n5);
        if (n10 < 0 && n11 < 0) {
            return null;
        }
        n10 = n10 <= 0 ? 1 : n10;
        n11 = n11 <= 0 ? 1 : n11;
        n12 = n12 <= 0 ? 1 : n12;
        n13 = n13 <= 0 ? 1 : n13;
        Pair<Float, Boolean> pair = fr.a(mapConfig, point.x, point.y, point2.x, point2.y, n12, n13);
        float f2 = ((Float)pair.first).floatValue();
        boolean bl2 = (Boolean)pair.second;
        float f3 = fr.a(mapConfig.getMapZoomScale(), f2, (double)n10);
        float f4 = fr.a(mapConfig.getMapZoomScale(), f2, (double)n11);
        if (f2 >= mapConfig.maxZoomLevel) {
            n9 = (int)((float)point2.x + ((float)(n3 - n2) + f3) * (float)n10 / (2.0f * f3));
            n8 = (int)((float)point.y + ((float)(n5 - n4) + f4) * (float)n11 / (2.0f * f4));
        } else if (bl2) {
            n9 = (int)((float)point2.x + (float)(n6 / 2 - n2) / f3 * (float)n10);
            n8 = (int)((float)point.y + ((float)(n5 - n4) + f4) * (float)n11 / (2.0f * f4));
        } else {
            n9 = (int)((float)point2.x + ((float)(n3 - n2) + f3) * (float)n10 / (2.0f * f3));
            n8 = (int)((float)point.y + (float)(n7 / 2 - n4) / f4 * (float)n11);
        }
        float f5 = mapConfig.getAnchorX() - (mapConfig.getMapWidth() >> 1);
        float f6 = mapConfig.getAnchorY() - (mapConfig.getMapHeight() >> 1);
        n9 = (int)((float)n9 + fr.a(mapConfig.getMapZoomScale(), f2, f5));
        n8 = (int)((float)n8 + fr.a(mapConfig.getMapZoomScale(), f2, f6));
        Pair pair2 = new Pair((Object)Float.valueOf(f2), (Object)IPoint.obtain(n9, n8));
        return pair2;
    }

    public static double a(float f2, double d2, double d3) {
        double d4 = d3 / (d2 *= (double)f2);
        return 20.0 - Math.log(d4) / Math.log(2.0);
    }

    private static float a(float f2, float f3, double d2) {
        return (float)(d2 / (Math.pow(2.0, 20.0f - f3) * (double)f2));
    }

    private static float a(float f2, float f3, float f4) {
        return (float)((double)f4 * Math.pow(2.0, 20.0f - f3) * (double)f2);
    }

    public static Pair<Float, Boolean> a(MapConfig mapConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = mapConfig.getSZ();
        boolean bl2 = true;
        if (n2 == n4 && n3 == n5) {
            f2 = mapConfig.getMaxZoomLevel();
        } else {
            float f3 = (float)fr.a(mapConfig.getMapZoomScale(), (double)n7, (double)Math.abs(n5 - n3));
            float f4 = (float)fr.a(mapConfig.getMapZoomScale(), (double)n6, (double)Math.abs(n4 - n2));
            f2 = Math.min(f4, f3);
            bl2 = f2 == f4;
            f2 = Math.min(mapConfig.getMaxZoomLevel(), Math.max(mapConfig.getMinZoomLevel(), f2));
        }
        return new Pair((Object)Float.valueOf(f2), (Object)bl2);
    }

    public static float b(MapConfig mapConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = mapConfig.getSZ();
        if (n2 != n4 && n3 != n5) {
            float f3 = (float)fr.a(mapConfig.getMapZoomScale(), (double)n7, (double)Math.abs(n5 - n3));
            float f4 = (float)fr.a(mapConfig.getMapZoomScale(), (double)n6, (double)Math.abs(n4 - n2));
            f2 = Math.max(f4, f3);
        }
        return f2;
    }

    public static boolean b(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            return true;
        }
        Log.w((String)"3dmap", (String)"the map must have a size");
        return false;
    }

    public static synchronized int[] a(int n2, int n3, int n4, int n5, MapConfig mapConfig, GLMapState gLMapState, int n6, int n7) {
        int n8 = mapConfig.getMapWidth();
        int n9 = mapConfig.getMapHeight();
        int n10 = mapConfig.getAnchorX();
        int n11 = mapConfig.getAnchorY();
        float f2 = fr.a(mapConfig.getMapZoomScale(), gLMapState.getMapZoomer(), (float)n10);
        float f3 = fr.a(mapConfig.getMapZoomScale(), gLMapState.getMapZoomer(), (float)(n8 - n10));
        float f4 = fr.a(mapConfig.getMapZoomScale(), gLMapState.getMapZoomer(), (float)n11);
        float f5 = fr.a(mapConfig.getMapZoomScale(), gLMapState.getMapZoomer(), (float)(n9 - n11));
        float f6 = (float)n4 + f2;
        float f7 = (float)n2 - f3;
        float f8 = (float)n3 + f4;
        float f9 = (float)n5 - f5;
        int[] nArray = new int[]{(int)Math.max(f6, Math.min((float)n6, f7)), (int)Math.max(f8, Math.min((float)n7, f9))};
        return nArray;
    }

    public static void a(Rect rect) {
        if (rect != null) {
            rect.set(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    public static void b(Rect rect, int n2, int n3) {
        if (rect != null) {
            if (n2 < rect.left) {
                rect.left = n2;
            }
            if (n2 > rect.right) {
                rect.right = n2;
            }
            if (n3 > rect.top) {
                rect.top = n3;
            }
            if (n3 < rect.bottom) {
                rect.bottom = n3;
            }
        }
    }

    public static byte[] a(byte[] byArray, int[] nArray) {
        byte[] byArray2 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            int n2 = bitmap.getWidth();
            int n3 = bitmap.getHeight();
            int n4 = 8;
            int n5 = 4;
            int n6 = 4;
            int n7 = 6;
            int n8 = 0;
            int n9 = n7;
            int n10 = 72;
            for (int i2 = 1; i2 < n10; ++i2) {
                for (int i3 = n4; i3 < n4 + n5; ++i3) {
                    int n11 = bitmap.getPixel(i3, i2);
                    if (i2 < n6 * n9) {
                        bitmap2.setPixel(i3, i2, nArray[n8]);
                        continue;
                    }
                    ++n8;
                    n9 += --n7;
                }
            }
            byArray2 = fr.b(bitmap2);
            if (byArray2 == null) {
                byArray2 = byArray;
            }
            bitmap2.recycle();
            bitmap.recycle();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static byte[] a(byte[] byArray, int n2) {
        return fr.a(byArray, n2, n2, true);
    }

    public static byte[] a(byte[] byArray, int n2, int n3, boolean bl2) {
        byte[] byArray2 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            int n4 = bitmap.getWidth();
            int n5 = bitmap.getHeight();
            for (int i2 = 0; i2 < n4; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    if (i2 == 0 || i3 == 0) {
                        if (bl2) continue;
                        bitmap2.setPixel(i2, i3, n3);
                        continue;
                    }
                    bitmap2.setPixel(i2, i3, n2);
                }
            }
            byArray2 = fr.b(bitmap2);
            if (byArray2 == null) {
                byArray2 = byArray;
            }
            bitmap2.recycle();
            bitmap.recycle();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] b(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Object var4_4 = null;
        try {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return byArray;
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
            }
            catch (Throwable throwable2) {
                Object var4_6 = null;
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                }
                throw throwable2;
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Throwable throwable4) {
                throwable4.printStackTrace();
            }
        }
        return null;
    }

    public static boolean a(List<BaseHoleOptions> list, PolygonHoleOptions polygonHoleOptions) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BaseHoleOptions baseHoleOptions;
            BaseHoleOptions baseHoleOptions2 = list.get(i2);
            if (baseHoleOptions2 instanceof PolygonHoleOptions) {
                baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2;
                bl2 = fr.a(baseHoleOptions.getPoints(), polygonHoleOptions.getPoints());
                if (!bl2) continue;
                return true;
            }
            if (!(baseHoleOptions2 instanceof CircleHoleOptions)) continue;
            baseHoleOptions = (CircleHoleOptions)baseHoleOptions2;
            bl2 = fr.b(polygonHoleOptions.getPoints(), (CircleHoleOptions)baseHoleOptions);
            if (!bl2) continue;
            return true;
        }
        return bl2;
    }

    public static boolean a(List<BaseHoleOptions> list, CircleHoleOptions circleHoleOptions) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BaseHoleOptions baseHoleOptions;
            BaseHoleOptions baseHoleOptions2 = list.get(i2);
            if (!(baseHoleOptions2 instanceof PolygonHoleOptions ? (bl2 = fr.b((baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2).getPoints(), circleHoleOptions)) : baseHoleOptions2 instanceof CircleHoleOptions && (bl2 = fr.a(circleHoleOptions, (CircleHoleOptions)(baseHoleOptions = (CircleHoleOptions)baseHoleOptions2))))) continue;
            return true;
        }
        return bl2;
    }

    public static boolean a(CircleHoleOptions circleHoleOptions, CircleHoleOptions circleHoleOptions2) {
        try {
            float f2 = AMapUtils.calculateLineDistance(circleHoleOptions2.getCenter(), circleHoleOptions.getCenter());
            boolean bl2 = (double)f2 < circleHoleOptions.getRadius() + circleHoleOptions2.getRadius();
            return bl2;
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "isPolygon2CircleIntersect");
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean b(List<LatLng> list, CircleHoleOptions circleHoleOptions) {
        try {
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.add(list.get(i2));
            }
            arrayList.add(list.get(0));
            ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
            for (int i3 = 0; i3 < arrayList.size() && i3 + 1 < arrayList.size(); ++i3) {
                boolean bl2;
                if (circleHoleOptions.getRadius() >= (double)AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)arrayList.get(i3)) || circleHoleOptions.getRadius() >= (double)AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)arrayList.get(i3 + 1))) {
                    return true;
                }
                arrayList2.clear();
                arrayList2.add((LatLng)arrayList.get(i3));
                arrayList2.add((LatLng)arrayList.get(i3 + 1));
                Pair<Integer, LatLng> pair = SpatialRelationUtil.calShortestDistancePoint(arrayList2, circleHoleOptions.getCenter());
                float f2 = AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)pair.second);
                boolean bl3 = bl2 = circleHoleOptions.getRadius() >= (double)f2;
                if (!bl2) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "isPolygon2CircleIntersect");
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean a(List<LatLng> list, List<LatLng> list2) {
        try {
            boolean bl2;
            int n2;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                bl2 = fr.a(list2.get(n2), list);
                if (!bl2) continue;
                return true;
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                bl2 = fr.a(list.get(n2), list2);
                if (!bl2) continue;
                return true;
            }
            return fr.b(list, list2);
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "isPolygon2PolygonIntersect");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean b(List<LatLng> list, List<LatLng> list2) {
        try {
            for (int i2 = 0; i2 < list.size() && i2 + 1 < list.size(); ++i2) {
                for (int i3 = 0; i3 < list2.size() && i3 + 1 < list2.size(); ++i3) {
                    boolean bl2 = fm.a(list.get(i2), list.get(i2 + 1), list2.get(i3), list2.get(i3 + 1));
                    if (!bl2) continue;
                    return bl2;
                }
            }
        }
        catch (Throwable throwable) {
            ic.c(throwable, "Util", "isSegmentsIntersect");
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean e(Context context) {
        File file = new File(fr.b(context));
        if (!file.exists()) {
            return true;
        }
        return FileUtil.deleteFile(file);
    }

    public static float a(DPoint dPoint, DPoint dPoint2) {
        if (dPoint == null || dPoint2 == null) {
            return 0.0f;
        }
        double d2 = dPoint.x;
        double d3 = dPoint2.x;
        double d4 = dPoint.y;
        double d5 = dPoint2.y;
        float f2 = (float)(Math.atan2(d5 - d4, d3 - d2) / Math.PI * 180.0);
        return f2;
    }
}

