#ifndef  _JMDOS_H_
#define  _JMDOS_H_

//#include <JMDKernel.h>
#include "FreeRTOSConfig.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "list.h"
#include "portable.h"
//#include "jmd_task.h"
//#include "jmdpiclib.h"

#define _MAIN_ 1
//#define _TASK1_ 1
//#define _TASK2_ 1
//#define _TASK3_ 1
//#define _TASK4_ 1
//#define _TASK5_ 1
//#define _TASK6_ 1
//#define _TASK7_ 1
//#define _TASK8_ 1

#define _TASK_BT_	0//
#define _PICTURETASK_EN_	0//ͼƬʾ

#define RTOS_MAIN_TASK_STACK_SIZE	256	//ջռ//ջռһҪֺ
#define RTOS_TASK_STACK_SIZE		192	//256//128//ջռ
#define RTOS_TASK_PRIORITIES		3	//ûȼ


void task_main_entry(void);
void task1_entry(void);
void task2_entry(void);
void task3_entry(void);
void task4_entry(void);
void task5_entry(void);
void task6_entry(void);
void task7_entry(void);
void task8_entry(void);

uint16_t OS_CreateTask(uint8_t tasknum);	//񴴽,һԲ
uint16_t OS_TaskDelete(uint8_t tasknum);	//ɾ,һԲ
uint16_t OS_TaskSuspend(uint8_t tasknum);	//
uint16_t OS_TaskResume(uint8_t tasknum);	//

void Create_Task(void);
//void BoardHardware_Init(void);


//Ϊ,Ĺɾ
xTaskHandle xComTaskHandle;//WIFI
//xTaskHandle xSubTaskHandle;//ӳ
#ifdef _MAIN_//Ĭϳʼmain
	xTaskHandle xMainHandle;
#endif

//#ifdef _TASK1_
	xTaskHandle xTask1Handle;
//#endif

#ifdef _TASK2_
	xTaskHandle xTask2Handle;
#endif

#ifdef _TASK3_
	xTaskHandle xTask3Handle;
#endif

#ifdef _TASK4_
	xTaskHandle xTask4Handle;
#endif

#ifdef _TASK5_
	xTaskHandle xTask5Handle;
#endif

#ifdef _TASK6_
	xTaskHandle xTask6Handle;
#endif

#ifdef _TASK7_
	xTaskHandle xTask7Handle;
#endif

#ifdef _TASK8_
	xTaskHandle xTask8Handle;
#endif



void Create_Task(void)//񴴽ϵͳ
{
#if _MAIN_ > 0//ԤΪ1ʱ,ʼ֮ǰʼõ
	OS_CreateTask(10);
#endif		
/*			
#if _TASK1_ > 0
	OS_CreateTask(1);
#endif

#if _TASK2_ > 0
	OS_CreateTask(2);
#endif

#if _TASK3_ > 0
	OS_CreateTask(3);
#endif

#if _TASK4_ > 0
	OS_CreateTask(4);
#endif

#if _TASK5_ > 0
	OS_CreateTask(5);
#endif

#if _TASK6_ > 0
	OS_CreateTask(6);
#endif

#if _TASK7_ > 0
	OS_CreateTask(7);
#endif

#if _TASK8_ > 0
	OS_CreateTask(8);
#endif

#ifdef _TASK_BT_
	Create_ComTask();
#endif
*/
	//ʼ
	vTaskStartScheduler();
}

#ifdef _TASK_BT_
void task_com_entry(void);
uint8_t Create_ComTaskFlag=0;
void Create_ComTask(void)//ͨ
{
	if(Create_ComTaskFlag)return;Create_ComTaskFlag=1;
	xTaskCreate(task_com_entry,//ַ,ָ
							( const signed char * )"task_com_entry", //
							128,//RTOS_TASK_STACK_SIZE,//256,//ջռ
							NULL, //ָڲ򴴽
							RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
							&xComTaskHandle );//,ӦôӶ
}

void os_com_task(void);//
void task_com_entry(void)//,붨
{
	//os_com_task();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
#endif//_TASK_BT_

#ifdef _PICTURETASK_EN_
xTaskHandle xPicTaskHandle;//WIFI
int Create_PicTask(void);
void task_pic_entry(void);
uint8_t _Create_PicTaskFlag=0;
int Create_PicTask(void)//ͨ
{
	if(_Create_PicTaskFlag)return _Create_PicTaskFlag;_Create_PicTaskFlag=1;
	xTaskCreate(task_pic_entry,//ַ,ָ
							( const signed char * )"task_pic_entry", //
							1728,//2048,//RTOS_TASK_STACK_SIZE,//256,//ջռ
							NULL, //ָڲ򴴽
							RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
							&xPicTaskHandle );//,ӦôӶ
	return 0;
}
void os_picture_task(void);
void task_pic_entry(void)
{
	os_picture_task();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
void PicTaskSuspend(void)
{
	vTaskSuspend(xPicTaskHandle);
}
void PicTaskResume(void)
{
	vTaskResume(xPicTaskHandle);
}
#endif//_PICTURETASK_EN_




#ifdef _MAIN_//Ĭϳʼ
int main(void);//
void task_main_entry(void)//,붨
{
  	main();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
#endif//#ifndef _MAIN_

//#ifdef _TASK1_
void task1(void);
void task1_entry(void)
{
	task1();
	vTaskDelete(NULL);
}
//#endif//_TASK1_

#ifdef _TASK2_
void task2(void);
void task2_entry(void)
{
	task2();
	vTaskDelete(NULL);
}
#endif//_TASK2_

#ifdef _TASK3_
void task3(void);
void task3_entry(void)
{
	task3();
	vTaskDelete(NULL);
}
#endif//_TASK3_

#ifdef _TASK4_
void task4(void);
void task4_entry(void)
{
	task4();
	vTaskDelete(NULL);
}
#endif//_TASK4_

#ifdef _TASK5_
void task5(void);
void task5_entry(void)
{
	task5();
	vTaskDelete(NULL);
}
#endif//_TASK5_

#ifdef _TASK6_
void task6(void);
void task6_entry(void)
{
	task6();
	vTaskDelete(NULL);
}
#endif//_TASK6_

#ifdef _TASK7_
void task7(void);
void task7_entry(void)
{
	task7();
	vTaskDelete(NULL);
}
#endif//_TASK7_

#ifdef _TASK8_
void task8(void);
void task8_entry(void)
{
	task8();
	vTaskDelete(NULL);
}
#endif//_TASK8_

//ҪȡռõĶ˿ʹȨʱ,볬ʱȴʹȨ,ʱȻûлȡ,Ӧ˳Աִ
#define MUTEXTAKETICKTOWAIT		100	//100ms
volatile uint16_t MutexTakeWaitTime=MUTEXTAKETICKTOWAIT;//˿ڱռµĳʱʱ
void SetPortMutexTakeWaitTime(uint16_t time){MutexTakeWaitTime=time;}


#define RcuWhichMutexTake(which,mode,Return) if(RcuPortMutexTake(which,mode)==2)\
                                            {\
												if(mode!=0)\
												{\
													uint32_t t_time=GetSystemTime()+MutexTakeWaitTime;\
													while(RcuPortMutexTake(which,mode)==2)\
													{\
														if(t_time<GetSystemTime())return(Return);\	
													}\
												}\
											}

//ͷRCU˿ʹȨֻռж˿ڵʹȨʹøö˿ 																								 
#define RcuWhichMutexGive(which,mode,Return) RcuPortMutexGive(which,mode)


#define _GET_FLAG(flagx,bity)			((flagx>>(bity<<1))&0X03)
#define _SET_FLAG(flagx,bity,state)		(flagx|=(state<<(bity<<1)))
#define _RESET_FLAG(flagx,bity,state)	(flagx&=~(state<<(bity<<1)))
static volatile uint32_t __task_create_flag=0;
static volatile uint32_t __task_management_flag=0;
#define vTaskHardwareMutexRelease(taskhandle) //RcuPortMutexRelease(taskhandle)//ͷʹõ
#define vTaskManagement_Enter()			os_setinterruptmask()//##ںж
#define vTaskManagement_Leave()			os_clearinterruptmask()//##ںж


static uint8_t _Get_OSTaskNum(uint8_t tasknum)
{
	extern pxCurrentTCB;//ǰеջ
	if(tasknum)return tasknum;
	//if(pxCurrentTCB==xMainHandle)return 0;
#ifdef _MAIN_
	if(pxCurrentTCB==xMainHandle)return 10;
#endif//_MAIN_	
//#ifdef _TASK1_
	if(pxCurrentTCB==xTask1Handle)return 1;
//#endif//_TASK1_

#ifdef _TASK2_
	if(pxCurrentTCB==xTask2Handle)return 2;
#endif//_TASK2_

#ifdef _TASK3_
	if(pxCurrentTCB==xTask3Handle)return 3;
#endif//_TASK3_

#ifdef _TASK4_
	if(pxCurrentTCB==xTask4Handle)return 4;
#endif//_TASK4_

#ifdef _TASK5_
	if(pxCurrentTCB==xTask5Handle)return 5;
#endif//_TASK5_

#ifdef _TASK6_
	if(pxCurrentTCB==xTask6Handle)return 6;
#endif//_TASK6_

#ifdef _TASK7_
	if(pxCurrentTCB==xTask7Handle)return 7;
#endif//_TASK7_

#ifdef _TASK8_
	if(pxCurrentTCB==xTask8Handle)return 8;
#endif//_TASK8_

	return 0;
}

static int16_t RTOS_TaskManagement(xTaskHandle taskhandle,uint8_t mode)////ɾ
{
	switch(mode)
	{	//ɾ
		case 1:	vTaskManagement_Enter();
			    vTaskHardwareMutexRelease(taskhandle);
			    vTaskDelete(taskhandle);
			    vTaskManagement_Leave();
	  			return 1;
		//
		case 2:	vTaskManagement_Enter();
			    vTaskHardwareMutexRelease(taskhandle);
		        vTaskSuspend(taskhandle);
		        vTaskManagement_Leave();
				return 2;
		break;
		//ѹ,ܻ
		case 3: vTaskResume(taskhandle);
				return 3;
		break;
	}
	return 0;
}

uint16_t OS_TaskManagement(uint8_t tasknum,uint8_t mode)//
{
	uint16_t state=NULL;
	extern pxCurrentTCB;//ǰеջ
	switch(tasknum)
	{
		#ifdef _MAIN_//Ĭϳʼ
		case 10: state=RTOS_TaskManagement(xMainHandle, mode);	break;
		#endif//_MAIN_
		
		//#ifdef _TASK1_
		case 1:	state=RTOS_TaskManagement(xTask1Handle, mode);	break;
		//#endif//_TASK1_

		#ifdef _TASK2_
		case 2:	state=RTOS_TaskManagement(xTask2Handle, mode);	break;
		#endif//_TASK2_

		#ifdef _TASK3_
		case 3:	state=RTOS_TaskManagement(xTask3Handle, mode);	break;
		#endif//_TASK3_

		#ifdef _TASK4_
		case 4:	state=RTOS_TaskManagement(xTask4Handle, mode);  break;
		#endif//_TASK4_

		#ifdef _TASK5_	
		case 5:	state=RTOS_TaskManagement(xTask5Handle, mode);  break;
		#endif//_TASK5_

		#ifdef _TASK6_	
		case 6:	state=RTOS_TaskManagement(xTask6Handle, mode);  break;
		#endif//_TASK6_

		#ifdef _TASK7_
		case 7:	state=RTOS_TaskManagement(xTask7Handle, mode);  break;
		#endif//_TASK7_

		#ifdef _TASK8_
		case 8:	state=RTOS_TaskManagement(xTask8Handle, mode);  break;
		#endif//_TASK8_		
	}
	return state;
}

uint16_t OS_CreateTaskx(uint8_t tasknum);//
void OS_TaskCreate(uint8_t tasknum)//񴴽
{
	OS_CreateTask(tasknum);	
}

uint16_t OS_TaskDelete(uint8_t tasknum)//ɾ
{
	uint8_t n=_Get_OSTaskNum(tasknum);//ȡ
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	if(_GET_FLAG(__task_management_flag,n)==1)return 1;_SET_FLAG(__task_management_flag,n,1);
	OS_TaskManagement(tasknum, 1);
	return 1;
}

uint16_t OS_TaskSuspend(uint8_t tasknum)//
{//ѾͲҪٽйѾɾܹ
	uint8_t n=_Get_OSTaskNum(tasknum);//ȡ
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	uint8_t flag=_GET_FLAG(__task_management_flag,n);
	if(flag==1||flag==2)return flag;_SET_FLAG(__task_management_flag,n,2);
	OS_TaskManagement(tasknum, 2);
	return 2;
}

uint16_t OS_TaskResume(uint8_t tasknum)//
{//ѾѵͲҪٽлѣѾɾܻ
	uint8_t n=_Get_OSTaskNum(tasknum);//ȡ
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	uint8_t flag=_GET_FLAG(__task_management_flag,n);
	if(flag==1||flag==3)return flag;_SET_FLAG(__task_management_flag,n,0x03);
	OS_TaskManagement(tasknum, 3);
	return 3;
}

uint16_t OS_CreateTask(uint8_t tasknum)//
{
	if(_GET_FLAG(__task_create_flag,tasknum))return 0;_RESET_FLAG(__task_management_flag,tasknum,0x03);
	switch(tasknum)
	{
		#ifdef _MAIN_
	    case 10:
			
	    xTaskCreate(task_main_entry,	//ַ,ָ
			        ( const signed char * )"task_main", 	//
			        RTOS_MAIN_TASK_STACK_SIZE,//RTOS_TASK_STACK_SIZE,//256,//ջռ
			        NULL, 			//ָڲ򴴽
			        RTOS_TASK_PRIORITIES,	//RTOS_TASK_PRIORITIES,//2//ȼ
			        &xMainHandle ); //,ӦôӶ	
		break;
		#endif//_MAIN_
		//#ifdef _TASK1_	
		case 1:
			xTaskCreate(task1_entry,//ַ,ָ
					        ( const signed char * )"task1", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask1Handle );//,ӦôӶ
		break;
		//#endif//_TASK1_
		
		#ifdef _TASK2_
		case 2:
			xTaskCreate(task2_entry,//ַ,ָ
					        ( const signed char * )"task2", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask2Handle );//,ӦôӶ
	  	break;
	 	#endif//_TASK2_
		
		#ifdef _TASK3_
		case 3:
			xTaskCreate(task3_entry,//ַ,ָ
					        ( const signed char * )"task3", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask3Handle );//,ӦôӶ
		break;
		#endif//_TASK3_
		
		#ifdef _TASK4_
		case 4:
			xTaskCreate(task4_entry,//ַ,ָ
					        ( const signed char * )"task4", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask4Handle );//,ӦôӶ
    	break;
		#endif//_TASK4_	
		
		#ifdef _TASK5_
		case 5:
			xTaskCreate(task5_entry,//ַ,ָ
					        ( const signed char * )"task5", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask5Handle );//,ӦôӶ
    	break;
		#endif//_TASK5_	
		
		#ifdef _TASK6_
		case 6:
			xTaskCreate(task6_entry,//ַ,ָ
					        ( const signed char * )"task6", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask6Handle );//,ӦôӶ
    	break;
		#endif//_TASK6_
		
		#ifdef _TASK7_	
		case 7:
			xTaskCreate(task7_entry,//ַ,ָ
					        ( const signed char * )"task7", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask7Handle );//,ӦôӶ
    	break;
		#endif//_TASK7_
		
		#ifdef _TASK8_
		case 8:
			xTaskCreate(task8_entry,//ַ,ָ
					        ( const signed char * )"task8", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask8Handle );//,ӦôӶ
    	break;
		#endif//_TASK8_		
	}

	_SET_FLAG(__task_create_flag,tasknum,0x01);
	return 1;
}


void OS_WifiTaskSuspend(void)//WIFI
{
	vTaskManagement_Enter();
	vTaskHardwareMutexRelease(xComTaskHandle);
	vTaskSuspend(xComTaskHandle);
	vTaskManagement_Leave();
}
void OS_WifiTaskResume(void)//WIFI
{
	//ѹ,ܻ
	vTaskResume(xComTaskHandle);
}
void OS_PicTaskSuspend(void)//Pic
{
	vTaskSuspend(xPicTaskHandle);
}
void OS_PicTaskResume(void)//Pic
{
	//ѹ,ܻ
	vTaskResume(xPicTaskHandle);
}

#endif


