//***************************(C) COPYRIGHT 2015 CZQ******************************
//*******************************************************************************
// File Name   	: jmdisr.h
// Version		  : V0.0
// Compiler		  : GCCARM
// Target		    : X3RCU (STM32F407ZET6)
// Author		    : CZQ
// Date			    : 2015/09/21
// Description  : ϵͳжϺļжϺͬһ,ļ
//                ʹжϺstm32fxxx_it.c,жϺΪѾĺ,
//                ļ¶жϺΪʵΪպڵù,
//                ûָκκ(ָжϴ),úΪ,жϺ
//                ͳһɺSetSysISRHookFunָעжϺҪ!
//*******************************************************************************
//
//*******************************************************************************
#ifndef __JMDISR_H
#define __JMDISR_H
//** defined ********************************************************************
//Ԥ
#define __ISR_HOOK_EN		1//ʹжϺ
//
#define NULL ((void *)0)
//funtion
//ѶжϺ,жϺͳһΪ:XX_ISR(),stm32fxxx_it.cжϺ
//ͬʱҪҽstm32fxxx_it.cжϺʵ
void USART1_ISR(void);
void USART2_ISR(void);
void USART3_ISR(void);
void UART4_ISR(void);
void UART5_ISR(void);
void USART6_ISR(void);
void EXTI9_5_ISR(void);
void EXTI15_10_ISR(void);
void TIM10_ISR(void);
void TIM7_ISR(void);
void SysTick_ISR(void);
void I2C3_EV_ISR(void);
void I2C3_ER_ISR(void);
void DMA1_Stream2_ISR(void);
//includes
void MotorCode1_ISR(void);
void MotorCode2_ISR(void);
void SysCOM1_ISR(void);
void SysCOM2_ISR(void);
void SysCOM3_ISR(void);
void SysCOM4_ISR(void);
void SysCOM5_ISR(void);
void SysCOM6_ISR(void);
void PID_ISR(void);
void I2C3_EVENT_ISR(void);
void I2C3_ERROR_ISR(void);
void DMA1_Stream2_I2C3_ISR(void);

void MotorCode12_PID_ISR(void);
void MotorCode34_PID_ISR(void);
void ComServo_ISR(void);

void InMusicDelay_ISR(void);
//***жϺ************************************************************************
//ض,ɿŸû
#if __ISR_HOOK_EN > 0
//жϹ
//:sysͷ,isr_hookβsys_name_isr_hook,name= i2c/SPI/UART/EXTI...
//
void (*sys_usart2_isr_hook)();
void (*sys_uart5_isr_hook)();
void (*sys_uart4_isr_hook)();
void (*sys_usart3_isr_hook)();
void (*sys_usart6_isr_hook)();
void (*sys_usart1_isr_hook)();
//ⲿж
void (*sys_exti15_10_isr_hook)();
void (*sys_exti9_5_isr_hook)();
//ʱ
void (*sys_timer7_isr_hook)();
void (*sys_timer6_isr_hook)();
void (*sys_timer10_isr_hook)();

//I2C
void (*sys_i2c3_ev_isr_hook)();
void (*sys_i2c3_er_isr_hook)();
void (*sys_dma1_stream2_isr_hook)();
//SysTick
void (*sys_systick_isr_hook)();

//
//ģʽ
void (*sys_motor12pid_isr_hook)();
void (*sys_motor34pid_isr_hook)();
void (*sys_motor56pid_isr_hook)();
typedef enum//ԶжϹ
{
	__U2_IRQN=0,
	__U5_IRQN=1,
	__U4_IRQN=2,
	__U3_IRQN=3,
	__U6_IRQN=4,
	__U1_IRQN=5,

	__E15_10_IRQN=6,
	__E9_5_IRQN=7,

	__T7_IRQN=8,
	__STICK_IRQN=9,
	__I2C3EV_IRQN=10,
	__I2C3ER_IRQN=11,
	__DMA1S2_IRQN=12,

	__T6_IRQN=13,
	__T10_IRQN=14
}ISRFUN_DEFINED;
//¼жϺҪSetSysISRHookFun
u8 SetSysISRHookFun(u8 n,void (*hook)(void))//жϹ,ע⣺һжϹ,ϵͳͲ
{
	switch(n)
  {
		case __U2_IRQN:  		if(sys_usart2_isr_hook!=hook)sys_usart2_isr_hook=hook;							return 1;	break;
		case __U5_IRQN:  		if(sys_uart5_isr_hook!=hook) sys_uart5_isr_hook=hook;								return 1;	break;
		case __U4_IRQN:  		if(sys_uart4_isr_hook!=hook) sys_uart4_isr_hook=hook;								return 1;	break;
		case __U3_IRQN:  		if(sys_usart3_isr_hook!=hook)sys_usart3_isr_hook=hook;							return 1;	break;
		case __U6_IRQN:  		if(sys_usart6_isr_hook!=hook)sys_usart6_isr_hook=hook;							return 1;	break;
		case __U1_IRQN:  		if(sys_usart1_isr_hook!=hook)sys_usart1_isr_hook=hook;							return 1;	break;

		case __E15_10_IRQN: if(sys_exti15_10_isr_hook!=hook)sys_exti15_10_isr_hook=hook;				return 1;	break;
		case __E9_5_IRQN:  	if(sys_exti9_5_isr_hook!=hook)  sys_exti9_5_isr_hook=hook;					return 1;	break;
		case __T7_IRQN:  		if(sys_timer7_isr_hook!=hook)   sys_timer7_isr_hook=hook;						return 1;	break;
		case __STICK_IRQN:  if(sys_systick_isr_hook!=hook)  sys_systick_isr_hook=hook;					return 1;	break;
		case __I2C3EV_IRQN: if(sys_i2c3_ev_isr_hook!=hook)  sys_i2c3_ev_isr_hook=hook;					return 1;	break;
		case __I2C3ER_IRQN: if(sys_i2c3_er_isr_hook!=hook)  sys_i2c3_er_isr_hook=hook;					return 1;	break;
		case __DMA1S2_IRQN: if(sys_dma1_stream2_isr_hook!=hook)sys_dma1_stream2_isr_hook=hook;	return 1;	break;

		case __T6_IRQN:  		if(sys_timer6_isr_hook!=hook)   sys_timer6_isr_hook=hook;						return 1;	break;
		case __T10_IRQN:  		if(sys_timer10_isr_hook!=hook)   sys_timer10_isr_hook=hook;						return 1;	break;
  }
	return 0;
}
//ΪһõжϺ
void SysMotorCodeISRFunInit(void)//ʼжϺ
{
//#if __ISR_HOOK_EN > 0
	SetSysISRHookFun(__E9_5_IRQN,MotorCode1_ISR);//EXTI9_5_ISR
	SetSysISRHookFun(__E15_10_IRQN,MotorCode2_ISR);//EXTI15_10_ISR
//#endif
}
void SysMCPidISRFunInit(void)//ʼģʽжϺ
{
//#if __ISR_HOOK_EN > 0
	SetSysISRHookFun(__T7_IRQN,PID_ISR);//öʱж
	if(sys_motor12pid_isr_hook!=MotorCode12_PID_ISR)  sys_motor12pid_isr_hook=MotorCode12_PID_ISR;//M12
	if(sys_motor34pid_isr_hook!=MotorCode34_PID_ISR)  sys_motor34pid_isr_hook=MotorCode34_PID_ISR;//M34
	//if(sys_motor56pid_isr_hook!=hook)  sys_motor56pid_isr_hook=hook;//M56
}

void SysComServoISRFunInit(void)//ʼŷʱжϺ
{
	SetSysISRHookFun(__T10_IRQN,ComServo_ISR);//öʱж
}


void SysUSARTISRFunInit(u8 Usartx)//ʼжϺ
{
//#if __ISR_HOOK_EN > 0
	switch(Usartx)
	{
		case __U2_IRQN:SetSysISRHookFun(__U2_IRQN,SysCOM2_ISR);break;//USART2_ISR//Servo1
		case __U5_IRQN:SetSysISRHookFun(__U5_IRQN,SysCOM5_ISR);break;//UART5_ISR//Servo2
		case __U4_IRQN:SetSysISRHookFun(__U4_IRQN,SysCOM4_ISR);break;//UART4_ISR//蓝牙
	//	case __U3_IRQN:SetSysISRHookFun(__U3_IRQN,SysCOM3_ISR);break;//USART3_ISR
		case __U6_IRQN:SetSysISRHookFun(__U6_IRQN,SysCOM6_ISR);break;//USART6_ISR//D6
		case __U1_IRQN:SetSysISRHookFun(__U1_IRQN,SysCOM1_ISR);break;//USART1_ISR//D3
	}
//#endif
}
void SysTIM7ISRFunInit(void)//ʼTIM7жϺ
{
//#if __ISR_HOOK_EN > 0
	SetSysISRHookFun(__T7_IRQN,PID_ISR);//
//#endif
}
void SysMusicISRFunInit(void)
{
	//#if __ISR_HOOK_EN > 0
		SetSysISRHookFun(__T6_IRQN,InMusicDelay_ISR);//
	//#endif
}
void SysTick_I2C_ISR(void);
void SysTickISRFunInit(void)//ʼsystickжϺ
{
//#if __ISR_HOOK_EN > 0
	SetSysISRHookFun(__STICK_IRQN,SysTick_I2C_ISR);//
//#endif
}
void SysI2C3ISRFunInit(void)//ʼI2C3_DMAжϺ
{
//#if __ISR_HOOK_EN > 0
	SetSysISRHookFun(__I2C3EV_IRQN,I2C3_EVENT_ISR);//
	SetSysISRHookFun(__I2C3ER_IRQN,I2C3_ERROR_ISR);//
	SetSysISRHookFun(__DMA1S2_IRQN,DMA1_Stream2_I2C3_ISR);//
//#endif
}
#endif//#if __ISR_HOOK_EN > 0
//***жϺ**END*******************************************************************
//***жϺ*****************************************************************************
//******************************************************************************
//*            STM32F2xx Peripherals Interrupt Handlers                        *
//******************************************************************************
void TIM7_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_timer7_isr_hook!=NULL)
	{sys_timer7_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	//if(TIM_GetITStatus(TIM7,TIM_IT_Update))
	//{
	//	PID_ISR();
	//	TIM_ClearITPendingBit(TIM7,TIM_IT_Update);//ж
	//}
	PID_ISR();
#endif//#if __ISR_HOOK_EN == 0
}
void TIM6_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_timer6_isr_hook!=NULL)
	{sys_timer6_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	PID_ISR();
#endif//#if __ISR_HOOK_EN == 0
}

void TIM10_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_timer10_isr_hook!=NULL)
	{sys_timer10_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	ComServo_ISR();
#endif//#if __ISR_HOOK_EN == 0
}


void SysTick_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_systick_isr_hook!=NULL)
	{sys_systick_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0
#if __ISR_HOOK_EN == 0//ʹжϺ
	SysTick_I2C_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void USART2_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_usart2_isr_hook!=NULL)
	{sys_usart2_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0
#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(USART2, USART_IT_RXNE) != RESET)
	{   // Read one byte from the receive data register
		//UART2_RX_ISR();
		UARTx_RX_ISR(0);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
//*******************************************************************************
// Function Name  :
// Description    : жϺ
// Input          :
// Output         :
// Return         :
// Author		  : CZQ 2014/11/11
//*******************************************************************************
void UART5_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_uart5_isr_hook!=NULL)
	{sys_uart5_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0
#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(UART5, USART_IT_RXNE) != RESET)
	{   // Read one byte from the receive data register
		//UART5_RX_ISR();
		UARTx_RX_ISR(1);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void UART4_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_uart4_isr_hook!=NULL)
	{sys_uart4_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(UART4, USART_IT_RXNE) != RESET)
	{   // Read one byte from the receive data register
		//UART4_RX_ISR();
		UARTx_RX_ISR(2);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void USART3_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_usart3_isr_hook!=NULL)
	{sys_usart3_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(USART3, USART_IT_RXNE) != RESET)
	{   // Read one byte from the receive data register
		//UART3_RX_ISR();
		UARTx_RX_ISR(3);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void USART6_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_usart6_isr_hook!=NULL)
	{sys_usart6_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(USART6, USART_IT_RXNE) != RESET)
	{
		//UART6_RX_ISR();
		UARTx_RX_ISR(4);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void USART1_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_usart1_isr_hook!=NULL)
	{sys_usart1_isr_hook();return ;}
#endif

#if __ISR_HOOK_EN == 0//ʹжϺ
	if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)
	{   // Read one byte from the receive data register
		//UART1_RX_ISR();
		UARTx_RX_ISR(5);
	}
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}

/*******************************************************************************
* Function Name  : EXTI15_10_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI15_10_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_exti15_10_isr_hook!=NULL)
	{sys_exti15_10_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	MotorCode2_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
/*******************************************************************************
* Function Name  : EXTI9_5_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI9_5_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_exti9_5_isr_hook!=NULL)
	{sys_exti9_5_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	MotorCode1_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void DMA1_Stream2_ISR(void)//RX
{
#if __ISR_HOOK_EN > 0
	if(sys_dma1_stream2_isr_hook!=NULL)
	{sys_dma1_stream2_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	DMA1_Stream2_I2C3_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void I2C3_EV_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_i2c3_ev_isr_hook!=NULL)
	{sys_i2c3_ev_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	I2C3_EVENT_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
void I2C3_ER_ISR(void)
{
#if __ISR_HOOK_EN > 0
	if(sys_i2c3_er_isr_hook!=NULL)
	{sys_i2c3_er_isr_hook();return ;}
#endif//#if __ISR_HOOK_EN > 0

#if __ISR_HOOK_EN == 0//ʹжϺ
	I2C3_ERROR_ISR();
#endif//#if __ISR_HOOK_EN == 0//ʹжϺ
}
//***жϺ**END************************************************************************

#endif//__JMDISR_H
