#ifndef _SPI_FLASH_H_
#define _SPI_FLASH_H_  1

#include "stm32f4xx.h"

//Dataflashָ
#define Cmd_DF_PageRead      	0xD2
#define Cmd_DF_Buffer1Read      0xD1
#define Cmd_DF_Buffer2Read      0xD3
#define Cmd_DF_WriteBuffer1     0x84
#define Cmd_DF_WriteBuffer2     0x87
#define Cmd_DF_Buffer1ToPage  	0x83
#define Cmd_DF_Buffer2ToPage  	0x86
#define Cmd_DF_PageErase        0x81
#define Cmd_DF_BlockErase       0x50
#define Cmd_DF_SectorErase      0x7C
#define Cmd_DF_AllErase         0xC7
#define Cmd_DF_ReadState        0xD7
#define Cmd_DF_ReadID           0x9F

#define Dummy_Byte	 			0xA5

/* Select SPI FLASH: ChipSelect pin low  */
#define Select_Flash()      GPIO_ResetBits(GPIOB,GPIO_Pin_12)
/* Deselect SPI FLASH: ChipSelect pin high */
#define NotSelect_Flash()    GPIO_SetBits(GPIOB,GPIO_Pin_12)

typedef enum
{
	SPI_NONE=0,
	SPI_SUCCESS,
	SPI_ERROR,
	SPI_OVERTIME
}SPI_FLASH_DEFINED;

void sFlash_Init(void);	//SPIʼ
u8 sFlash_ReadByte(void);		//flashһֽ
u8 sFlash_SendByte(u8 byte);		//	FLASHһֽ
void sFlashPageEarse(u16 page);	//ָҳ,ҳΧ0-4095

void sFlashPageRead(u16 page,u8 *Data);		//ȡҳҳΧ0-4095
void sFlashPageWrite1(u16 page,u8 *Data);		//дһҳҳΧ0-4095
void sFlashPageWrite2(u16 page, u8 * Data);

//void sFlashWaitBusy(void);			//Flashæ
u8 sFlashWaitBusy(void);			//Flashæ20140329
void sFlashReadID(u8 *ProdustID);		//ȡflashIDĸֽ
u8 sFlashReadState(void);	
void sFlashModity512bytes(void);
void sFlashMultiRead(u8 *buf,u32 addr,u16 page_len);
#endif
