
#ifndef __LCD320240_H
#define __LCD320240_H

#ifdef __cplusplus
 extern "C" {
#endif
#include"stm32f4xx_conf.h"
#include "LCD_COLOR.h"

#include "charcter.h"

#if _LCD_CN_EN_ == 1
 #ifdef _LCD_CHINESE_EN_
  #ifndef  _LCD_CHINESE_EN_EXISTS_
  #define _LCD_CHINESE_EN_EXISTS_
	#include"CnLib.h"//汉字�?
 u8 LCD_Chinese(u16 x, u16 y,u8* pch,u16 fColor,u16 bColor,u8 transparent);
  #endif
 #endif
#endif

#if __LCD_FONT_16X32 == 1
#include"ascii_font16x32.h"
#endif
#if LCD_FONT_EN==1
#include"fonts.h"
static LcdFont_Typedef *Lcdfont;
void LCD_SetFont(LcdFont_Typedef *font)
{
  	Lcdfont=font;
}
 #endif
 extern u16 gLcdVersion;
#define _LCD_WR_DELAY()	{asm("nop");asm("nop");asm("nop");asm("nop");asm("nop");asm("nop");}
void Delay (vu32 nCount)
{
	vu32 i;
	for (i=0;i<nCount*2625;i++);//fclk=168Mhz 0.25毫秒级延�?
	//for (i=0;i<nCount*5250;i++);//fclk=168Mhz 0.5毫秒级延�?
	//for (i=0;i<nCount*10500;i++);//fclk=168Mhz 1毫秒级延�?
	//for (i=0;i<nCount*1000;i++);//
}
void Delayus(vu32 nCount)//fclk=168Mhz
{
	volatile int i;	 	
	for (i=0;i<nCount*10;i++);
}

void Delayns(vu32 nCount)
{
	volatile int i;	 	
	for (i=0;i<nCount;i++);
}
//RST-PF15 CS-PF13 RS-PF12 WR-PF11 RD-PB2
//D0~D7-PG0~PG7 LED-PD15
//TX+	PF5	ADC3_IN15
//TY+	PF6	ADC3_IN4
//TX-	PF7	ADC3_IN5
//TY-	PF8	ADC3_IN6
void LCD_PinInit(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
    RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOG|
    					   RCC_AHB1Periph_GPIOF|
    					   RCC_AHB1Periph_GPIOB|
    					   RCC_AHB1Periph_GPIOD ,ENABLE);

    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  	//初始化PG0~7-data8-data15
    GPIO_InitStructure.GPIO_Pin = 0x00ff;
    GPIO_Init(GPIOG, &GPIO_InitStructure);

    //初始化控制�?�线端口
    //RST-PF15 CS-PF13 RS-PF12 WR-PF11
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11|GPIO_Pin_12|GPIO_Pin_13|GPIO_Pin_15;
    GPIO_Init(GPIOF, &GPIO_InitStructure);
    //RD-PB2
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2;
    GPIO_Init(GPIOB, &GPIO_InitStructure);
    //LED-PD15
    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_15;
    GPIO_Init(GPIOD, &GPIO_InitStructure);
}
void SetCS(u8 temp)		{if(temp){GPIOF->BSRRL=GPIO_Pin_13;}else{GPIOF->BSRRH=GPIO_Pin_13;}}//CS-PF13
void SetRS(u8 temp)		{if(temp){GPIOF->BSRRL=GPIO_Pin_12;}else{GPIOF->BSRRH=GPIO_Pin_12;}}//RS-PF12
void SetWR(u8 temp)		{if(temp){GPIOF->BSRRL=GPIO_Pin_11;}else{GPIOF->BSRRH=GPIO_Pin_11;}}//WR-PF11
void SetRD(u8 temp)		{if(temp){GPIOB->BSRRL=GPIO_Pin_2; }else{GPIOB->BSRRH=GPIO_Pin_2; }}//RD-PB2
void SetReset(u8 temp)	{if(temp){GPIOF->BSRRL=GPIO_Pin_15;}else{GPIOF->BSRRH=GPIO_Pin_15;}}//RST-PF15
void SetBackLed(u8 temp)	{if(temp){GPIOD->BSRRL=GPIO_Pin_15;}else{GPIOD->BSRRH=GPIO_Pin_15;}}//LED-PD15
//#####################################
void LCD_Write_Bus(u8 VH,u8 VL)
{
	SetWR(0);
    GPIOG->BSRRL=VH;
	GPIOG->BSRRH=(~VH)&0x00FF;
	//SetWR(0);
	//Delayns(1);
	_LCD_WR_DELAY();
	SetWR(1);

	SetWR(0);
    GPIOG->BSRRL=VL;
	GPIOG->BSRRH=(~VL)&0x00FF;
	//SetWR(0);
	//Delayns(1);
	_LCD_WR_DELAY();
	SetWR(1);
}

void LCD_Write_Com(u8 VH,u8 VL)
{
    SetRS(0);
    LCD_Write_Bus(VH,VL);
}

void LCD_Write_Data(u8 VH,u8 VL)
{
    SetRS(1);
    LCD_Write_Bus(VH,VL);
}
void LCD_Write_Bus8Bit(u8 V)//9341
{
	SetWR(0);
  GPIOG->BSRRL=V;
	GPIOG->BSRRH=(~V)&0x00FF;
	//SetWR(0);
	//Delayns(1);
	_LCD_WR_DELAY();
	SetWR(1);
}
void LCD_Write_Com8Bit(u8 V)//9341
{
	SetRS(0);
	LCD_Write_Bus8Bit(V);
}
void LCD_Write_Data8Bit(u8 V)//9341
{
	SetRS(1);
	LCD_Write_Bus8Bit(V);
}
void LCD_Write_Com16Bit(u16 V)//9341
{
	SetRS(0);
	LCD_Write_Bus8Bit(V>>8);
	LCD_Write_Bus8Bit(V&0xff);
}
void LCD_Write_Data16Bit(u16 V)//9341
{
	SetRS(1);
	LCD_Write_Bus8Bit(V>>8);
	LCD_Write_Bus8Bit(V&0xff);
}
void  LCD_WR_REG(u16 Command,u16 Data)
{
    //LCD_Write_Com(Command>>8,Command);
    //LCD_Write_Data(Data>>8,Data);
	switch(gLcdVersion)
	{
		case 1:	case 2:
			LCD_Write_Com8Bit(Command>>8);LCD_Write_Com8Bit(Command);
			LCD_Write_Data8Bit(Data>>8);LCD_Write_Data8Bit(Data);
		break;
		default:
			LCD_Write_Com(Command>>8,Command);
			LCD_Write_Data(Data>>8,Data);
		break;
	}
}
void LCD_Data_DDROutput(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
  	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  	GPIO_InitStructure.GPIO_Pin = 0x0ff; //初始化PG0~7-data8-data15
  	GPIO_Init(GPIOG, &GPIO_InitStructure);
}
void LCD_Data_DDRInput(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  	GPIO_InitStructure.GPIO_Pin = 0x0ff; //初始化PG0~7-data8-data15
  	GPIO_Init(GPIOG, &GPIO_InitStructure);
}
u16 LCD_Read_Bus16Bit(void)
{
	u16 data=0;
	u16 datah,datal;
	SetRD(0);
	_LCD_WR_DELAY();
	SetRD(1);
	datah=GPIOG->IDR&0x0FF;
	SetRD(0);
	_LCD_WR_DELAY();
	SetRD(1);
	datal=GPIOG->IDR&0x0FF;
	data=(datah<<8)|datal;
	return data;
}
u16 LCD_Read_ID(void)
{
	u16 m_id=0;
	LCD_Write_Com(0x0,0x0);
	LCD_Data_DDRInput();
	SetWR(1);
	SetRS(1);
	SetCS(0);
	m_id=LCD_Read_Bus16Bit();
	SetCS(1);
	LCD_Data_DDROutput();

	return m_id;
}
void LCD_Init(void)
{
SetReset(1);
Delay(50);
SetReset(0);
Delay(50);
SetReset(1);
SetCS(1);
SetRD(1);
SetWR(1);
Delay(50);

SetCS(0);
if(gLcdVersion==0)
{
//************* Start Initial Sequence **********// 
LCD_Write_Com(0x00,0xE5); LCD_Write_Data(0x78,0xF0); // set SRAM internal timing
LCD_Write_Com(0x00,0x01); LCD_Write_Data(0x00,0x00);  // set SS and SM bit
LCD_Write_Com(0x00,0x02); LCD_Write_Data(0x07,0x00);  // set 1 line inversion
LCD_Write_Com(0x00,0x03); LCD_Write_Data(0x10,0x38);  // set GRAM write direction and BGR=1.
LCD_Write_Com(0x00,0x04); LCD_Write_Data(0x00,0x00);  // Resize register
LCD_Write_Com(0x00,0x08); LCD_Write_Data(0x02,0x02);     // set the back porch and front porch
LCD_Write_Com(0x00,0x09); LCD_Write_Data(0x00,0x00);  // set non-display area refresh cycle ISC[3:0]
LCD_Write_Com(0x00,0x0A); LCD_Write_Data(0x00,0x00);  // FMARK function
LCD_Write_Com(0x00,0x0C); LCD_Write_Data(0x00,0x00); // RGB interface setting
LCD_Write_Com(0x00,0x0D); LCD_Write_Data(0x00,0x00);  // Frame marker Position
LCD_Write_Com(0x00,0x0F); LCD_Write_Data(0x00,0x00); // RGB interface polarity
//*************Power On sequence ****************// 
LCD_Write_Com(0x00,0x10); LCD_Write_Data(0x00,0x00); // SAP, BT[3:0], AP, DSTB, SLP, STB
LCD_Write_Com(0x00,0x11); LCD_Write_Data(0x00,0x07); // DC1[2:0], DC0[2:0], VC[2:0]
LCD_Write_Com(0x00,0x12); LCD_Write_Data(0x00,0x00); // VREG1OUT voltage
LCD_Write_Com(0x00,0x13); LCD_Write_Data(0x00,0x00); // VDV[4:0] for VCOM amplitude
LCD_Write_Com(0x00,0x07); LCD_Write_Data(0x00,0x01);
Delay(200); // Dis-charge capacitor power voltage
LCD_Write_Com(0x00,0x10); LCD_Write_Data(0x16,0x90); // SAP, BT[3:0], AP, DSTB, SLP, STB
LCD_Write_Com(0x00,0x11); LCD_Write_Data(0x02,0x27); // Set DC1[2:0], DC0[2:0], VC[2:0]
Delay(50);   // Delay 50ms
LCD_Write_Com(0x00,0x12); LCD_Write_Data(0x00,0x8A); // External reference voltage= Vci;
Delay(50);   // Delay 50ms
LCD_Write_Com(0x00,0x13); LCD_Write_Data(0x1A,0x00); // VDV[4:0] for VCOM amplitude
LCD_Write_Com(0x00,0x29); LCD_Write_Data(0x00,0x0E); // VCM[5:0] for VCOMH
LCD_Write_Com(0x00,0x2B); LCD_Write_Data(0x00,0x0B); // Set Frame Rate
Delay(50); // Delay 50ms 
LCD_Write_Com(0x00,0x20); LCD_Write_Data(0x00,0x00); // GRAM horizontal Address
LCD_Write_Com(0x00,0x21); LCD_Write_Data(0x00,0x00); // GRAM Vertical Address
 // ----------- Adjust the Gamma   Curve ----------//
LCD_Write_Com(0x00,0x30); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x31); LCD_Write_Data(0x06,0x04);
LCD_Write_Com(0x00,0x32); LCD_Write_Data(0x03,0x05);
LCD_Write_Com(0x00,0x35); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x36); LCD_Write_Data(0x0C,0x09);
LCD_Write_Com(0x00,0x37); LCD_Write_Data(0x02,0x04);
LCD_Write_Com(0x00,0x38); LCD_Write_Data(0x03,0x01);
LCD_Write_Com(0x00,0x39); LCD_Write_Data(0x07,0x07);
LCD_Write_Com(0x00,0x3C); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x3D); LCD_Write_Data(0x0A,0x0A);
 //------------------ Set GRAM area ---------------//
LCD_Write_Com(0x00,0x50); LCD_Write_Data(0x00,0x00);  // Horizontal GRAM Start Address
LCD_Write_Com(0x00,0x51); LCD_Write_Data(0x00,0xEF);  // Horizontal GRAM End Address
LCD_Write_Com(0x00,0x52); LCD_Write_Data(0x00,0x00);  // Vertical GRAM Start Address
LCD_Write_Com(0x00,0x53); LCD_Write_Data(0x01,0x3F);  // Vertical GRAM Start Address
LCD_Write_Com(0x00,0x60); LCD_Write_Data(0xA7,0x00);  // Gate Scan Line
LCD_Write_Com(0x00,0x61); LCD_Write_Data(0x00,0x01);  // NDL,VLE, REV
LCD_Write_Com(0x00,0x6A); LCD_Write_Data(0x00,0x00);  // set scrolling line
 //-------------- Partial Display Control ---------//
LCD_Write_Com(0x00,0x80); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x81); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x82); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x83); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x84); LCD_Write_Data(0x00,0x00);
LCD_Write_Com(0x00,0x85); LCD_Write_Data(0x00,0x00);
 //-------------- Panel Control -------------------//
LCD_Write_Com(0x00,0x90); LCD_Write_Data(0x00,0x10);
LCD_Write_Com(0x00,0x92); LCD_Write_Data(0x06,0x00);
LCD_Write_Com(0x00,0x07); LCD_Write_Data(0x01,0x33);  // 262K color and display ON
}
else if(gLcdVersion==2)//9341
{
	//************* Start Initial Sequence **********
	LCD_Write_Com8Bit  (0xCF);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0xC1);
	LCD_Write_Data8Bit (0X30);

	LCD_Write_Com8Bit  (0xED);
	LCD_Write_Data8Bit (0x64);
	LCD_Write_Data8Bit (0x03);
	LCD_Write_Data8Bit (0X12);
	LCD_Write_Data8Bit (0X81);

	LCD_Write_Com8Bit  (0xE8);
	LCD_Write_Data8Bit (0x85);
	LCD_Write_Data8Bit (0x10);
	LCD_Write_Data8Bit (0x7A);

	LCD_Write_Com8Bit  (0xCB);
	LCD_Write_Data8Bit (0x39);
	LCD_Write_Data8Bit (0x2C);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x34);
	LCD_Write_Data8Bit (0x02);

	LCD_Write_Com8Bit  (0xF7);
	LCD_Write_Data8Bit (0x20);

	LCD_Write_Com8Bit  (0xEA);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0xC0);    //Power control
	LCD_Write_Data8Bit (0x21);   //VRH[5:0]

	LCD_Write_Com8Bit  (0xC1);    //Power control
	LCD_Write_Data8Bit (0x13);   //SAP[2:0];BT[3:0]

	LCD_Write_Com8Bit  (0xC5);    //VCM control
	LCD_Write_Data8Bit (0x32);
	LCD_Write_Data8Bit (0x3C);

	LCD_Write_Com8Bit  (0xC7);    //VCM control2
	LCD_Write_Data8Bit (0X98);
//0X36(MSB->LSB):MY  MX  MV  ML  BGR  MH  XX 00
//横屏,原点坐标在右上角 MY:MX:MV->001
	LCD_Write_Com8Bit  (0x36);    //显示方向  Memory Access Control
	//LCD_Write_Data8Bit (0x08);//竖屏 原点左上�?
	LCD_Write_Data8Bit (0x68);	//横屏 原点坐标在右上角

	LCD_Write_Com8Bit  (0x3A);
	LCD_Write_Data8Bit (0x55);//像素16Bit

	LCD_Write_Com8Bit  (0xB1);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x16);

	LCD_Write_Com8Bit  (0xB6);    // Display Function Control
	LCD_Write_Data8Bit (0x0A);
	LCD_Write_Data8Bit (0xA2);

	LCD_Write_Com8Bit  (0xF6);
	LCD_Write_Data8Bit (0x01);
	LCD_Write_Data8Bit (0x30);

	LCD_Write_Com8Bit  (0xF2);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0x26);    //Gamma curve selected
	LCD_Write_Data8Bit (0x01);

	LCD_Write_Com8Bit  (0xE0);    //Set Gamma
	LCD_Write_Data8Bit (0x0F);
	LCD_Write_Data8Bit (0x1E);
	LCD_Write_Data8Bit (0x1B);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x0E);
	LCD_Write_Data8Bit (0x08);
	LCD_Write_Data8Bit (0x47);
	LCD_Write_Data8Bit (0XB7);
	LCD_Write_Data8Bit (0x37);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x14);
	LCD_Write_Data8Bit (0x05);
	LCD_Write_Data8Bit (0x0C);
	LCD_Write_Data8Bit (0x07);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0XE1);    //Set Gamma
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x21);
	LCD_Write_Data8Bit (0x24);
	LCD_Write_Data8Bit (0x04);
	LCD_Write_Data8Bit (0x11);
	LCD_Write_Data8Bit (0x07);
	LCD_Write_Data8Bit (0x38);
	LCD_Write_Data8Bit (0x48);
	LCD_Write_Data8Bit (0x48);
	LCD_Write_Data8Bit (0x04);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x0A);
	LCD_Write_Data8Bit (0x33);
	LCD_Write_Data8Bit (0x38);
	LCD_Write_Data8Bit (0x0F);

	LCD_Write_Com8Bit  (0x11);    //Exit Sleep
	Delay(280);
	LCD_Write_Com8Bit  (0x29);    //Display on
}
else//st7789
{
	//--------------------------------ST7789S Frame rate setting----------------------------------//
	LCD_Write_Com8Bit(0xb2);
	LCD_Write_Data8Bit(0x0c);
	LCD_Write_Data8Bit(0x0c);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x33);
	LCD_Write_Data8Bit(0x33);

	LCD_Write_Com8Bit(0xb7);
	LCD_Write_Data8Bit(0x35);

	//横屏,原点坐标在右上角 MY:MX:MV->001
	LCD_Write_Com8Bit  (0x36);  //显示方向  Memory Access Control
	LCD_Write_Data8Bit (0x60);	//横屏 原点坐标在右上角

	LCD_Write_Com8Bit(0x3A);
	LCD_Write_Data8Bit(0x55);//65K RGB color 16BIT
	//---------------------------------ST7789S Power setting--------------------------------------//
	LCD_Write_Com8Bit(0xbb);
	LCD_Write_Data8Bit(0x30);//vcom

	LCD_Write_Com8Bit(0xc3);
	//LCD_Write_Data8Bit(0x1C);//17调深�?
	LCD_Write_Data8Bit(0x27);//17调深�?

	LCD_Write_Com8Bit(0xc4);
	LCD_Write_Data8Bit(0x18);

	LCD_Write_Com8Bit(0xc6);
	LCD_Write_Data8Bit(0x0f);

	LCD_Write_Com8Bit(0xd0);
	LCD_Write_Data8Bit(0xa4);
	LCD_Write_Data8Bit(0xa2);
	//--------------------------------ST7789S gamma setting---------------------------------------//
	LCD_Write_Com8Bit(0xe0);
	LCD_Write_Data8Bit(0xf0);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x0a);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x11);
	LCD_Write_Data8Bit(0x1a);
	LCD_Write_Data8Bit(0x3b);
	LCD_Write_Data8Bit(0x34);
	LCD_Write_Data8Bit(0x4e);
	LCD_Write_Data8Bit(0x3a);

	LCD_Write_Data8Bit(0x12);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x16);
	LCD_Write_Data8Bit(0x1b);

	LCD_Write_Com8Bit(0xe1);
	LCD_Write_Data8Bit(0xf0);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x0a);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x11);
	LCD_Write_Data8Bit(0x1a);
	LCD_Write_Data8Bit(0x3b);
	LCD_Write_Data8Bit(0x34);
	LCD_Write_Data8Bit(0x4e);
	LCD_Write_Data8Bit(0x3a);

	LCD_Write_Data8Bit(0x12);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x16);
	LCD_Write_Data8Bit(0x1b);//*/

	LCD_Write_Com8Bit(0x3a);
	LCD_Write_Data8Bit(0x55); //18 RGB ,55-16BIT RGB

	//************************
	LCD_Write_Com8Bit(0x11);
	Delay(280);      //Delay 120ms

	LCD_Write_Com8Bit(0x29); //display on
}
SetCS(1);//关闭片�?�使�?
}

void Address_set(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2) 
{ 
	if(gLcdVersion)//9341/st7789
	{
		LCD_Write_Com8Bit  (0x2A);
		LCD_Write_Data16Bit(x1);//�?始X
		LCD_Write_Data16Bit(x2);//结束X
		LCD_Write_Com8Bit  (0x2B);
		LCD_Write_Data16Bit(y1);//�?始Y
		LCD_Write_Data16Bit(y2);//结束Y
		LCD_Write_Com8Bit  (0x2C);
	}
	else//9325
	{
    LCD_Write_Com(0x00, 0x20); LCD_Write_Data(y1 >> 8, y1); //设置X坐标位置
    LCD_Write_Com(0x00, 0x21); LCD_Write_Data(x1 >> 8, x1); //设置Y坐标位置
    LCD_Write_Com(0x00, 0x50); LCD_Write_Data(y1 >> 8, y1); //�?始X
    LCD_Write_Com(0x00, 0x52); LCD_Write_Data(x1 >> 8, x1); //�?始Y
    LCD_Write_Com(0x00, 0x51); LCD_Write_Data(y2 >> 8, y2); //结束X
    LCD_Write_Com(0x00, 0x53); LCD_Write_Data(x2 >> 8, x2); //结束Y
    LCD_Write_Com(0x00, 0x22);
	}
} 

//设置光标位置
//Xpos:横坐�?
//Ypos:纵坐�?
void LCD_SetCursor(u16 Xpos, u16 Ypos)
{
	LCD_WR_REG(0x020,Xpos);
	LCD_WR_REG(0x021,Xpos);
	LCD_Write_Com(0x0, 0x22);
}
void LCD_Pant(u16 color) 
{ 
    int i, j; 
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
    SetCS(0); 
    Address_set(0,0,LCD_Width-1,LCD_Heigh-1);
    for(i = 0; i < LCD_Heigh; i++)
    { 
        for (j = 0; j < LCD_Width; j++)
        { 
            LCD_Write_Data(color>>8, color); 
        } 
    } 
    SetCS(1);
	os_task_exit_critical();//开启任务调度
} 

void LCD_DrawPoint(u16 x,u16 y,u16 color)
{
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
	if(x>=LCD_Width||y>=LCD_Heigh)return;
	SetCS(0); 
  Address_set(x,y,x,y);
  LCD_Write_Data(color>>8, color); 
  SetCS(1); 
  os_task_exit_critical();//开启任务调度
}
#if LCD_FONT_EN==1
void LCD_charcter(u16 x,u16 y,u8 ch,u16 ch_color,u16 bg_color,u8 transparent)//transparent�?1，�?�明
{
	const u8 *c;
  	u16 i,j;
	u8 var0;
  	u16 index=0;
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
	u32 offest=(ch-32)*((Lcdfont->Height*Lcdfont->Width)>>3);
	c=&Lcdfont->table[offest]; 
  	if(transparent !=1)
	{
		Address_set(x,y,x+Lcdfont->Width-1,y+Lcdfont->Height-1);//加快显示速度
	}
  	for(index=0;index<Lcdfont->Height;index++)
  	{
    	for(i=0;i<Lcdfont->Width;i++)
    	{  			
			//var0=c[]
			if(transparent !=1)
			{
				if(var0&(0x1<<j))LCD_Write_Data(ch_color>>8, ch_color);
				else LCD_Write_Data(bg_color>>8, bg_color);
			}
			else
			{
				if(var0&(0x1<<j))	{LCD_DrawPoint(x+j,y+i, ch_color);}
			}
    	}
  	}
	os_task_exit_critical();//开启任务调度
}
#endif
void LCD_en(u16 x,u16 y,u8 ch,u16 ch_color,u16 bg_color,u8 transparent)//transparent�?1，�?�明
{
 	u8 i,j,var0;
	u8* pic;
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
	ch-=32;
	pic=(u8*)CHARLIB[ch];
	SetCS(0); 
	if(transparent !=1)
	{
		Address_set(x,y,x+7,y+15);//加快显示速度
	}
	for(i=0;i<16;i++)
	{
      var0=*(pic+i);
	  for(j=0;j<8;j++)
	  {
		if(transparent !=1)
		{
			if((var0&(0x1<<j))!=0)LCD_Write_Data(ch_color>>8, ch_color);
			else LCD_Write_Data(bg_color>>8, bg_color);
		}
		else
		{
			if((var0&(0x1<<j))!=0)	{LCD_DrawPoint(x+j,y+i, ch_color);}
			//else
			//{
			//	if(transparent !=1)	{LCD_DrawPoint(x+j,y+i, bg_color);}//transparent�?1，�?�明
			//}
		}
	  }
	}
	SetCS(1); 
	os_task_exit_critical();//开启任务调度
}
//*******************************************************************************
// Function Name  : LCD_String
// Description    : 字符串显示函�?
// Input          : x,y:数字起始坐标;
//					*pch:显示的中文字符，例如"�?"
//					ch_color:字体颜色
//					bg_color:背景颜色
//                  transparent:1透明,0不�?�明
// Output         : None
// Return         : None
// Author		  : CZQ 2014/07/29
//*******************************************************************************
void LCD_String(u16 x,u16 y,u8* ch,u16 ch_color,u16 bg_color,u8 transparent)
{
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
    while((*ch)!='\0')
    {
	#if _LCD_CN_EN_==1
	 #ifdef _LCD_CHINESE_EN_
       #ifdef  _LCD_CHINESE_EN_EXISTS_
		if(*ch<0x80)//ascii�?
	   #endif
	 #endif
	#endif//#if _LCD_CN_EN_==1
		{
    	  LCD_en(x,y,*ch,ch_color,bg_color,transparent);
	      ch++;
	      x+=8;
		}
	#if _LCD_CN_EN_==1
	 #ifdef _LCD_CHINESE_EN_
       #ifdef  _LCD_CHINESE_EN_EXISTS_
		else
		{
			LCD_Chinese(x,y,(u8*)ch,ch_color,bg_color,transparent);
			x+=CnLib_Msg[0];
			ch+=2;
		}
	   #endif
	 #endif
	#endif//#if _LCD_CN_EN_==1
    }
	os_task_exit_critical();//开启任务调度
}

void LCD_DrawRectangle(u16 x1,u16 y1,u16 x2,u16 y2,u16 color)
{
int i, j; 
os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源

SetCS(0); 
	if(x1>=LCD_Width)x1=LCD_Width-1;	if(y1>=LCD_Heigh)y1=LCD_Heigh-1;
	if(x2>=LCD_Width)x2=LCD_Width-1;	if(y2>=LCD_Heigh)y2=LCD_Heigh-1;
Address_set(x1,y1,x2,y2); 
for(i = x1; i <= x2; i++) 
{ 
for (j =y1; j <= y2; j++) 
{ 
LCD_Write_Data(color>>8, color); 
} 
}
SetCS(1); 
os_task_exit_critical();//开启任务调度

}


void LCD_3g(u16 x,u16 y,s32 num,u16 ch_color,u16 bg_color)
{
	u8 temp[3],i=0;
	if(num<0)//20140220
	{
		num	=-num;
		LCD_en(x,y,'-',ch_color,bg_color,0);
	}
	else
	{
		LCD_en(x,y,' ',ch_color,bg_color,0);
	}
   for(i=0;i<3;i++)
   	{
		temp[i]=num%10+48;
		num/=10;
	}
   	if(temp[2]==48)	LCD_en(x+8,y,' ',ch_color,bg_color,0); 
	else LCD_en(x+8,y,temp[2],ch_color,bg_color,0);
	if((temp[1]==48)&&(temp[2]==48))	LCD_en((x+16),y,' ',ch_color,bg_color,0); 
	else LCD_en((x+16),y,temp[1],ch_color,bg_color,0);
	LCD_en((x+24),y,temp[0],ch_color,bg_color,0);
}
//2147483647
//4294967296
void LCD_5g(u16 x,u16 y,s32 num,u16 ch_color,u16 bg_color)
{
 	u8 temp[6],i=0,flag=0;
	u8 NumSign=0;	//0就是正，1就是�?
	if(num<0)
	{
	num	=-num;
	NumSign	=	1;
	}

   	for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
	
	temp[5]=' ';
	for(i=5;i>0;i--)
	{
		if((temp[i-1]!=48)&&(flag==0))
		{
		if(NumSign==1)temp[i]='-';
		flag=1;
		}
		else if((flag==0)&&(i>1))
		{
		temp[i-1]=' ';
		}
		else if(temp[0]==48)
		{
		temp[0]='0';
		}
	}
	
	LCD_en(x,y,temp[5],ch_color,bg_color, 0);
	LCD_en((x+8),y,temp[4],ch_color,bg_color, 0);
	LCD_en((x+16),y,temp[3],ch_color,bg_color, 0);
	LCD_en((x+24),y,temp[2],ch_color,bg_color, 0);
	LCD_en((x+32),y,temp[1],ch_color,bg_color, 0);
	LCD_en((x+40),y,temp[0],ch_color,bg_color, 0);
}

void LCD_8g(u16 x,u16 y,s32 num,u16 ch_color,u16 bg_color)
{
	u8 temp[9],i=0,flag=0;
	u8 NumSign=0;	//0就是正，1就是�?
	if(num<0)
	{
	num	=-num;
	NumSign	=	1;
	}
   	for(i=0;i<8;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
	
	temp[8]=' ';
	for(i=8;i>0;i--)
	{
		if((temp[i-1]!=48)&&(flag==0))
		{
		if(NumSign==1)temp[i]='-';
		flag=1;
		}
		else if((flag==0)&&(i>1))
		{
		temp[i-1]=' ';
		}
		else if(temp[0]==48)
		{
		temp[0]='0';
		}
	}

	LCD_en(x,y,temp[8],ch_color,bg_color, 0);
   	LCD_en(x+8,y,temp[7],ch_color,bg_color, 0);
	LCD_en((x+16),y,temp[6],ch_color,bg_color, 0);
	LCD_en((x+24),y,temp[5],ch_color,bg_color, 0);
	LCD_en((x+32),y,temp[4],ch_color,bg_color, 0);
	LCD_en((x+40),y,temp[3],ch_color,bg_color, 0);
	LCD_en((x+48),y,temp[2],ch_color,bg_color, 0);
	LCD_en((x+56),y,temp[1],ch_color,bg_color, 0);
	LCD_en((x+64),y,temp[0],ch_color,bg_color, 0);
	
}

void LCD_3bit(u16 x,u16 y,u16 num,u16 ch_color,u16 bg_color)
{
 u8 temp[3],i=0;

   for(i=0;i<4;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}


  for(i=2;i>0;i--)
   	{
   	if(temp[i]==48)temp[i]=32;//32鏄┖鏍�?
   	else
   	{break;}
   	}


   	LCD_en(x,y,temp[2],ch_color,bg_color,0);
	LCD_en((x+8),y,temp[1],ch_color,bg_color,0);
	LCD_en((x+16),y,temp[0],ch_color,bg_color,0);
}

void LCD_4bit(u16 x,u16 y,u16 num,u16 ch_color,u16 bg_color)
{
 u8 temp[4],i=0;
 u8 transparent=0;
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}


  for(i=3;i>0;i--)
   	{
   	if(temp[i]==48)temp[i]=32;//32鏄┖鏍�?
   	else
   	{break;}
   	}

	  
   	LCD_en(x,y,temp[3],ch_color,bg_color,transparent);
	LCD_en((x+8),y,temp[2],ch_color,bg_color,transparent);
	LCD_en((x+16),y,temp[1],ch_color,bg_color,transparent);
	LCD_en((x+24),y,temp[0],ch_color,bg_color,transparent);
}

void LCD_5bit(u16 x,u16 y,u16 num,u16 ch_color,u16 bg_color)
{
 u8 temp[5],i=0;
 
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   	LCD_en(x,y,temp[4],ch_color,bg_color,0);
	LCD_en((x+8),y,temp[3],ch_color,bg_color,0);
	LCD_en((x+16),y,temp[2],ch_color,bg_color,0);
	LCD_en((x+24),y,temp[1],ch_color,bg_color,0);
	LCD_en((x+32),y,temp[0],ch_color,bg_color,0);
}

void LCD_float8g2(u16 x,u16 y,double num,u16 ch_color,u16 bg_color)//20140220
{
 	u8 temp[9],d_temp[2],i=0,j=0,flag=0,dflag=0;
	u32 i_num,d_num;
	u8 NumSign=0;	//0就是正，1就是�?
	
	if(num<0)
	{
		num	=-num;
		NumSign	= 1;
	}
	i_num=(u32)num;
	d_num=(u32)(num*1000-i_num*1000)/10;
   	for(i=0,j=0;i<8;i++)
   	{
		temp[i]=i_num%10+48;
		i_num/=10;
		if(j<2)
		{
			d_temp[j]=d_num%10+48;
			d_num/=10;
			j++;
		}
	}
	temp[8]=' ';
	for(i=8,j=0;i>0;i--)
	{
		if((temp[i-1]!=48)&&(flag==0))
		{
			if(NumSign==1)temp[i]='-';
			flag=1;
		}
		else if((flag==0)&&(i>1)){temp[i-1]=' ';}
		else if(temp[0]==48)
		{
			temp[0]='0';
			if((flag==0)&&(NumSign==1)){temp[1]='-';}
		}
		if((j<1)&&(dflag==0))
		{
			if(d_temp[j]=='0')	{d_temp[j]=' ';}
			else	{dflag=1;}
			j++;
		}
	}
	LCD_en((x   ),y,temp[8],ch_color,bg_color,0);
   	LCD_en((x+8 ),y,temp[7],ch_color,bg_color,0);
	LCD_en((x+16),y,temp[6],ch_color,bg_color,0);
	LCD_en((x+24),y,temp[5],ch_color,bg_color,0);
	LCD_en((x+32),y,temp[4],ch_color,bg_color,0);
	LCD_en((x+40),y,temp[3],ch_color,bg_color,0);
	LCD_en((x+48),y,temp[2],ch_color,bg_color,0);
	LCD_en((x+56),y,temp[1],ch_color,bg_color,0);
	LCD_en((x+64),y,temp[0],ch_color,bg_color,0);
	LCD_en((x+72),y,'.',    ch_color,bg_color,0);
	LCD_en((x+80),y,d_temp[1],ch_color,bg_color,0);
	LCD_en((x+88),y,d_temp[0],ch_color,bg_color,0);
}

u8 g_RollLine=0;
u8 g_RollRow=0;//g_RollLine是行，g_RollRow是列
u8 g_FlashState=0;

void LCD_LineBreak(void)
{
	//琛�
	g_RollLine++;
	if(g_RollLine>10)
	{
	g_RollLine=0;
	g_FlashState=1;
	}
	//鍒�
	g_RollRow=0;
}


void LCD_RollString(u8* ch,u16 ch_color,u16 bg_color,u8 linebreak,u8 transparent)
{
    u16 x=0;
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源
	  if(g_FlashState==1){LCD_Pant(bg_color);g_FlashState=0;}
    while((*ch)!='\0')
    	{
    	  LCD_en(g_RollRow,g_RollLine*16+1,*ch,ch_color,bg_color,transparent);
	      ch++;
	      g_RollRow+=8;
    	}
	if(linebreak==1)
		{
		LCD_LineBreak();
		}
	os_task_exit_critical();//开启任务调度

}

void LCD_Roll5bit(u16 num,u16 ch_color,u16 bg_color,u8 linebreak,u8 transparent)
{
 u8 temp[5],i=0;
   if(g_FlashState==1){LCD_Pant(bg_color);g_FlashState=0;}
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   for(i=0;i<5;i++)
   	{
   	LCD_en(g_RollRow,g_RollLine*16+1,temp[4-i],ch_color,bg_color,transparent);
	g_RollRow+=8;
   	}
   if(linebreak==1)
   	{
   	LCD_LineBreak();
   	}
}

void LCD_cn(u16 x,u16 y,u8* pic,u16 ch_color,u16 bg_color,u8 transparent)
{
 	u16 i,j,var0,k,z=0;

	SetCS(0); 
	for(i=0;i<32;i++)
	{
	k=i;
      	var0=*(pic+i);
	if(i>=16){z=8;k-=16;}
	for(j=0;j<8;j++)
	 	{
		if((var0&(0x1<<j))!=0){LCD_DrawPoint(x+j+z,y+k, ch_color);}
		else{if(transparent !=1){LCD_DrawPoint(x+j+z,y+k, bg_color);}}
		}
	}
	SetCS(1); 
}

//*******************************************************************************
// Function Name  : LCD_Chinese
// Description    : 中文字符显示函数
// Input          : x,y:数字起始坐标;
//					*pch:显示的中文字符，例如"�?"
//					fColor:字体颜色
//					bColor:背景颜色
//                  transparent:1透明,0不�?�明
// Output         : None
// Return         : None
// Author		  : CZQ 2015/02/06
// 修正透明显示不正常问�?
//*******************************************************************************
#if _LCD_CN_EN_==1
 #ifdef _LCD_CHINESE_EN_
  #ifdef  _LCD_CHINESE_EN_EXISTS_
u8 LCD_Chinese(u16 x, u16 y,u8* pch,u16 fColor,u16 bColor,u8 transparent)
{
	u16 i,j,k,n,xi,yi;
	u16 m;
	s8 *pcn;
	u16 nmax;
	u16 listmax;
	u16 fx,fy;
	os_task_enter_critical();//临界区处理,禁止任务调度破坏共享资源

	fx=CnLib_Msg[0];//字宽 8的整数�??
	fy=CnLib_Msg[1];//字高 16
	nmax=CnLib_Msg[2];//字体宽字节数  2
	listmax=CnLib_Msg[3];//列表个数 32

	for(i=0;i<listmax;i++)//扫描字库列表
	{
		if((CnLib_List[i][0]==(s8)pch[0])&&(CnLib_List[i][1]==(s8)pch[1]))
		{
			pcn=(s8*)Cnlib[i];//指向对应数组地址
			break;
		}
	}
	if(i==listmax)return 0;//不在列表里面则不显示

	SetCS(0); //打开片�?�使�?
	if(transparent!=1)	{Address_set(x,y,(x+fx-1),(y+fy-1));}
    for(i=0;i<fy;i++) //y 16
	{
		for(n=0;n<nmax;n++)//y 2
		{
			if(transparent==1)
			{
				xi=(n<<3)+x;
				yi=y+i;
			}
			m=*(pcn+n+i*nmax);
			for(j=0;j<8;j++) //x
	  		{
				if(transparent !=1)
				{
					if((m&(0x1<<j))!=0)LCD_Write_Data(fColor>>8, fColor);
					else LCD_Write_Data(bColor>>8, bColor);
				}
				else//透明
				{
					if((m&(0x1<<j))!=0)	{LCD_DrawPoint(xi+j,yi, fColor);}
				}
	  		}
		}
	}
	SetCS(1); //打开片�?�使�?
	os_task_exit_critical();//开启任务调度
	return 1;
}
  #endif
 #endif
#endif

#ifdef __cplusplus
}
#endif//__cplusplus

#endif
