//***************************(C) COPYRIGHT 2014 CZQ******************************
//*******************************************************************************
//        Joinmax Digital Module library 0.0
//*******************************************************************************
// File Name   	: JMDKernel.h
// Version		: V0.0
// Compiler		: GCCARM
// Target		: X3RCU (STM32F407ZET6)
// Author		: CZQ
// Date			: 2014/08/17
// Description  :
//*******************************************************************************
//
//*******************************************************************************
#ifndef _JMDKERNEL_H_
#define _JMDKERNEL_H_

#ifdef __cplusplus
 extern "C" {
#endif

#include <stdio.h>
#include <math.h>
#include "stm32f4xx_conf.h"
#include "stm32f4xx.h"
#include "LCD_COLOR.h"
typedef char* string;
#ifdef  APP_GLOBALS
	#define  _APP_EXT
#else
	#define  _APP_EXT  extern
#endif

#ifndef  _PinFormat_H_
#define  _PinFormat_H_
const u32 portarray[8]={GPIOA,GPIOB,GPIOC,GPIOD,GPIOE,GPIOF,GPIOG};

struct select
{
	unsigned type:4;   //Ӳ
	unsigned group1:3; //һ
	unsigned bit1:4;   //һλ
	unsigned group2:3; //ڶ
	unsigned bit2:4;   //ڶλ
	unsigned group3:3; //
	unsigned bit3:4;   //λ
	unsigned group4:3; //
	unsigned bit4:4;   //λ
};
#endif

#define Servo1 2
#define Servo2 1
#define Servo3 0
#define Servo4 9

#define ON		1
#define OFF	0
//typedef---------------------------------------------------------
typedef struct
{
	u8 state;//״̬0ûм⵽,1⵽
	u16 x;	 //Xᴥ1~240,0ûдֵ
	u16 y;	 //Yᴥ1-320,0ûдֵ
	u8 sr;	 //ȡֵ״̬Ĵx,yظȡx/yֵʱ0ֻȡǰһֵʱ1/2
}SysThouch_Typedef;
typedef struct
{
	//ͨ
	u16 eep[8];
	u8  dir[8];		//﷽
	u8  power[8];	//﹦
	//
	u16 mceep[3];	
	s32 code[3];	//ֵ
	u8  mcdir[3];	//뷽
	u8  codedir[3];	//ֵ
	u8  mcpower[3];	//﹦
	u8  mode[3];	//ģʽ 2ŷģʽ
}SysMotor_Typedef;
typedef struct
{
	u8 buffer[1024];//ڽջ
	u16 lenght;//ڽռ
	u16 readbufcnt;//ָ

	u8 rxmode;//ģʽ:0ֻ,1ݰģʽ(ݰ)
	//ݰʽ:0x56+0xAB+sizeL+sizeH+id+D0+D1++sum
	//0x56,0xAB:ͷ
	//size:ݰܳ2Byte/1Byte
	//id:ID(1Byte)
	//(1Byte)sum=0x56^0xAB^sizeL^sizeH^id^D0^D1^
	u8 id;//ID
	u16 packetsize;//ݰ
	u8 packetflag;//յݰ־
	u16 sum;//
	u16 packetstart;//ݰʼָ(IDʼ)
	u8 packetnew;//0:ûнյݰ,1:ݰ,Уͨ,2ݰȶ
	u16 pacnketcnt;//ݰ
}SysCom_Typedef;//
_APP_EXT SysMotor_Typedef SysMotor;

vu8 g_Servo8to10Flag=0;
vu8 g_MotorCode2Motor=0;
vu8 g_MotorCode2MotorIC=0;
vu8 TTSC_Flag=0;
vu16 g_MotorPowerFlag=0;//﹦޸M1~M6:BIT0~BIT5
vu8 g_MSpeedPer[6]={100,100,100,100,100,100};
vu8 g_LcdBackLignt=1;//Ĭϱ
//*** include *******************************************************************
void X3RCU_Init(void);
void GPIO_Setting(GPIO_TypeDef* port,u8 pin,u8 mode,u8 OType,u8 PuPd);

void Button_PinInit(void);
void SysBeep_Init(void);
void System_Touch_ADC3_Init(void);

void SystemRTC_init(void);
void SetSystemTime(void);
u32 GetSystemTime(void);
void delayms(unsigned long ms);

u16 GetTouchXFilter(SysThouch_Typedef *Thouch);
u16 GetTouchYFilter(SysThouch_Typedef *Thouch);
u16 GetTouchState(SysThouch_Typedef *Thouch);

u16 GetAdcResult(u8 port,u8 pin);

u8 Motor_Init(u8 MotorX);//ͨ˿ڳʼ
u8 SetMotorPWMFreq(u32 freq);
void ReadSysMotorEeprom(u8 which,SysMotor_Typedef *mMotor);
void ReadSysMotorCodeEeprom(u8 which,SysMotor_Typedef *mMotor);
void SetMotorX(u8 MotorX,u8 Dir,u8 Speed);
void MotorCode_Init(u8 MotorX);
void SetMotorCntZero(u8 MotorX);
vs32 GetMotorCnt(u8 MotorX);
void SetMotorCodeMode(u8 MotorX,u8 mode);
void SetCodeServoAngle(u8 MotorX,u8 Dir,u8 speed,u32 Pulse);
void SetMotorY(u8 MotorX,u8 Dir,u8 Speed);

u8  ComServoInit(u8 ServoNo);
void ComServoAngle(u8 ServoX,u8 angle);

void SysADC_Init(void);
//ⲿeeprom
void I2CEep_SetIICSpeed(u16 speed);//ⲿeepromI2Cдٶ,Ĭ14(400K)
u8 I2CEep_Write(u16 addr,//0~256
		            u16 data);//0~65535 1ַӦ2Byte
u8 I2CEep_Read(u16 addr,//0~256
		           u16 *data);//0~65535 1ַӦ2Byte								
#ifdef __cplusplus
}
#endif//__cplusplus

#endif
