#include "HardwareInfo.c"
#include "JMLib.c"
#include <SetLCDBack.h>
#include <SetLCDString.h>
#include <SetRFPassWord.h>
#include <GetRFModuleRemoteGravity.h>
#include <SetLCD8Char.h>

int main(void)
{
    X3RCU_Init();
    unsigned int gx = 0;
    unsigned int gy = 0;
    unsigned int gz = 0;
    SetLCDBack(1);
    SetLCDString(0, 0, "Remote Gravity", YELLOW, BLACK);
    SetRFPassWord(_RFMODULE_1_, 1234567);
    SetLCDString(0, 16, "gx", YELLOW, BLACK);
    SetLCDString(0, 32, "gy", YELLOW, BLACK);
    SetLCDString(0, 48, "gz", YELLOW, BLACK);
    while (1)
    {
        gx = GetRFModuleRemoteGravity(_RFMODULE_1_, 1);
        SetLCD8Char(24, 16, gx, YELLOW, BLACK);
        gy = GetRFModuleRemoteGravity(_RFMODULE_1_, 2);
        SetLCD8Char(24, 32, gy, YELLOW, BLACK);
        gz = GetRFModuleRemoteGravity(_RFMODULE_1_, 3);
        SetLCD8Char(24, 48, gz, YELLOW, BLACK);
    }
    while(1);
}

