#ifndef _DHTSENSOR_
#define _DHTSENSOR_

 u32 WIRE_PORT;
 u8 WIRE_BIT;
 
 #define Set_WIRE_DDR 	GPIO_Setting((GPIO_TypeDef*)WIRE_PORT,WIRE_BIT,GPIO_Mode_Out_PP)
 #define Cls_WIRE_DDR 	GPIO_Setting((GPIO_TypeDef*)WIRE_PORT,WIRE_BIT,GPIO_Mode_IN_FLOATING)
 #define Set_WIRE     	GPIO_SetBits((GPIO_TypeDef*)WIRE_PORT,(1<<WIRE_BIT))
 #define Cls_WIRE     	GPIO_ResetBits((GPIO_TypeDef*)WIRE_PORT,(1<<WIRE_BIT))
 #define WIRE_PinStatus  GPIO_ReadInputDataBit((GPIO_TypeDef*)WIRE_PORT,(1<<WIRE_BIT))
 
#define _DTHSDELAYBASIC_		{asm("nop");asm("nop");asm("nop");asm("nop");asm("nop");}
void DTHS_Delayus(unsigned long nCount)
{
	unsigned int i;
	for (i=0;i<nCount;i++){_DTHSDELAYBASIC_;}
}
void DTHS_Delayms(unsigned long nCount)
{
	unsigned long i;
	unsigned int j;
	for (i=0;i<nCount;i++)
	{
		for (j=0;j<4500;j++)
		{_DTHSDELAYBASIC_;}
	}
}
void DTHS_Delay28us(void)
{
	DTHS_Delayus(165);//165-28.2us 175-30.2us
}
void DTHS_Delay40us(void)
{
	DTHS_Delayus(240);//240-40.2us
}
void DTHS_Delay18ms(void)
{
	DTHS_Delayms(20);//18-18ms
}
// read 8 bits onice
unsigned char DTHS_GetOneByte(void)
{
	unsigned char i,temp=0,data=0;
	for(i=0;i<8;i++)
	{
		while(!WIRE_PinStatus);// ʾȡĸߵλʱ20usȡ1,ȡ0
		DTHS_Delay28us(); //ͨ U8FLAG ж bit11 ʾݵ 0:26-28us
		if(WIRE_PinStatus)temp=0X01;
		else temp=0X00;
		while(WIRE_PinStatus);
		data<<=1;
		data|=temp;
	}
	return data;
}
//--------------------- ʪȶȡӳ ------------
//DHT11һͨѶʱ3ms鲻С100ms
//DTH111s
//8bitʪ+8bitʪС+8bi¶+8bit¶С
unsigned char GetDHT11Data(unsigned char i,unsigned int *pdat)
{
	unsigned char sum,s;
	unsigned char hum_int,hum_dec;
	unsigned char temp_int,temp_dec;
	
	Set_WIRE_DDR;
	Cls_WIRE;
	DTHS_Delay18ms();// 18ms
	Set_WIRE;
	DTHS_Delay40us();// ʱ 20us-40us
	Cls_WIRE_DDR;//ͷ Ϊ жϴӻӦź
	
	if(!WIRE_PinStatus)// жϴӻǷе͵ƽӦź 粻ӦӦ
	{
		while(!WIRE_PinStatus);//жϴӻǷ񷢳 80us ĵ͵ƽӦźǷ  
		while(WIRE_PinStatus);//жϴӻǷ񷢳 80us ĸߵƽ緢ݽ״̬
		
		hum_int=DTHS_GetOneByte();//ʪ
		hum_dec=DTHS_GetOneByte();//ʪС Ϊ0
		temp_int=DTHS_GetOneByte();//ʪ
		temp_dec=DTHS_GetOneByte();//ʪС Ϊ0
		sum=DTHS_GetOneByte();
		
		Set_WIRE_DDR;
		Set_WIRE;
		
		s=hum_int+hum_dec+temp_int+temp_dec;//У
		if(s==sum)
		{
			if(i)//ʪ
			{
				*pdat=hum_int;
			}
			else//¶
			{
				*pdat=temp_int;
			}
			return (1);
		}
		else *pdat=999;//
	}
	else *pdat=888;//
	return(0);
}

#endif