//***************************(C) COPYRIGHT 2019 LXW******************************
//*******************************************************************************
// File Name   	: jmdisr.h
// Version		  : V0.0
// Compiler		  : GCCARM
// Target		    : E6RCU (STM32F407VGXX)
// Author		    : LXW
// Date			    : 2019/3/20
// Description  : ϵͳжϺļжϺͬһ,ļ
//                ʹжϺstm32f4xx_it.c,жϺΪѾĺ,
//                ļ¶жϺΪʵΪպڵù,
//                ûָκκ(ָжϴ),úΪ,жϺ
//                ͳһɺSetSysISRHookFunָעжϺҪ!
//*******************************************************************************
// hook ⲻõжռԴ
//*******************************************************************************
#ifndef __JMDISR_H
#define __JMDISR_H
//** defined ********************************************************************
//Ԥ
#define __ISR_HOOK_EN		1//ʹжϺ
//
#ifndef NULL
#define NULL ((void *)0)
#endif

#define SET_FUN_HOOK(hook,inhook)	if(hook!=inhook)hook=inhook;
//funtion
//ѶжϺ,жϺͳһΪ:XX_ISR(),stm32fxxx_it.cжϺ
//ͬʱҪҽstm32fxxx_it.cжϺʵ
void USART1_ISR(void);
void USART2_ISR(void);
void USART3_ISR(void);
void EXTI9_5_ISR(void);
//void TIM3_ISR(void);
//void TIM5_ISR(void);
//void TIM4_ISR(void);
void TIM7_ISR(void);
void TIM9_ISR(void);

//includes
void MotorCoding_Istr(void);//
void UART1_RX_ISR(void);//WIFI
void BlueTH_RX_ISR(void);
void UART2_RX_ISR(void);//P8 
void PID_ISR(void);//ֱ
void JS_RXD_ISR(void);//
void RockerDelay_ISR(void);//ֱ
void JS_TIM_ISR(void);//ֱ
void InMusicDelay_ISR(void);//ֲ
void ComServo_ISR(void);//ŷ

void Motor1_MCPid_Isr(void);
void Motor2_MCPid_Isr(void);
void Motor3_MCPid_Isr(void);
void Motor4_MCPid_Isr(void);

void ReadIRISR(void);
void SendIRISR(void);

void MP3_RX_ISR(void);
//***жϺ************************************************************************
//ض,ɿŸû
#if __ISR_HOOK_EN > 0
//жϹ
//:sysͷ,isr_hookβsys_name_isr_hook,name= i2c/SPI/UART/EXTI...
//
void (*sys_usart2_isr_hook)();
void (*sys_usart1_isr_hook)();
void (*sys_usart3_isr_hook)();
//ⲿж
void (*sys_exti15_10_isr_hook)();
void (*sys_exti9_5_isr_hook)();
//ʱ
//void (*sys_timer3_isr_hook)();
//void (*sys_timer4_isr_hook)();
//void (*sys_timer5_isr_hook)();
void (*sys_timer7_isr_hook)();
void (*sys_timer1_up_isr_hook)();
void (*sys_timer9_isr_hook)();
void (*sys_timer10_isr_hook)();
void (*sys_timer12_isr_hook)();

//2ֱߣڱж
void (*sys_motor1pid_isr_hook)();
void (*sys_motor2pid_isr_hook)();
void (*sys_motor3pid_isr_hook)();
void (*sys_motor4pid_isr_hook)();

typedef enum//ԶжϹ
{
	__U3_IRQN=0,//
	__U2_IRQN=1,//P8

	__E9_5_IRQN=2,

	//__T3_IRQN=3,
	//__T4_IRQN=4,
	__T7_IRQN=5,
	__T9_IRQN=6,

	__T1_UP_IRQN=7,
	__E15_10_IRQN=8,
	
	//__U1_IRQN=9,//MP3
	__T10_IRQN=10,
	__T12_IRQN=12,


}ISRFUN_DEFINED;
//¼жϺҪSetSysISRHookFun
uint8_t SetSysISRHookFun(uint8_t n,void (*hook)(void))//жϹ,ע⣺һжϹ,ϵͳͲ
{
	uint8_t state=0;
	os_task_enter_critical();//ٽ,ֹƻԴ
	switch(n)
  {
		case __U2_IRQN:  		if(sys_usart2_isr_hook!=hook)sys_usart2_isr_hook=hook;							state = 1;	break;
		//case __U1_IRQN:  		if(sys_usart1_isr_hook!=hook)sys_usart1_isr_hook=hook;							state = 1;	break;
		case __U3_IRQN:  		if(sys_usart3_isr_hook!=hook)sys_usart3_isr_hook=hook;							state = 1;	break;

		case __E9_5_IRQN:   	if(sys_exti9_5_isr_hook!=hook)  sys_exti9_5_isr_hook=hook;					state = 1;	break;

	//	case __T3_IRQN:  		if(sys_timer3_isr_hook!=hook)   sys_timer3_isr_hook=hook;						state = 1;	break;
	//	case __T4_IRQN:  		if(sys_timer4_isr_hook!=hook)   sys_timer4_isr_hook=hook;						state = 1;	break;
		case __T7_IRQN:  		if(sys_timer7_isr_hook!=hook)   sys_timer7_isr_hook=hook;						state = 1;	break;
		case __T9_IRQN: 		if(sys_timer9_isr_hook!=hook)	sys_timer9_isr_hook=hook;						state = 1;	break;
		case __T10_IRQN: 		if(sys_timer10_isr_hook!=hook)	sys_timer10_isr_hook=hook;						state = 1;	break;
		case __T12_IRQN: 		if(sys_timer12_isr_hook!=hook)	sys_timer12_isr_hook=hook;						state = 1;	break;
		case __T1_UP_IRQN: 	if(sys_timer1_up_isr_hook!=hook)sys_timer1_up_isr_hook=hook;				state = 1;	break;
		case __E15_10_IRQN: if(sys_exti15_10_isr_hook!=hook)sys_exti15_10_isr_hook=hook;			  state = 1;	break;
  }
	os_task_exit_critical();//
	return state;
}
//ΪһõжϺ
void SysMotorCodeISRFunInit(void)//ʼжϺ
{
	SetSysISRHookFun(__E9_5_IRQN,MotorCoding_Istr);//EXTI9_5_ISR
}
void SysUSARTISRFunInit(uint8_t Usartx)//ʼжϺ
{
	switch(Usartx)
	{
		case __U2_IRQN:SetSysISRHookFun(__U2_IRQN,UART2_RX_ISR);break;//USART2_ISR
		//case __U1_IRQN:SetSysISRHookFun(__U1_IRQN,UART1_RX_ISR);break;//USART1_ISR
		case __U3_IRQN:SetSysISRHookFun(__U3_IRQN,BlueTH_RX_ISR);break;//BlueTH_RX_ISR
	}
}
void SysPIDISRFunInit(void)//ʼTIM3жϺ
{
	SetSysISRHookFun(__T12_IRQN,PID_ISR);//
	if(sys_motor1pid_isr_hook!=Motor1_MCPid_Isr)sys_motor1pid_isr_hook=Motor1_MCPid_Isr;
	if(sys_motor2pid_isr_hook!=Motor2_MCPid_Isr)sys_motor2pid_isr_hook=Motor2_MCPid_Isr;
	if(sys_motor3pid_isr_hook!=Motor3_MCPid_Isr)sys_motor3pid_isr_hook=Motor3_MCPid_Isr;
	if(sys_motor4pid_isr_hook!=Motor4_MCPid_Isr)sys_motor4pid_isr_hook=Motor4_MCPid_Isr;
}
/*
void SysJSISRFunInit(void)//ʼжϺ
{
	//SetSysISRHookFun(__T6_IRQN,JS_TIM_ISR);//
	SetSysISRHookFun(__U1_IRQN,JS_RXD_ISR);//ڽжϺ
}*/
void RockerISRFunInit(void)//ʼTIM9жϺ
{
	SetSysISRHookFun(__T9_IRQN,RockerDelay_ISR);//
}

void SysMusicISRFunInit(void)//ʼTIM7жϺ
{
	SetSysISRHookFun(__T7_IRQN,InMusicDelay_ISR);//
}

void SysComServoISRFunInit(void)//ʼTIM10жϺ
{
	SetSysISRHookFun(__T10_IRQN,ComServo_ISR);//
}

void SysSendIRCodeISRFunInit(void)//TIM1_UP ʼжϺ
{
	SetSysISRHookFun(__T1_UP_IRQN,SendIRISR);//
}
void SysReadIRCodeISRFunInit(void)//EXTI15_10ʼжϺ
{
	SetSysISRHookFun(__E15_10_IRQN,ReadIRISR);//
}
/*
void SysMP3ISRFunInit(void)//USART1 MP3ʼ
{
	SetSysISRHookFun(__U1_IRQN,MP3_RX_ISR);//
}*/
#endif//#if __ISR_HOOK_EN > 0
//***жϺ**END*******************************************************************
//***жϺ*****************************************************************************
//******************************************************************************
//*            STM32F2xx Peripherals Interrupt Handlers                        *
//******************************************************************************
void USART2_ISR(void)
{
	if(sys_usart2_isr_hook!=NULL)
	{sys_usart2_isr_hook();return ;}
}
/*
void USART1_ISR(void)
{
	if(sys_usart1_isr_hook!=NULL)
	{sys_usart1_isr_hook();return ;}
}*/
void USART3_ISR(void)
{
	if(sys_usart3_isr_hook!=NULL)
	{sys_usart3_isr_hook();return ;}
}
/*******************************************************************************
* Function Name  : EXTI9_5_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI9_5_ISR(void)
{
	if(sys_exti9_5_isr_hook!=NULL)
	{sys_exti9_5_isr_hook();return ;}
}
/*
void TIM3_ISR(void)
{
	if(sys_timer3_isr_hook!=NULL)
	{sys_timer3_isr_hook();return ;}
}

void TIM5_ISR(void)
{
	if(sys_timer5_isr_hook!=NULL)
	{sys_timer5_isr_hook();return ;}
}*/
void TIM7_ISR(void)
{
	if(sys_timer7_isr_hook!=NULL)
	{sys_timer7_isr_hook();return ;}
}

void TIM9_ISR(void)
{
	if(sys_timer9_isr_hook!=NULL)
	{sys_timer9_isr_hook();return ;}
}
void TIM10_ISR(void)
{
	if(sys_timer10_isr_hook!=NULL)
	{sys_timer10_isr_hook();return ;}
}

void TIM12_ISR(void)
{
	if(sys_timer12_isr_hook!=NULL)
	{sys_timer12_isr_hook();return ;}
}


void TIM1_UP_ISR(void)
{
	if(sys_timer1_up_isr_hook!=NULL)
	{sys_timer1_up_isr_hook();return ;}
}
/*******************************************************************************
* Function Name  : EXTI15_10_IRQHandler
* Description    : This function handles External lines 15 to 10 interrupt request.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTI15_10_ISR(void)
{
	if(sys_exti15_10_isr_hook!=NULL)
	{sys_exti15_10_isr_hook();return ;}
}
//***жϺ**END************************************************************************
#endif//__JMDISR_H
