#include "HardwareInfo.c"
#include "JMLib.c"
#include <SetLCDBack.h>
#include <SetDisplayString.h>
#include <SetRFPassWord.h>
#include <GetRFModuleRemoteRocker.h>
#include <SetDisplayVar.h>

int main(void)
{
    M6RCU_Init();
    int xL = 0;
    int yL = 0;
    int xR = 0;
    int yR = 0;
    SetLCDBack(ON);
    SetDisplayString(1, "P1", YELLOW, BLACK);
    SetDisplayString(2, "Remote Rocker", YELLOW, BLACK);
    SetRFPassWord(_P1_, 1234567);
    SetDisplayString(4, "Left  X:", YELLOW, BLACK);
    SetDisplayString(5, "Left  Y:", YELLOW, BLACK);
    SetDisplayString(7, "Right X:", YELLOW, BLACK);
    SetDisplayString(8, "Right Y:", YELLOW, BLACK);
    while (1)
    {
        xL = GetRFModuleRemoteRocker(_P1_, 0, 0);
        SetDisplayVar(4, xL, YELLOW, BLACK);
        yL = GetRFModuleRemoteRocker(_P1_, 0, 1);
        SetDisplayVar(5, yL, YELLOW, BLACK);
        xR = GetRFModuleRemoteRocker(_P1_, 1, 0);
        SetDisplayVar(7, xR, YELLOW, BLACK);
        yR = GetRFModuleRemoteRocker(_P1_, 1, 1);
        SetDisplayVar(8, yR, YELLOW, BLACK);
    }
    while(1);
}

