#ifndef _NRF24L01_H_
#define _NRF24L01_H_

#include "stm32f10x.h"

//ģغ궨
#define SET_SPI_NSS()        GPIO_SetBits(GPIOC, GPIO_Pin_5);
#define RESET_SPI_NSS()    GPIO_ResetBits(GPIOC, GPIO_Pin_5);
#define SET_RF_CE()             GPIO_SetBits(GPIOB, GPIO_Pin_0);
#define RESET_RF_CE()         GPIO_ResetBits(GPIOB, GPIO_Pin_0);

// SPI(nRF24L01) commands
#define READ_REG        0x00  // Define read command to register
#define WRITE_REG       0x20  // Define write command to register
#define RD_RX_PLOAD     0x61  // RXЧݣ1-32ֽڴС0ֽڿʼ
#define WR_TX_PLOAD     0xA0  // дTXЧݣ1-32ֽڴС0ֽڿʼд
#define FLUSH_TX        0xE1  // Define flush TX register commandշͻ
#define FLUSH_RX        0xE2  // Define flush RX register commandսջ
#define REUSE_TX_PL     0xE3  // Define reuse TX payload register commandظʹһݰ
//#define NOP             0xFF  // Define No Operation, might be used to read status register

// SPI(nRF24L01) registers(addresses)
#define CONFIG          0x00  // 'Config' register address
#define EN_AA           0x01  // 'Enable Auto Acknowledgment' register address
#define EN_RXADDR       0x02  // 'Enabled RX addresses' register address
#define SETUP_AW        0x03  // 'Setup address width' register address
#define SETUP_RETR      0x04  // 'Setup Auto. Retrans' register address
#define RF_CH           0x05  // 'RF channel' register address
#define RF_SETUP        0x06  // 'RF setup' register address
#define STATUS          0x07  // 'Status' register address
#define OBSERVE_TX      0x08  // 'Observe TX' register address,ͼĴ
#define CD              0x09  // 'Carrier Detect' register address
#define RX_ADDR_P0      0x0A  // 'RX address pipe0' register address
#define RX_ADDR_P1      0x0B  // 'RX address pipe1' register address
#define RX_ADDR_P2      0x0C  // 'RX address pipe2' register address
#define RX_ADDR_P3      0x0D  // 'RX address pipe3' register address
#define RX_ADDR_P4      0x0E  // 'RX address pipe4' register address
#define RX_ADDR_P5      0x0F  // 'RX address pipe5' register address
#define TX_ADDR         0x10  // 'TX address' register address
#define RX_PW_P0        0x11  // 'RX payload width, pipe0' register addressͨЧݿ
#define RX_PW_P1        0x12  // 'RX payload width, pipe1' register address
#define RX_PW_P2        0x13  // 'RX payload width, pipe2' register address
#define RX_PW_P3        0x14  // 'RX payload width, pipe3' register address
#define RX_PW_P4        0x15  // 'RX payload width, pipe4' register address
#define RX_PW_P5        0x16  // 'RX payload width, pipe5' register address
#define FIFO_STATUS     0x17  // 'FIFO Status Register' register address

#define MAX_RT  	0x10  // Max #of TX retrans interruptط趨
#define TX_DS   	0x20  // TX data sent interrupt
#define RX_DR   	0x40  // RX data received

#define TX_ADR_WIDTH    5   // 5 bytes TX(RX) address width
//#define TX_PLOAD_WIDTH  32  // 32bytes TX payload

#define TX_MODE    1
#define RX_MODE    0

#define Fail          0x40  //ʧܱ־
#define S_Success   0x80  //ͳɹ־
#define RF_Password   1234567  //ϵĬ
#define RF_Conect_OK  0xFF

#define PSWD_Addr    ((unsigned long)0x004000+32)
#define UID_Key_Addr         48  //UIDԿԵַ

#define Start_T2_Soft1()   do{T2_Soft1_Use_Flag=SET;T2_Soft1_Counter=0;}while(0)
#define Stop_T2_Soft1()   do{T2_Soft1_Use_Flag=RESET;T2_Soft1_Counter=0;}while(0)
#define Reset_T2_Soft1()   do{T2_Soft1_Counter=0;}while(0)

#define Start_T2_Soft2()   do{T2_Soft2_Use_Flag=SET;T2_Soft2_Counter=0;SetSystemTime();}while(0)
#define Stop_T2_Soft2()   do{T2_Soft2_Use_Flag=RESET;T2_Soft2_Counter=0;}while(0)
#define Reset_T2_Soft2()   do{T2_Soft2_Counter=0;}while(0)

#define Start_T2_Soft3()   do{T2_Soft3_Use_Flag=SET;T2_Soft3_Counter=0;}while(0)
#define Stop_T2_Soft3()   do{T2_Soft3_Use_Flag=RESET;T2_Soft3_Counter=0;}while(0)
#define Reset_T2_Soft3()   do{T2_Soft3_Counter=0;}while(0)

#define Set_LED_Flashing()  do{ Led_Flashing_Flag=SET;}while(0)
#define Stop_LED_Flashing()  do{Flash_time=0; Led_Flashing_Flag=RESET;}while(0)

//#define Set_LED_On()     do{cbi(S_LED_ODR,S_LED_Pin);cbi(S_LED2_ODR,S_LED2_Pin);}while(0)
//#define Set_LED_Off()    do{sbi(S_LED_ODR,S_LED_Pin);sbi(S_LED2_ODR,S_LED2_Pin);}while(0)


void SPI_RF_Configuration(void);
u8 SPI_RW(u8 data);
void nRF24L01_IRQ(void);
void delay_us(unsigned int number);
u8 RF_SendCMDTo_PC(u8 *data) ;
void Record_PSWD(u8* pswd);
void Set_RF_Buffer_Length(u8 length);
#endif
