//***************************(C) COPYRIGHT 2015 CZQ******************************
//*******************************************************************************
// File Name   	: print.h
// Version		  : V0.1
// Compiler		  : GCCARM
// Target		    : E3RCU (STM32F103VET6)
// Author		    : CZQ
// Date			    : 2015/10/28
// Description  : ӡغ,֧
//*******************************************************************************
// V0.0 printֵ֧ĴӡݸʽΪ:
//      %c ַ(ASCII)
//      %s ַ,֧
//      %f double
//      %d,%i зʮ
//      %u ޷ʮ
//      %o ޷Ű˽
//      %B 
//      %x %X ʮ
// V0.1 %#B,%#o,%#x,%#X,//ʮֱǰʾ0b/o/0x
//*******************************************************************************
#ifndef _JMDPRINT_H_
#define _JMDPRINT_H_

#ifndef NULL
#define NULL ((void *)0)
#endif

#include"jmkernel32.h"
//#include <stdio.h>
#include <stdarg.h>
#include"LCD_COLOR.h"
//#include <jmkernel32.h>
//#include"LCD320240.h"
#define __PRINT_FONT_CN_EN		1//1:ӡ֧,0ӡ֧
#define __PRINT_FLOAT_EN			1//1:ָ֧,0ָ֧
//ӡر
static unsigned int LcdBackColor=BLACK,//ʾɫ
                    LcdFontColor=WHITE,//ʾɫ
                    DispCursor_x=0,//X
                    DispCursor_y=0;//Y

//***õֿҺصĺ***************************************************
void SetFlashFontSize(u16 type);
u16 GetFontLibWidth(void);
u16 GetFontLibHeight(void);
void SetNumFontType(void);//ȡֿ
u32 GetLCDFontLib(void);
u16 GetLCDFontType(void);
//***õֿҺصı***********************************************
#define RINT_FONT_EN_TYPE		GetAsciiFontType()//ASIIַ

#define PRINT_FONT_WIDTH		GetFontLibWidth()//ַ
#define PRINT_FONT_HEIGHT	GetFontLibHeight()//ַ
#define RINT_FONT_TYPE			GetLCDFontType()//ǰַ

#define ClearPrintScreen()	 LCD_Pant(LcdBackColor)
#define DisplayPrintChar(c) LCD_en(DispCursor_x,DispCursor_y,c,LcdFontColor,LcdBackColor,0)//ASCII

#if __PRINT_FONT_CN_EN>0//
#define RINT_FONT_CN_TYPE 	 GetChineseFontType()//ֿ
#define DisplayPrintCn(c)   LCD_DisplayFont(DispCursor_x,DispCursor_y,c,LcdFontColor,LcdBackColor,0,RINT_FONT_CN_TYPE)
#endif//__PRINT_FONT_CN_EN

//ñɫ
void SetPrintfFontColor(unsigned int fontcolor,unsigned int backcolor){	LcdBackColor=backcolor,LcdFontColor=fontcolor;}
//ʾ
void SetPrintfCursor(unsigned int x,unsigned int y){DispCursor_x=x;DispCursor_y=y;}
void GetPrintfCurrentCursor(unsigned int *x,unsigned int *y){*x=DispCursor_x;*y=DispCursor_y;}
//ҹصԭʼλ
void PrintCleanScreen(void){SetPrintfCursor(0,0);ClearPrintScreen();}
void SetPrintfNextCursorY(void)//ùY
{
	DispCursor_y+=PRINT_FONT_HEIGHT;
	if(DispCursor_y>(LCD_Heigh-PRINT_FONT_HEIGHT))
	{
		DispCursor_y=0;//ͷʾ
		PrintCleanScreen();//
	}
	//DispCursor_x=0;
}
void SetPrintfNextCursorX(void)//ƶһλ
{
	DispCursor_x+=PRINT_FONT_WIDTH;
	if(DispCursor_x>(LCD_Width-(PRINT_FONT_WIDTH)))
	{
		SetPrintfNextCursorY();
		DispCursor_x=0;
	}
}
#define SetPrintfNextCursor() SetPrintfNextCursorX()//һ
#if __PRINT_FONT_CN_EN>0//֧
signed int fputcn(char *pStr)//ʾ
{
	int state=0;
	if(RINT_FONT_TYPE!=RINT_FONT_CN_TYPE)//Ӣ->ڱ߽⴦
	{
		if(DispCursor_x>(LCD_Width-(PRINT_FONT_WIDTH<<1)))
		{
			DispCursor_x=0;
			SetPrintfNextCursorY();
		}
	}
	//SetPrintFontSizeChinese();
	state= DisplayPrintCn(pStr);
	if(state!=0)//ʾɹ
	{
		SetPrintfNextCursor();//Ƶһλ
		return 1;
	}
	if(*(pStr+1)<0x80)
	{
		return 2;
	}
	return 0;//Ҫʾֲֿ
}
#endif//#if __PRINT_FONT_CN_EN>0//֧

char printchar(unsigned char c)//ʾַ
{
	//SetPrintFontSizeAscii();
	switch(c)
	{
		case '\r':SetPrintfNextCursorY();break;//ƶһ
		case '\n':DispCursor_x=0;        break;
		default:break;
	}
	//if(c<0x20||c>0x7e)return 2;//ASCIIʾ
	if(c<0x20||(c>0x7e&&c<0x80))return 2;//ASCIIʾ

	DisplayPrintChar(c);
	SetPrintfNextCursor();//Ƶһλ
	return 0;
}
void print(char* fmt, ...);
void printch(char ch);
void printdec(int dec,int numfirst);
void printunsigneddec(unsigned int dec,int numfirst);
#if __PRINT_FLOAT_EN>0
void printflt(double flt,int numfirst);
#endif
void printbin(unsigned int bin,int numfirst);
void printhex(unsigned int hex,char c,int numfirst,int numsize);
void printoctal(unsigned int octal,int numfirst);
void printstr(char* str);

#define console_print(ch)    printchar(ch)//putchar(ch)

void print(char* fmt, ...)
{
#if __PRINT_FLOAT_EN>0
    double vargflt = 0;
#else
		int vargflt = 0;
#endif//#if __PRINT_FLOAT_EN>0
    int  vargint = 0,sta=0;
    char* vargpch = NULL;
    char vargch = 0;
    char* pfmt = NULL;
    va_list vp;
    unsigned char c;
    int numfirst=0;//ڱ־ʾǲǵһʾ
    //int numflag=0;//ű־λ
		int numsize=0;
		unsigned int mhex,mlen;

    va_start(vp, fmt);
    pfmt = fmt;
    while(*pfmt)
    {
        if(*pfmt == '%')
        {
      NextStep:
            switch(*(++pfmt))
            {

                case 'c'://ascii
                    vargch = va_arg(vp, int);
                    /*  va_arg(ap, type), if type is narrow type (char, short, float) an error is given in strict ANSI
                        mode, or a warning otherwise.In non-strict ANSI mode, 'type' is allowed to be any expression. */
                    printch(vargch);
                    break;
                case 'd'://ʮ
                case 'i'://ʮ
                	  vargint = va_arg(vp, int);
                    printdec(vargint,numfirst);

                    break;
                case 'u'://%u ŵʮֵ
                	  vargint = va_arg(vp, unsigned int);
                    printunsigneddec(vargint,numfirst);
                    break;
								#if __PRINT_FLOAT_EN>0
                case 'f'://ʽ
                    vargflt = va_arg(vp, double);
                    /*  va_arg(ap, type), if type is narrow type (char, short, float) an error is given in strict ANSI
                        mode, or a warning otherwise.In non-strict ANSI mode, 'type' is allowed to be any expression. */
                    printflt(vargflt,numfirst);
                    break;
								#endif//__PRINT_FLOAT_EN
                case 's'://ַ
                    vargpch = va_arg(vp, char*);
                    printstr(vargpch);
                    break;
                //case 'b'://
                case 'B':
                    vargint = va_arg(vp, unsigned int);
                    printbin(vargint,numfirst);
                    break;
                case 'o'://ŵİ˽
                    vargint = va_arg(vp, unsigned int);
                    printoctal(vargint,numfirst);
                    break;
                case 'x':// ŵʮ
                case 'X':
PrintHex_Step:
                    vargint = va_arg(vp, unsigned int);
										/*if(numsize>0)
										{
											mhex=(unsigned int)vargint;	mlen=0;
											do{mhex/=16;mlen++;}while(mhex>0);
											if(mlen<numsize)
											{
												for(mlen;mlen<numsize;mlen++)printch('0');
											}
										}//*/
                    printhex(vargint,*pfmt,numfirst,numsize);
                    break;
                case '%'://%
                    printch('%');
                    break;
                case '#'://# //ʮǰ׺0b/o/0xc,s,d,uӰ죻o࣬ʱǰ׺ox࣬ʱǰ׺0x
                    if(*(pfmt+1)=='x'||*(pfmt+1)=='X')
                    {
                    	//numflag=1;
                    	printstr("0x");
                    	goto NextStep;
                    }
                    else if(*(pfmt+1)=='B')
                    {
                    	//numflag=1;
                    	printstr("0b");
                    	goto NextStep;
                    }
                    else if(*(pfmt+1)=='o')
                    {
                    	//numflag=1;
                    	printstr("o");
                    	goto NextStep;
                    }
                    break;
                default:
									if(*pfmt>='0'&&*pfmt<='9'&&*(pfmt+1)>='0'&&*(pfmt+1)<='9')
									{
										if(*(pfmt+2)=='x'||*(pfmt+2)=='X')
										{
											
											numsize=(*pfmt-'0')*10+(*(pfmt+1)-'0');
											pfmt+=2;
											goto PrintHex_Step;
										}
									}
                    break;
            }//switch(*(++pfmt))
            pfmt++;
        }//if(*pfmt == '%')
        else
        {
        	c=*pfmt;
#if __PRINT_FONT_CN_EN>0//֧
        	if(c<0x80)
#endif//#if __PRINT_FONT_CN_EN>0//֧
        	{
        		printch(*pfmt++);
        	}
#if __PRINT_FONT_CN_EN>0//֧
        	else//
        	{
          	sta=fputcn((unsigned char *)pfmt);//ʾ
          	if(sta!=1)//ʾʧ
      			{//ֿбҲӦֿ,ʾΪո
          		printch('?');
          		if(sta==0)
          		{
          			printch('?');
          			pfmt++;
          		}
          		pfmt++;
      			}
          	else//ʾɹ
          	{
      				pfmt+=2;
          	}
        	}
#endif//#if __PRINT_FONT_CN_EN>0//֧
        }
    }//while(*pfmt)
    va_end(vp);
}

void printch(char ch)
{
    console_print(ch);
}
//static char decnew=0;
void printdec(int dec,int numfirst)
{
		if(dec<0)//
		{
			dec=-dec;
			printch('-');
		}
    if(dec==0&&numfirst)
    {
    	numfirst=0;
      return;
    }
    if(numfirst==0) numfirst=1;
    printdec(dec/10,numfirst);
    printch((char)(dec%10 + '0'));
}
//static char udecnew=0;
void printunsigneddec(unsigned int dec,int numfirst)
{
    if(dec==0&&numfirst)
    {
    	numfirst=0;
      return;
    }
    if(numfirst==0) numfirst=1;
    printunsigneddec(dec/10,numfirst);
    printch((char)(dec%10 + '0'));
}
#if __PRINT_FLOAT_EN >0
void printflt(double flt,int numfirst)
{
    int icnt = 0;
    int tmpint = 0;
    int n;

    tmpint = (int)flt;
    printdec(tmpint,numfirst);
    printch('.');
    flt = flt - tmpint+0.0000005;// 
    tmpint = (int)(flt * 1000000);

    for(n=0;n<5;n++)//ȥ0
    {
    	if(tmpint%10)break;
    	else tmpint/=10;
    }

    printdec(tmpint,numfirst);
}
#endif//__PRINT_FLOAT_EN
void printstr(char* str)
{
	int sta;
    while(*str)
    {
#if __PRINT_FONT_CN_EN>0//֧
    	if((unsigned char)*str<0x80)//
#endif//#if __PRINT_FONT_CN_EN>0//֧
    	{//
        printch(*str++);
    	}//
#if __PRINT_FONT_CN_EN>0//֧
    	else//ʾ
    	{//
    		sta=fputcn(str);//
    		if(sta!=1)//жҪʾַǷֿ
				{//ֿбҲӦֿ,ʾΪո
    			printch('?');//PrintChar('?');//
    			if(sta==0)//
    			{//
    				printch('?');//PrintChar('?');//
    				str++;//
    			}//if(sta==0)
    			str++;//
				}//if(sta!=1)
    		else//ʾɹ
    		{
    			str+=2;//
    		}//else if(sta==1)
    	}//else if(ch>=0x80)
#endif//#if __PRINT_FONT_CN_EN>0//֧
    }
}
//static char ubinnew=0;
void printbin(unsigned int bin,int numfirst)
{
    if(bin == 0&&numfirst)
    {
       // printstr("0b");
    	numfirst=0;
      return;
    }
    if(numfirst==0)
    {
    	//if(numflag)printstr("0b");
    	numfirst=1;
    }
    printbin(bin/2,numfirst);
    printch((char)(bin%2 + '0'));
}
//static char hexnew=0;
void printhex(unsigned int hex,char c,int numfirst,int numsize)//numsize=0 ,numsize>0 ȹ̶
{
	int mlen=0;
	unsigned int mhex;
  if(hex==0&&numfirst)
  {
  	numfirst=0;
    return;
  }
  if(numfirst==0)
  {
  	//if(numflag)printstr("0x");
		mhex=(unsigned int)hex;	mlen=0;
		do{mhex/=16;mlen++;}while(mhex>0);
		if(mlen<numsize)
		{
			for(mlen;mlen<numsize;mlen++)printch(' ');
		}
		
  	numfirst=1;
  }
  printhex((hex>>4),c,numfirst,numsize);//
	//printhex(hex/16,c);
  if((hex&0XF) < 10)
  {
    printch((char)((hex&0X0F) + '0'));
		//printch((char)((hex%16) + '0'));
  }
  else
  {
    if(c=='X')	printch((char)(((hex&0X0F) - 10) + 'A' ));
		//printch((char)((hex%16) - 10 + 'A' ));
    else 	printch((char)(((hex&0X0F) - 10) + 'a' ));
		//printch((char)((hex%16) - 10 + 'a' ));
  }
}
//static char octalnew=0;
void printoctal(unsigned int octal,int numfirst)//˽
{
  if(octal==0&&numfirst)
  {
  	numfirst=0;
    return;
  }
  if(numfirst==0)
  {
  	//if(numflag)printstr("o");
  	numfirst=1;
  }
  printoctal(octal/8,numfirst);
  printch((char)(octal%8 + '0'));
}

#endif//_PRINTF_H_
