#ifndef _LCD_
#define _LCD_

#include "stm32f10x_gpio.h"
#include "stm32f10x_rcc.h"

unsigned char vop=0x18;
u8 Disp_buf[1024];


//PCtoLCD2002
unsigned char const CHARLCDLIB[][16] = {
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
{0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x30,0x00,0x00,0x00},/*"!",0*/
{0x00,0x10,0x0C,0x06,0x10,0x0C,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*""",1*/
{0x40,0xC0,0x78,0x40,0xC0,0x78,0x40,0x00,0x04,0x3F,0x04,0x04,0x3F,0x04,0x04,0x00},/*"#",2*/
{0x00,0x70,0x88,0xFC,0x08,0x30,0x00,0x00,0x00,0x18,0x20,0xFF,0x21,0x1E,0x00,0x00},/*"$",3*/
{0xF0,0x08,0xF0,0x00,0xE0,0x18,0x00,0x00,0x00,0x21,0x1C,0x03,0x1E,0x21,0x1E,0x00},/*"%",4*/
{0x00,0xF0,0x08,0x88,0x70,0x00,0x00,0x00,0x1E,0x21,0x23,0x24,0x19,0x27,0x21,0x10},/*"&",5*/
{0x00,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",6*/
{0x00,0x00,0x00,0xE0,0x18,0x04,0x02,0x00,0x00,0x00,0x00,0x07,0x18,0x20,0x40,0x00},/*"(",7*/
{0x00,0x02,0x04,0x18,0xE0,0x00,0x00,0x00,0x00,0x40,0x20,0x18,0x07,0x00,0x00,0x00},/*")",8*/
{0x40,0x40,0x80,0xF0,0x80,0x40,0x40,0x00,0x02,0x02,0x01,0x0F,0x01,0x02,0x02,0x00},/*"*",9*/
{0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x1F,0x01,0x01,0x01,0x00},/*"+",10*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xB0,0x70,0x00,0x00,0x00,0x00,0x00},/*",",11*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01},/*"-",12*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00},/*".",13*/
{0x00,0x00,0x00,0x00,0x80,0x60,0x18,0x04,0x00,0x60,0x18,0x06,0x01,0x00,0x00,0x00},/*"/",14*/
{0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x0F,0x10,0x20,0x20,0x10,0x0F,0x00},/*"0",15*/
{0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00},/*"1",16*/
{0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00},/*"2",17*/
{0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,0x00,0x18,0x20,0x20,0x20,0x11,0x0E,0x00},/*"3",18*/
{0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00},/*"4",19*/
{0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0x00,0x00,0x19,0x21,0x20,0x20,0x11,0x0E,0x00},/*"5",20*/
{0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00},/*"6",21*/
{0x00,0x38,0x08,0x08,0xC8,0x38,0x08,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0x00,0x00},/*"7",22*/
{0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00},/*"8",23*/
{0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x00,0x31,0x22,0x22,0x11,0x0F,0x00},/*"9",24*/
{0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00},/*":",25*/
{0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x60,0x00,0x00,0x00,0x00},/*";",26*/
{0x00,0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00,0x01,0x02,0x04,0x08,0x10,0x20,0x00},/*"<",27*/
{0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00},/*"=",28*/
{0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x02,0x01,0x00},/*">",29*/
{0x00,0x70,0x48,0x08,0x08,0x08,0xF0,0x00,0x00,0x00,0x00,0x30,0x36,0x01,0x00,0x00},/*"?",30*/
{0xC0,0x30,0xC8,0x28,0xE8,0x10,0xE0,0x00,0x07,0x18,0x27,0x24,0x23,0x14,0x0B,0x00},/*"@",31*/
{0x00,0x00,0xC0,0x38,0xE0,0x00,0x00,0x00,0x20,0x3C,0x23,0x02,0x02,0x27,0x38,0x20},/*"A",32*/
{0x08,0xF8,0x88,0x88,0x88,0x70,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x11,0x0E,0x00},/*"B",33*/
{0xC0,0x30,0x08,0x08,0x08,0x08,0x38,0x00,0x07,0x18,0x20,0x20,0x20,0x10,0x08,0x00},/*"C",34*/
{0x08,0xF8,0x08,0x08,0x08,0x10,0xE0,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00},/*"D",35*/
{0x08,0xF8,0x88,0x88,0xE8,0x08,0x10,0x00,0x20,0x3F,0x20,0x20,0x23,0x20,0x18,0x00},/*"E",36*/
{0x08,0xF8,0x88,0x88,0xE8,0x08,0x10,0x00,0x20,0x3F,0x20,0x00,0x03,0x00,0x00,0x00},/*"F",37*/
{0xC0,0x30,0x08,0x08,0x08,0x38,0x00,0x00,0x07,0x18,0x20,0x20,0x22,0x1E,0x02,0x00},/*"G",38*/
{0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20},/*"H",39*/
{0x00,0x08,0x08,0xF8,0x08,0x08,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00},/*"I",40*/
{0x00,0x00,0x08,0x08,0xF8,0x08,0x08,0x00,0xC0,0x80,0x80,0x80,0x7F,0x00,0x00,0x00},/*"J",41*/
{0x08,0xF8,0x88,0xC0,0x28,0x18,0x08,0x00,0x20,0x3F,0x20,0x01,0x26,0x38,0x20,0x00},/*"K",42*/
{0x08,0xF8,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x20,0x30,0x00},/*"L",43*/
{0x08,0xF8,0xF8,0x00,0xF8,0xF8,0x08,0x00,0x20,0x3F,0x00,0x3F,0x00,0x3F,0x20,0x00},/*"M",44*/
{0x08,0xF8,0x30,0xC0,0x00,0x08,0xF8,0x08,0x20,0x3F,0x20,0x00,0x07,0x18,0x3F,0x00},/*"N",45*/
{0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,0x0F,0x10,0x20,0x20,0x20,0x10,0x0F,0x00},/*"O",46*/
{0x08,0xF8,0x08,0x08,0x08,0x08,0xF0,0x00,0x20,0x3F,0x21,0x01,0x01,0x01,0x00,0x00},/*"P",47*/
{0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,0x0F,0x18,0x24,0x24,0x38,0x50,0x4F,0x00},/*"Q",48*/
{0x08,0xF8,0x88,0x88,0x88,0x88,0x70,0x00,0x20,0x3F,0x20,0x00,0x03,0x0C,0x30,0x20},/*"R",49*/
{0x00,0x70,0x88,0x08,0x08,0x08,0x38,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00},/*"S",50*/
{0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00},/*"T",51*/
{0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,0x00,0x1F,0x20,0x20,0x20,0x20,0x1F,0x00},/*"U",52*/
{0x08,0x78,0x88,0x00,0x00,0xC8,0x38,0x08,0x00,0x00,0x07,0x38,0x0E,0x01,0x00,0x00},/*"V",53*/
{0xF8,0x08,0x00,0xF8,0x00,0x08,0xF8,0x00,0x03,0x3C,0x07,0x00,0x07,0x3C,0x03,0x00},/*"W",54*/
{0x08,0x18,0x68,0x80,0x80,0x68,0x18,0x08,0x20,0x30,0x2C,0x03,0x03,0x2C,0x30,0x20},/*"X",55*/
{0x08,0x38,0xC8,0x00,0xC8,0x38,0x08,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00},/*"Y",56*/
{0x10,0x08,0x08,0x08,0xC8,0x38,0x08,0x00,0x20,0x38,0x26,0x21,0x20,0x20,0x18,0x00},/*"Z",57*/
{0x00,0x00,0x00,0xFE,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x7F,0x40,0x40,0x40,0x00},/*"[",58*/
{0x00,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x06,0x38,0xC0,0x00},/*"\",59*/
{0x00,0x02,0x02,0x02,0xFE,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x7F,0x00,0x00,0x00},/*"]",60*/
{0x00,0x00,0x04,0x02,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"^",61*/
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80},/*"_",62*/
{0x00,0x02,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"`",63*/
{0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x19,0x24,0x22,0x22,0x22,0x3F,0x20},/*"a",64*/
{0x08,0xF8,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x3F,0x11,0x20,0x20,0x11,0x0E,0x00},/*"b",65*/
{0x00,0x00,0x00,0x80,0x80,0x80,0x00,0x00,0x00,0x0E,0x11,0x20,0x20,0x20,0x11,0x00},/*"c",66*/
{0x00,0x00,0x00,0x80,0x80,0x88,0xF8,0x00,0x00,0x0E,0x11,0x20,0x20,0x10,0x3F,0x20},/*"d",67*/
{0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x1F,0x22,0x22,0x22,0x22,0x13,0x00},/*"e",68*/
{0x00,0x80,0x80,0xF0,0x88,0x88,0x88,0x18,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00},/*"f",69*/
{0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x6B,0x94,0x94,0x94,0x93,0x60,0x00},/*"g",70*/
{0x08,0xF8,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x3F,0x21,0x00,0x00,0x20,0x3F,0x20},/*"h",71*/
{0x00,0x80,0x98,0x98,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00},/*"i",72*/
{0x00,0x00,0x00,0x80,0x98,0x98,0x00,0x00,0x00,0xC0,0x80,0x80,0x80,0x7F,0x00,0x00},/*"j",73*/
{0x08,0xF8,0x00,0x00,0x80,0x80,0x80,0x00,0x20,0x3F,0x24,0x02,0x2D,0x30,0x20,0x00},/*"k",74*/
{0x00,0x08,0x08,0xF8,0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00},/*"l",75*/
{0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x20,0x3F,0x20,0x00,0x3F,0x20,0x00,0x3F},/*"m",76*/
{0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x3F,0x21,0x00,0x00,0x20,0x3F,0x20},/*"n",77*/
{0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x1F,0x20,0x20,0x20,0x20,0x1F,0x00},/*"o",78*/
{0x80,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0xFF,0xA1,0x20,0x20,0x11,0x0E,0x00},/*"p",79*/
{0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x00,0x00,0x0E,0x11,0x20,0x20,0xA0,0xFF,0x80},/*"q",80*/
{0x80,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x20,0x20,0x3F,0x21,0x20,0x00,0x01,0x00},/*"r",81*/
{0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x33,0x24,0x24,0x24,0x24,0x19,0x00},/*"s",82*/
{0x00,0x80,0x80,0xE0,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x1F,0x20,0x20,0x00,0x00},/*"t",83*/
{0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x1F,0x20,0x20,0x20,0x10,0x3F,0x20},/*"u",84*/
{0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x80,0x00,0x01,0x0E,0x30,0x08,0x06,0x01,0x00},/*"v",85*/
{0x80,0x80,0x00,0x80,0x00,0x80,0x80,0x80,0x0F,0x30,0x0C,0x03,0x0C,0x30,0x0F,0x00},/*"w",86*/
{0x00,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x20,0x31,0x2E,0x0E,0x31,0x20,0x00},/*"x",87*/
{0x80,0x80,0x80,0x00,0x00,0x80,0x80,0x80,0x80,0x81,0x8E,0x70,0x18,0x06,0x01,0x00},/*"y",88*/
{0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x00,0x21,0x30,0x2C,0x22,0x21,0x30,0x00},/*"z",89*/
{0x00,0x00,0x00,0x00,0x80,0x7C,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x3F,0x40,0x40},/*"{",90*/
{0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00},/*"|",91*/
{0x00,0x02,0x02,0x7C,0x80,0x00,0x00,0x00,0x00,0x40,0x40,0x3F,0x00,0x00,0x00,0x00},/*"}",92*/
{0x00,0x06,0x01,0x01,0x02,0x02,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"~",93*/
};

u8 LCD_PinInit(void);
void LCD_delay(unsigned int t);
void writec(unsigned char com);
void writed(unsigned char data);
 void LCD_config(void);
 void Display_char_pic(unsigned char *p);
 void Display_clear(void);
 void Display_char_en(u8 x,u8 y,u8 ch);
 void Prints_En(u8 x,u8 y,u8* pd);
 void Display_LCD8bit(u8 x,u8 y,u32 num,u8 disapper);
 void SetSDA(unsigned char temp){if(temp){GPIOD->BSRR=(1<<11);}else{GPIOD->BRR=(1<<11);}}

 void SetSCL(unsigned char temp){if(temp){GPIOD->BSRR=(1<<12);}else{GPIOD->BRR=(1<<12);}}

 void SetRS(unsigned char temp){if(temp){GPIOD->BSRR=(1<<13);}else{GPIOD->BRR=(1<<13);}}  //RS

 void SetRST(unsigned char temp){if(temp){GPIOD->BSRR=(1<<14);}else{GPIOD->BRR=(1<<14);}}

 void SetCS(unsigned char temp){if(temp){GPIOD->BSRR=(1<<15);}else{GPIOD->BRR=(1<<15);}}



void LCD_delay(unsigned int t)
{
    volatile unsigned int i,j;
	for(j=0;j<t;j++)
	for( i=0; i<10; i++ );
}

void writec(unsigned char com)
{ unsigned char i ;
	SetCS(0);
	SetRS(0);

   for(i=0;i<8;i++)
    {
		if(com&0x80)SetSDA(1);else SetSDA(0);
		com = com<<1;
		SetSCL(1);
		SetSCL(0);
     }
    SetCS(1);
    SetRS(1);
 }

void writed(unsigned char data)
{ unsigned char i ;
	SetCS(0);
	SetRS(1);

   for(i=0;i<8;i++)
    {
		if(data&0x80)SetSDA(1);else SetSDA(0);
		data = data<<1;
		SetSCL(1);
		SetSCL(0);
     }
      SetCS(1);
      SetRS(1);
 }

 void LCD_config(void)
{
   unsigned char col;
   LCD_PinInit();
       SetRST(1);
       LCD_delay(1000);
       SetRST(0);
       LCD_delay(1000);
       SetRST(1);
       LCD_delay(1000);

     writec(0xe3);  // reset signal
     writec(0xa2);  //(0xa2 1/9 bias,1/65 duty )
     writec(0xa0);  // ADC select
     writec(0xc8);  // command output select
     writec(0x2f);  // power control
     writec(0x24);  // select resistor ratio Rb/Ra
     writec(0x81);  // select volume  0x81
     writec(vop);   // vop
     writec(0xf8);  // x4
     writec(0x08);  // x4
     writec(0xb0);//set page address
     writec(0x10);//set column address
     writec(0x00);
     for(col=0;col<128;col++)writed(0x00);  //
     writec(0xaf);  //display on

     Display_clear();
}
 
u8 LCDInitFlag =0;
u8 LCD_PinInit(void)
{
  if(LCDInitFlag==0){LCDInitFlag =1;} else return 0;
	//ʼ߶˿
	  GPIO_InitTypeDef GPIO_InitStructure;
	 //ʼ߶˿PC
	  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11|GPIO_Pin_12|GPIO_Pin_13|GPIO_Pin_14|GPIO_Pin_15;   //ʼPD0=RS PD1
	  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	  GPIO_Init(GPIOD, &GPIO_InitStructure);

  LCD_config();
}

void Display_clear(void)
{
   unsigned char  row,col;

   for (row=0xb0; row<0xb8; row++)
   {
      writec(row);//set page address
      writec(0x10);//set column address
      writec(0x00);
      for(col=0;col<128;col++)writed(0x00);
   }
}

//ʾ֡Ӣĺͷ
void Display_char_en(u8 x,u8 y,u8 ch)
{
 	u8 i,j,var0,var1;
	u8* pic;
	ch-=32;
	pic=(u8*)CHARLCDLIB[ch];
	os_task_enter_critical();
	for(i=0;i<2;i++)
	{
		writec(0xb0+i+y);     //set page address
		writec(0x10+(x>>4));  //set column MSB address
		writec(x&0x0F);       //set column LSB address
		for(j=0;j<8;j++)writed(*(pic+8*i+j));
	}
	os_task_exit_critical();
}

void Display_char_en1(u8 x,u8 y,u8 ch,u8 head,u8 end)
{
 	u8 i,j,var0,var1;
	u8* pic;
	ch-=32;
	pic=(u8*)CHARLCDLIB[ch];
	for(i=0;i<2;i++)
	{
		writec(0xb0+i+y);     //set page address
		writec(0x10+(x>>4));  //set column MSB address
		writec(x&0x0F);       //set column LSB address
		for(j=0;j<8;j++)
			{
				if(i==0)
					writed(*(pic+8*i+j)|head);
				else
					writed(*(pic+8*i+j)|end);
			}
	}
}


void Display_char_pic(unsigned char *p)
{
   unsigned char  row,col;

   for (row=0xb0; row<0xb8; row++)
   {
      writec(row);//set page address
      writec(0x10);//set column address
      writec(0x00);
      for(col=0;col<128;col++)
      writed(*p++);
   }
}

void Display_LCD10bit(u8 x,u8 y,u32 num,u8 disapper)
{
	 u8 temp[10],i=0;

	   for(i=0;i<10;i++)
	   	{
	   	temp[i]=num%10+48;
		num/=10;
		}
	   if(disapper==0)
	   	{
	 	 for(i=9;i>0;i--)
	   		{
	   		if(temp[i]==48)temp[i]=32;//32ǿո
	   		else
	   		{break;}
	   		}
	   	}
	   	Display_char_en(x+8,y,temp[9]);
	   	Display_char_en(x+16,y,temp[8]);
		Display_char_en(x+24,y,temp[7]);
		Display_char_en((x+32),y,temp[6]);
		Display_char_en((x+40),y,temp[5]);
		Display_char_en((x+48),y,temp[4]);
		Display_char_en((x+56),y,temp[3]);
		Display_char_en((x+64),y,temp[2]);
		Display_char_en((x+72),y,temp[1]);
		Display_char_en((x+80),y,temp[0]);

}

void LCD_10g(u16 x,u16 y,u32 num)
{
 	u8 temp[11],i=0,flag=0;
	u8 NumSign=0;	//01Ǹ

 	if(num>2147483647)
	{
	num	=	4294967296-num;
	NumSign	=	1;
	}

   	for(i=0;i<10;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}

	temp[10]=' ';
	for(i=10;i>0;i--)
	{
		if((temp[i-1]!=48)&&(flag==0))
		{
		if(NumSign==1)temp[i]='-';
		flag=1;
		}
		else if((flag==0)&&(i>1))
		{
		temp[i-1]=' ';
		}
		else if(temp[0]==48)
		{
		temp[0]='0';
		}
	}

	Display_char_en(x,y,temp[10]);
   	Display_char_en(x+8,y,temp[9]);
   	Display_char_en(x+16,y,temp[8]);
	Display_char_en(x+24,y,temp[7]);
	Display_char_en((x+32),y,temp[6]);
	Display_char_en((x+40),y,temp[5]);
	Display_char_en((x+48),y,temp[4]);
	Display_char_en((x+56),y,temp[3]);
	Display_char_en((x+64),y,temp[2]);
	Display_char_en((x+72),y,temp[1]);
	Display_char_en((x+80),y,temp[0]);

}

void Prints_En(u8 x,u8 y,u8* pd)
{
    while((*pd)!='\0')
    	{
    	  Display_char_en(x,y,*pd);
	  x+=8;
	  pd++;
    	}
}
#endif
