//*********************************************************
//   Joinmax Digital Module library 2.0
//*********************************************************
// File                 : JMLib.c 
// Version              :  V1.0
// Compiler             : GCCARM
// Target               : STM32F103VET6
// Author               : CZQ
// Support telephone    : +86 20 84134792 (JoinMax digital)
// Support fax          : +86 20 84134890 (JoinMax digital)
//********************  Module List  **********************
// 
//*********************************************************
//IICģĵַ
//BE-1727 :  0x02	GetCompoI
//BE-2615 :  0x76   GetCompassB
//BE-6303 :  0x04 	GetUltrasound
//BE-2620 :  0XA6   GetGSensor
//BE-1151 :  0XA1	GetAirQuality
//BE-2205 :	 0X0E   SetMusicPlayer
//BE-2621 :  0X3A	GetAHRS  SetAHRS
//BE-1131 :	 0X350  GetColorSensor SetColorSensor
//BE-1132 :  0X350 or 0XA8  GetColorSensor SetColorSensor
//**********************  HISTORY  ************************

#include <jmkernel32.h>
#include <math.h>
#include <Pinformat.h>
#include <LCD_COLOR.h>
//#include "jmisr.h"
#include"jmdos.h"
#include"lcd320240.h"
#include"jmdmath.h"


#ifndef _TC_VAR_
#define _TC_VAR_
vu32 TouchClicks[8];
u8 Flag_ADS[8]={0,0,0,0,0,0,0,0};
u16 _Adc_indicatorlamp=0;
#endif

#if _TOUCH_TO_SCREEN_EN_ > 0
vu8 TTSC_Flag;
#endif

//==SetNSec Readding ID:  == DON'T DELETE!! ==

#ifdef _SETWAITFORTIME_
 #ifndef  _SETWAITFORTIME_EXISTS_
  #define _SETWAITFORTIME_EXISTS_
  #include <jmkernel32.h>
  void SetWaitForTime(float s){

    u32 endtime;
    endtime=(u32)(s*1000);
    Delay1ms(endtime);

  }
 #endif
#endif

#ifdef _SETLIGHTSENSORLED_
#ifndef  _SETLIGHTSENSORLED_EXISTS_
#define _SETLIGHTSENSORLED_EXISTS_
#include <jmkernel32.h>

  void SetLightSensorLed(u8 which,int state){
   u32 port1 = portarray[RcuPORT[which][0]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
   u8 bit3=RcuPIN[which][2];
    u16 i;
    u8 channel;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);
    
    if(state==1)
    {
     GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
		 state=0x80;
    }
    else
    {
     GPIO_ResetBits((GPIO_TypeDef*)port1,(1<<bit1));
		 state=0x00;
    }
		Flag_ADS[which]=1|state;
  }
 #endif
#endif

#ifdef _SETLIGHTSENSORILAMP_
#ifndef  _SETLIGHTSENSORILAMP_EXISTS_
#define _SETLIGHTSENSORILAMP_EXISTS_
#include <jmkernel32.h>
//ûҶָʾ indicator lamp
  void SetLightSensorILamp(u8 which,int state){
   u32 port2 = portarray[RcuPORT[which][1]];
   u8 bit2=RcuPIN[which][1];
    u16 i;
    u8 channel;
		
    GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    
    if(state==1)
    {
     GPIO_SetBits((GPIO_TypeDef*)port2,(1<<bit2));
    }
    else
    {
     GPIO_ResetBits((GPIO_TypeDef*)port2,(1<<bit2));
    }
		if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)_Adc_indicatorlamp|=(1<<(which-1));//ñ־λ
  }
 #endif
#endif


#ifdef _SETLIGHTSENSORTHRESHOLD_
#ifndef  _SETLIGHTSENSORTHRESHOLD_EXISTS_
#define _SETLIGHTSENSORTHRESHOLD_EXISTS_
#include <jmkernel32.h>
  void SetLightSensorThreshold(u8 which,int Threshold){
   WriteAdcThreshold(which-1,Threshold,1);//޸ֵ
  }
 #endif
#endif

#ifdef _GETLIGHTSENSORTHRESHOLD_
#ifndef  _GETLIGHTSENSORTHRESHOLD_EXISTS_
#define _GETLIGHTSENSORTHRESHOLD_EXISTS_
#include <jmkernel32.h>
  u16 GetLightSensorThreshold(u8 which){
   return ReadAdcThreshold(which-1);
  }
 #endif
#endif

#ifdef _GETANTILIGHT_
#ifndef  _GETANTILIGHT_EXISTS_
#define _GETANTILIGHT_EXISTS_
#include <jmkernel32.h>

  u16 GetAntiLight(u8 which){
   u32 port1 = portarray[RcuPORT[which][0]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
   u8 bit3=RcuPIN[which][2];
    u16 m_Value1,m_Value2,m_Value3;
    u8 channel;
		RcuWhichMutexTake(which,1,4095);
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);
    
    GPIO_ResetBits((GPIO_TypeDef*)port1,(1<<bit1));
    Delay1ms(5);
    m_Value1 = GetAdcResult(which);
    GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
    Delay1ms(5);
    m_Value2 = GetAdcResult(which);
    RcuWhichMutexGive(which,1,4095);
    if(m_Value2>m_Value1)
    {
    m_Value3 = m_Value2 - m_Value1; 
    }
    else
    {
    m_Value3 = 0;
    }
    
    return m_Value3;
  }
 #endif
#endif

#ifdef _GETLIGHTSENSOR_
#ifndef  _GETLIGHTSENSOR_EXISTS_
#define _GETLIGHTSENSOR_EXISTS_
#include <jmkernel32.h>

  u16 GetLightSensor(u8 which){
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i;
    u8 channel;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);

  if(Flag_ADS[which]==0)
	{
		RcuWhichMutexTake(which,1,4095);
		GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
		Flag_ADS[which]=0X81;
    Delay1ms(10);
		RcuWhichMutexGive(which,1,4095);
	}
    i=GetAdcResult(which);
		if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
		GPIO_AdcLed2State(which,(GPIO_TypeDef*)port2,bit2,i,1);//ָʾ״̬
    return (u16)i;
  }
 #endif
#endif


#ifdef _GETLIGHTSENSORDATA_
#ifndef  _GETLIGHTSENSORDATA_EXISTS_
#define _GETLIGHTSENSORDATA_EXISTS_
#include <jmkernel32.h>

  u16 GetLightSensorData(u8 which)
	{
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i,th;
    u8 channel;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);

  if(Flag_ADS[which]==0)
	{
		RcuWhichMutexTake(which,1,4095);
		GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
		Flag_ADS[which]=0X81;
    Delay1ms(10);
		RcuWhichMutexGive(which,1,4095);
	}
		th=ReadAdcThreshold(which-1);//ȡֵ
		i=GetAdcResult(which);
		if(i<th)
		{
			i=1;
			if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
			GPIO_SetBits((GPIO_TypeDef*)port2,(1<<bit2));
		}
		else 
		{
			i=0;
			if(((_Adc_indicatorlamp>>(which-1))&0x01)==0)
			GPIO_ResetBits((GPIO_TypeDef*)port2,(1<<bit2));
		}
    return (u16)i;
  }
 #endif
#endif
#ifdef _SETWAITFORDARK_
#ifndef  _SETWAITFORDARK_EXISTS_
#define _SETWAITFORDARK_EXISTS_
#include <jmkernel32.h>

  void SetWaitforDark(u8 which,u16 value){
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i;
    u8 channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);

    if(Flag_ADS[which]==0)
	{
	RcuWhichMutexTake(which,1,4095);
	GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
	Flag_ADS[which]=0X81;
        Delay1ms(10);
	RcuWhichMutexGive(which,1,4095);
	}

	do
	{
    	i=GetAdcResult(which);
	}while(i>value);
	
  }
 #endif
#endif

#ifdef _SETWAITFORLIGHT_
#ifndef  _SETWAITFORLIGHT_EXISTS_
#define _SETWAITFORLIGHT_EXISTS_
#include <jmkernel32.h>

  u16 SetWaitforLight(u8 which,u16 value){
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i;
    u8 channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);

    if(Flag_ADS[which]==0)
	{
	RcuWhichMutexTake(which,1,4095);
	GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
	Flag_ADS[which]=0X81;
        Delay1ms(10);
				RcuWhichMutexGive(which,1,4095);
	}

	do
	{
    	i=GetAdcResult(which);
	}while(i<value);
	
  }
 #endif
#endif

#ifdef _SETWAITFORDARKER_
#ifndef  _SETWAITFORDARKER_EXISTS_
#define _SETWAITFORDARKER_EXISTS_
#include <jmkernel32.h>

  u16 SetWaitforDarker(u8 which,u16 value){
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i,temp;
    u8 channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);
	
    if(Flag_ADS[which]==0)
	{
	RcuWhichMutexTake(which,1,4095);
	GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
	Flag_ADS[which]=0X81;
        Delay1ms(10);
				RcuWhichMutexGive(which,1,4095);
	}

	temp = GetAdcResult(which);
	do
	{
    	i=GetAdcResult(which);
	}while(i>(temp-value));
	
  }
 #endif
#endif

#ifdef _SETWAITFORLIGHTER_
#ifndef  _SETWAITFORLIGHTER_EXISTS_
#define _SETWAITFORLIGHTER_EXISTS_
#include <jmkernel32.h>

  u16 SetWaitforLighter(u8 which,u16 value){
   u32 port1 = portarray[RcuPORT[which][0]];
	 u32 port2 = portarray[RcuPORT[which][1]];
   u32 port3 = portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
	 u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
    u16 i,temp;
    u8 channel;
		
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
		GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
    GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);

    if(Flag_ADS[which]==0)
	{
	RcuWhichMutexTake(which,1,4095);
	GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
	Flag_ADS[which]=0X81;
	Delay1ms(10);
	RcuWhichMutexGive(which,1,4095);
	}
	
	temp = GetAdcResult(which);
	do
	{
    	i=GetAdcResult(which);
	}while(i<(temp+value));
	
  }
 #endif
#endif


#ifdef _GETTOUCH_
 #ifndef  _GETTOUCH_EXISTS_
  #define _GETTOUCH_EXISTS_
  #include <jmkernel32.h>

  u16 GetTouch(u8 which){
   u32 port1=portarray[RcuPORT[which][1]];//I2C_SCL
   u8 bit1=RcuPIN[which][1];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);

    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value==0) return 0;
    else      return 1;
  }
 #endif
#endif

#ifdef _GETTOUCHA_
 #ifndef  _GETTOUCHA_EXISTS_
  #define _GETTOUCHA_EXISTS_
  #include <jmkernel32.h>

u16 GetTouchA(u8 which)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SDA
   u8 bit1=RcuPIN[which][0];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);

    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value==0)
      return 0;
    else
      return 1;
  }
 #endif
#endif

#ifdef _GETTOUCHB_
 #ifndef  _GETTOUCHB_EXISTS_
  #define _GETTOUCHB_EXISTS_
  #include <jmkernel32.h>

u16 GetTouchB(u8 which)
{
   u32 port1=portarray[RcuPORT[which][2]];//ADC
   u8 bit1=RcuPIN[which][2];
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);

    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value==0)    return 0;
    else   return 1;
  }
 #endif
#endif

#ifdef _SETFONTSIZE_
 #ifndef  _SETFONTSIZE_EXISTS_
  #define _SETFONTSIZE_EXISTS_
void SetFontSize(u8 size)//С
{
	SetFlashFontSize(size);//0(С8X16)/1(32X32)
}
 #endif
#endif
//==SetLCDBack Readding ID:  == DON'T DELETE!! ==

#ifdef _SETLCDBACK_
 #ifndef  _SETLCDBACK_EXISTS_
  #define _SETLCDBACK_EXISTS_
  #include <jmkernel32.h>
  #include "LCD320240.h"
void SetLCDBack(u8 led)
{
	GPIO_Setting(LCD_BACKLED_GPIO,LCD_BACKLED_PIN,GPIO_Mode_Out_PP);//ʼ˿
	SetBackLed(led);
	g_LcdBackLignt=led;//ñƲ	
}
 #endif
#endif

//==SetLCD8Char Readding ID:  == DON'T DELETE!! ==

#ifdef _SETDISPLAYVAR_
#ifndef  _SETDISPLAYVAR_EXISTS_
#define _SETDISPLAYVAR_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetDisplayVar(int y,s32 data,u16 ch_color,u16 bg_color)
{
  SetBackLed(g_LcdBackLignt);
	os_task_enter_critical();
  SetNumFontType();//ʾֿ
	os_task_exit_critical();
	LCD_DisplayNum(LCD_Width-(GetFontLibWidth()*10)-1, (y-1)*GetFontLibHeight(),(s32)data, ch_color, bg_color,0x8088); 
}
#endif
#endif

//==SetLCD10Char Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYVARU32_
#ifndef  _SETDISPLAYVARU32_EXISTS_
#define _SETDISPLAYVARU32_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetDisplayVarU32(int y,u32 data,u16 ch_color,u16 bg_color)
{
  SetBackLed(g_LcdBackLignt);
  os_task_enter_critical();
  SetNumFontType();//ʾֿ
  os_task_exit_critical();
  LCD_DisplayNumU32(LCD_Width-(GetFontLibWidth()*10)-1, (y-1)*GetFontLibHeight(),(u32)data, ch_color, bg_color,0x800A); 
}
#endif
#endif

//==SetDisplayFloat Readding ID:  == DON'T DELETE!! ==
#ifdef _SETDISPLAYFLOAT_
#ifndef  _SETDISPLAYFLOAT_EXISTS_
#define _SETDISPLAYFLOAT_EXISTS_
#include "LCD320240.h"

void SetDisplayFloat(int y,double data,u16 ch_color,u16 bg_color)
{
	SetBackLed(g_LcdBackLignt);
	os_task_enter_critical();
  SetNumFontType();//ʾֿ
	os_task_exit_critical();
	LCD_DisplayFloatNum(LCD_Width-(GetFontLibWidth()*12)-1, (y-1)*GetFontLibHeight(),(double)data, ch_color, bg_color,0x0802);  
}
 #endif
#endif

#ifdef _SETLCDCLEAR_
#ifndef  _SETLCDCLEAR_EXISTS_
#define _SETLCDCLEAR_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDClear(u16 m_color)
{
  LCD_Pant(m_color);
}
#endif
#endif

#ifdef _SETLCDDOT_
#ifndef  _SETLCDDOT_EXISTS_
#define _SETLCDDOT_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDDot(u8 x,u16 y,u16 m_color)
{
	SetBackLed(g_LcdBackLignt);
	if(x==0||y==0)return;
#if _TOUCH_TO_SCREEN_EN_ > 0
	u16 iy=320-y;
	if(TTSC_Flag)iy=320-y;//if(TTSC_Flag)iy=y;
	else iy=y;
	LCD_DrawPoint((x-1),(iy),m_color);
#else
  //LCD_DrawPoint((x-1),(320-y),m_color);
	LCD_DrawPoint((x-1),(y-1),m_color);
#endif
}
#endif
#endif

#ifdef _SETLCDPICTURE_
#ifndef  _SETLCDPICTURE_EXISTS_
#define _SETLCDPICTURE_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDPicture(u8 x,u16 y,u8 num)
{
SetBackLed(g_LcdBackLignt);
  LCD_DrawPicture(x,y,Picture1,YELLOW,BLACK);
}

#endif
#endif

#ifdef _GETCHOICEBOX_
#ifndef _GETCHOICEBOX_EXISTS_
#define _GETCHOICEBOX_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

u8 GetChoiceBox(u8* words)
{
  u8 state=0;
  u16 m_TouchX,m_TouchY,m_Valid;
  LCD_Pant(BLACK);
  SetBackLed(g_LcdBackLignt);
  LCD_String(0,16,words,YELLOW,BLACK);
  LCD_Display4Chioce();

  while(state==0)
  {
		m_TouchX=ReadTouchXFilter();
		m_TouchY=ReadTouchYFilter();
		
   if((m_TouchY>65)&&(m_TouchY<134))
    {
       if((m_TouchX>27)&&(m_TouchX<96))
			{
				state=1;//A
			}
			else if((m_TouchX>143)&&(m_TouchX<212))
			{
				state=2;//B
			}
		}
		else if((m_TouchY>176)&&(m_TouchY<245))
		{
			if((m_TouchX>27)&&(m_TouchX<96))
			{
				state=3;//C
			}
			else if((m_TouchX>143)&&(m_TouchX<212))
			{
				state=4;//D
			}
    }
		Delay1ms(10);
  }
	LCD_Pant(BLACK);
	return state;
}

#endif
#endif

//==SetLCDString Readding ID:  == DON'T DELETE!! ==

#ifdef _SETDISPLAYSTRING_
#ifndef  _SETDISPLAYSTRING_EXISTS_
#define _SETDISPLAYSTRING_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

 void SetDisplayString(int y,s8* pic,u16 ch_color,u16 bg_color)
{
  SetBackLed(g_LcdBackLignt);
  LCD_String(0,(y-1)*GetFontLibHeight(),pic,ch_color,bg_color);
}
 #endif
#endif

//==SetLCDClear Readding ID:  == DON'T DELETE!! ==

#ifdef   _SETLCDCLEAR_
#ifndef  _SETLCDCLEAR_EXISTS_
#define  _SETLCDCLEAR_EXISTS_
#include <jmkernel32.h>
#include "LCD12864.h"
void SetLCDClear(void){
    clearwindow();
}
#endif
#endif

#ifdef _SET3CLED_
 #ifndef  _SET3CLED_EXISTS_
  #define _SET3CLED_EXISTS_
  #include <jmkernel32.h>

void Set3CLed(u8 which,u16 Color)
{
   u32 port1=portarray[RcuPORT[which][0]];
   u32 port2=portarray[RcuPORT[which][1]];
   u32 port3=portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];

   u8 RedLed,GreenLed,BlueLed;
RcuWhichMutexTake(which,1,0);
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
   GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_Out_PP);

   switch(Color)
	{
	case 0: RedLed=0;GreenLed=0;BlueLed=0;	break;
	case RED:RedLed=1;GreenLed=0;BlueLed=0;	break;
	case 1: RedLed=1;GreenLed=0;BlueLed=0;	break;
	case GREEN:RedLed=0;GreenLed=1;BlueLed=0;	break;
	case 2: RedLed=0;GreenLed=1;BlueLed=0;	break;
	case BLUE:RedLed=0;GreenLed=0;BlueLed=1;	break;
	case 3: RedLed=0;GreenLed=0;BlueLed=1;	break;
	case YELLOW:RedLed=1;GreenLed=1;BlueLed=0;	break;
	case 4: RedLed=1;GreenLed=1;BlueLed=0;	break;
	case PURPLE:RedLed=1;GreenLed=0;BlueLed=1;	break;
	case 5: RedLed=1;GreenLed=0;BlueLed=1;	break;
	case CYAN:RedLed=0;GreenLed=1;BlueLed=1;	break;
	case 6: RedLed=0;GreenLed=1;BlueLed=1;	break;
	case WHITE:RedLed=1;GreenLed=1;BlueLed=1;	break;
	case 7: RedLed=1;GreenLed=1;BlueLed=1;	break;
	}


//ɫ
   if(GreenLed==1)//if(RedLed==1)
   GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
   else
   GPIO_ResetBits((GPIO_TypeDef*)port1,( 1<<bit1));
//ɫ
   if(RedLed==1)//if(GreenLed==1)
   GPIO_SetBits((GPIO_TypeDef*)port2,(1<<bit2));
   else
   GPIO_ResetBits((GPIO_TypeDef*)port2,( 1<<bit2));
//ɫ
   if(BlueLed==1)
   GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
   else
   GPIO_ResetBits((GPIO_TypeDef*)port3,(1<<bit3));
RcuWhichMutexGive(which,1,0);
  }
 #endif
#endif

#ifdef _SETMOTOR_
 #ifndef  _SETMOTOR_EXISTS_
 #define _SETMOTOR_EXISTS_
 #include <jmkernel32.h>

void SetMotor(u8 which,int speed)
{
	u8 m_speedper;
	speed=(u8)speed;
	SetMotorNormalMode(which);
	if(g_MotorPowerFlag)
	{
		switch(which)
		{
			case 1:m_speedper=g_M1SpeedPer;break;
			case 2:m_speedper=g_M2SpeedPer;break;
			case 3:m_speedper=g_M3SpeedPer;break;
			case 4:m_speedper=g_M4SpeedPer;break;
		}
	}
	if(speed==0)
	{
		SetMotorX(which,1,speed);
	}
	else if(speed<=100)
	{
		if(g_MotorPowerFlag)speed=(u8)((u16)m_speedper*speed/100);
		SetMotorX(which,2,speed);
	}
	else
	{
		speed=256-speed;
		if(g_MotorPowerFlag)speed=(u8)((u16)m_speedper*(speed)/100);
		SetMotorX(which,0,speed);
		//SetMotorX(which,0,256-speed);
	}   
}
 #endif
#endif

#ifdef _SETMOTORCODE_
 #ifndef  _SETMOTORCODE_EXISTS_
 #define _SETMOTORCODE_EXISTS_
 #include <jmkernel32.h>

void SetMotorCode(u8 which)
{
   MotorCodingInit();
   switch(which)
   {
	case 1:SetMotorCnt1Zero();
	break;
	case 2:SetMotorCnt2Zero();
	break;
	case 3:SetMotorCnt3Zero();
	break;
	case 4:SetMotorCnt4Zero();
	break;
   }
}
 #endif
#endif

#ifdef _GETMOTORCODE_
 #ifndef  _GETMOTORCODE_EXISTS_
 #define _GETMOTORCODE_EXISTS_
 #include <jmkernel32.h>

vs32 GetMotorCode(u8 which)
{
  MotorCodingInit();
  switch(which)
  {
		case 1:return GetMotorCnt1();	break;
		case 2:return GetMotorCnt2();	break;
		case 3:return GetMotorCnt3();	break;
		case 4:return GetMotorCnt4();	break;
  }
}
 #endif
#endif

//==GetSysTime Readding ID:  == DON'T DELETE!! ==

#ifdef _GETSYSTIME_
 #ifndef  _GETSYSTIME_EXISTS_
  #define _GETSYSTIME_EXISTS_
  #include <jmkernel32.h>

  u32 GetSysTime(void){
  return GetSystemTime();
  }
 #endif
#endif

//==SetSysTime Readding ID:  == DON'T DELETE!! ==

#ifdef _SETSYSTIME_
 #ifndef  _SETSYSTIME_EXISTS_
  #define _SETSYSTIME_EXISTS_
  #include <jmkernel32.h>

  void SetSysTime(void){
    SetSystemTime();
  }
 #endif
#endif
//==Getdata Readding eeprom ==

#ifdef _GETDATA_
 #ifndef  _GETDATA_EXISTS_
  #define _GETDATA_EXISTS_
  #include <jmkernel32.h>

u16 GetData(int dataadr){
  if((dataadr>0)&&(dataadr<=156))
  return ReadEEP(dataadr);
  else
  return 888;
}
 #endif
#endif

//==Setdata write data to eeprom ==

#ifdef _SETDATA_
 #ifndef  _SETDATA_EXISTS_
  #define _SETDATA_EXISTS_
  #include <jmkernel32.h>

void SetData(int dataadr,int datacode)
{
	if(datacode>4095)datacode=4095;
	if((dataadr>0)&&(dataadr<=156))
	WriteEEP(dataadr,datacode);
}
 #endif
#endif

//==GetButton1 Readding ID:  == DON'T DELETE!! ==
#ifdef   _GETLEFTBUTTON_
#ifndef  _GETLEFTBUTTON_EXISTS_
#define _GETLEFTBUTTON_EXISTS_
#include <jmkernel32.h>
u8 GetLeftButton(void)
{  
 GPIO_Setting(GPIOB,3,GPIO_Mode_IPU);
 u8 value=GPIO_ReadInputDataBit(GPIOB,GPIO_Pin_3);
  if(value)      return 0;
  else      return 1;
}
#endif
#endif

//==GetButton2 Readding ID:  == DON'T DELETE!! ==
#ifdef   _GETRIGHTBUTTON_
#ifndef  _GETRIGHTBUTTON_EXISTS_
#define _GETRIGHTBUTTON_EXISTS_
#include <jmkernel32.h>
u8 GetRightButton(void)
{
 GPIO_Setting(GPIOB,4,GPIO_Mode_IPU);
 u8 value=GPIO_ReadInputDataBit(GPIOB,GPIO_Pin_4);
 if(value)      return 0;
  else      return 1;
}
#endif
#endif

#ifdef   _GETTOUCHSCREEN_
#ifndef  _GETTOUCHSCREEN_EXISTS_
#define _GETTOUCHSCREEN_EXISTS_
#include <jmkernel32.h>
u16 GetTouchScreen(void)
{
  //u16 m_value;
  //m_value= GetTouchValid();
  //return m_value;
	return ReadTouchState();
}
#endif
#endif

#ifdef   _GETTOUCHSCREENX_
#ifndef  _GETTOUCHSCREENX_EXISTS_
#define _GETTOUCHSCREENX_EXISTS_
#include <jmkernel32.h>
u16 GetTouchScreenX(void)
{
	return ReadTouchXFilter();
}
#endif
#endif

#ifdef   _GETTOUCHSCREENY_
#ifndef  _GETTOUCHSCREENY_EXISTS_
#define _GETTOUCHSCREENY_EXISTS_
#include <jmkernel32.h>
u16 GetTouchScreenY(void)
{
  u16 m_value;
	m_value=ReadTouchYFilter();
#if _TOUCH_TO_SCREEN_EN_ > 0
	if(TTSC_Flag)
	{
		if(m_value>320)m_value=320;
		if(m_value)m_value=321-m_value;
	}
#endif	
   return m_value;
}
#endif
#endif

#ifdef   _GETINMIC_
#ifndef  _GETINMIC_EXISTS_
#define _GETINMIC_EXISTS_
#include <jmkernel32.h>

u16 GetInMic(void)
{
u16 temp;
temp=ReadInMicVaule();
return temp;
}
#endif
#endif

#ifdef   _SETWAITFORLOUD_
#ifndef  _SETWAITFORLOUD_EXISTS_
#define _SETWAITFORLOUD_EXISTS_
#include <jmkernel32.h>

void SetWaitforLoud(int value)
{
	u16 temp;
	do
	{
		temp=ReadInMicVaule();
	}while(temp<value);
}
#endif
#endif

#ifdef   _SETWAITFORQUIET_
#ifndef  _SETWAITFORQUIET_EXISTS_
#define _SETWAITFORQUIET_EXISTS_
#include <jmkernel32.h>

void SetWaitforQuiet(int value)
{
	u16 temp;
	do
	{
		temp=ReadInMicVaule();
	}while(temp>value);
}
#endif
#endif

#ifdef   _SETWAITFORLOUDER_
#ifndef  _SETWAITFORLOUDER_EXISTS_
#define _SETWAITFORLOUDER_EXISTS_
#include <jmkernel32.h>

void SetWaitforLouder(int value)
{
u16 temp,org;
	org=ReadInMicVaule();
	do
	{
	temp=ReadInMicVaule();
	}while(temp<(org+value));
}
#endif
#endif

#ifdef   _SETWAITFORQUIETER_
#ifndef  _SETWAITFORQUIETER_EXISTS_
#define _SETWAITFORQUIETER_EXISTS_
#include <jmkernel32.h>

void SetWaitforQuieter(int value)
{
u16 temp,org;
	org=ReadInMicVaule();
	do
	{
	temp=ReadInMicVaule();
	}while(temp>(org-value));
}
#endif
#endif

#ifdef   _GETINVOTAGE_
#ifndef  _GETINVOTAGE_EXISTS_
#define _GETINVOTAGE_EXISTS_
#include <jmkernel32.h>

u16 GetInVotage(void)
{
u16 temp;
u32 m_Votage;
temp=ReadInVoltageVaule();
m_Votage=((temp*74)/10+400)/100;
return (u16)m_Votage;
}
#endif
#endif

//==SetLCDBack Readding ID:  == DON'T DELETE!! ==

#ifdef _SETINBEEP_
 #ifndef  _SETINBEEP_EXISTS_
  #define _SETINBEEP_EXISTS_
  #include <jmkernel32.h>

void SetInBeep(u8 state)
{
  Beep(state);
}
 #endif
#endif


#ifdef _SETMOTORSERVO_
 #ifndef  _SETMOTORSERVO_EXISTS_
  #define _SETMOTORSERVO_EXISTS_
  #include <jmkernel32.h>

void SetMotorServo(u8 which,int speed,s32 Angle)
{
Angle=abs(Angle);
Motor_Init();
MotorCodingInit();
SetMotorServoMode(which);
SetCodeServoAngle48(which,speed,Angle);
}
 #endif
#endif

#ifdef _SETMOTORSERVO128_
 #ifndef  _SETMOTORSERVO128_EXISTS_
  #define _SETMOTORSERVO128_EXISTS_
  #include <jmkernel32.h>

void SetMotorServo128(u8 which,int speed,s32 Angle)
{
Angle=abs(Angle);
Motor_Init();
MotorCodingInit();
SetMotorServoMode(which);
SetCodeServoAngle128(which,speed,Angle);
}
 #endif
#endif


#ifdef _SETWAITFORANGLE_
 #ifndef  _SETWAITFORANGLE_EXISTS_
  #define _SETWAITFORANGLE_EXISTS_
  #include <jmkernel32.h>

void SetWaitForAngle(u8 which,int speed,s32 Angle)
{
s32 m_Target=0,m_CV;
Angle=abs(Angle);
Motor_Init();
MotorCodingInit();
SetMotorServoMode(which);
SetCodeServoAngle48(which,speed,Angle);

m_Target = GetTMCP(which);

	do
	{
		switch(which)
		{
			case 1:m_CV=GetMotorCnt1();	break;
			case 2:m_CV=GetMotorCnt2();	break;
			case 3:m_CV=GetMotorCnt3();	break;
			case 4:m_CV=GetMotorCnt4();	break;
		}
		if((m_Target>=(m_CV-2))&&(m_Target<=(m_CV+2)))break;
  }while(1);
}
 #endif
#endif


#ifdef _SETWAITFORANGLE128_
 #ifndef  _SETWAITFORANGLE128_EXISTS_
  #define _SETWAITFORANGLE128_EXISTS_
  #include <jmkernel32.h>

void SetWaitForAngle128(u8 which,int speed,s32 Angle)
{
s32 m_Target=0,m_CV;
Angle=abs(Angle);
Motor_Init();
MotorCodingInit();
SetMotorServoMode(which);
SetCodeServoAngle128(which,speed,Angle);

m_Target = GetTMCP(which);

do{
    switch(which)
	{
	case 1:m_CV=GetMotorCnt1();	break;
	case 2:m_CV=GetMotorCnt2();	break;
	case 3:m_CV=GetMotorCnt3();	break;
	case 4:m_CV=GetMotorCnt4();	break;
	}

     if((m_Target>=(m_CV-2))&&(m_Target<=(m_CV+2)))break;

  }while(1);
}
 #endif
#endif

#ifdef _SETWAITFORPRESS_
 #ifndef  _SETWAITFORPRESS_EXISTS_
  #define _SETWAITFORPRESS_EXISTS_
  #include <jmkernel32.h>

void SetWaitForPress(u8 which)
{
   u32 port1=portarray[RcuPORT[which][1]];
   u8 bit1=RcuPIN[which][1];
   u8 value;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);
    do
    {
    value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==0);
   TouchClicks[which-1]++;
   Delay1ms(10);
}
 #endif
#endif

#ifdef _SETWAITFORRELEASE_
 #ifndef  _SETWAITFORRELEASE_EXISTS_
  #define _SETWAITFORRELEASE_EXISTS_
  #include <jmkernel32.h>

void SetWaitForRelease(u8 which)
{
   u32 port1=portarray[RcuPORT[which][1]];
   u8 bit1=RcuPIN[which][1];
   u8 value;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);
    do
    {
    value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==1);
   TouchClicks[which-1]++;
   Delay1ms(10);
}
 #endif
#endif

#ifdef _SETWAITFORBUMP_
 #ifndef  _SETWAITFORBUMP_EXISTS_
  #define _SETWAITFORBUMP_EXISTS_
  #include <jmkernel32.h>

void SetWaitForBump(u8 which)
{
   u32 port1=portarray[RcuPORT[which][1]];
   u8 bit1=RcuPIN[which][1];
   u8 value;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);
    do
    {
    value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==0);
    Delay1ms(10);
    do
    {
    value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    }while(value==1);
    TouchClicks[which-1]++;
    Delay1ms(10);
}
 #endif
#endif

#ifdef _GETNUMBEROFCLICKS_
 #ifndef  _GETNUMBEROFCLICKS_EXISTS_
  #define _GETNUMBEROFCLICKS_EXISTS_
  #include <jmkernel32.h>

u32 GetNumberOfClicks(u8 which)
{
    return TouchClicks[which-1];
}
 #endif
#endif
 
 
//==GetUltrasound (adr=04)Readding ID:  == DON'T DELETE!! == 

#ifdef _GETULTRASOUND_
 #ifndef  _GETULTRASOUND_EXISTS_
  #define _GETULTRASOUND_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
#define _ULTRASOUND_ADDR_		0X04
u16 GetUltrasound(u8 which)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u32 port3=portarray[RcuPORT[which][2]];//ADC
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];

   u16 data;
   u8  datah=0,datal=0,cmd=0,s=0,SUM=0,i;
   //OS_ENTER_CRITICAL();
 
	 //if(!mode)//IICģʽ
	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
   
   //ADģʽݳ߳,4095
  /* if(mode)//AD ģʽ
   {
		GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_AIN);
		data=GetAdcResult(which);
   }
   else //I2C ģʽ
   {//*/
	   for(i=0;i<3;i++)
   {
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);
      Soft_I2C_Write(&iic_typedef,0xaa);
      Soft_I2C_Stop(&iic_typedef);
      
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_+1);
      cmd=Soft_I2C_Read(&iic_typedef,0);  //ݿͷ
      if(cmd!=0xAA) cmd=Soft_I2C_Read(&iic_typedef,0);  //N76E003
      datah=Soft_I2C_Read(&iic_typedef,0);  //ݸ߰λ
      datal=Soft_I2C_Read(&iic_typedef,0);  //ڰλ
      s=Soft_I2C_Read(&iic_typedef,1);    //
      Soft_I2C_Stop(&iic_typedef);
      SUM=(uint8_t)(cmd+datah+datal);//У
      if(SUM==s)i=3;    //һζȡɹһΣɹ
    }
		
		//OS_EXIT_CRITICAL();
		SUM=(u8)(cmd+datah+datal);//У
		
		if(SUM!=s||cmd!=0xAA)//
		{
			data=999;
		}
		else
		{
			data=(u16)(((u16)datah<<8)|datal);	
		}
		RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
	//}
	
    return (u16)data;
}
 #endif
#endif


//==SetUltrasoundled (adr=04)Readding ID:  == DON'T DELETE!! == 

#ifdef _SETULTRASOUNDLED_
 #ifndef  _SETULTRASOUNDLED_EXISTS_
  #define _SETULTRASOUNDLED_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
#define _ULTRASOUND_ADDR_		0X04
u16 SetUltrasoundled(u8 which,u8 cmddata)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u32 port3=portarray[RcuPORT[which][2]];//ADC
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];

   //OS_ENTER_CRITICAL();
 
	 //if(!mode)//IICģʽ
	 RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	 Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
   

		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);
		Soft_I2C_Write(&iic_typedef,cmddata);
		Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
   
}
 #endif
#endif

//==GetDBCompoI Readding ID:0x02  == DON'T DELETE!! == 
//BE1727
#ifdef _GETCOMPOI_
 #ifndef  _GETCOMPOI_EXISTS_
  #define _GETCOMPOI_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
 
#define _COMPOI_ADDR_		0X02//I2C ַ
u8 GetCompoI(u8 which, u8 command)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	 RcuWhichMutexTake(which,1,0XFFFF);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_temp,m_fix;
    if(command<=15)
    {
    	if( command <= 7)
	{
	  switch(command)
	  {		
		case 1:m_fix = 7;		break;
		case 2:m_fix = 6;		break;
		case 3:m_fix = 5;		break;
		case 4:m_fix = 4;		break;
		case 5:m_fix = 3;		break;
		case 6:m_fix = 2;		break;
		case 7:m_fix = 1;		break;
	  }
	}
	else
	{
		m_fix = command;
	}

    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOI_ADDR_);//0x02
    Soft_I2C_Write(&iic_typedef,m_fix);
    Soft_I2C_Stop(&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOI_ADDR_+1);//0x03 
    m_temp=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef); 
		//OS_EXIT_CRITICAL();
    }
		RcuWhichMutexGive(which,1,0xffff);//ͷIIC˿ʹȨ
    if(m_fix == 8)
    {
		if(m_temp==255)return 255;
		return (8-m_temp);
    }
    else
    {
		return m_temp;
    }  
   
}
 #endif
#endif


//==GetCompassB Readding ID:0x76  == DON'T DELETE!! == ָ

#ifdef _GETCOMPASSB_
 #ifndef  _GETCOMPASSB_EXISTS_
  #define _GETCOMPASSB_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
#define _COMPOB_ADDR_		0X76//I2C ַ
u16 GetCompassB(u8 which)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,9999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    u8 low;
    u8 high;
    u16 angle;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOB_ADDR_);//
    Soft_I2C_Write(&iic_typedef,0x01);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_COMPOB_ADDR_+1);
    high=Soft_I2C_Read(&iic_typedef,0);
    low=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
//OS_EXIT_CRITICAL();
    if(high==1)
      angle=256+low;
    else
      if(high==0)
        angle=low;
      else
        angle=9999;
				RcuWhichMutexGive(which,1,angle);//ͷIIC˿ʹȨ
    return angle;
  }
 #endif
#endif

//==GETGETGSENSOR Readding ID:0xa6  == DON'T DELETE!! == ٶ

#ifdef _GETGSENSOR_
 #ifndef  _GETGSENSOR_EXISTS_
  #define _GETGSENSOR_EXISTS_
   #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
#define _GSENSOR_ADDR_  0xA6
//2:6.6ms;  4:9ms;  3:7.9ms
#define _GS_cnt_ 	4//ֵ˲>=2
void ADXL345_Write(Soft_I2C_Typedef *iic_typedef,u8 Reg,u8 Data)
{
//OS_ENTER_CRITICAL();
	Soft_I2C_Start(iic_typedef);
	Soft_I2C_Write(iic_typedef,_GSENSOR_ADDR_);
	Soft_I2C_Write(iic_typedef,Reg);
	Soft_I2C_Write(iic_typedef,Data);
	Soft_I2C_Stop(iic_typedef);
	//OS_EXIT_CRITICAL();
}
void gSense_Init(Soft_I2C_Typedef *iic_typedef)
{
	ADXL345_Write(iic_typedef,0x31, 0x00);	//òΧ
	ADXL345_Write(iic_typedef,0x2C, 0x0A);  //趨
	ADXL345_Write(iic_typedef,0x2D, 0x08);  //趨Դģʽ
	ADXL345_Write(iic_typedef,0x1E, 0x00);  //Xƫ 0 У
	ADXL345_Write(iic_typedef,0x1F, 0x00);  //Yƫ 0
	ADXL345_Write(iic_typedef,0x20, 0x0a);  //Zƫ 0 
}
int GetGSensor(u8 which,u8 axis)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,0XFFFF);//ȡ˿IICʹȨ
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	u8 i,j,m_temp[6];
	s16 GS_X,GS_Y,GS_Z;
	s8 g_x,g_y,g_z;
	s8 buf=0;
	s16 GS_Data[_GS_cnt_][3];  //ٶȵʷ¼˲
	u8 GS_idx;
	
	
	gSense_Init(&iic_typedef);//ʼ
	Delay1ms(2);
	
	for(GS_idx=0;GS_idx<_GS_cnt_;GS_idx++)
	{
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_GSENSOR_ADDR_);
		Soft_I2C_Write(&iic_typedef,0x32);
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,_GSENSOR_ADDR_+1);
		for(j=0;j<5;j++)m_temp[j]=Soft_I2C_Read(&iic_typedef,0);
		m_temp[5]=Soft_I2C_Read(&iic_typedef,1);
		Soft_I2C_Stop(&iic_typedef);

		GS_Data[GS_idx][0]	=	(m_temp[1]*256+m_temp[0]);
		GS_Data[GS_idx][1]	=	(m_temp[3]*256+m_temp[2]);
		GS_Data[GS_idx][2]	=	(m_temp[5]*256+m_temp[4]);
	}
	//OS_EXIT_CRITICAL();
	GS_X = 0;
	GS_Y = 0;
	GS_Z = 0;
	g_x = 0;
	g_y = 0;
	g_z = 0;
	
	for(i=0;i<_GS_cnt_;i++)
	{
		GS_X += GS_Data[i][0];
		GS_Y += GS_Data[i][1];
		GS_Z += GS_Data[i][2];
	}
	
	g_x	=(s8)(GS_X/4/_GS_cnt_);
	g_y	=(s8)(GS_Y/4/_GS_cnt_);
	g_z	=(s8)(GS_Z/4/_GS_cnt_);
	
	switch(axis)
	{
		case 1:buf=g_x;break;
		case 2:buf=g_y;break;
		case 3:buf=g_z;break;
	}
	RcuWhichMutexGive(which,1,buf);//ͷIIC˿ʹȨ
	return buf;
}
 #endif
#endif

#ifdef   _GETBLUETOOTH_
#ifndef  _GETBLUETOOTH_EXISTS_
#define  _GETBLUETOOTH_EXISTS_
#include <jmkernel32.h>

u16 GetBluetooth(void)  
{
   u16 m_temp;	
  //SetUsart1RxMode(0);//ͨģʽ
  m_temp = ReadBTData();
  return m_temp;
}

 #endif
#endif


#ifdef   _SETBLUETOOTH_
#ifndef  _SETBLUETOOTH_EXISTS_
#define  _SETBLUETOOTH_EXISTS_
#include <jmkernel32.h>

void SetBluetooth(u8 data)  
{
  SendBTData(data);
}

 #endif
#endif

//==SetBluetooth Readding ID:  == DON'T DELETE!! ==

#ifdef _SETWIFIDATA_
 #ifndef  _SETWIFIDATA_EXISTS_
  #define _SETWIFIDATA_EXISTS_

void SetWifiData(u8 data)
{
	SetWirelessData(data);
}
 #endif
#endif

//==GetBluetooth Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFIDATA_
 #ifndef  _GETWIFIDATA_EXISTS_
  #define _GETWIFIDATA_EXISTS_
 
u16 GetWifiData(void)
{
	return ReadWirelessData();
}
 #endif
#endif
//==SetFan Readding ID:  == DON'T DELETE!! == 

#ifdef _SETFAN_
 #ifndef  _SETFAN_EXISTS_
  #define _SETFAN_EXISTS_
  #include <jmkernel32.h>

void SetFan(u8 which,int speed)
{
speed=(u8)speed;
	if(speed==0)
	{
		SetMotorX(which,1,speed);
	}
   else if(speed<=100)
	{
		SetMotorX(which,2,speed);
	}
   else
	{
SetMotorX(which,0,256-speed);
	}  
}

 #endif
#endif


//==SetIR Readding ID:  == DON'T DELETE!! == ⷢ -PIN3

#ifdef _SETIR_
 #ifndef  _SETIR_EXISTS_
  #define _SETIR_EXISTS_
  #include <jmkernel32.h>

void SetIR(u8 which,u8 state)
{
   volatile unsigned long i=0;
   u32 port1=portarray[RcuPORT[which][0]];
   u32 port2=portarray[RcuPORT[which][1]];
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
   GPIO_ResetBits((GPIO_TypeDef*)port2,(1<<bit2));

	if(state>0)
	{
		for(i=0;i<11500;i++);//for(i=0;i<9999;i++);
		for(i=0;i<11500;i++);//11500-2ms
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);//delay24ms
		GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
		for(i=0;i<9999;i++);
    }
    GPIO_ResetBits((GPIO_TypeDef*)port1,( 1<<bit1));

}
 #endif
#endif


//==GetIRDete Readding ID:  == DON'T DELETE!! ==  PIN3

#ifdef _GETIRDETE_
 #ifndef  _GETIRDETE_EXISTS_
  #define _GETIRDETE_EXISTS_
  #include <jmkernel32.h>
  
u8 GetIRDete(u8 which)
{
    u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u8 bit1=RcuPIN[which][0];
	
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPU);
    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 0;
    else     return 1;
}
 #endif
#endif


//==GetIRDist Readding ID:  == DON'T DELETE!! == 

#ifdef _GETIRDIST_
 #ifndef  _GETIRDIST_EXISTS_
  #define _GETIRDIST_EXISTS_
  #include <jmkernel32.h>

u16 GetIRDist(u8 which)
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
    u16 i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);
    i=GetAdcResult(which);
    return (u16)i;
}
 #endif
#endif

//==GetInfrared Readding ID:  == DON'T DELETE!! == 

#ifdef _GETINFRARED_
 #ifndef  _GETINFRARED_EXISTS_
  #define _GETINFRARED_EXISTS_
  #include <jmkernel32.h>

u16 GetInfrared(u8 which)
{
    u32 port1=portarray[RcuPORT[which][0]];//SCL
	u8 bit1=RcuPIN[which][0];
	
	GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);//GPIO_Mode_IPU
    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 1;
    else     return 0;
}
 #endif
#endif

//==GetRemoIR Readding ID:  == DON'T DELETE!! == 

#ifdef _GETREMOIR_
 #ifndef  _GETREMOIR_EXISTS_
  #define _GETREMOIR_EXISTS_
  #include <jmkernel32.h>
  

u16 GetRemoIR(u8 which)
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
    u16 i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);
    i=GetAdcResult(which);
    return (u16)i;
}
 #endif
#endif


//==GetVolume Readding ID:  == DON'T DELETE!! == ˷

#ifdef _GETVOLUME_
 #ifndef  _GETVOLUME_EXISTS_
  #define _GETVOLUME_EXISTS_
  #include <jmkernel32.h>

u16 GetVolume(u8 which)
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
    u16 i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);
    i=GetAdcResult(which);
    return (u16)i;
}
 #endif
#endif

//==GetVoltage Readding ID:  == DON'T DELETE!! == ѹ
//ѹʽVin=Vout/0.091λ=Vout*1000/91
//0.0~30.0
#ifdef _GETVOLTAGE_
 #ifndef  _GETVOLTAGE_EXISTS_
  #define _GETVOLTAGE_EXISTS_
  #include <jmkernel32.h>

u16 GetVoltage(u8 which)//mV
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
	u32 adc;
	u32 m_Voltage;
	u8 i;
	u32 s=0;

    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);

	for(i=0;i<5;i++)
	{
		adc=GetAdcResult(which);
		s+=adc;
	}
	adc=s/5;
	
	m_Voltage=(u32)((adc*80586)/91)/10000;//(((temp*3300*1000)/4095)/91);
	
    return (u16)m_Voltage;
}
 #endif
#endif

//==GetCurrent Readding ID:  == DON'T DELETE!! == 
//ʽI=|(Vout-2.5)/0.185 λС2.5VǸ
//-4.0~4.0A
#ifdef _GETCURRENT_
 #ifndef  _GETCURRENT_EXISTS_
  #define _GETCURRENT_EXISTS_
  #include <jmkernel32.h>
  
int GetCurrent(u8 which)
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
	u16 adc;
	float buf;
	s16 m_current;
	u8 i;
	u32 s=0;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);

    for(i=0;i<5;i++)
	{
		adc=GetAdcResult(which);
		s+=adc;
	}
	adc=s/5;
	
	buf=(float)(adc*80.586);//(u32)(adc*3300)/4095
	buf-=250000;
	m_current=(s16)(buf/185)/10;
	
    return (int)m_current;
}
 #endif
#endif


//==GetPhoto Readding ID:  == DON'T DELETE!! == 

#ifdef _GETPHOTO_
 #ifndef  _GETPHOTO_EXISTS_
  #define _GETPHOTO_EXISTS_
  #include <jmkernel32.h>

u16 GetPhoto(u8 which)
{
    u32 port1=portarray[RcuPORT[which][2]];//ADC
	u8 bit1=RcuPIN[which][2];
	
    u16 i;
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_AIN);
    i=GetAdcResult(which);
    return (u16)i;
  }
 #endif
#endif

//==GetMagnet Readding ID:  == DON'T DELETE!! ==  PIN3

#ifdef _GETMAGNET_
 #ifndef  _GETMAGNET_EXISTS_
  #define _GETMAGNET_EXISTS_
  #include <jmkernel32.h>
  
u8 GetMagnet(u8 which)
{
    u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u8 bit1=RcuPIN[which][0];
	
    GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPU);
    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
    if(value) return 0;
    else     return 1;
}
 #endif
#endif


//==GetDTHSensor Readding ID:  == DON'T DELETE!! == ʪ PIN4
// digital temperature and humidity sensor
//0: Humidity
//1: Temperature
#ifdef _GETDTHSENSOR_
 #ifndef  _GETDTHSENSOR_EXISTS_
  #define _GETDTHSENSOR_EXISTS_
	#include <jmkernel32.h>
	#include"DTHSensor.h"
u16 GetDTHSensor(u8 which,int mode)
{
    u32 port1=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][1];
	u16 value;
	u8 i,j;
	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	WIRE_PORT=port1;
	WIRE_BIT=bit1;
	i=0;j=20;
	do
	{
		os_task_enter_critical();
		i=GetDHT11Data(mode,&value);
		os_task_exit_critical();
		if(j>0)j--;
		else {i=1;j=0;}
	}while(i==0);
	
	RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
	return (u16)value;
  }
 #endif
#endif

//==GetAirQuality  Readding ID: 0xa0 == DON'T DELETE!! == 

#ifdef _GETAIRQUALITY_
 #ifndef  _GETAIRQUALITY_EXISTS_
  #define _GETAIRQUALITY_EXISTS_
	#include <jmkernel32.h>
  #include "I2C_Soft.h"
#define _AQ_ADDR_		0XA1//I2C ַ
u8 GetAirQuality(u8 which)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	
	u8 data;
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,0XFFFF);//ȡ˿IICʹȨ
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0XA1);//0XA1
	data=Soft_I2C_Read(&iic_typedef,1);
	Soft_I2C_Stop(&iic_typedef);
	RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
	//OS_EXIT_CRITICAL();
	return (u8)data;
  }
 #endif
#endif

//==GetMusicPlayer  Readding ID: 0xa0 == DON'T DELETE!! == 

#ifdef _SETMUSICPLAYER_
 #ifndef  _SETMUSICPLAYER_EXISTS_
  #define _SETMUSICPLAYER_EXISTS_
	#include <jmkernel32.h>
  #include "I2C_Soft.h"
#define _MUSICPLAY_ADDR_		0x0E//I2C ַ
void SetMusicPlayer(u8 which, int cmd)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	u16 i;
	//OS_ENTER_CRITICAL();
 
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef, _MUSICPLAY_ADDR_);
	Soft_I2C_Write(&iic_typedef,cmd);
	Soft_I2C_Stop(&iic_typedef);	
	RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
	//OS_EXIT_CRITICAL();
  }
 #endif
#endif

//==GetIR Readding ID:  == DON'T DELETE!! == ⷢһ

#ifdef _GETIR_
 #ifndef  _GETIR_EXISTS_
  #define _GETIR_EXISTS_
  #include <jmkernel32.h>

u8 GetIR(u8 whichs,u8 whichr,u8 state)
{
   volatile unsigned long i=0;
   u32 port1=portarray[RcuPORT[whichs][0]];//I2C_SCL
   u8 bit1=RcuPIN[whichs][0];
   u32 port2=portarray[RcuPORT[whichr][0]];//I2C_SCL
   u8 bit2=RcuPIN[whichr][0];
	 
   RcuWhichMutexTake(whichs,1,0);
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
	if(state>0)
	{
		for(i=0;i<11500;i++);//11500-2ms
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		for(i=0;i<11500;i++);
		GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
		for(i=0;i<9999;i++);
    }
    GPIO_ResetBits((GPIO_TypeDef*)port1,( 1<<bit1));
	
    GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_IPU);
    u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port2,(1<<bit2));
		RcuWhichMutexGive(whichs,1,0);
    if(value) return 0;
    else     return 1;
}
 #endif
#endif

#ifdef   _SETWAITFORBLUETOOTH_
 #ifndef  _SETWAITFORBLUETOOTH_EXISTS_
 #define  _SETWAITFORBLUETOOTH_EXISTS_
   #include <jmkernel32.h>

void SetWaitForBluetooth(u8 data)  
{
	u16 m_temp;	
	do
	{
		m_temp = ReadBTData();
	}while(m_temp!=data);
}

 #endif
#endif


#ifdef   _SETWAITFORWIFIDATA_
 #ifndef  _SETWAITFORWIFIDATA_EXISTS_
 #define  _SETWAITFORWIFIDATA_EXISTS_
   #include <jmkernel32.h>

void SetWaitForWifiData(u8 data)  
{
	u16 m_temp;	
	do
	{
		m_temp = ReadWirelessData();
	}while(m_temp!=data);
}

 #endif
#endif

#ifdef _SETPIDMOTOR_
 #ifndef  _SETPIDMOTOR_EXISTS_
 #define _SETPIDMOTOR_EXISTS_
 #include <jmkernel32.h>

void SetPIDMotor(u8 which,u8 speed)
{
	Motor_Init();
	MotorPIDTime_Init();
	MotorCodingInit();
	SetMotorPIDMode(which);
	SetPIDSpeed(which,speed);
}
 #endif
#endif

#ifdef _SETPIDMOTORREF_
 #ifndef  _SETPIDMOTORREF_EXISTS_
 #define _SETPIDMOTORREF_EXISTS_
 #include <jmkernel32.h>

void SetPIDMotorRef(u8 pulse)
{
	SetFullSpeedRef(pulse);
}
 #endif
#endif

//------BE2560-ʱģ-----------------------------

//==calendar Readding adr:07  == DON'T DELETE!! ==

#ifdef _GETCALENDAR_
 #ifndef  _GETCALENDAR_EXISTS_
  #define _GETCALENDAR_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

unsigned char GetCalendar(u8 which, unsigned char command)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,88);//ȡ˿IICʹȨ
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char data;
    unsigned char temph,templ;
    unsigned char ack=1;    
	if((command>=30)&&(command<=41))
  {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);
		Soft_I2C_Stop(&iic_typedef);
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x0f);     
		data=Soft_I2C_Read(&iic_typedef,1);
		Soft_I2C_Stop(&iic_typedef); 
		//OS_EXIT_CRITICAL();
		if(command<37)
		{
			templ=data;
			temph=data;
			templ=templ&0x0f;       
			temph=temph>>4;
			data=temph*10+templ;
		}
		//return data;
  }
	else
	{
		data=88;//return 88;
	}
	RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
	return data;
}
 #endif
#endif

//==calendar write adr:07  == DON'T DELETE!! ==

#ifdef _SETCALENDAR_
 #ifndef  _SETCALENDAR_EXISTS_
  #define _SETCALENDAR_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetCalendar(u8 which, unsigned char sec,unsigned char min,unsigned char hour,unsigned char date,unsigned char month,unsigned char year)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[4];
    unsigned long temp;
    unsigned int temp1;
    
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,49);    //COMMAND=49
    ack &=Soft_I2C_Write(&iic_typedef,year);    
    ack &=Soft_I2C_Write(&iic_typedef,month);
    ack &=Soft_I2C_Write(&iic_typedef,date);
    ack &=Soft_I2C_Write(&iic_typedef,hour); 
    ack &=Soft_I2C_Write(&iic_typedef,min);
    ack &=Soft_I2C_Write(&iic_typedef,sec);     
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
 }
 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD1_
 #ifndef  _SETBE2560LCD1_EXISTS_
  #define _SETBE2560LCD1_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetBE2560LCD1(u8 which, unsigned char command,unsigned char lx,unsigned char lxdchar)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1;
    unsigned char led;
 
	if(command==50)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);  
		ack &=Soft_I2C_Write(&iic_typedef,lx);   
		ack &=Soft_I2C_Write(&iic_typedef,lxdchar); 
		Soft_I2C_Stop(&iic_typedef);
    }
	if(command==54)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command); 
		Soft_I2C_Stop(&iic_typedef);
    }
	if(command==55)
    {
		Soft_I2C_Start(&iic_typedef);
		ack &=Soft_I2C_Write(&iic_typedef,0x0e);
		ack &=Soft_I2C_Write(&iic_typedef,command);    
		ack &=Soft_I2C_Write(&iic_typedef,lx); 
		Soft_I2C_Stop(&iic_typedef);
    }
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
 }

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560BACK_
 #ifndef  _SETBE2560BACK_EXISTS_
  #define _SETBE2560BACK_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetBE2560Back(u8 which, unsigned char led)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1;
    
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,53);    
    ack &=Soft_I2C_Write(&iic_typedef,led); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
    
}

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD3_
 #ifndef  _SETBE2560LCD3_EXISTS_
  #define _SETBE2560LCD3_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetBE2560LCD3(u8 which, unsigned char lx,unsigned int lxdint)
{
    u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[2];
    unsigned int temp1;

    temp1=lxdint;
    buf[0]=(unsigned char)temp1;
    temp1=lxdint;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,51);
    ack &=Soft_I2C_Write(&iic_typedef,lx);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
}

 #endif
#endif

//== write calendaradr lcd:07  == DON'T DELETE!! ==

#ifdef _SETBE2560LCD8_
 #ifndef  _SETBE2560LCD8_EXISTS_
  #define _SETBE2560LCD8_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetBE2560LCD8(u8 which, unsigned char lx,unsigned long lxdlong)
{
    u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[4];
    unsigned long temp1;
	
    temp1=lxdlong;
    buf[0]=(unsigned char)temp1;

    temp1=lxdlong;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;

    temp1=lxdlong;
    temp1=temp1>>16;
    buf[2]=(unsigned char)temp1;

    temp1=lxdlong;  
    temp1=temp1>>24;
    buf[3]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,52);
    ack &=Soft_I2C_Write(&iic_typedef,lx);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[2]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[3]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
 }

 #endif
#endif

//== set calendaradr speaker:07  == DON'T DELETE!! ==

#ifdef _SETBE2560SPK_
 #ifndef  _SETBE2560SPK_EXISTS_
  #define _SETBE2560SPK_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"

void SetBE2560spk(u8 which, unsigned char time,unsigned int freq)
{
    u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	//OS_ENTER_CRITICAL();

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char ack=1; 
    unsigned char buf[2];
    unsigned int temp1;
    
    temp1=freq;
    buf[0]=(unsigned char)temp1;
    temp1=freq;  
    temp1=temp1>>8;
    buf[1]=(unsigned char)temp1;
    Soft_I2C_Start(&iic_typedef);
    ack &=Soft_I2C_Write(&iic_typedef,0x0e);
    ack &=Soft_I2C_Write(&iic_typedef,56);
    ack &=Soft_I2C_Write(&iic_typedef,time);     
    ack &=Soft_I2C_Write(&iic_typedef,buf[0]); 
    ack &=Soft_I2C_Write(&iic_typedef,buf[1]); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
  //OS_EXIT_CRITICAL();
 }

 #endif
#endif
//------------------------------------------
//==SETTOUCHTOSCREENCOORDINATE Readding ID:  == DON'T DELETE!! ==

#ifdef _SETTOUCHTOSCREENCOORDINATE_
 #ifndef  _SETTOUCHTOSCREENCOORDINATE_EXISTS_
  #define _SETTOUCHTOSCREENCOORDINATE_EXISTS_
  
void SetTouchToScreenCoordinate(void)
{
  #if _TOUCH_TO_SCREEN_EN_ > 0
	TTSC_Flag=1;
  #endif
}
 #endif
#endif

//==SETAHRS Readding ID:  == DON'T DELETE!! == 

#ifdef _SETAHRS_
 #ifndef  _SETAHRS_EXISTS_
  #define _SETAHRS_EXISTS_
  
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
void SetAHRS(u8 which,u8 command)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0x3a);//addr
	Soft_I2C_Write(&iic_typedef,0xaa);
	Soft_I2C_Write(&iic_typedef,0x55);
	Soft_I2C_Write(&iic_typedef,command);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0);
	Soft_I2C_Write(&iic_typedef,0xcf);
	Soft_I2C_Stop(&iic_typedef);
	RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
	//OS_EXIT_CRITICAL();
	Delay1ms(1000);
}
 #endif
#endif

//==GETAHRS Readding ID:  == DON'T DELETE!! == 

#ifdef _GETAHRS_
 #ifndef  _GETAHRS_EXISTS_
  #define _GETAHRS_EXISTS_
  
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
  s16 g_AhrsRecBuf[8][9];
  u8 g_AhrsRecBufCnt[8];
  u8 g_AhrsFistRxFlag[8];
  u8 g_LastCmdList[8][9];
s16 GetAHRSRecBuf(u8 which,u8 cnt)//Ѿ򷵻8888
{
	s16 buf;
	if(cnt>8)return 9999;//cnt=9-1
	buf=g_AhrsRecBuf[which][cnt];
	g_AhrsRecBuf[which][cnt]=8888;
	if(buf!=8888)
	{
		g_AhrsRecBufCnt[which]++;
		g_LastCmdList[which][cnt]=1;
	}
	if(g_AhrsRecBufCnt[which]>8)//Ѿȫ
	{
		g_AhrsRecBufCnt[which]=0;
		g_AhrsFistRxFlag[which]=0;
	}
	return buf;
}
s16 GetAHRS(u8 which,u8 command1,u8 command2)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
	u8 i,j;
	u8 ACK=0;
	s16 m_data;
	u8 m_AhrsRecBufList[22];
	u8 m_Rxflag=0;//һ
	u8 whichx=which-1;
	//OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,9999);//ȡ˿IICʹȨ
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	if(g_AhrsFistRxFlag[whichx]==0||command2||g_LastCmdList[whichx][command1-1])
	{
		m_Rxflag=1;//һλ
		if(command2==0)g_AhrsFistRxFlag[whichx]=1;
		else g_AhrsFistRxFlag[whichx]=0;
		for(i=0;i<9;i++)	{g_LastCmdList[whichx][i]=0;}//
		
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x3b);//addr
		for(i=0;i<22;i++)
		{
			if(i==21) ACK =1;
			else  ACK = 0;
			m_AhrsRecBufList[i]=Soft_I2C_Read(&iic_typedef,ACK);  
		}  
		Soft_I2C_Stop(&iic_typedef);
	}
	//OS_EXIT_CRITICAL();
	if(m_Rxflag)//һ
    {
		g_AhrsRecBufCnt[whichx]=0;
		if(m_AhrsRecBufList[0]==0xaa && m_AhrsRecBufList[1]==0x55 && m_AhrsRecBufList[21]==0xcf)//ȷݰ
		{
			g_AhrsFistRxFlag[whichx]=2;
			g_AhrsRecBuf[whichx][0]=(s16)(m_AhrsRecBufList[2])|((s8)m_AhrsRecBufList[3]<<8);//roll// degreeŴ10
			g_AhrsRecBuf[whichx][1]=(s16)(m_AhrsRecBufList[4])|((s8)m_AhrsRecBufList[5]<<8);//pitch// degreeŴ10
			g_AhrsRecBuf[whichx][2]=(s16)(m_AhrsRecBufList[6])|((s8)m_AhrsRecBufList[7]<<8);//yaw//ƫ degreeŴ10
			g_AhrsRecBuf[whichx][3]=(s16)(m_AhrsRecBufList[8])|((s8)m_AhrsRecBufList[9]<<8);//ax//ٶX gŴ100
			g_AhrsRecBuf[whichx][4]=(s16)(m_AhrsRecBufList[10])|((s8)m_AhrsRecBufList[11]<<8);//ay//ٶY gŴ100
			g_AhrsRecBuf[whichx][5]=(s16)(m_AhrsRecBufList[12])|((s8)m_AhrsRecBufList[13]<<8);//az//ٶZ gŴ100
			g_AhrsRecBuf[whichx][6]=(s16)(m_AhrsRecBufList[14])|((s8)m_AhrsRecBufList[15]<<8);//gx//X  dpsŴ100
			g_AhrsRecBuf[whichx][7]=(s16)(m_AhrsRecBufList[16])|((s8)m_AhrsRecBufList[17]<<8);//gy//Y  dpsŴ100
			g_AhrsRecBuf[whichx][8]=(s16)(m_AhrsRecBufList[18])|((s8)m_AhrsRecBufList[19]<<8);//gz//Z  dpsŴ100
		}
		else 
		{
			g_AhrsFistRxFlag[whichx]=0;
			return 9999;//յݰ
		}
		m_AhrsRecBufList[0]=0;		
		m_AhrsRecBufList[1]=0; 		
		m_AhrsRecBufList[21]=0;
   }
   if(g_AhrsFistRxFlag[whichx]==2)  m_data=GetAHRSRecBuf(whichx,command1-1);//command1=1~9
   else m_data=9999;
	 RcuWhichMutexGive(which,1,m_data);//ͷIIC˿ʹȨ
   return (s16)m_data;
}
 #endif
#endif

#ifdef _SETEXTBLUETOOTHMODE_
 #ifndef  _SETEXTBLUETOOTHMODE_EXISTS_
  #define _SETEXTBLUETOOTHMODE_EXISTS_
  
	#include "jmkernel32.h"
	#include "bluetooth.h"
	
u8 SetExtBluetoothMode(u8 *name,u8 *mode,u8 *pswd)
{
	return ExtBT_Config(name,mode,pswd);
}

 #endif
#endif

#ifdef _SETEXTBLUETOOTH_
 #ifndef  _SETEXTBLUETOOTH_EXISTS_
  #define _SETEXTBLUETOOTH_EXISTS_
  
	#include "jmkernel32.h"
	#include "bluetooth.h"
	
void SetExtBluetooth(u8 data)
{
	SendExtBTData(data);
}

 #endif
#endif

#ifdef _GETEXTBLUETOOTH_
 #ifndef  _GETEXTBLUETOOTH_EXISTS_
  #define _GETEXTBLUETOOTH_EXISTS_
  
	#include "jmkernel32.h"
	#include "bluetooth.h"
	
u16 GetExtBluetooth(void)
{
	return ReadExtBTData();
}

 #endif
#endif

#ifdef _SETEXTBLUETOOTHCMD_
 #ifndef  _SETEXTBLUETOOTHCMD_EXISTS_
  #define _SETEXTBLUETOOTHCDM_EXISTS_
  
	#include "jmkernel32.h"
	#include "bluetooth.h"
	
u8 SetExtBluetoothCmd(u8 mode,u8 *strcmd,u8 *str)
{
	return ExtBT_AT_SetCmd(mode,strcmd,str);
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERBUTTON_
 #ifndef  _GETREMOTECONTROLLERBUTTON_EXISTS_
  #define _GETREMOTECONTROLLERBUTTON_EXISTS_
  
	#include "jmkernel32.h"
//0~19,20~39:0~39,40:ȫֵ
u32 GetRemoteControllerButton(void)//
{
	Joystick_Init();
	//26bit=1,0~19bit0~19,26bit=1,0~19bit20~39;
	//27bit=1,3Dģʽ,27bit=0,ͨģʽ;
	//20~25bit
	return ReadJSButtonData(0);//0 1~4ֵ(32Bit),1~41~4ֵ(8Bit)
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERBUTTONSTATE_
 #ifndef  _GETREMOTECONTROLLERBUTTONSTATE_EXISTS_
  #define _GETREMOTECONTROLLERBUTTONSTATE_EXISTS_
  
	#include "jmkernel32.h"
//0~19,20~39:0~39
u16 GetRemoteControllerButtonState(void)//ؼֵ
{
	u32 m_buf=0;
	u8 i,flag=0;
	Joystick_Init();
	m_buf=ReadJSButtonData(0);	//0 1~4ֵ(32Bit),1~41~4ֵ(8Bit)
	if((m_buf&0x000fffff)==0)return 999;//ûа 
	if(m_buf&(0x04000000))flag=1;
	for(i=0;i<20;i++)
	{
		if(m_buf&(1<<i))
		{
			if(flag)return (i+20);
			else return i;
		}
	}
	return 999;
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLERROCKER_
 #ifndef  _GETREMOTECONTROLLERROCKER_EXISTS_
  #define _GETREMOTECONTROLLERROCKER_EXISTS_
  
	#include "jmkernel32.h"
	//dir=0 left,dir=1 right, axis=0 x,  axis=1 y
u32 GetRemoteControllerRocker(u8 dir,u8 axis)//ҡֵ
{
	Joystick_Init();
	if(dir==0)
	{
		if(axis==0)return ReadJSRockerData(1);
		else return ReadJSRockerData(2);
	}
	else
	{
		if(axis==0)return ReadJSRockerData(3);
		else return ReadJSRockerData(4);
	}
}

 #endif
#endif


#ifdef _GETREMOTECONTROLLERGRAVITY_
 #ifndef  _GETREMOTECONTROLLERGRAVITY_EXISTS_
  #define _GETREMOTECONTROLLERGRAVITY_EXISTS_

	#include "jmkernel32.h"
	//i=1 x,i=2 y,i=3 z
s16 GetRemoteControllerGravity(u8 i)//ȡٶ
{
	u16 m_val;
	Joystick_Init();
	m_val=ReadJSGravityData(i+3);
	if(m_val==999)return 999;
	return (s8)m_val;
}

 #endif
#endif

#ifdef _GETREMOTECONTROLLEREULERIAN_
 #ifndef  _GETREMOTECONTROLLEREULERIAN_EXISTS_
  #define _GETREMOTECONTROLLEREULERIAN_EXISTS_

	#include "jmkernel32.h"

u16 g_QLastList[4];
s16 g_RollLast,g_PitchLast,g_YawLast;

//i=1 Roll,2 Pitch,3 Yaw
s16 GetRemoteControllerEulerian(u8 i)//ȡŷ
{
	s16 m_val=0;
	float quartf[4];
	s32 q0,q1,q2,q3;
	Joystick_Init();
	if(ReadJSQuartfData(&q0,&q1,&q2,&q3)==0)
	{
		g_QLastList[0]=0;
		g_QLastList[1]=0;
		g_QLastList[2]=0;
		g_QLastList[3]=0;
		g_RollLast=0;g_PitchLast=0;g_YawLast=0;
		return 999;
	}
	if(g_QLastList[0]!=q0||g_QLastList[1]!=q1||g_QLastList[2]!=q2||g_QLastList[3]!=q3)
	{
		quartf[0] = q0/1073741824.0;  
		quartf[1] = q1/1073741824.0;
		quartf[2] = q2/1073741824.0;
		quartf[3] = q3/1073741824.0;
	}
	switch(i)
	{
		case 1:// Roll
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (s16)g_RollLast;
			m_val = atan2(2*(quartf[2]*quartf[3]+quartf[0]*quartf[1]),\
					quartf[0]*quartf[0]-quartf[1]*quartf[1]-quartf[2]*quartf[2]+quartf[3]*quartf[3])*57.3;
			g_RollLast=m_val;
		}break;
		case 2:// Pitch
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (s16)g_PitchLast;
			m_val = asin(-2*(quartf[1]*quartf[3]-quartf[0]*quartf[2]))*57.3;
			g_PitchLast=m_val;
		}break;
		case 3:// Yaw
		{
			if(g_QLastList[0]==q0&&g_QLastList[1]==q1&&g_QLastList[2]==q2&&g_QLastList[3]==q3)return (s16)g_YawLast;
			m_val = atan2(2*(quartf[1]*quartf[2]+quartf[0]*quartf[3]),\
			quartf[0]*quartf[0]+quartf[1]*quartf[1]-quartf[2]*quartf[2]-quartf[3]*quartf[3])*57.3;
			g_YawLast=m_val;
		}break;
	}
	return (s16)m_val;
}

 #endif
#endif

#ifdef _SETMOTORDIRECTION_
 #ifndef  _SETMOTORDIRECTION_EXISTS_
 #define _SETMOTORDIRECTION_EXISTS_
 #include <jmkernel32.h>

void SetMotorDirection(u8 dir,u8 speed)//dir 0:left 1:right ;speed 0~10
{

}
 #endif
#endif


//==SetLCDSolidCircle Readding ID:  == DON'T DELETE!! == ʵԲ

#ifdef _SETLCDSOLIDCIRCLE_
 #ifndef  _SETLCDSOLIDCIRCLE_EXISTS_
  #define _SETLCDSOLIDCIRCLE_EXISTS_
 #include <jmkernel32.h>
#include "LCD320240.h"
  
void SetLCDSolidCircle(int x,int y,u16 radius,u16 color)
{
	u16 xs,xe,ix,ys,ye,iy,yb,ib;
	if(x>radius)xs=x-radius;
	else xs=0;
	xe=x+radius;
	SetBackLed(g_LcdBackLignt);
	for(ix=xs;ix<=xe;ix++)
	{
		if(ix>x)	ib=sqrt(radius*radius-(ix-x)*(ix-x));
		else ib=sqrt(radius*radius-(x-ix)*(x-ix));
		if(y>ib)ys=y-ib;
		else ys=0;
		ye=y+ib;
		if(ye>319)ye=319;
		LCD_DrawRectangle( ix,ys,ix, ye, color);
	}
}
 #endif
#endif

//==SetLCDFilledRectangle Readding ID:  == DON'T DELETE!! == ʵľ

#ifdef _SETLCDFILLEDRECTANGLE_
 #ifndef  _SETLCDFILLEDRECTANGLE_EXISTS_
  #define _SETLCDFILLEDRECTANGLE_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDFilledRectangle(int x1,int y1,int x2,int y2,u16 color)
{
	SetBackLed(g_LcdBackLignt);
	LCD_DrawRectangle(x1,y1,x2,y2,color);
}
 #endif
#endif

//==SetLCDRectangle Readding ID:  == DON'T DELETE!! == 

#ifdef _SETLCDRECTANGLE_
 #ifndef  _SETLCDRECTANGLE_EXISTS_
  #define _SETLCDRECTANGLE_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDRectangle(int x1,int y1,int x2,int y2,int w,u16 color)
{
	u8 wmx,wmy,wm;
	wmx=x2-x1;
	wmy=y2-y1;
	wm=(wmx<wmy)?wmx:wmy;
	if(w>wm)w=wm;
	if(w>0)w-=1;
	SetBackLed(g_LcdBackLignt);
	LCD_DrawRectangle( x1,y1,x2,y1+w, color);
	LCD_DrawRectangle( x1,y1+w,x1+w, y2, color);
	LCD_DrawRectangle( x1+w,y2-w,x2, y2, color);
	LCD_DrawRectangle( x2-w,y1+w,x2, y2-w, color);
}
 #endif
#endif


//==GetColorSensor Readding ID:  == DON'T DELETE!! == BE1130
//STM8 addr 10bit//N76E003 addr 8bit
#ifdef _GETCOLORSENSOR_
 #ifndef  _GETCOLORSENSOR_EXISTS_
  #define _GETCOLORSENSOR_EXISTS_
  
  #include "I2C_Soft.h"
 u8 MCUN76E003FirstByte; 
u32 GetColorSensor(u8 which,u8 cmd)
{   
  u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
  u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
  u8 bit1=RcuPIN[which][0];
  u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  u32 m_val=0;
  u8 m_val1=0, m_val2=0, m_val3=0;
  u8 m_bit1=0, m_bit2=0;
  u8 first=0,end=0;
  u8 m_id=0;
  u8 sum=0,m_para1=0,m_para2=0;
  u8 addrh,addrl;
  u8 id=1;
  u8 addr;
  
   RcuWhichMutexGive(which,1,MCUN76E003FirstByte);//ͷIIC˿ʹȨ

    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
    MCUN76E003FirstByte=Soft_I2C_Read(&iic_typedef,1);//0xA9
    Soft_I2C_Stop(&iic_typedef);//ֹͣλ
    if(MCUN76E003FirstByte==0xA9)  //N76E0037bitַ
    {
         addr=id+0xA8-1;//0xA8

          //FistByte+cmd+parameter1+parameter2+sum
          Soft_I2C_Start(&iic_typedef);
        //  Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
          Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
          Soft_I2C_Write(&iic_typedef,0xFA);//0
          Soft_I2C_Write(&iic_typedef,cmd);//2
           Soft_I2C_Stop(&iic_typedef);//ֹͣλ
        //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
        //if(cmd<20&&cmd>0)//

        if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
        {
          Soft_I2C_Start(&iic_typedef);//ظʼλ
          Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);
          m_id=Soft_I2C_Read(&iic_typedef,0);
          m_val1=Soft_I2C_Read(&iic_typedef,0);
          if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
          {
            m_val2=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=8;m_bit2=0;
          }
          if(cmd==5)
          {
            m_val3=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=16;m_bit2=8;
          }
          end=Soft_I2C_Read(&iic_typedef,1);
        }
        Soft_I2C_Stop(&iic_typedef);//ֹͣλ

        //OS_EXIT_CRITICAL();
        sum=m_id+m_val1+m_val2+m_val3;//Уͼ

        if(first==0xEA&&sum==end&&m_id==addr)
        {
          m_val=(u32)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
        }
        else
        {
          m_val=999;
        }
        RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
        return m_val;

    }
    else
    {
            addr=id+0x50-1;//0xf650~0xf657

         //FistByte+cmd+parameter1+parameter2+sum
          Soft_I2C_Start(&iic_typedef);
          Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
          Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
          Soft_I2C_Write(&iic_typedef,0xFA);//0
          Soft_I2C_Write(&iic_typedef,cmd);//2

          //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
          //if(cmd<20&&cmd>0)//
         if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
         {
             Soft_I2C_Start(&iic_typedef);//ظʼλ
             Soft_I2C_Write(&iic_typedef,0xf7);//SlaveAddr|0x01
             first=Soft_I2C_Read(&iic_typedef,0);
             m_id=Soft_I2C_Read(&iic_typedef,0);//Ͱλַ
             m_val1=Soft_I2C_Read(&iic_typedef,0);
            if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
           {
                m_val2=Soft_I2C_Read(&iic_typedef,0);
              m_bit1=8;m_bit2=0;
            }
             if(cmd==5)
           {
               m_val3=Soft_I2C_Read(&iic_typedef,0);
               m_bit1=16;m_bit2=8;
            }
           end=Soft_I2C_Read(&iic_typedef,1);
         }
          Soft_I2C_Stop(&iic_typedef);//ֹͣλ

          //OS_EXIT_CRITICAL();
          sum=m_id+m_val1+m_val2+m_val3;//Уͼ

         if(first==0xEA&&sum==end&&m_id==addr)
         {
            m_val=(u32)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
         }
          else
          {
            m_val=999;
         }
         RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
         return m_val;
    }

}
 #endif
#endif




//==GetColorSensorRGB Readding ID:  == DON'T DELETE!! == BE1130
//addr 10bit
#ifdef _GETCOLORSENSORRGB_
 #ifndef  _GETCOLORSENSORRGB_EXISTS_
  #define _GETCOLORSENSORRGB_EXISTS_
  
  #include "I2C_Soft.h"
 u8 GetMCUN76E003FirstByteRGB; //ɫר
u32 GetColorSensorRGB(u8 which,u8 cmd)
{   
  u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
  u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
  u8 bit1=RcuPIN[which][0];
  u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  u32 m_val=0;
  u8 m_val1=0, m_val2=0, m_val3=0;
  u8 m_bit1=0, m_bit2=0;
  u8 first=0,end=0;
  u8 m_id=0;
  u8 sum=0,m_para1=0,m_para2=0;
  u8 addrh,addrl;
  u8 id=1;
  u8 addr;

   RcuWhichMutexGive(which,1,MCUN76E003FirstByte);//ͷIIC˿ʹȨ
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
    GetMCUN76E003FirstByteRGB=Soft_I2C_Read(&iic_typedef,1);//0xA9
    Soft_I2C_Stop(&iic_typedef);//ֹͣλ
    if(GetMCUN76E003FirstByteRGB==0xA9)  
  {
        addr=id+0xA8-1;//0xA8
  
        //FistByte+cmd+parameter1+parameter2+sum
        Soft_I2C_Start(&iic_typedef);
      //  Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
        Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
        Soft_I2C_Write(&iic_typedef,0xFA);//0
        Soft_I2C_Write(&iic_typedef,cmd);//2
         Soft_I2C_Stop(&iic_typedef);//ֹͣλ
      //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
      //if(cmd<20&&cmd>0)//
    
      if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
      {
        Soft_I2C_Start(&iic_typedef);//ظʼλ
        Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr|0x01
        first=Soft_I2C_Read(&iic_typedef,0);//SlaveAddr|0x01
        first=Soft_I2C_Read(&iic_typedef,0);
        m_id=Soft_I2C_Read(&iic_typedef,0);
        m_val1=Soft_I2C_Read(&iic_typedef,0);
        if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
        {
          m_val2=Soft_I2C_Read(&iic_typedef,0);
          m_bit1=8;m_bit2=0;
        }
        if(cmd==5)
        {
          m_val3=Soft_I2C_Read(&iic_typedef,0);
          m_bit1=16;m_bit2=8;
        }
        end=Soft_I2C_Read(&iic_typedef,1);
      } 
      Soft_I2C_Stop(&iic_typedef);//ֹͣλ
      
      //OS_EXIT_CRITICAL();
      sum=m_id+m_val1+m_val2+m_val3;//Уͼ

      if(first==0xEA&&sum==end&&m_id==addr) 
      {
        m_val=(u32)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
      }
      else 
      {
        m_val=999;
      }
      RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
      return m_val;
  }
   else
   {
  
        addr=id+0x50-1;//0xf650~0xf657
        
        //FistByte+cmd+parameter1+parameter2+sum
        Soft_I2C_Start(&iic_typedef);
        Soft_I2C_Write(&iic_typedef,0xf6);//SlaveAddrH
        Soft_I2C_Write(&iic_typedef,addr);//SlaveAddrL
        Soft_I2C_Write(&iic_typedef,0xFA);//0
        Soft_I2C_Write(&iic_typedef,cmd);//2
        
        //FistByte+id+parameter1+[parameter2]+[parameter3]+sum
        //if(cmd<20&&cmd>0)//
        if((cmd<20&&cmd>0)||(cmd>60&&cmd<=74)||((cmd>=254)&&(cmd<=255)))
        {
          Soft_I2C_Start(&iic_typedef);//ظʼλ
          Soft_I2C_Write(&iic_typedef,0xf7);//SlaveAddr|0x01
          first=Soft_I2C_Read(&iic_typedef,0);
          m_id=Soft_I2C_Read(&iic_typedef,0);//Ͱλַ
          m_val1=Soft_I2C_Read(&iic_typedef,0);
          if((cmd>=5&&cmd<=18)||(cmd>60&&cmd<=74)||(cmd==254))
          {
            m_val2=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=8;m_bit2=0;
          }
          if(cmd==5)
          {
            m_val3=Soft_I2C_Read(&iic_typedef,0);
            m_bit1=16;m_bit2=8;
          }
          end=Soft_I2C_Read(&iic_typedef,1);
        } 
        Soft_I2C_Stop(&iic_typedef);//ֹͣλ
        
        //OS_EXIT_CRITICAL();
        sum=m_id+m_val1+m_val2+m_val3;//Уͼ

        if(first==0xEA&&sum==end&&m_id==addr) 
        {
          m_val=(u32)(m_val1<<m_bit1)|(m_val2<<m_bit2)|(m_val3);
        }
        else 
        {
          m_val=999;
        }
        RcuWhichMutexGive(which,1,m_val);//ͷIIC˿ʹȨ
        return m_val;
  }
}
 #endif
#endif


//==SetColorSensor Readding ID:  == DON'T DELETE!! == BE1130
//addr 10bit
#ifdef _SETCOLORSENSOR_
 #ifndef  _SETCOLORSENSOR_EXISTS_
  #define _SETCOLORSENSOR_EXISTS_
  
  #include "I2C_Soft.h"
 u8 SetMCUN76E003FirstByte; //ɫר
u32 SetColorSensor(u8 which,u8 cmd,int parameter)
{   
  u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
  u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
  u8 bit1=RcuPIN[which][0];
  u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
  RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
  Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
                    &iic_typedef);
  u8 sum=0;
  u8 addr=0x50;//ʱַĵͰλ
  u8 m_addrh,m_addrl;
  u8 first,m_id,end;
  u16 m_val;
  u8 id=1;
  if(cmd==40||cmd==41)return;
  //sum=ID+cmd+parameter1+parameter2;
  

  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,0xA9);//SlaveAddr+0x01
  SetMCUN76E003FirstByte=Soft_I2C_Read(&iic_typedef,1);//0xA9
  Soft_I2C_Stop(&iic_typedef);//ֹͣλ
  
  if(SetMCUN76E003FirstByte==0xA9)  
  {
        //ӻַΪ8Bite  0XA8
      //TX FistByte+cmd+parameter1+parameter2
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,0xA8);//0I2C_ADDR
      Soft_I2C_Write(&iic_typedef,0xEA);//0I2C_SetFirstByte
      Soft_I2C_Write(&iic_typedef,cmd);//дӻ
      Soft_I2C_Write(&iic_typedef,parameter>>8);//
      Soft_I2C_Write(&iic_typedef,parameter&0xff);//
      Soft_I2C_Stop(&iic_typedef);
      RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
      //OS_EXIT_CRITICAL();
      if(((cmd>=31)&&(cmd<=32))||(cmd>=34&&cmd<=37)||(cmd>=44&&cmd<=55))Delay1ms(25);
      else if(cmd>=33)Delay1ms(200);
      else if(cmd>=43)Delay1ms(1500);
  }
  else
  {
      //ӻַΪ10Bite 0xf6xx:2λ̶Ϊ11,ͰλΪ0x50~0x57,ʵʹõĵַΪ0x350~0x357(0xf650~0xf657)
      //TX FistByte+cmd+parameter1+parameter2
      Soft_I2C_Start(&iic_typedef);
      Soft_I2C_Write(&iic_typedef,0xf6);//дʱַ
      Soft_I2C_Write(&iic_typedef,addr);//
      Soft_I2C_Write(&iic_typedef,0xEA);//0I2C_SetFirstByte
      Soft_I2C_Write(&iic_typedef,cmd);//дӻ
      Soft_I2C_Write(&iic_typedef,parameter>>8);//
      Soft_I2C_Write(&iic_typedef,parameter&0xff);//
      Soft_I2C_Stop(&iic_typedef);
      RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
      //OS_EXIT_CRITICAL();
      if(((cmd>=31)&&(cmd<=32))||(cmd>=34&&cmd<=37)||(cmd>=44&&cmd<=55))Delay1ms(25);
      else if(cmd>=33)Delay1ms(200);
      else if(cmd>=43)Delay1ms(1500);
  }
}
 #endif
#endif

//==SetServo Readding ID:  == DON'T DELETE!! ==
#ifdef _SETSERVO_
 #ifndef  _SETSERVO_EXISTS_
  #define _SETSERVO_EXISTS_
  
void SetServo(u8 which,int angle)
{
	SetComServoAngleAdjustFlag(1);
    ComServoInit(which);
	if(angle==220)ComServoAngle(which,0);//粻
	else ComServoAngle(which,(angle+50));
}
 #endif
#endif

//==SetMusicNote Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICNOTE_
 #ifndef  _SETMUSICNOTE_EXISTS_
  #define _SETMUSICNOTE_EXISTS_
	#include "I2C_Soft.h"
	//̶90/	
const u16 MusicMeter_TimeList[]={133,300,217,550,383,1050,716,2050,1383,4050,2716};//ʱʱ
u8 SetMusicNote(u8 which,u8 m_note,u8 m_meter,u8 m_pitch,u8 m_scale)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,0);//ȡ˿IICʹȨ
	Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	u8 ack;
	u16 dt;
	u8 m_led=1;//LED
	u8 mmeter=m_meter&0x0f;//ȡ
	if(m_note==0)m_led=0;//ֹͣʱ
	
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,0x0E);	//ַ
	Soft_I2C_Write(&iic_typedef,0XEA);	//ͷ
	Soft_I2C_Write(&iic_typedef,m_note);	//1 0ֹͣ1~7
	Soft_I2C_Write(&iic_typedef,m_pitch);//2  0ͣ1У2
	Soft_I2C_Write(&iic_typedef,m_scale);//3  10ȫ
	Soft_I2C_Write(&iic_typedef,mmeter);//4  beatflag&0xf0=0ʱ 0:1/8  1:3/8  2:1/4  3:3/4  4:1/2  5:3/2  6:1  7:3  8:2  9:6  10:4 
	Soft_I2C_Write(&iic_typedef,0);//5 Ϊ1ʱĽʱ߰λ,λ1ms
	Soft_I2C_Write(&iic_typedef,0);//6 Ͱλ
	Soft_I2C_Write(&iic_typedef,1);//7 beatflag 4λʱ1̶ 0ɵ,2 ֶmeter1/meter23Ĺ̶䣻λ ѡ̶:0X10:TimeList1[],TimeList[]
	Soft_I2C_Write(&iic_typedef,0);//8 stop4λ һ 0ֹͣ1ֹͣfreqflagλ 1ָƣ0ʹ
	Soft_I2C_Write(&iic_typedef,1);//9 ʱ;ʱ(4λ)1:ʱ0;4λsettime 1ʱ(=1ʱ)̶Ϊʱ
	Soft_I2C_Write(&iic_typedef,m_led);//10 led LED״̬,led
	Soft_I2C_Write(&iic_typedef,0);	//11 ĵķbeatflag=2
	Soft_I2C_Write(&iic_typedef,0);	//12 ĵķĸbeatflag=2
	Soft_I2C_Write(&iic_typedef,0);	//13 ָƵ freqflag==1
	Soft_I2C_Write(&iic_typedef,0);	//14 
	Soft_I2C_Write(&iic_typedef,0xF5);//β
	Soft_I2C_Stop(&iic_typedef);
	//OS_EXIT_CRITICAL();
	//dt =6000;//ʱ
	dt=MusicMeter_TimeList[mmeter];//ȡʱʱ
	do//ضӦλӦɹʾ
	{
		 //OS_ENTER_CRITICAL();
		Soft_I2C_Start(&iic_typedef);
		Soft_I2C_Write(&iic_typedef,0x0F);
		ack=Soft_I2C_Read(&iic_typedef,1);	
		Soft_I2C_Stop(&iic_typedef);
		//OS_EXIT_CRITICAL();
		if(ack==0xFA)break;//return 1;//ϱ־
		if(ack==0xFC)break;//ε²
		Delay1ms(1);
	}while(dt--);
	RcuWhichMutexGive(which,1,0);//ͷIIC˿ʹȨ
	if(ack==0XFA)return 1;
	return 0;//ʱ
}
 #endif
#endif


#ifdef _GETTRACEV2I2C_
 #ifndef _GETTRACEV2I2C_EXISTS_
  #define _GETTRACEV2I2C_EXISTS_

  #include "I2C_Soft.h"

u8 GetTraceV2I2C( u8 which, u8 command)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();

	RcuWhichMutexTake(which,1,0XFFFF);//ȡ˿IICʹȨ
Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_ChannelState;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,command);
    Soft_I2C_Stop(&iic_typedef);
    
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x19);
    m_ChannelState=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,0XFFFF);//ͷIIC˿ʹȨ
    //OS_EXIT_CRITICAL();
    return m_ChannelState;
}
 #endif
#endif

#ifdef  _SETTRACEV2COLOR_
 #ifndef _SETTRACEV2COLOR_EXISTS_
  #define _SETTRACEV2COLOR_EXISTS_

  #include "I2C_Soft.h"

void SetTraceV2Color(u8 which,int ch1,int ch2,int ch3,int ch4,int ch5,int ch6,int ch7)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,51);
    Soft_I2C_Write(&iic_typedef,ch1);
    Soft_I2C_Write(&iic_typedef,ch2);
    Soft_I2C_Write(&iic_typedef,ch3);
    Soft_I2C_Write(&iic_typedef,ch4);
    Soft_I2C_Write(&iic_typedef,ch5);
    Soft_I2C_Write(&iic_typedef,ch6);
    Soft_I2C_Write(&iic_typedef,ch7);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
}
  #endif
#endif

#ifdef  _SETTRACEV2BEEPI2C_
 #ifndef _SETTRACEV2BEEPI2C_EXISTS_
  #define _SETTRACEV2BEEPI2C_EXISTS_
  
  #include "I2C_Soft.h"

void SetTraceV2BeepI2C( u8 which,int beeptime)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    unsigned char m_ChannelState;
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,52);
    Soft_I2C_Stop(&iic_typedef);
    
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,beeptime);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
    //OS_EXIT_CRITICAL();
}
  #endif
#endif

#ifdef  _SETTRACEV2PERCENTI2C_
 #ifndef _SETTRACEV2PERCENTI2C_EXISTS_
  #define _SETTRACEV2PERCENTI2C_EXISTS_

  #include "I2C_Soft.h"

void SetTraceV2PercentI2C( u8 which,int molecular,int denominator)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
   //OS_ENTER_CRITICAL();
	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,0x18);
    Soft_I2C_Write(&iic_typedef,55);
    Soft_I2C_Write(&iic_typedef,molecular);
    Soft_I2C_Write(&iic_typedef,denominator);
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
		//OS_EXIT_CRITICAL();
}
   #endif
 #endif
 
 
#ifdef _SETMOTORPOWER_
 #ifndef _SETMOTORPOWER_EXISTS_
 #define _SETMOTORPOWER_EXISTS_

void SetMotorPower(u8 m_Per1,int m_Per2,int m_Per3,int m_Per4)//﹦
{
	g_MotorPowerFlag=1;
	g_M1SpeedPer=m_Per1;//M1
	g_M2SpeedPer=m_Per2;//M2
	g_M3SpeedPer=m_Per3;//M3
	g_M4SpeedPer=m_Per4;//M4
}	
 #endif
#endif


//==SetRFPassWord Readding ID:  BE-9242 == DON'T DELETE!! ==

#ifdef _SETRFPASSWORD_
 #ifndef  _SETRFPASSWORD_EXISTS_
  #define _SETRFPASSWORD_EXISTS_
  
  #include "I2C_Soft.h"
  #define _I2C_addr_w  0XA0
  
 void SetRFPassWord(u8 which,u32 password)
  {
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];
 
    u8 pw[6]={0x00};
    u8 check_sum=0;
    //OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
    Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
   pw[0]=(u8)(password/1000000);  
   pw[1]=(u8)((password/100000)%10);
   pw[2]=(u8)((password/10000)%10);
   pw[3]=(u8)((password/1000)%10);
   pw[4]=(u8)((password/100)%10);
   pw[5]=(u8)(password%100);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
    //޸ָ
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x01);//
    check_sum+=0x01;
    Soft_I2C_Write(&iic_typedef,0x09); 
    check_sum+=0x09;
    Soft_I2C_Write(&iic_typedef,pw[0]); 
    check_sum+=pw[0];
    Soft_I2C_Write(&iic_typedef,pw[1]);
    check_sum+=pw[1];
    Soft_I2C_Write(&iic_typedef,pw[2]);  
    check_sum+=pw[2];   
    Soft_I2C_Write(&iic_typedef,pw[3]); 
    check_sum+=pw[3];
    Soft_I2C_Write(&iic_typedef,pw[4]);
    check_sum+=pw[4];
    Soft_I2C_Write(&iic_typedef,pw[5]);  
    check_sum+=pw[5];
    Soft_I2C_Write(&iic_typedef,check_sum);  
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
    delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
		//OS_EXIT_CRITICAL();
 }
 #endif
#endif

//==GetRFModuleByte Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEBYTE_
 #ifndef  _GETRFMODULEBYTE_EXISTS_
  #define _GETRFMODULEBYTE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

u16 GetRFModuleByte(u8 which)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u16 data=999;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u8 n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x11&&rf_data[15]==0xCF) //
    {	
       data=rf_data[3];
    }
		RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
    delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
		//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif


//==SetRFModuleByte Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _SETRFMODULEBYTE_
 #ifndef  _SETRFMODULEBYTE_EXISTS_
  #define _SETRFMODULEBYTE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

u8 SetRFModuleByte(u8 which,u8 _data)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u8 check_sum=0;
	u8 ok_flag=0x02;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,0);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
//ָ
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x02);//,
    check_sum+=0x02;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,_data); 
    check_sum+=_data;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	 //òѯ
	Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x04);//
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	//ȡ
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    do{
    	   ok_flag=Soft_I2C_Read(&iic_typedef,0);
    	 }while(ok_flag==0x02); //ϲѯȴ
    ok_flag=Soft_I2C_Read(&iic_typedef,1); 
    Soft_I2C_Stop(&iic_typedef);
		RcuWhichMutexGive(which,1,0);//ͷIIC˿ʹȨ
    delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
		//OS_EXIT_CRITICAL();
   return(ok_flag);
}
 #endif
#endif

//==GetRFModuleRemoteButton Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEBUTTON_
 #ifndef  _GETRFMODULEREMOTEBUTTON_EXISTS_
  #define _GETRFMODULEREMOTEBUTTON_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

u16 GetRFModuleRemoteButton(u8 which)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u16 data=999;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u32 code=0;
	u32 k=1;
	u8 n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //
    {
    	code=(u32)rf_data[3]*0x1000000+(u32)rf_data[4]*0x10000+(u32)rf_data[5]*0x100+(u32)rf_data[6];
    	 for(n=0;n<20;n++)
       {
       	 if(code&(k<<n))
       	 {
       	 	 data=n;
       	 	 if(code&(k<<26))
       	 	 {
       	 	 	  data+=20;
       	 	 }
       	 	 break;
       	 }
       }
    }
		RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
	delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
	//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif

//==GetRFModuleRemoteCode Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTECODE_
 #ifndef  _GETRFMODULEREMOTECODE_EXISTS_
  #define _GETRFMODULEREMOTECODE_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

u32 GetRFModuleRemoteCode(u8 which)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u32 code=0;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u32 k=1;
	u8 n;
		RcuWhichMutexTake(which,1,0);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);

    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //
    {
    	code=(u32)rf_data[3]*0x1000000+(u32)rf_data[4]*0x10000+(u32)rf_data[5]*0x100+(u32)rf_data[6];
    }
		RcuWhichMutexGive(which,1,code);//ͷIIC˿ʹȨ
	delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
   return code;
}
 #endif
#endif

//==GetRFModuleRemoteGravity Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEGRAVITY_
 #ifndef  _GETRFMODULEREMOTEGRAVITY_EXISTS_
  #define _GETRFMODULEREMOTEGRAVITY_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

s16 GetRFModuleRemoteGravity(u8 which,u8 axis)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	s16 data=999;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u8 n;
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //
    {
        switch(axis){
        	                  case 0x01:{data=(s8)rf_data[11];}break; //X
        	                  case 0x02:{data=(s8)rf_data[12];}break; //Y
        	                  case 0x03:{data=(s8)rf_data[13];}break;//Z
        	                  default:{data=999;}
        	               } 
    }
		RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
   return data;
}
 #endif
#endif

//==GetRFModuleRemoteRocker Readding ID:  == DON'T DELETE!! == BE9242
#ifdef _GETRFMODULEREMOTEROCKER_
 #ifndef  _GETRFMODULEREMOTEROCKER_EXISTS_
  #define _GETRFMODULEREMOTEROCKER_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

s16 GetRFModuleRemoteRocker(u8 which,u8 direction,u8 axis)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	s16 data=999;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u8 n;
//OS_ENTER_CRITICAL();
		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	 Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //
    {
    	 if(direction==0)
    	 {
            switch(axis){
        	                     case 0x00:{data=(s8)rf_data[7];}break; //X
        	                     case 0x01:{data=(s8)rf_data[8];}break; //Y
        	                     default:{data=999;}
        	                  } 
        
        }
        else
        {
        	  switch(axis){
        	                     case 0x00:{data=(s8)rf_data[9];}break; //X
        	                     case 0x01:{data=(s8)rf_data[10];}break; //Y
        	                     default:{data=999;}
        	                  } 
        }
    }
		RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
//OS_EXIT_CRITICAL();
   return data;
}
 #endif
#endif


#ifdef _SETMUSICADDDATA_
 #ifndef  _MUSICADDDATA_EXISTS_
  #define _MUSICADDDATA_EXISTS_
  #include <jmkernel32.h>
	#include "jmmusic.h"
  void SetMusicAddData(u8 mdata,int time)
  {
	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, mdata, time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

#ifdef _SETMUSICADDTREBLE_
 #ifndef  _SETMUSICADDTREBLE_EXISTS_
  #define _SETMUSICADDTREBLE_EXISTS_
  #include <jmkernel32.h>
  #include "jmmusic.h"
  void SetMusicAddtreble(u8 mdata,int time){
  	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (14+mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicAddalto Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICADDALTO_
 #ifndef  _MUSICADDALTO_EXISTS_
  #define _MUSICADDALTO_EXISTS_
  #include <jmkernel32.h>
  #include "jmmusic.h"
  void SetMusicAddalto(u8 mdata,int time){
    	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (7+mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicAddbass Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICADDBASS_
 #ifndef  _MUSICADDBASS_EXISTS_
  #define _MUSICADDBASS_EXISTS_
  #include <jmkernel32.h>
  #include "jmmusic.h"
void SetMusicAddbass(u8 mdata,int time){
   	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (mdata), time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

//==SetMusicStop Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICSTOP_
 #ifndef  _SETMUSICSTOP_EXISTS_
  #define _SETMUSICSTOP_EXISTS_
  #include <jmkernel32.h>
  #include "jmmusic.h"
void SetMusicStop(int time){
   	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, (0), (u8)time);
	Music_AddData(0,m_Music.time);
  }
 #endif
#endif

//==SetMusicRepeat Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICREPEAT_
 #ifndef  _SETMUSICREPEAT_EXISTS_
  #define _SETMUSICREPEAT_EXISTS_
  #include <jmkernel32.h>
  void SetMusicRepeat(int c)
 {
  Music_Repeat(c);
  }
 #endif
#endif

//==SetMusicClear Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICCLEAR_
 #ifndef  _SETMUSICCLEAR_EXISTS_
  #define _SETMUSICCLEAR_EXISTS_
  #include <jmkernel32.h>
  
void SetMusicClear(void)
{
  Music_DataClear();
}
 #endif
#endif

//==SetMusicPlay Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICPLAY_
 #ifndef  _MUSICPLAY_EXISTS_
  #define _MUSICPLAY_EXISTS_
  #include <jmkernel32.h>

  void SetMusicPlay(void)
  {
   //InMusicPlayX();
   InMusic_Play();
  }
 #endif
#endif

//==GetMusicState Readding ID:  == DON'T DELETE!! ==

#ifdef   _GETMUSICSTATE_
#ifndef  _GETMUSICSTATE_EXISTS_
#define  _GETMUSICSTATE_EXISTS_
#include <jmkernel32.h>

u8 GetMusicState(void)
  {
   return Music_GetEndState();
  }
 #endif
#endif

#ifdef _SETINSOUND_
 #ifndef  _SETINSOUND_EXISTS_
  #define _SETINSOUND_EXISTS_
  #include <jmkernel32.h>

  void SetInSound(int freq,int time)
  {
		if(freq>20000)freq=20000;
		if(time==0)return;
		else if(time>0x7fff)time=0x7fff;
		SetAddMusicPlay(freq,time);
#ifndef __RCU_MUSIC_FREQ_PLAY_DISABLE
		Delay1ms(time);
#endif//__RCU_MUSIC_FREQ_PLAY_DISABLE
  }
 #endif
#endif

//==SetTunes Readding ID:  == DON'T DELETE!! ==

#ifdef _SETMUSICMETER_
 #ifndef  _SETMUSICMETER_EXISTS_
  #define _SETMUSICMETER_EXISTS_
  #include <jmkernel32.h>
  #include "jmmusic.h"
void SetMusicMeter(unsigned int meter)//޸ĽģĬ80/
{
	u32 mmeter=60000/meter;
	MusicMeter(TimeList,mmeter);
}
 #endif
#endif

#ifdef _GETRCUPORTDATA_
 #ifndef  _GETRCUPORTDATA_EXISTS_
  #define _GETRCUPORTDATA_EXISTS_
  #include <jmkernel32.h>
u16 GetRcuPortData(u8 which)//ʵʹõRCU֮ͨģ
{
  u32 port1=portarray[RcuPORT[which][0]];
  u8 bit1=RcuPIN[which][0];
  u32 port2=portarray[RcuPORT[which][1]];
  u8 bit2=RcuPIN[which][1];
  u32 port3=portarray[RcuPORT[which][2]];
  u8 bit3=RcuPIN[which][2];
	
  GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IN_FLOATING);
  GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_IN_FLOATING);
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_IN_FLOATING);

  u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
  value|=GPIO_ReadInputDataBit((GPIO_TypeDef*)port2,(1<<bit2))<<1;
  value|=GPIO_ReadInputDataBit((GPIO_TypeDef*)port3,(1<<bit3))<<2;
  
  switch(value)
  {
		case 0:value=0;break;
		case 1:value=1;break;
		case 2:value=2;break;
		case 3:value=4;break;
		case 4:value=3;break;
		case 5:value=5;break;
		case 6:value=6;break;
		case 7:value=7;break;
  }
  return value;
}
 #endif
#endif

#ifdef _SETMOTORSTRAIGHTANGLE_
 #ifndef  _SETMOTORSTRAIGHTANGLE_EXISTS_
  #define _SETMOTORSTRAIGHTANGLE_EXISTS_

void SetMotorStraightAngle(u8 whichL,u8 whichR,int speed,s32 pulse)//ֱ
{
	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	u8 which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0);
	CarPidCtrl_Init(0,which ,0,speed, pulse);
	Create_PicTask();//ʼ
}
 #endif
#endif

#ifdef _SETWAITFORSTRAIGHT_
 #ifndef  _SETWAITFORSTRAIGHT_EXISTS_
  #define _SETWAITFORSTRAIGHT_EXISTS_
	
void SetWaitForStraight(u8 whichL,u8 whichR,int speed,long pulse)//ֱ(ȴ)
{
	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	u8 which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,0,(void *)0);
	CarPidCtrl_Init(0,which ,0,speed, pulse);
	Create_PicTask();//ʼ
	while(1)
	{
		if(ReadPidCtrlFlag(0)==0)break;//Ѿִ
	}
}
#endif
#endif

#ifdef _SETCARTURN_
 #ifndef  _SETCARTURN_EXISTS_
  #define _SETCARTURN_EXISTS_

void SetCarTurn(u8 whichL,u8 whichR,int speed,long pulse)//ת speed>0ת,<0ת =0ֹͣ
{
	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	u8 which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	which=whichL|(whichR<<4);
	PidPara_Init(0,1,(void *)0);
	CarPidCtrl_Init(0,which ,1,speed, pulse);
	Create_PicTask();//ʼ
}
#endif
#endif

#ifdef _SETWAITFORCARTURN_
 #ifndef  _SETWAITFORCARTURN_EXISTS_
  #define _SETWAITFORCARTURN_EXISTS_

void SetWaitForCarTurn(u8 whichL,u8 whichR,int speed,long pulse)//ת䣨ȴ speed>0ת,<0ת =0ֹͣ
{
	if(pulse<0)pulse=-pulse;//pulse=abs(pulse);
	u8 which;
	if(whichL==0||whichL>4||whichR==0||whichR>4)return ;
	u8 m_speedper;
	which=whichL|(whichR<<4);
	PidPara_Init(0,1,(void *)0);
	CarPidCtrl_Init(0,which ,1,speed, pulse);
	Create_PicTask();//ʼ
	while(1)
	{
		if(ReadPidCtrlFlag(0)==0)break;//Ѿִ
	}
}
#endif
#endif

#ifdef _SETMOTORSTRAIGHTANGLE128_
 #ifndef  _SETMOTORSTRAIGHTANGLE128_EXISTS_
  #define _SETMOTORSTRAIGHTANGLE128_EXISTS_
  #include <jmkernel32.h>

void SetMotorStraightAngle128(u8 which,int speed,s32 Angle)
{
	Angle=abs(Angle);
	Motor_Init();
	MotorCodingInit();
	MotorPIDTime_Init();
	SetMCPidServoAngle128(which,speed,Angle);
}
 #endif
#endif

#ifdef _SETTASKSUSPEND_
 #ifndef  _SETTASKSUSPEND_EXISTS_
  #define _SETTASKSUSPEND_EXISTS_
 
u16 SetTaskSuspend(u8 tasknum)//ָ,tasknum=0Լ
{
	return OS_TaskSuspend(tasknum);
}
 #endif
#endif

#ifdef _SETTASKRESUME_
 #ifndef  _SETTASKRESUME_EXISTS_
  #define _SETTASKRESUME_EXISTS_
 
u16 SetTaskResume(u8 tasknum)//ָ
{
	OS_TaskCreate(tasknum);//
	return OS_TaskResume(tasknum);
}
 #endif
#endif

#ifdef _SETTASKDELETE_
 #ifndef  _SETTASKDELETE_EXISTS_
  #define _SETTASKDELETE_EXISTS_
 
u16 SetTaskDelete(u8 tasknum)//ɾָ
{
	return OS_TaskDelete(tasknum);
}
 #endif
#endif

#ifdef _SETTASKCREATE_
 #ifndef  _SETTASKCREATE_EXISTS_
  #define _SETTASKCREATE_EXISTS_
 
u16 SetTaskCreate(u8 tasknum)//ָ
{
	return OS_TaskCreate(tasknum);
}
 #endif
#endif


#ifdef _GETIRCODE_
 #ifndef  _GETIRCODE_EXISTS_
  #define _GETIRCODE_EXISTS_

extern vu32 IR_code;
extern u8 IR_revOK;
u8 lastIRData;
u8 GetIRCode(u8 which)
{
u8 IR_addr,IR_addr_n,IR_data,IR_data_n;

u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
u8 bit2=RcuPIN[which][1];

GPIO_SetBits((GPIO_TypeDef*)port2,(1<<bit2));
   ReadIRcodeInit();
   if(IR_revOK==1)
   {
    IR_revOK=0;
   IR_addr = 0xFF&(IR_code>>24);
   IR_addr_n = 0xFF&(IR_code>>16);
   IR_data = 0xFF&(IR_code>>8);
   IR_data_n = 0xFF&IR_code;
   lastIRData = IR_data;
   return IR_data;
   }
   if(IR_revOK==2)
   {
      IR_revOK=0;
      return lastIRData;
    }
   else
   {
    	return 0;
    }

}	
 #endif
#endif

#ifdef _SETIRCODE_
 #ifndef  _SETIRCODE_EXISTS_
  #define _SETIRCODE_EXISTS_

u8 SetIRCode(u8 which,u8 data)
{
    u8 status;
//ΪַΪ
    status=SendIRFunction(0,data);
    return status;
}	
 #endif
#endif

#ifdef _SETIRBOARD_
 #ifndef  _SETIRBOARD_EXISTS_
  #define _SETIRBOARD_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
#define _SETIRBOARD_ADDR_		0X08
void SetIRBoard(u8 which,u8 addr,u8 mode,u8 color)
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u32 port3=portarray[RcuPORT[which][2]];//ADC
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
   
   u16 data;
   u8  cmd=0;

   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
		    &iic_typedef);
   if(mode>3)mode=3;
   if(color>63)color=63;
   cmd = (mode<<6|color);
   Soft_I2C_Start(&iic_typedef);
   Soft_I2C_Write(&iic_typedef,_SETIRBOARD_ADDR_);
   Soft_I2C_Write(&iic_typedef,0xAA);
   Soft_I2C_Write(&iic_typedef,addr);
   Soft_I2C_Write(&iic_typedef,cmd);
   Soft_I2C_Stop(&iic_typedef);
	 RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
}
 #endif
#endif

#ifdef _SETMP3PLAY_
 #ifndef  _SETMP3PLAY_EXISTS_
  #define _SETMP3PLAY_EXISTS_
	#include "jmdmp3lib.h"
void SetMp3Play(u16 folder,u16 mp3num)//ָļļ
{
  MP3_PlaySong(0X05,((folder&0XFF)<<8)|((mp3num&0XFF)));
}	
 #endif
#endif

#ifdef _SETMP3SUSPEND_
 #ifndef  _SETMP3SUSPEND_EXISTS_
  #define _SETMP3SUSPEND_EXISTS_
	#include "jmdmp3lib.h"
void SetMp3Suspend(void)//ͣ
{
  MP3_PlaySong(0x02,0x0000);
}	
 #endif
#endif

#ifdef _GETRANDOM_
 #ifndef  _GETRANDOM_EXISTS_
  #define _GETRANDOM_EXISTS_
#define _MULTIPLIER 	0x015a4e35L 
#define _INCREMENT	 	1 
u8 g_GetRandomFirst=0;
int GetRandom(int m,int n)
{
	static long seed;
	int rn=0,randn;
	if(g_GetRandomFirst==0)//һ趨
	{
		seed=GetSystemTime()+ReadInMicVaule()+ReadInVoltageVaule();
		Delay1ms(1);
		seed=(GetSystemTime()+ReadInMicVaule()+216+ReadInVoltageVaule())%0x8000;
		g_GetRandomFirst=1;
	}
	seed = _MULTIPLIER*seed + _INCREMENT; 
	randn=((int)(seed>>16) & 0x7fff); 
	rn=(int)(randn%(n-m+1)+m);//m~n
	return((int)rn);
}
 #endif
#endif


#ifdef _GETRCUPORTDATA_
 #ifndef  _GETRCUPORTDATA_EXISTS_
  #define _GETRCUPORTDATA_EXISTS_
  #include <jmkernel32.h>
u16 GetRcuPortData(u8 which)//ʵʹõRCU֮ͨģ
{
  u32 port1=portarray[RcuPORT[which][0]];
  u8 bit1=RcuPIN[which][0];
  u32 port2=portarray[RcuPORT[which][1]];
  u8 bit2=RcuPIN[which][1];
  u32 port3=portarray[RcuPORT[which][2]];
  u8 bit3=RcuPIN[which][2];
	
  GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_IPD);
  GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_IPD);
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_IPD);//GPIO_Mode_IN_FLOATING

  u8 value=GPIO_ReadInputDataBit((GPIO_TypeDef*)port1,(1<<bit1));
  value|=GPIO_ReadInputDataBit((GPIO_TypeDef*)port2,(1<<bit2))<<1;
  value|=GPIO_ReadInputDataBit((GPIO_TypeDef*)port3,(1<<bit3))<<2;
  
  switch(value)
  {
		case 0:value=0;break;
		case 1:value=1;break;
		case 2:value=2;break;
		case 3:value=4;break;
		case 4:value=3;break;
		case 5:value=5;break;
		case 6:value=6;break;
		case 7:value=7;break;
  }
  return value;
}
 #endif
#endif

#ifdef _SETRCUPORTDATA_
 #ifndef  _SETRCUPORTDATA_EXISTS_
  #define _SETRCUPORTDATA_EXISTS_

void SetRcuPortData(u8 which,u16 Color)
{
   u32 port1=portarray[RcuPORT[which][0]];
   u32 port2=portarray[RcuPORT[which][1]];
   u32 port3=portarray[RcuPORT[which][2]];
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];
   u8 RedLed,GreenLed,BlueLed;
   GPIO_Setting((GPIO_TypeDef*)port1,bit1,GPIO_Mode_Out_PP);
   GPIO_Setting((GPIO_TypeDef*)port2,bit2,GPIO_Mode_Out_PP);
   GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_Out_PP);
   switch(Color)
	{
		case 0: RedLed=0;GreenLed=0;BlueLed=0;	break;
		case 1: RedLed=1;GreenLed=0;BlueLed=0;	break;
		case 2: RedLed=0;GreenLed=1;BlueLed=0;	break;
		case 3: RedLed=0;GreenLed=0;BlueLed=1;	break;
		case 4: RedLed=1;GreenLed=1;BlueLed=0;	break;
		case 5: RedLed=1;GreenLed=0;BlueLed=1;	break;
		case 6: RedLed=0;GreenLed=1;BlueLed=1;	break;
		case 7: RedLed=1;GreenLed=1;BlueLed=1;	break;
	}

//ɫ
   if(RedLed==1)   GPIO_SetBits((GPIO_TypeDef*)port1,(1<<bit1));
   else   GPIO_ResetBits((GPIO_TypeDef*)port1,( 1<<bit1));
//ɫ
   if(GreenLed==1)   GPIO_SetBits((GPIO_TypeDef*)port2,(1<<bit2));
   else   GPIO_ResetBits((GPIO_TypeDef*)port2,( 1<<bit2));
//ɫ
   if(BlueLed==1)   GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
   else   GPIO_ResetBits((GPIO_TypeDef*)port3,(1<<bit3));

  }
 #endif
#endif

//== Readding ID:  == DON'T DELETE!! ==

#ifdef _GETWIFIREMOTE_
 #ifndef  _GETWIFIREMOTE_EXISTS_
  #define _GETWIFIREMOTE_EXISTS_
 
u16 GetWifiRemote(u16 num)//1-12
{
	//if(GetWifiReadRxMode()!=1)	
	//{
	//	SetWifiReadRxMode(1);//WIFIģʽΪЭ
	//}
	//SetWifiRemoteMode(1);
	WifiRemote_Init();
	return ReadWifiPacketData(num+2);
}
 #endif
#endif
#ifdef _GETWIFIPUTTER_
 #ifndef  _GETWIFIPUTTER_EXISTS_
  #define _GETWIFIPUTTER_EXISTS_
 
s16 GetWifiPutter(u16 num)
{
	WifiRemote_Init();
	return (s8)ReadWifiPacketData(num+15);//13+2-14+2
}
 #endif
#endif
//==GetRFModuleRemoteBit Readding ID:  == DON'T DELETE!! == BE9237
#ifdef _GETRFMODULEREMOTEBIT_
 #ifndef  _GETRFMODULEREMOTEBIT_EXISTS_
  #define _GETRFMODULEREMOTEBIT_EXISTS_
  #include "I2C_Soft.h"
   #define _I2C_addr_w  0XA0

u16 GetRFModuleRemoteBit(u8 which,u8 num)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u16 data=0;
	u8 check_sum=0;
	u8 rf_data[16]={0x00};  
	u32 code=0;
	u32 k=1;
	u8 n;

		RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
		Soft_I2C_Typedef iic_typedef;
	 Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
										&iic_typedef);
	delay_iic=IIC_SPEED_100K;//20->100k 34->70k 30->78k
	  Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w);
    Soft_I2C_Write(&iic_typedef,0xaa);    
    Soft_I2C_Write(&iic_typedef,0x55);    
    Soft_I2C_Write(&iic_typedef,0x05);//,ѯջ
    check_sum+=0x05;
    Soft_I2C_Write(&iic_typedef,0x04); 
    check_sum+=0x04;
    Soft_I2C_Write(&iic_typedef,0x00); 
    check_sum+=0x00;
	 Soft_I2C_Write(&iic_typedef,check_sum); 
	 Soft_I2C_Stop(&iic_typedef);
	
    Soft_I2C_Start(&iic_typedef);
    Soft_I2C_Write(&iic_typedef,_I2C_addr_w+1);
    for(n=0;n<15;n++) //һҪȡл
    {
         rf_data[n]=Soft_I2C_Read(&iic_typedef,0);
    }
    rf_data[15]=Soft_I2C_Read(&iic_typedef,1);
    Soft_I2C_Stop(&iic_typedef);
    
    // data=rf_data[3];
    if(rf_data[0]==0x56&&rf_data[1]==0xAB&&rf_data[2]==0x05&&rf_data[15]==0xCF) //
    {
    	   code=(u32)rf_data[3]*0x1000000+(u32)rf_data[4]*0x10000+(u32)rf_data[5]*0x100+(u32)rf_data[6];
       	 if(code&(k<<num))
       	 {
       	 	 data=1;
       	 }
    }
		RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
   	delay_iic=IIC_SPEED_DEFAULT;//ָĬٶ
    return data;
}
 #endif
#endif

#ifdef _GETWIFIVOICE_
 #ifndef _GETWIFIVOICE_EXISTS_
  #define _GETWIFIVOICE_EXISTS_
 
u16 GetWifiVoice(u8 *str)
{
	int s=-1;
	//if(GetWifiReadRxMode()!=1)	
	//{
	//	SetWifiReadRxMode(1);//WIFIģʽΪЭ
	//}
	WifiVoice_Init();
	s=ReadWifiVoiceResult(str);
	if(s==-1)return 0;
	else return 1;//ʶɹ
}
 #endif
#endif
#ifdef _SETWIFIVOICESTRING_
 #ifndef _SETWIFIVOICESTRING_EXISTS_
  #define _SETWIFIVOICESTRING_EXISTS_
 #include "LCD320240.h"
u16 SetWifiVoiceString(int y,u16 ch_color,u16 bg_color)
{
	u8* str=ReadWifiVoiceString();
	u8 strlist[32],i,n=LCD_Width/GetFontLibWidth();
	for(i=0;i<n;i++)
	{
		if(*str!='\0')strlist[i]=*str++;
		else strlist[i]=' ';
	}
	strlist[i]='\0';
  SetBackLed(g_LcdBackLignt);
  LCD_String(0,(y-1)*GetFontLibHeight(),strlist,ch_color,bg_color);
}
 #endif
#endif

#ifdef _SETNOTE_
 #ifndef  _SETNOTE_EXISTS_
  #define _SETNOTE_EXISTS_
  #include "jmmusic.h"
  void SetNote(int note)
  {
		u16 freq;
		BeepInit();
		if(note==0)
		{
			BeepOff();
		}
		else
		{
			freq=NoteList[1][note-1];
			SetMusicPWMFreq(freq);
		}
  }
 #endif
#endif


//==SetUartData Readding ID:  == DON'T DELETE!! ==

#ifdef _SETUARTDATA_
 #ifndef  _SETUARTDATA_EXISTS_
  #define _SETUARTDATA_EXISTS_

void SetUartData(u8 port,u8 data,u32 baud)//P8ʹ
{
	u32 BaudRate;
	if(port==0||port>3)return ;
  switch(baud)
  {
		case 0:BaudRate=9600  ;break;
		case 1:BaudRate=14400 ;break;
		case 2:BaudRate=19200 ;break;
		case 3:BaudRate=38400 ;break;
		case 4:BaudRate=57600 ;break;
		case 5:BaudRate=76800 ;break;
		case 6:BaudRate=115200;break;
		case 7:BaudRate=128000;break;
		case 8:BaudRate=256000;break;
		case 9:BaudRate=512000;break;
		case 10:BaudRate=921600;break;
		default:BaudRate=baud;break;
  }
	SysCOM_Init(port,BaudRate);
	SetPortUartData(port,data);//SetComData(data);
}
 #endif
#endif

//==GetUartData Readding ID:  == DON'T DELETE!! ==

#ifdef _GETUARTDATA_
 #ifndef  _GETUARTDATA_EXISTS_
  #define _GETUARTDATA_EXISTS_
 
u16 GetUartData(u8 port,u32 baud)//P1,P2,P3ȡ
{
	u16 buf;
	u32 BaudRate;
	if(port==0||port>3)return 999;
  switch(baud)
  {
		case 0:BaudRate=9600  ;break;
		case 1:BaudRate=14400 ;break;
		case 2:BaudRate=19200 ;break;
		case 3:BaudRate=38400 ;break;
		case 4:BaudRate=57600 ;break;
		case 5:BaudRate=76800 ;break;
		case 6:BaudRate=115200;break;
		case 7:BaudRate=128000;break;
		case 8:BaudRate=256000;break;
		case 9:BaudRate=512000;break;
		case 10:BaudRate=921600;break;
		default:BaudRate=baud;break;
  }
	SysCOM_Init(port,BaudRate);
	buf=ReadPortUartData(port);//ReadCOMData();
	return buf;
}
 #endif
#endif


#ifdef _SETLCDFILLEDRECTANGLE2_
 #ifndef  _SETLCDFILLEDRECTANGLE2_EXISTS_
  #define _SETLCDFILLEDRECTANGLE2_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDFilledRectangle2(u16 x,u16 y,u16 xlong ,u16 ylong,u16 color)
{
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	if(xlong==0||ylong==0)return ;
	LCD_DrawRectangle(x,y,x+xlong,y+ylong,color);
}
 #endif
#endif

#ifdef _SETLCDRECTANGLE2_
 #ifndef  _SETLCDRECTANGLE2_EXISTS_
  #define _SETLCDRECTANGLE2_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDRectangle2(u16 x1,u16 y1,u16 xlong,u16 ylong,u16 w,u16 color)
{
	u8 wmx,wmy,wm;
	u16 x2,y2;
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	if(xlong==0||ylong==0)return ;
	
	x2=x1+xlong;
	y2=y1+ylong;
	wmx=x2-x1;
	wmy=y2-y1;
	wm=(wmx<wmy)?wmx:wmy;
	if(w>wm)w=wm;
	if(w>0)w-=1;
	
	LCD_DrawRectangle( x1,y1,x2,y1+w, color);// |
	LCD_DrawRectangle( x1,y1+w,x1+w, y2, color);//  |
	LCD_DrawRectangle( x1+w,y2-w,x2, y2, color);//-
	LCD_DrawRectangle( x2-w,y1+w,x2, y2-w, color);//_
}
 #endif
#endif

#ifdef _SETLCDLINE_
 #ifndef  _SETLCDLINE_EXISTS_
  #define _SETLCDLINE_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetLCDLine(u16 x1,u16 y1,s16 angle, u16 lenght,u16 color)
{
	SetBackLed(g_LcdBackLignt);//GPIO_SetBits(GPIOA,GPIO_Pin_4);
	LCD_Line(x1,y1,angle,lenght,color,1);
}
 #endif
#endif
//==SetOneServo Readding ID:  == DON'T DELETE!! ==//BE5235/BE5236

#ifdef _SETONESERVO_
 #ifndef  _SETONESERVO_EXISTS_
  #define _SETONESERVO_EXISTS_
  
  #include "I2C_Soft.h"
  
#define _SERVO2_ADDR_		(0x18)//0x18
void SetOneServo(u8 which,u8 Channel, u8 angle, u16 time)
{
	u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
	u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
	u8 bit1=RcuPIN[which][0];
	u8 bit2=RcuPIN[which][1];

	u8 timh,timl;
	u8 sum=0;
	timh=time>>8;
	timl=time&0xff;
	
	RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
 	Soft_I2C_Typedef iic_typedef;
 	Soft_I2C_BspInit( port2,bit2,//SDA
   									port1,bit1,//SCL
   									&iic_typedef);
	//if(g_Servo8to10Flag==0)//10
	{
		sum=(u8)(Channel+angle+timh+timl);
	}
  Soft_I2C_Start(&iic_typedef);
  Soft_I2C_Write(&iic_typedef,_SERVO2_ADDR_);
  Soft_I2C_Write(&iic_typedef,0xfa);
  Soft_I2C_Write(&iic_typedef,Channel);
  Soft_I2C_Write(&iic_typedef,angle);
  Soft_I2C_Write(&iic_typedef,timh);
  Soft_I2C_Write(&iic_typedef,timl);
	//if(g_Servo8to10Flag==0)
	Soft_I2C_Write(&iic_typedef,sum);//10
  Soft_I2C_Stop(&iic_typedef);
  RcuWhichMutexGive(which,1,999);//ͷIIC˿ʹȨ
}
 #endif
#endif


#ifdef _SETDISPLAYPICTURE_
 #ifndef  _SETDISPLAYPICTURE_EXISTS_
  #define _SETDISPLAYPICTURE_EXISTS_
	#include"lcd320240.h"
int SetDisplayPicture(int x,int y,//ͼƬʼX=0-239Y=0-319
		            	 	 	const char* filename,//ͼƬļ(ַ),ƲģͼƬƲܳ8ֽ,׺ܳ3ֽ
		            	 	 	char scale)//ͼű0-3 : 1,1/2,1/4,1/8
{
	int res=0;
	SetBackLed(g_LcdBackLignt);
	//return LCD_DisplayPicture(x,y,filename,scale);
	while(ReadDisplayPictureFlag());//ȴһʾ
	os_task_enter_critical();
	SetDisplayPictureFlag(1);//ʾһεͼƬ
	StartDisplayPicture(x,y,filename,scale);
	os_task_exit_critical();
	while(ReadDisplayPictureFlag());//ȴʾ
	res=ReadDisplayPictureState();//ʾ״̬
	switch(res)
	{
		case 2:res=1;break;//̻ݴ
		case 3://res=4;break;//빤õĹС
		case 4:res=4;break;//뻺С
		case 7://res=3;break;//ֵ֧ͼƬ
		case 8:res=3;break;//ֵ֧ĸʽ
		case 1://res=5;break;//ж
		case 5://res=5;break;//
		case 6://res=5;break;//ͼƬݴ
		case 9:res=5;break;//ű̫,޷ʾ
		case 10:res=2;break;//Ҳfile
		case 0:
		default:	res=0;break;
	}
	return res;
}
#endif
#endif
#ifdef _SETDISPLAYSTR_
#ifndef  _SETDISPLAYSTR_EXISTS_
#define _SETDISPLAYSTR_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

 void SetDisplayStr(int x,int y,s8* pic,u16 ch_color,u16 bg_color)
{
  SetBackLed(g_LcdBackLignt);
  LCD_String(x,y,pic,ch_color,bg_color);
}
 #endif
#endif

#ifdef _SETDISPLAYVARIABLE_
#ifndef  _SETDISPLAYVARIABLE_EXISTS_
#define _SETDISPLAYVARIABLE_EXISTS_
#include <jmkernel32.h>
#include "LCD320240.h"

void SetDisplayVariable(int x,int y,s32 data,u16 ch_color,u16 bg_color)
{
  SetBackLed(g_LcdBackLignt);
	os_task_enter_critical();
  SetNumFontType();//ʾֿ
	os_task_exit_critical();
	LCD_DisplayNum(x,y,(s32)data, ch_color, bg_color,0x8088); 
}
#endif
#endif

#ifdef _SETWIFIUDPMODE_
 #ifndef  _SETWIFIUDPMODE_EXISTS_
  #define _SETWIFIUDPMODE_EXISTS_

u16 SetWifiUdpMode(u8 *remotip,u16 remoteport,u16 port)//UDPӵIPͶ˿
{
	if(WifiSetting_Init(remotip,remoteport,port,1)==2)return 1;
	return 0;
}
 #endif
#endif


#ifdef _SETULTRASOUND_
 #ifndef  _SETULTRASOUND_EXISTS_
  #define _SETULTRASOUND_EXISTS_
  #include <jmkernel32.h>
  #include "I2C_Soft.h"
  
#define _ULTRASOUND_ADDR_		0X04
void SetUltrasound(int which, int command)
{
  u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
  u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
  u8 bit1=RcuPIN[which][0];
  u8 bit2=RcuPIN[which][1];
#define __SetBitColor(c)   (0x40|(c<<3)|(c))
  u32 data;
  u8  datah=0,datal=0,vsn=0,s=0,SUM=0;
  
   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
										port1,bit1,//SCL
										&iic_typedef);
  
  switch(command)
	{//01RG BRGB
	case 0: command=0;	   break;
	case RED:
	case 1: command=0x04;break;
	case GREEN:
	case 2: command=0x02;break;
	case BLUE:
	case 3: command=0x01;break;
	case YELLOW:
	case 4: command=0x06;break;
	case PURPLE:
	case 5: command=0x05;break;
	case CYAN:
	case 6: command=0x03;break;
	case WHITE:
	case 7: command=0x07;break;
	case 8: break;
	default:return;break;
	}
	if(command<=7)command=SetBitColor(command);
	Soft_I2C_Start(&iic_typedef);
	Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);
	Soft_I2C_Write(&iic_typedef,command);
	Soft_I2C_Stop(&iic_typedef);
  
  RcuWhichMutexGive(which,1,data);//ͷIIC˿ʹȨ
}
 #endif
#endif


#ifdef _GETEV3ULTRASONICSENSOR_
 #ifndef  _GETEV3ULTRASONICSENSOR_EXISTS_
  #define _GETEV3ULTRASONICSENSOR_EXISTS_

double GetEV3UltrasonicSensor(u16 port,u8 mode)//ȡEV3,mode=0-2,0:US-DIST-CM;1:US-DIST-IN;2:US-LISTEN
{
	s32 data=9999;
	s32 flag;
	Port_Uart_Init(port);
	Create_UartTask();
	WriteSensorMode(port,0X1E,mode);
	flag=ReadUartSensorBuffer(port,0X1E,&data);
	if(flag<0||flag!=mode)return 9999;
	else return (double)data/10.0;
	
}
 #endif
#endif

#ifdef _GETEV3COLORSENSOR_
 #ifndef  _GETEV3COLORSENSOR_EXISTS_
  #define _GETEV3COLORSENSOR_EXISTS_

s32 GetEV3ColorSensor(u16 port,u8 mode)//ȡEV3ɫ,mode=0-2,0:COL-REFLECT;1:COL-AMBIENT;2:COL-COLOR
{
	s32 data=9999;
	s32 flag;
	Port_Uart_Init(port);
	Create_UartTask();
	WriteSensorMode(port,0X1D,mode);
	flag=ReadUartSensorBuffer(port,0X1D,&data);
	if(flag<0||flag!=mode)data=9999;
	return data;
}
 #endif
#endif

#ifdef _GETEV3GYROSENSOR_
 #ifndef  _GETEV3GYROSENSOR_EXISTS_
  #define _GETEV3GYROSENSOR_EXISTS_

s32 GetEV3GyroSensor(u16 port,u8 mode)//ȡEV3Ǵ,mode=0-2,0:GYRO-ANG;1:GYRO-RATE
{
	s32 data=9999;
	s32 flag;
	Port_Uart_Init(port);
	Create_UartTask();
	WriteSensorMode(port,0X20,mode);
	flag=ReadUartSensorBuffer(port,0X20,&data);
	if(flag<0||flag!=mode)data=9999;
	return data;
}
 #endif
#endif


//==GetRFID (adr=0x50)Readding ID:  == DON'T DELETE!! == rc522 // I2C 0x50
//rfid
#ifdef _GETRFID522_
#ifndef  __GETRFID522__EXISTS_
#define __GETRFID522__EXISTS_
#include <jmkernel32.h>
#include "I2C_Soft.h"
#include "MFRC522.h"
u8 rc522Reset=1;//rc522ʼ־λ
u32 GetRFID522(u8 which)//ѡģʽ
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u32 port3=portarray[RcuPORT[which][2]];//RST
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];   
   
   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);

    unsigned char TagType[2];
  u8 SelectedSnr[4];
  u32 tmp;
   
    char status;
  unsigned char i=1;

    if(rc522Reset)
    {//ʼrc522
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_Out_PP);
  GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);
  GPIO_ResetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);
  GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);

    WriteRawRC(CommandReg,PCD_RESETPHASE,&iic_typedef); 
    WriteRawRC(ModeReg,0x3D,&iic_typedef);//MifareͨѶCRCʼֵ0x6363
  WriteRawRC(TReloadRegL,30,&iic_typedef);           
  WriteRawRC(TReloadRegH,0,&iic_typedef);
  WriteRawRC(TModeReg,0x8D,&iic_typedef);
  WriteRawRC(TPrescalerReg,0x3E,&iic_typedef);
  WriteRawRC(TxAutoReg,0x40,&iic_typedef);
  
  ClearBitMask(TxControlReg, 0x03,&iic_typedef);//ر
  i = ReadRawRC(TxControlReg,&iic_typedef);//
    if (!(i & 0x03))
    { SetBitMask(TxControlReg, 0x03,&iic_typedef);  }
  rc522Reset=0;
    }
 
  else
  {
  status = PcdRequest(REQ_ALL,TagType,&iic_typedef);//Ѱ
  if(!status)
  {
    status = PcdAnticoll(SelectedSnr,&iic_typedef);//ײ
    { PcdHalt(&iic_typedef);  }
  }
  }
  tmp=SelectedSnr[0]*0x1000000+SelectedSnr[1]*0x10000+SelectedSnr[2]*0x100+SelectedSnr[3];
  return tmp;
}

 #endif
#endif



//==_SETRFID_ (adr=0x50)Readding ID:  == DON'T DELETE!! == 
//rfidд
#ifdef _SETRFID522_
#ifndef  _SETRFID522_EXISTS_
#define _SETRFID522_EXISTS_
#include <jmkernel32.h>
#include "I2C_Soft.h"
#include "MFRC522.h"
u8 rc522Reset=1;//rc522ʼ־λ
u32 SetRFID522(u8 which,u8 mode,u8 buf)//ѡģʽ
{
   u32 port1=portarray[RcuPORT[which][0]];//I2C_SCL
   u32 port2=portarray[RcuPORT[which][1]];//I2C_SDA
   u32 port3=portarray[RcuPORT[which][2]];//RST
   u8 bit1=RcuPIN[which][0];
   u8 bit2=RcuPIN[which][1];
   u8 bit3=RcuPIN[which][2];   
   
   RcuWhichMutexTake(which,1,999);//ȡ˿IICʹȨ
   Soft_I2C_Typedef iic_typedef;
   Soft_I2C_BspInit(port2,bit2,//SDA
                    port1,bit1,//SCL
          &iic_typedef);
          
  unsigned char DefaultKey[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
    unsigned char TagType[2];
  u8 SelectedSnr[4];
  u32 tmp;
   
    char status;
  //unsigned char snr, buf[16];
  unsigned char snr;
  unsigned char i=1;

    if(rc522Reset)
    {//ʼrc522
  GPIO_Setting((GPIO_TypeDef*)port3,bit3,GPIO_Mode_Out_PP);
  GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);
  GPIO_ResetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);
  GPIO_SetBits((GPIO_TypeDef*)port3,(1<<bit3));
  Delay1ms(1);

    WriteRawRC(CommandReg,PCD_RESETPHASE,&iic_typedef); 
    WriteRawRC(ModeReg,0x3D,&iic_typedef);//MifareͨѶCRCʼֵ0x6363
  WriteRawRC(TReloadRegL,30,&iic_typedef);           
  WriteRawRC(TReloadRegH,0,&iic_typedef);
  WriteRawRC(TModeReg,0x8D,&iic_typedef);
  WriteRawRC(TPrescalerReg,0x3E,&iic_typedef);
  WriteRawRC(TxAutoReg,0x40,&iic_typedef);
  
  ClearBitMask(TxControlReg, 0x03,&iic_typedef);//ر
  i = ReadRawRC(TxControlReg,&iic_typedef);//
    if (!(i & 0x03))
    { SetBitMask(TxControlReg, 0x03,&iic_typedef);  }
  rc522Reset=0;
    }
 
  else
  {
//  buf[0]=6;
  status = PcdRequest(REQ_ALL,TagType,&iic_typedef);//ѰƬͣѰʽ飩
  if(!status)
  {
    status = PcdAnticoll(SelectedSnr,&iic_typedef);//ײSelectedSnrλţ
    if(!status)
    { 
      status=PcdSelect(SelectedSnr,&iic_typedef);//ѡƬ
      if(!status)
      {
        snr = 1;  //1ĸ
        status = PcdAuthState(KEYA, (snr*4+3), DefaultKey, SelectedSnr, &iic_typedef);// У1룬λÿһ3
          if(!status)
        {
          if(mode==0)//ģʽѡ񣬶1
          { 
            status = PcdRead((snr*4+0), &buf, &iic_typedef);  // ȡ10ݵbuf[0]-buf[16]
            return buf[0];
          }
          if(mode==1)//ģʽѡд1
          { 
            status = PcdWrite((snr*4+0), &buf, &iic_typedef);  // дbuf[0]-buf[16]д10 
          }
          if(!status)
          {
            WaitCardOff(&iic_typedef);//ȴƬ뿪
          }
        }
      }
    }
  }
  }
  tmp=status;
  return tmp;
}

 #endif
#endif